/*
 * @(#)src/contract/ras/sov/jvmras.h, core, xs131, 20030107 1.2
 * ===========================================================================
 * Licensed Materials - Property of IBM
 * "Restricted Materials of IBM"
 *
 * IBM Java(tm)2 SDK, Standard Edition, v 1.3.1
 * (C) Copyright IBM Corp. 1998, 2001. All Rights Reserved
 * US Government Users Restricted Rights - Use, duplication or disclosure
 * restricted by GSA ADP Schedule Contract with IBM Corp.
 * ===========================================================================
 * Module Information:
 *
 * DESCRIPTION:
 * RAS header file for use in all core libraries that use any of the facilities
 * provided by the Diagnostics subcomponent of the JVM.
 * ===========================================================================
 */
#ifndef _IBM_JVMRAS_H_
#define _IBM_JVMRAS_H_

#include <jni.h>

/*
 * ======================================================================
 * Allow for inclusion in C++
 * ======================================================================
 */
#ifdef __cplusplus
extern "C" {
#endif

/*
 * ======================================================================
 * Forward declarations
 * ======================================================================
 */

struct DgTrcExecStruct;
typedef struct DgTrcExecStruct DgTrcExec;
struct rasHpiInterface;
typedef struct rasHpiInterface RasHpiInterface;
struct rasJniInterface;
typedef struct rasJniInterface RasJniInterface;

/*
 * ======================================================================
 * RasInfo structures
 * ======================================================================
 */
typedef struct RasInfo {
    int  type;
    union {

        struct {
            int    number;
            char **names;
        } query;

        struct {
            int    number;
            char **names;
        } trace_components;

        struct {
            char          *name;
            int            first;
            int            last;
            unsigned char *bitMap;
        } trace_component;
    } info;
} RasInfo;

#define RASINFO_TYPES               0
#define RASINFO_TRACE_COMPONENTS    1
#define RASINFO_TRACE_COMPONENT     2
#define RASINFO_MAX_TYPES           2

/*
 * ======================================================================
 *  Macro to initialise the values of JvmRasHeader
 * ======================================================================
 */

#define RasHdrInit(ptr, name, size) \
        memcpy(((JvmRasHeader *)ptr)->eyecatcher, name, 4); \
        ((JvmRasHeader *)ptr)->length = size;

/*
 * ======================================================================
 * External access facade
 * ======================================================================
 */
#define JVMRAS_VERSION_1_1      0x7F000001

typedef struct DgRasInterface {
    char    eyecatcher[4];
    int     length;
    int     version;
    int     modification;
    int     (JNICALL *TraceRegister)(JNIEnv *env,
                                     void (JNICALL *func)(JNIEnv *env2,
                             void **threadLocal, int traceId,
                             const char * format, va_list var));
    int     (JNICALL *TraceDeregister)(JNIEnv *env,
                                       void (JNICALL *func)(JNIEnv *env2,
                               void **threadLocal, int traceId,
                               const char * format, va_list var));
    int     (JNICALL *TraceSet)(JNIEnv *env, const char *);
    void    (JNICALL *TraceSnap)(JNIEnv *env, char *);
    void    (JNICALL *TraceSuspend)(JNIEnv *env);
    void    (JNICALL *TraceResume)(JNIEnv *env);
    int     (JNICALL *GetRasInfo)(JNIEnv * env, RasInfo * info_ptr);
    int     (JNICALL *ReleaseRasInfo)(JNIEnv * env, RasInfo * info_ptr);
    int     (JNICALL *DumpRegister)(JNIEnv *env,
                                    int (JNICALL *func)(JNIEnv *env2,
                                                        void **threadLocal,
                                                        int reason));
    int     (JNICALL *DumpDeregister)(JNIEnv *env,
                                      int (JNICALL *func)(JNIEnv *env2,
                                                          void **threadLocal,
                                                          int reason));
    void    (JNICALL *NotifySignal)(JNIEnv *env, int signal);
    /*start ibm@36537*/
    int     (JNICALL *CreateThread)( JNIEnv *env, void (JNICALL *startFunc)(void*),
                                        void *args, int GCSuspend );
    int     (JNICALL *GenerateJavacore)( JNIEnv *env );
    int     (JNICALL *RunDumpRoutine)( JNIEnv *env, int componentID, int level,
                                       void (*printrtn)(void *env, const char *tagName,
                                                        const char *fmt, ...) );
    int     (JNICALL *InjectSigsegv)( JNIEnv *env );
    int     (JNICALL *InjectOutOfMemory)( JNIEnv *env );
    int     (JNICALL *SetOutOfMemoryHook)( JNIEnv *env, void (*OutOfMemoryFunc)(void) );
    int     (JNICALL *GetComponentDataArea)( JNIEnv *env, char *componentName,
                                               void **dataArea, int *dataSize );
    int     (JNICALL *InitiateSystemDump)( JNIEnv *env );
    /*end ibm@36537*/
} DgRasInterface;

/*
 * ======================================================================
 *    Dump exit return codes
 * ======================================================================
 */

#define RAS_DUMP_CONTINUE   0         /* Continue with diagnostic collection */
#define RAS_DUMP_ABORT      1         /* No more diagnostics should be taken */

/*
 * ======================================================================
 *    Thread Creation types
 * ======================================================================
 */

/*start ibm@36537*/
#define NO_GC_THREAD_SUSPEND    0       /* Do not suspend thread during CG. */
#define GC_THREAD_SUSPEND       1       /* Suspend thread during CG. */

#define RAS_THREAD_NAME_SIZE    50      /* Size of Ras Thread Name. */
/*end ibm@36537*/

/*
 * ======================================================================
 *    Dump Handler types                                        ibm@36540
 * ======================================================================
 */

enum dumpType {
     NODUMPS      = 0,
     JAVADUMP     = 0x01,
     SYSDUMP      = 0x02,
     CEEDUMP      = 0x04,
     HEAPDUMP     = 0x08,                                      /*ibm@56721*/
     MAXDUMPTYPES = 6                                          /*ibm@56721*/
};

#define ALLDUMPS (JAVADUMP | SYSDUMP | CEEDUMP | HEAPDUMP)     /*ibm@56721*/
#define OSDUMP    ALLDUMPS + 1

/*
 * ======================================================================
 *    RAS structure header
 * ======================================================================
 */

typedef struct RasDataHeader {
    char eyecatcher[4];
    int length;
    int version;
    int modification;
} RasDataHeader;


typedef void (*DgRasOutOfMemoryHook)(void);                 /*ibm@42314*/

/*
 * ======================================================================
 * Function prototypes
 * ======================================================================
 */

int  JNICALL rasTraceRegister(JNIEnv *env , void (JNICALL *func)(JNIEnv *env2,
                        void **threadLocal, int traceId,
                        const char * format, va_list varargs));
int  JNICALL rasTraceDeregister(JNIEnv *env ,
                                   void (JNICALL *func)(JNIEnv *env2,
                          void **threadLocal, int traceId,
                          const char * format, va_list varargs));
int  JNICALL rasGetRasInfo(JNIEnv * env, RasInfo * info_ptr);
int  JNICALL rasReleaseRasInfo(JNIEnv * env, RasInfo * info_ptr);
/*start ibm@36537*/
int  JNICALL rasCreateThread( JNIEnv *env, void (JNICALL *startFunc)(void*),
                              void *args, int GCSuspend );
int  JNICALL rasGenerateJavacore( JNIEnv *env );
int  JNICALL rasRunDumpRoutine( JNIEnv *env, int componentID, int level,
                                void (*printrtn)(void *env, const char *tagName,
                                                 const char *fmt, ...) );
int  JNICALL rasInjectSigsegv( JNIEnv *env );
int  JNICALL rasInjectOutOfMemory( JNIEnv *env );
int  JNICALL rasSetOutOfMemoryHook( JNIEnv *env, void (*OutOfMemoryFunc)(void) );
int  JNICALL rasGetComponentDataArea( JNIEnv *env, char *componentName,
                                      void **dataArea, int *dataSize );
int  JNICALL rasInitiateSystemDump( JNIEnv *env );
DgRasOutOfMemoryHook dgGetOutOfMemoryHook(void);            /*ibm@42314*/
/*end ibm@36537*/

/*
 * ======================================================================
 * Facade access macros
 * ======================================================================
 */

#define RAS_FACADE(env) dgTrcExec.rasTrcIntf->

#ifdef __cplusplus
} /* extern "C" */
#endif
#endif /* !_IBM_JVMRAS_H_ */

/*
 * End of file
 */
