/*
 * @(#)src/contract/jvm/sov/jvmmi.h, core, xs131, 20030107 1.4.2.3
 * ===========================================================================
 * Licensed Materials - Property of IBM
 * "Restricted Materials of IBM"
 *
 * IBM Java(tm)2 SDK, Standard Edition, v 1.3.1
 * (C) Copyright IBM Corp. 1998, 2001. All Rights Reserved
 * US Government Users Restricted Rights - Use, duplication or disclosure
 * restricted by GSA ADP Schedule Contract with IBM Corp.
 * ===========================================================================
 */

/*
 *
 * ===========================================================================
 *
 *
 *
 * ===========================================================================
 * Change activity:
 *
 * Reason  Date   Origin  Description
 * ------  ----   ------  ----------------------------------------------------
 * 028883  250401 hdmsa   Creation
 * 033898  050701 hdrjm   Tidy up - add module information
 * 034149  180701 hdseb   Definition of JVMMI_callback structure for use in
 *                        monitor and object enumeration routines
 * 034693  070801 hdbdp   Definition of JVMMI_callback incorrect
 * 041832  120302 jkbar3  JVMMI enhancements (events only)
 * 042159  230302 jkbar3  JVMMI enhancements (event details)
 * 042232  260302 jkbar3  JVMMI enhancements (Thread Creation Requested et al)
 * 042240  260326 jkbar3  JVMMI - Enumerate definitions and events
 * 042321  120202 jkbar3  Monitor enumeration not returning any monitors
 * 051608  110602 jkbar3  corect misleading monitor_info comments
 * 055597  280902 hdcrk   RAS backport from 1.4.0
 *
 * ===========================================================================
 * Module Information:
 *
 * DESCRIPTION: Contains definitions/declarations related to JVMMI. This
 * header is likely to be published if the Monitoring Interface is made public.
 * Additional non-public JVMMI elements are defined in ci_jvmmi.h.
 * ===========================================================================
 */

#include <jni.h>

#define JVMMI_VERSION_1         ((jint)0x00010011)


/****************************************************************************/
/* Event types which may be monitored                                       */
/****************************************************************************/

/*ibm@41832-start*/
#define JVMMI_EVENT_COUNT                    17 /* Number of events defined */

#define JVMMI_EVENT_THREAD_START      0
#define JVMMI_EVENT_THREAD_STOP       1
#define JVMMI_EVENT_CLASS_LOAD        2
#define JVMMI_EVENT_CLASS_UNLOAD      3

#define JVMMI_EVENT_THREAD_CREATED            4
#define JVMMI_EVENT_THREAD_CREATION_REQUESTED 5
#define JVMMI_EVENT_JVM_INIT_DONE             6
#define JVMMI_EVENT_JVM_SHUTDOWN              7
#define JVMMI_EVENT_GC_MARK_START             8
#define JVMMI_EVENT_GC_START                  9
#define JVMMI_EVENT_GC_FINISH                10
#define JVMMI_EVENT_HEAP_SIZE                11
#define JVMMI_EVENT_HEAP_FULL                12
#define JVMMI_EVENT_HEAP_LOW                 13
#define JVMMI_EVENT_AREA_ALLOC               14
#define JVMMI_EVENT_OUT_OF_MEMORY            15
#define JVMMI_EVENT_HEAP_DUMP                16
/*ibm@41832-end*/

/****************************************************************************/
/* "Items" which may be enumerated over                                     */
/* Any changes here need to be reflected in jvmmi_enumerateDefinitions      */
/****************************************************************************/

#define JVMMI_LIST_COUNT        6           /* number of lists defined      */ /*ibm@41832*/

#define JVMMI_LIST_DEFINITION   0x10000000  /* what can be enumerated       */ /*ibm@42240*/
#define JVMMI_LIST_EVENT              0x10000001  /* what events can be monitored */
#define JVMMI_LIST_COMPONENT    0x10000002  /* components: st, gc, etc.     */
#define JVMMI_LIST_MONITOR            0x10000003  /* monitors */
#define JVMMI_LIST_OBJECT             0x10000004  /* All objects in heap */
#define JVMMI_LIST_THREAD       0x10000005  /* All threads                  */ /*ibm@42159*/


/****************************************************************************/
/* Return codes                                                             */
/****************************************************************************/

#define JVMMI_OK     JNI_OK
#define JVMMI_ERR    JNI_ERR
#define JVMMI_OTHER  999


/****************************************************************************/
/* Heap Constants                                                           */
/* The following constants will be used to identify the heap to which a     */
/* heap event (e.g. Heap Low) relates.  If running in non-resettable mode,  */
/* the only value seen will be JVMMI_MAIN_HEAP.                             */
/****************************************************************************/
#define JVMMI_MAIN_HEAP        1   /* The main heap (non-resettable mode)   */
#define JVMMI_MIDDLEWARE_HEAP  1   /* The Middleware Heap (resettable mode) */
#define JVMMI_TRANSIENT_HEAP   2   /* The Transient Heap (resettable mode)  */


/****************************************************************************/
/* JVMMI_Event                                                              */
/****************************************************************************/

typedef struct JVMMI_Event{

/****************************************************************************/
/* NOTE: Any change to this structure may need reflecting in the            */
/* jvmmi_enumerateEvents function.                                          */
/****************************************************************************/

    int type;                 /* The type of the event */
    JNIEnv *envID;            /* Env where event occured */

/*ibm41832-start*/
    union{                           /* The valid element of the union is   */
                                     /* dictated by type                    */
      struct{
          void *id;           /* Unique ID of monitor */
          int tid;                   /* Thread id of current owner          */ /*ibm@51608*/
          int flat_inflated;  /* 0 = flat, 1 = inflated */
          char *name;                /* name of monitor                     */ /*ibm@42321*/
      } monitor_info;

      struct{
          void *id;           /* Unique ID of object */
          int size;           /* Size of object */
          char *classname;    /* Name of class this is instance of */
      } object_info;

      struct{
          char *name;         /* Class name */
          char *source;       /* Source file name */
          int interfaces;     /* Number of interfaces */
          int methods;        /* Number of methods */
          int fields;         /* Number of fields */
      } class_info;

      struct{
          int type;                  /* object Type which can be enumerated */
          char *description;         /* V brief description of enmeration   */ /*ibm@42240*/
      } enumeration_info;

      struct{
          char name[3];       /* Name of component */
          void *interface;    /* Pointer to components interface */
      } component_info;

      struct{
          int type;           /* Type of event */
          char *detail_name;  /* Name of element in detail union */
          char *elements;     /* List of elements in detail */
          char *description;  /* V brief description of event */
      } event_info;

      struct {
          int unused;                /* unused                              */
      } no_additional_info;

      struct {
          int  heap_type;            /* which heap was involved?            */
          size_t old_heap_size;      /* how big was this heap before?       */
          size_t new_heap_size;      /* how big is this heap now?           */
          size_t free_heap_size;     /* how much room is left on it?        */
      } heap_info;

      struct {
          size_t alloc_bytes;        /* bytes allocated since last alloc    */
                                     /* event                               */
      } alloc_info;

      struct {
          void *id;                  /* which thread generated event?       */
          void *parent_id;           /* ID of it's creator                  */
          void *child_id;            /* ID it (just) created or NULL        */
                                     /* if not a thread created event       */
          char *name;                /* name of thread - e.g. "main"        */
      } thread_info;

      struct {
          char    *detail_message;   /* detail message                      */
          long     allocated_memory; /* allocated bytes                     */
          int      GC_cycles_done;   /* number of GC cycles performed       */
          size_t   max_heap_size;    /* max size of heap                    */
          size_t   free_list_bytes;  /* bytes on the free list              */
      } memory_exception_info;

      struct {
          size_t   free_space;        /* free heap space                    */
          size_t   expected_space;    /* a size_t for expected space        */
          size_t   kickoff_threshold; /* less than this left and we mark    */
      } mark_info;
/*ibm41832-start*/

    } detail;
} JVMMI_Event;



/****************************************************************************/
/* JVMMI_Interface                                                          */
/****************************************************************************/

typedef int(JNICALL *jvmmi_callback_t)(JNIEnv *env, JVMMI_Event *evt,          /*ibm@42232*/
                                       void *userData, int tid);               /*ibm@42232*/

typedef struct JVMMI_Interface{
    /* Enable a callback to "func" on event type "eventId" */
    int (JNICALL *EnableEvent)(JNIEnv *env,
                               jvmmi_callback_t func,                          /*ibm@42232*/
                               void *userData,
                               int eventId);
    /* Disable previously enabled callback to "func" on event type "eventId" */
    int (JNICALL *DisableEvent)(JNIEnv *env,
                               jvmmi_callback_t func,                          /*ibm@42232*/
                               void *userData,
                               int eventId);
    /* Request a callback to "func" for each item of type "itemType", up to a maximum of "limit" items */
    int (JNICALL *EnumerateOver)(JNIEnv *env,
                               int itemType,
                               int limit,
                               jvmmi_callback_t func,                          /*ibm@42232*/
                               void *userData);
} JVMMI_Interface;


/****************************************************************************/
/* JVMMI_callbackDetail                                                     */
/****************************************************************************/

typedef struct JVMMI_callbackDetail{
    jvmmi_callback_t func;                                                     /*ibm@42232*/
    void *userData;
    char enabledEvents[JVMMI_EVENT_COUNT];
    struct JVMMI_callbackDetail *next;
} JVMMI_callbackDetail;



/****************************************************************************/
/* JVMMI_callback                                                           */
/****************************************************************************/

typedef struct JVMMI_callback {                                             /*ibm@34149 starts*/
    void *userdata;
    JNIEnv *env;
    int limit;
    int objcount;
    jvmmi_callback_t func;                                                   /*ibm@42232*/
} JVMMI_callback;                                                            /*ibm@34149 ends ibm@34693*/


/****************************************************************************/
/* Function declarations                                                    */
/****************************************************************************/

JVMMI_Interface * jvmmi_GetInterface_1(JavaVM *vm);

