/*
 * Decompiled with CFR 0.152.
 */
package hfalk.util;

import hfalk.db.DBHotEditManager;
import hfalk.db.DBHotSpotGroup;
import hfalk.db.DBHotSpotItem;
import hfalk.util.Compositor;
import hfalk.util.Service;
import java.io.ByteArrayOutputStream;
import java.io.PrintWriter;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

public class HTMLCompositor
implements Compositor {
    private ByteArrayOutputStream outputStream;
    private ResourceBundle resource;

    public HTMLCompositor() {
        try {
            Locale locale = new Locale(DBHotEditManager.instance().getLanguage(), DBHotEditManager.instance().getCountry());
            this.resource = ResourceBundle.getBundle("hfalk.JHotEditL", locale);
            return;
        }
        catch (MissingResourceException missingResourceException) {
            return;
        }
    }

    public void compose(ByteArrayOutputStream byteArrayOutputStream, DBHotSpotGroup dBHotSpotGroup) {
        PrintWriter printWriter = new PrintWriter(byteArrayOutputStream);
        if (dBHotSpotGroup.size() == 0) {
            printWriter.println("");
            printWriter.close();
        }
        String string = dBHotSpotGroup.fileName().substring(dBHotSpotGroup.fileName().lastIndexOf(Service.fileSeparator()) + 1, dBHotSpotGroup.fileName().length());
        String string2 = string.substring(0, string.length() - 4);
        printWriter.println("<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 3.2 Final//EN\">");
        printWriter.println("<HTML>");
        printWriter.println("<BODY>\n");
        printWriter.println("<HEAD>");
        printWriter.println("  <TITLE>" + string2 + "</TITLE>\n");
        printWriter.println("  <META NAME=\"Generator\" ");
        printWriter.println("        CONTENT=\"HotSpot Editor v" + this.resource.getString("JHotEdit_Version") + "\">");
        printWriter.println("</HEAD>\n");
        printWriter.println("<MAP>");
        printWriter.println("<MAP NAME=\"" + string2 + "\">");
        int n = 0;
        while (n < dBHotSpotGroup.size()) {
            int n2;
            DBHotSpotItem dBHotSpotItem = dBHotSpotGroup.itemAt(n);
            if (dBHotSpotItem.type().equals("POLY")) {
                printWriter.print("<AREA SHAPE=POLY COORDS=\"");
                printWriter.print(dBHotSpotItem.value()[0]);
                printWriter.print("," + dBHotSpotItem.value()[1]);
                n2 = 2;
                while (n2 < dBHotSpotItem.value().length) {
                    printWriter.print("," + dBHotSpotItem.value()[n2]);
                    printWriter.print("," + dBHotSpotItem.value()[n2 + 1]);
                    n2 += 2;
                }
                printWriter.print("\" HREF=\"" + dBHotSpotItem.description() + "\"");
                printWriter.println(" ALT=\"" + dBHotSpotItem.name() + "\">");
            }
            if (dBHotSpotItem.type().equals("RECT")) {
                printWriter.print("<AREA SHAPE=RECT COORDS=\"");
                if (dBHotSpotItem.value()[2] > dBHotSpotItem.value()[0] && dBHotSpotItem.value()[3] > dBHotSpotItem.value()[1]) {
                    printWriter.print(dBHotSpotItem.value()[0]);
                    printWriter.print("," + dBHotSpotItem.value()[1]);
                    printWriter.print("," + dBHotSpotItem.value()[2]);
                    printWriter.print("," + dBHotSpotItem.value()[3]);
                }
                if (dBHotSpotItem.value()[2] < dBHotSpotItem.value()[0] && dBHotSpotItem.value()[3] < dBHotSpotItem.value()[1]) {
                    printWriter.print(dBHotSpotItem.value()[2]);
                    printWriter.print("," + dBHotSpotItem.value()[3]);
                    printWriter.print("," + dBHotSpotItem.value()[0]);
                    printWriter.print("," + dBHotSpotItem.value()[1]);
                }
                if (dBHotSpotItem.value()[2] <= dBHotSpotItem.value()[0] && dBHotSpotItem.value()[3] >= dBHotSpotItem.value()[1]) {
                    printWriter.print(dBHotSpotItem.value()[2]);
                    printWriter.print("," + dBHotSpotItem.value()[1]);
                    printWriter.print("," + dBHotSpotItem.value()[0]);
                    printWriter.print("," + dBHotSpotItem.value()[3]);
                }
                if (dBHotSpotItem.value()[2] >= dBHotSpotItem.value()[0] && dBHotSpotItem.value()[3] <= dBHotSpotItem.value()[1]) {
                    printWriter.print(dBHotSpotItem.value()[0]);
                    printWriter.print("," + dBHotSpotItem.value()[3]);
                    printWriter.print("," + dBHotSpotItem.value()[2]);
                    printWriter.print("," + dBHotSpotItem.value()[1]);
                }
                printWriter.print("\" HREF=\"" + dBHotSpotItem.description() + "\"");
                printWriter.println(" ALT=\"" + dBHotSpotItem.name() + "\">");
            }
            if (dBHotSpotItem.type().equals("CIRCLE")) {
                printWriter.print("<AREA SHAPE=CIRCLE COORDS=\"");
                printWriter.print(dBHotSpotItem.value()[0]);
                printWriter.print("," + dBHotSpotItem.value()[1]);
                n2 = (int)Math.round(Math.sqrt(Math.pow(dBHotSpotItem.value()[2] - dBHotSpotItem.value()[0], 2.0) + Math.pow(dBHotSpotItem.value()[3] - dBHotSpotItem.value()[1], 2.0)));
                printWriter.print("," + String.valueOf(n2));
                printWriter.print("\" HREF=\"" + dBHotSpotItem.description() + "\"");
                printWriter.println(" ALT=\"" + dBHotSpotItem.name() + "\">");
            }
            ++n;
        }
        printWriter.println("<AREA SHAPE=default NOHREF>");
        printWriter.println("</MAP>\n");
        printWriter.println("<CENTER>");
        if (string.substring(string.length() - 3, string.length()).equals("gif")) {
            printWriter.println("<IMG SRC=\"" + string2 + ".gif" + "\" USEMAP=\"#" + string2 + "\">");
        } else {
            printWriter.println("<IMG SRC=\"" + string2 + ".jpg" + "\" USEMAP=\"#" + string2 + "\">");
        }
        printWriter.println("</CENTER>");
        printWriter.println("\n</BODY>");
        printWriter.println("</HTML>");
        printWriter.close();
    }
}

