/*
 * Decompiled with CFR 0.152.
 */
package hfalk.hotedit;

import com.sun.java.swing.AbstractAction;
import com.sun.java.swing.JFrame;
import com.sun.java.swing.JOptionPane;
import hfalk.JHotEdit;
import hfalk.db.DBHotEditManager;
import hfalk.print.PrintDocument;
import java.awt.Component;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.image.ImageObserver;
import java.util.Calendar;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

public class PrintReport00
extends AbstractAction {
    JFrame frame;
    private ResourceBundle resource;
    PrintDocument doc;

    public PrintReport00(JFrame jFrame) {
        this.frame = jFrame;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        try {
            Locale locale = new Locale(DBHotEditManager.instance().getLanguage(), DBHotEditManager.instance().getCountry());
            this.resource = ResourceBundle.getBundle("hfalk.hotedit.PrintReport00L", locale);
        }
        catch (MissingResourceException missingResourceException) {
            JOptionPane.showMessageDialog((Component)this.frame, (Object)missingResourceException.getMessage(), (String)"INFORMATION_MESSAGE", (int)1);
            return;
        }
        this.print();
    }

    public String description() {
        return this.resource.getString("PrintReport00_Description");
    }

    public boolean print() {
        int n;
        try {
            this.doc = new PrintDocument((Frame)this.frame, "PrintReport00");
        }
        catch (Exception exception) {
            this.doc = null;
            return false;
        }
        Calendar calendar = Calendar.getInstance();
        String string = calendar.getTime().toString();
        this.doc.setHeader(((JHotEdit)this.frame).hotSpotGroup.name(), string);
        this.doc.setFooter(((JHotEdit)this.frame).hotSpotGroup.fileName(), "");
        this.doc.setApplicationName(this.resource.getString("PrintReport00_ApplicationName"));
        this.doc.newPage();
        this.doc.printHeader();
        Graphics graphics = this.doc.getGraphics();
        Rectangle rectangle = this.doc.getBounds();
        if (((JHotEdit)this.frame).img.getWidth((ImageObserver)this.frame) < rectangle.width) {
            int n2 = (rectangle.width - ((JHotEdit)this.frame).img.getWidth((ImageObserver)this.frame)) / 2;
            n = (rectangle.height - ((JHotEdit)this.frame).img.getHeight((ImageObserver)this.frame)) / 2;
            graphics.drawImage(((JHotEdit)this.frame).img, rectangle.x + n2, rectangle.y + n, ((JHotEdit)this.frame).img.getWidth((ImageObserver)this.frame), ((JHotEdit)this.frame).img.getHeight((ImageObserver)this.frame), (ImageObserver)this.frame);
        }
        if (((JHotEdit)this.frame).img.getWidth((ImageObserver)this.frame) >= rectangle.width) {
            float f = (float)rectangle.width / (float)((JHotEdit)this.frame).img.getWidth((ImageObserver)this.frame);
            ((JHotEdit)this.frame).img.getWidth((ImageObserver)this.frame);
            n = (int)(((float)rectangle.height - (float)((JHotEdit)this.frame).img.getHeight((ImageObserver)this.frame) * f) / 3.0f);
            graphics.drawImage(((JHotEdit)this.frame).img, rectangle.x, n, (int)((float)((JHotEdit)this.frame).img.getWidth((ImageObserver)this.frame) * f), (int)((float)((JHotEdit)this.frame).img.getHeight((ImageObserver)this.frame) * f), (ImageObserver)this.frame);
        }
        this.doc.printFooter();
        this.doc.formFeed();
        this.doc.print();
        return true;
    }
}

