/*
 * Decompiled with CFR 0.152.
 */
package hfalk.hotedit;

import com.sun.java.swing.JDialog;
import com.sun.java.swing.JOptionPane;
import com.sun.java.swing.JPanel;
import hfalk.JHotEdit;
import hfalk.db.DBHotEditManager;
import hfalk.db.DBHotSpotItem;
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Event;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.Label;
import java.awt.LayoutManager;
import java.awt.TextArea;
import java.awt.TextComponent;
import java.awt.TextField;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

public class JEditHotSpot
extends JDialog
implements ActionListener {
    protected Button okButton;
    protected Button cancelButton;
    protected TextField idPatchTextField;
    protected TextField idNameTextField;
    protected TextArea descriptionTextArea;
    DBHotSpotItem currentItem;
    JHotEdit frame;
    private ResourceBundle resource;
    boolean isAdding;

    public JEditHotSpot(JHotEdit jHotEdit, String string, boolean bl, DBHotSpotItem dBHotSpotItem) {
        super((Frame)((Object)jHotEdit), string, true);
        Locale locale;
        try {
            locale = new Locale(DBHotEditManager.instance().getLanguage(), DBHotEditManager.instance().getCountry());
            this.resource = ResourceBundle.getBundle("hfalk.hotedit.JEditHotSpotL", locale);
        }
        catch (MissingResourceException missingResourceException) {
            JOptionPane.showMessageDialog((Component)((Object)this.frame), (Object)missingResourceException.getMessage(), (String)"INFORMATION_MESSAGE", (int)1);
            return;
        }
        this.frame = jHotEdit;
        ((Component)((Object)this)).enableEvents(64L);
        this.getContentPane().setLayout(new CardLayout(10, 10));
        ((Dialog)((Object)this)).setTitle(string);
        this.currentItem = dBHotSpotItem;
        this.isAdding = bl;
        locale = new JPanel((LayoutManager)new BorderLayout(10, 10));
        JPanel jPanel = new JPanel((LayoutManager)new BorderLayout(10, 10));
        Label label = new Label(this.resource.getString("JEditHotSpot_LabelPatch"));
        this.idPatchTextField = new TextField(3);
        JPanel jPanel2 = new JPanel((LayoutManager)new BorderLayout());
        jPanel2.add("West", label);
        jPanel2.add("East", this.idPatchTextField);
        jPanel.add("North", (Component)jPanel2);
        Label label2 = new Label(this.resource.getString("JEditHotSpot_LabelName"));
        this.idNameTextField = new TextField(32);
        JPanel jPanel3 = new JPanel((LayoutManager)new BorderLayout());
        jPanel3.add("West", label2);
        jPanel3.add("East", this.idNameTextField);
        jPanel.add("Center", (Component)jPanel3);
        Label label3 = new Label(this.resource.getString("JEditHotSpot_LabelDescription"));
        this.descriptionTextArea = new TextArea(10, 30);
        JPanel jPanel4 = new JPanel((LayoutManager)new BorderLayout());
        jPanel4.add("North", label3);
        jPanel4.add("South", this.descriptionTextArea);
        jPanel.add("South", (Component)jPanel4);
        ((Container)((Object)locale)).add("Center", (Component)jPanel);
        JPanel jPanel5 = new JPanel((LayoutManager)new FlowLayout());
        this.okButton = new Button(DBHotEditManager.instance().common("Common_OK"));
        this.okButton.addActionListener(this);
        jPanel5.add(this.okButton);
        this.cancelButton = new Button(DBHotEditManager.instance().common("Common_Cancel"));
        this.cancelButton.addActionListener(this);
        jPanel5.add(this.cancelButton);
        ((Container)((Object)locale)).add("South", (Component)jPanel5);
        this.getContentPane().add("Center", (Component)((Object)locale));
        ((Dialog)((Object)this)).setResizable(false);
        if (dBHotSpotItem != null && !this.isAdding) {
            ((TextComponent)this.idPatchTextField).setText(String.valueOf(dBHotSpotItem.patch()));
            ((TextComponent)this.idNameTextField).setText(dBHotSpotItem.name());
            this.idNameTextField.setEditable(false);
            ((Component)this.idNameTextField).setBackground(Color.lightGray);
            this.descriptionTextArea.setText(dBHotSpotItem.description());
        }
        this.idPatchTextField.requestFocus();
        this.getContentPane().setBackground(Color.lightGray);
        ((Window)((Object)this)).pack();
        ((Dialog)((Object)this)).setResizable(false);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (string.equals(DBHotEditManager.instance().common("Common_OK"))) {
            int n;
            String string2 = this.idPatchTextField.getText();
            if (string2.length() == 0) {
                JOptionPane.showMessageDialog((Component)((Object)this.frame), (Object)this.resource.getString("JEditHotSpot_NoPatchNum"), (String)((Dialog)((Object)this)).getTitle(), (int)1);
                return;
            }
            string2 = this.descriptionTextArea.getText();
            if (string2.length() == 0) {
                JOptionPane.showMessageDialog((Component)((Object)this.frame), (Object)this.resource.getString("JEditHotSpot_NoDescription"), (String)((Dialog)((Object)this)).getTitle(), (int)1);
                return;
            }
            try {
                n = Integer.parseInt(this.idPatchTextField.getText());
            }
            catch (NumberFormatException numberFormatException) {
                JOptionPane.showMessageDialog((Component)((Object)this.frame), (Object)this.resource.getString("JEditHotSpot_NoPatchNum"), (String)((Dialog)((Object)this)).getTitle(), (int)1);
                return;
            }
            if (n < 1 || n > 255) {
                JOptionPane.showMessageDialog((Component)((Object)this.frame), (Object)this.resource.getString("JEditHotSpot_ValidPatch"), (String)((Dialog)((Object)this)).getTitle(), (int)1);
                return;
            }
            string2 = this.idNameTextField.getText();
            if (string2.length() > 64) {
                JOptionPane.showMessageDialog((Component)((Object)this.frame), (Object)this.resource.getString("JEditHotSpot_ValidName"), (String)((Dialog)((Object)this)).getTitle(), (int)1);
                return;
            }
            if (string2.length() == 0) {
                JOptionPane.showMessageDialog((Component)((Object)this.frame), (Object)this.resource.getString("JEditHotSpot_EmptyName"), (String)((Dialog)((Object)this)).getTitle(), (int)1);
                return;
            }
            this.currentItem.setPatch(n);
            this.currentItem.setDescription(this.descriptionTextArea.getText());
            this.currentItem.setVisible(true);
            if (this.isAdding) {
                if (!this.frame.hotSpotGroup.doNameExist(this.idNameTextField.getText())) {
                    JOptionPane.showMessageDialog((Component)((Object)this.frame), (Object)this.resource.getString("JEditHotSpot_NotUniqueName"), (String)((Dialog)((Object)this)).getTitle(), (int)1);
                    return;
                }
                this.currentItem.setName(this.idNameTextField.getText());
                this.frame.hotSpotGroup.add(this.currentItem);
            }
            this.setVisible(false);
            ((Window)((Object)this)).dispose();
        }
        if (string.equals(DBHotEditManager.instance().common("Common_Cancel"))) {
            this.setVisible(false);
            ((Window)((Object)this)).dispose();
        }
    }

    public boolean getFocus(Event event, Object object) {
        this.okButton.requestFocus();
        return true;
    }

    public void setLocation() {
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        ((Component)((Object)this)).setLocation((dimension.width - ((Component)((Object)this)).getSize().width) / 2, (dimension.height - ((Component)((Object)this)).getSize().height) / 2);
    }

    protected void processWindowEvent(WindowEvent windowEvent) {
        switch (windowEvent.getID()) {
            case 201: {
                this.setVisible(false);
                ((Window)((Object)this)).dispose();
                return;
            }
        }
        super.processWindowEvent(windowEvent);
    }

    public void setVisible(boolean bl) {
        if (bl) {
            this.setLocation();
            super.setVisible(true);
            return;
        }
        super.setVisible(false);
    }
}

