/*
 * Decompiled with CFR 0.152.
 */
package hfalk.db;

import hfalk.db.DBHotSpotGroup;
import hfalk.util.Service;
import java.awt.Dimension;
import java.awt.Point;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import java.util.Vector;

public class DBHotEditManager {
    private String id;
    private String version;
    private static DBHotEditManager _instance = null;
    private Vector windowList = new Vector();
    private Vector groupNameList = new Vector();
    private Vector groupFileList = new Vector();
    private Vector lastGroupList = new Vector();
    private ResourceBundle common;
    private boolean isCommonLoaded;
    private String _language;
    private String _country;
    public static final int STATE_NORMAL = 0;
    public static final int STATE_DRAW = 2;
    public static final int STATE_MOVE = 4;
    public static final int STATE_RESIZE = 8;
    public static final int STATE_STARTMARK = 16;
    public int state;

    public static DBHotEditManager instance() {
        if (_instance == null) {
            _instance = new DBHotEditManager();
        }
        return _instance;
    }

    protected DBHotEditManager() {
        if (!new File("DATA").exists()) {
            new File("DATA").mkdir();
        }
        if (this.load() != 0) {
            this.save();
        }
        Locale locale = new Locale(this.getLanguage(), this.getCountry());
        this.common = ResourceBundle.getBundle("hfalk.CommonL", locale);
    }

    public boolean setWindowPosition(String string, Point point, Dimension dimension) {
        String string2 = String.valueOf(string) + "," + String.valueOf(point.x) + "," + String.valueOf(point.y) + "," + String.valueOf(dimension.width) + "," + String.valueOf(dimension.height);
        int n = 0;
        while (n < this.windowList.size()) {
            String string3 = (String)this.windowList.elementAt(n);
            StringTokenizer stringTokenizer = new StringTokenizer(string3, ",");
            String string4 = stringTokenizer.nextToken();
            if (string4.equals(string)) {
                try {
                    this.windowList.setElementAt(string2, n);
                }
                catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {}
                return true;
            }
            ++n;
        }
        this.windowList.addElement(string2);
        return true;
    }

    public Point getWindowPositionLocation(String string) {
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        while (n3 < this.windowList.size()) {
            String string2 = (String)this.windowList.elementAt(n3);
            StringTokenizer stringTokenizer = new StringTokenizer(string2, ",");
            String string3 = stringTokenizer.nextToken();
            if (string3.equals(string)) {
                String string4 = stringTokenizer.nextToken();
                String string5 = stringTokenizer.nextToken();
                stringTokenizer.nextToken();
                stringTokenizer.nextToken();
                n = Integer.parseInt(string4);
                n2 = Integer.parseInt(string5);
            }
            ++n3;
        }
        return new Point(n, n2);
    }

    public Dimension getWindowPositionDimension(String string) {
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        while (n3 < this.windowList.size()) {
            String string2 = (String)this.windowList.elementAt(n3);
            StringTokenizer stringTokenizer = new StringTokenizer(string2, ",");
            String string3 = stringTokenizer.nextToken();
            if (string3.equals(string)) {
                stringTokenizer.nextToken();
                stringTokenizer.nextToken();
                String string4 = stringTokenizer.nextToken();
                String string5 = stringTokenizer.nextToken();
                n = Integer.parseInt(string4);
                n2 = Integer.parseInt(string5);
            }
            ++n3;
        }
        return new Dimension(n, n2);
    }

    public void addGroup(String string, String string2) {
        this.groupNameList.addElement(string);
        this.groupFileList.addElement(string2);
    }

    public void removeGroup(String string) {
        int n = 0;
        while (n < this.groupNameList.size()) {
            String string2 = (String)this.groupNameList.elementAt(n);
            if (string2.equals(string)) {
                this.groupNameList.removeElementAt(n);
            }
            ++n;
        }
    }

    public int sizeGroup() {
        return this.groupNameList.size();
    }

    public DBHotSpotGroup itemGroup(String string) {
        int n = 0;
        while (n < this.groupNameList.size()) {
            String string2 = (String)this.groupNameList.elementAt(n);
            if (string2.equals(string)) {
                DBHotSpotGroup dBHotSpotGroup = new DBHotSpotGroup();
                dBHotSpotGroup.setFileName((String)this.groupFileList.elementAt(n));
                dBHotSpotGroup.load();
                return dBHotSpotGroup;
            }
            ++n;
        }
        return null;
    }

    public String itemGroupNameAt(int n) {
        String string = (String)this.groupNameList.elementAt(n);
        return string;
    }

    public void addLastGroup(String string) {
        int n = this.lastGroupList.size();
        if (string.equals(this.itemLastGroup(string))) {
            if (this.itemLastGroupAt(0).equals(string)) {
                return;
            }
            int n2 = 1;
            while (n2 < this.sizeLastGroup()) {
                if (this.itemLastGroupAt(n2).equals(string)) {
                    this.lastGroupList.removeElementAt(n2);
                }
                ++n2;
            }
            this.lastGroupList.insertElementAt(string, 0);
            return;
        }
        if (n < 5) {
            this.lastGroupList.insertElementAt(string, 0);
            return;
        }
        this.lastGroupList.removeElementAt(4);
        this.lastGroupList.insertElementAt(string, 0);
    }

    public void removeLastGroup(String string) {
        int n = 0;
        while (n < this.lastGroupList.size()) {
            String string2 = (String)this.lastGroupList.elementAt(n);
            if (string2.equals(string)) {
                this.lastGroupList.removeElementAt(n);
            }
            ++n;
        }
    }

    public int sizeLastGroup() {
        return this.lastGroupList.size();
    }

    public String itemLastGroupAt(int n) {
        String string = (String)this.lastGroupList.elementAt(n);
        return string;
    }

    public String itemLastGroup(String string) {
        int n = 0;
        while (n < this.lastGroupList.size()) {
            String string2 = (String)this.lastGroupList.elementAt(n);
            if (string2.equals(string)) {
                return string2;
            }
            ++n;
        }
        return null;
    }

    public String getLanguage() {
        return this._language;
    }

    public DBHotEditManager setLanguage(String string) {
        this._language = string;
        return this;
    }

    public String getCountry() {
        return this._country;
    }

    public DBHotEditManager setCountry(String string) {
        this._country = string;
        Locale locale = new Locale(this.getLanguage(), this.getCountry());
        this.common = ResourceBundle.getBundle("hfalk.CommonL", locale);
        return this;
    }

    public String common(String string) {
        return this.common.getString(string);
    }

    public int load() {
        String string;
        int n;
        String string2 = null;
        Properties properties = new Properties();
        try {
            FileInputStream fileInputStream = new FileInputStream("DATA" + Service.fileSeparator() + "HotEditManager.DBHotEditManager");
            properties.load(fileInputStream);
        }
        catch (FileNotFoundException fileNotFoundException) {
            return 1;
        }
        catch (IOException iOException) {
            System.out.println("IOException: Could Not Load!");
            return 2;
        }
        this.id = properties.getProperty("HotEditManager.Id");
        if (!this.id.equals("HotEditManager")) {
            return 3;
        }
        this.version = properties.getProperty("HotEditManager.Version");
        if (!this.version.equals("1.0")) {
            return 4;
        }
        try {
            string2 = properties.getProperty("HotEditManager.WindowPosition");
        }
        catch (NullPointerException nullPointerException) {}
        if (string2 != null) {
            this.windowList.addElement(string2);
        }
        try {
            n = Integer.parseInt(properties.getProperty("HotEditManager.HotSpotGroup.Count"));
        }
        catch (NumberFormatException numberFormatException) {
            return 5;
        }
        int n2 = 0;
        while (n2 < n) {
            string2 = "HotEditManager.HotSpotGroup.Name." + String.valueOf(n2 + 1);
            string = new String(properties.getProperty(string2));
            string2 = "HotEditManager.HotSpotGroup.FileName." + String.valueOf(n2 + 1);
            String string3 = new String(properties.getProperty(string2));
            string2 = "HotEditManager.HotSpotGroup.WindowPosition." + String.valueOf(n2 + 1);
            String string4 = new String();
            try {
                string4 = new String(properties.getProperty(string2));
            }
            catch (NullPointerException nullPointerException) {}
            this.addGroup(string, string3);
            this.windowList.addElement(string4);
            ++n2;
        }
        try {
            n = Integer.parseInt(properties.getProperty("HotEditManager.LastHotSpotGroup.Count"));
        }
        catch (NumberFormatException numberFormatException) {
            n = 0;
        }
        if (n != 0) {
            int n3 = 0;
            while (n3 < n) {
                string2 = "HotEditManager.LastHotSpotGroup.Name." + String.valueOf(n3 + 1);
                string = new String(properties.getProperty(string2));
                this.addLastGroup(string);
                ++n3;
            }
        }
        try {
            this._language = new String(properties.getProperty("HotEditManager.Language"));
            this._country = new String(properties.getProperty("HotEditManager.Country"));
        }
        catch (NullPointerException nullPointerException) {
            this._language = null;
            this._country = null;
        }
        return 0;
    }

    public boolean save() {
        Object object;
        Object object2;
        String string;
        String string2;
        int n;
        Properties properties = new Properties();
        ((Hashtable)properties).put("HotEditManager.Id", "HotEditManager");
        ((Hashtable)properties).put("HotEditManager.Version", "1.0");
        if (this.groupNameList == null) {
            return false;
        }
        if (this.groupNameList.size() != 0) {
            ((Hashtable)properties).put("HotEditManager.HotSpotGroup.Count", String.valueOf(this.groupNameList.size()));
            n = 0;
            while (n < this.groupNameList.size()) {
                string2 = (String)this.groupNameList.elementAt(n);
                String string3 = (String)this.groupFileList.elementAt(n);
                string = "HotEditManager.HotSpotGroup.Name." + String.valueOf(n + 1);
                ((Hashtable)properties).put(string, string2);
                string = "HotEditManager.HotSpotGroup.FileName." + String.valueOf(n + 1);
                ((Hashtable)properties).put(string, string3);
                string = "HotEditManager.HotSpotGroup.WindowPosition." + String.valueOf(n + 1);
                int n2 = 0;
                while (n2 < this.windowList.size()) {
                    object2 = (String)this.windowList.elementAt(n2);
                    object = new StringTokenizer((String)object2, ",");
                    String string4 = ((StringTokenizer)object).nextToken();
                    if (string4.equals(string2)) {
                        ((Hashtable)properties).put(string, object2);
                    }
                    ++n2;
                }
                ++n;
            }
        } else {
            ((Hashtable)properties).put("HotEditManager.HotSpotGroup.Count", String.valueOf(0));
        }
        string = "HotEditManager.WindowPosition";
        n = 0;
        while (n < this.windowList.size()) {
            String string5 = (String)this.windowList.elementAt(n);
            object2 = new StringTokenizer(string5, ",");
            object = ((StringTokenizer)object2).nextToken();
            if (((String)object).equals("HotEditManager")) {
                ((Hashtable)properties).put(string, string5);
            }
            ++n;
        }
        if (this.lastGroupList != null) {
            if (this.lastGroupList.size() != 0) {
                ((Hashtable)properties).put("HotEditManager.LastHotSpotGroup.Count", String.valueOf(this.lastGroupList.size()));
                int n3 = 0;
                while (n3 < this.lastGroupList.size()) {
                    string2 = (String)this.lastGroupList.elementAt(this.lastGroupList.size() - (n3 + 1));
                    string = "HotEditManager.LastHotSpotGroup.Name." + String.valueOf(n3 + 1);
                    ((Hashtable)properties).put(string, string2);
                    ++n3;
                }
            } else {
                ((Hashtable)properties).put("HotEditManager.LastHotSpotGroup.Count", String.valueOf(0));
            }
        }
        if (this._language != null) {
            ((Hashtable)properties).put("HotEditManager.Language", this._language);
        } else {
            this._language = "en";
            this._country = "UK";
            ((Hashtable)properties).put("HotEditManager.Language", "en");
            ((Hashtable)properties).put("HotEditManager.Country", "UK");
        }
        if (this._country != null) {
            ((Hashtable)properties).put("HotEditManager.Country", this._country);
        } else {
            this._language = "en";
            this._country = "UK";
            ((Hashtable)properties).put("HotEditManager.Language", "en");
            ((Hashtable)properties).put("HotEditManager.Country", "UK");
        }
        try {
            FileOutputStream fileOutputStream = new FileOutputStream("DATA" + Service.fileSeparator() + "HotEditManager.DBHotEditManager");
            properties.save(fileOutputStream, "HotEditManager Settings");
        }
        catch (IOException iOException) {
            System.out.println("IOException: Could not Save!");
        }
        return true;
    }
}

