/* Filename: hj11v2b.cmd                                                   */
/* Description : Simple REXX script to execute SUN's HotJava Browser v3.0  */
/*               under OS/2 with JDK 1.1.1 or higher                       */
/* Installation: Just place it in the hojava directory (this is the        */
/*               directory with the following sub-directories:             */
/*                    /hotjava1.1                                          */
/*                    /sun                                                 */
/*                    /sunw                                                */
/*                                                                         */
/*                                                                         */
/*                                        (w) von Alexander Hoff           */
/*                                                N.E.W.S. GbR             */
/*                                                Herrenhof 13             */
/*                                                41515 Grevenbroich       */
/*                                                Germany                  */
/*                                                Email: AHoff@news-gbr.de */
/*                                                                         */

      /* load  REXX functions */
if RxFuncQuery('SysLoadFuncs') then do
 call RxFuncAdd 'SysLoadFuncs','REXXUTIL','SysLoadFuncs'
 call SysLoadFuncs 
end

'@echo off'

setlocal

   /* Check, if the java_home environment variable is set, if not exit */
javahome=GetValue('JAVA_HOME')

if (javahome='') then do
  say '_______________________________________________________'
  say 'JAVA_HOME environment variable not set !'
  say ''
  say '  Please set JAVA_HOME in your config.sys to point to your'
  say '  JAVAOS/2 or any other desired directory.'
  say '      For Example: set JAVA_HOME=C:\JAVA11'
  say ''
  say '  Alternative you can set the environment variable now'
  say '  manually. This would be a non permanent change.'
  say '  Do you want to do this (Y/N)?'
  say '_______________________________________________________'
  say ''
  key=KeyPressed()
  if (key='Y') then do
     say '  Please enter the desired java home directory'
     say '     For Example: C:\JAVA11\ETC  (<ENTER> to end):'
     NewDir = strip( lineIn() )
     if (DirExists(NewDir)<>0) then do
       say ''
       say '  The directory you specified does not exists. Do you want me to '
       say '  to create it (Y/N)?'
       key=KeyPressed()
       if (key='Y') then 'mkdir 'NewDir''
       else do
          endlocal
          exit
       end / * of else */
     end /* of if (DirExists ... */
  end /* of if (key= ... */
  else do
    endlocal
    exit
  end /* of else */
end /* of if (javahome= ... */

   /* get current drive and directory */
 parse upper source . . sourcefile
hotjavadrive = filespec('DRIVE', sourcefile)
hotjavahelp = filespec('PATH', sourcefile)
hotjavapath = hotjavadrive''hotjavahelp

   /* setup environment variables */
'set classpath='hotjavapath'browser.jar;%CLASSPATH%'
'set hotjava_home='hotjavajpath''

   /* check, if the tmp environment variable is set */
tmppath=GetValue('TMP')
if tmppath='' then do
  say ''
  say '_______________________________________________________'
  say 'TMP environment variable not set!'
  say ' Please set TMP in your config.sys to point to your'
  say ' TMP directory.'
  say '  For Example: SET TMP=D:\TMP\BAK'
  say ''
  say '  Alternative you can set the environment variable now'
  say '  manually. This would be a non permanent change.'
  say '  Do you want to do this (Y/N)?'
  say '_______________________________________________________'
  say ''
  key=KeyPressed()
  if (key='Y') then do
     say '  Please enter the desired tmp directory'
     say '     For Example: C:\TMP  (<ENTER> to end):'
     NewDir = strip( lineIn() )
     if (DirExists(NewDir)<>0) then do
       say ''
       say '  The directory you specified does not exists. Do you want me to '
       say '  to create it (Y/N)?'
       key=KeyPressed()
       if (key='Y') then 'mkdir 'NewDir''
       else do
          endlocal
          exit
       end / * of else */
     end /* of if (DirExists ... */
  end /* of if (key= ... */
  else do
    endlocal
    exit
  end /* of else */
end /* of if (tmppath= ... */

    /* update javahome variable. it may have changed */
javahome=GetValue('JAVA_HOME')
    /* update tmppath variable. it may have changed  */
tmppath=GetValue('TMP')

   /* now setup the remaining environment variables */
'set weblog='tmppath''

     /* start the HotJava Browser */
'java -Dhotjava.home='hotjavapath' -Djava.home='javahome' sunw.hotjava.Main'

endlocal

exit


/*---------------------------------------------------------------------*/
/* Subroutines                                                         */
/*---------------------------------------------------------------------*/

GetValue: Procedure             /* Obtain an environment variable      */
  Arg EnvVal .
  res  = value(EnvVal,,'OS2ENVIRONMENT')
Return res

/*---------------------------------------------------------------------*/
KeyPressed: Procedure
   key=SysGetKey(NOECHO)
   key= TRANSLATE(key)
Return key

/*---------------------------------------------------------------------*/
DirExists: Procedure
  parse arg testdir .

                         /* init the return code                       */
   thisRC = ""
 
                         /* install a temporary error handler to check */
                         /* if the drive with the directory to test is */
                         /* ready                                      */
   SIGNAL ON NOTREADY NAME DirDoesNotExist
 
                         /* check if the drive is ready                */
   call stream testDir || "\*", "D"
 
 
                         /* save the current directory of the current  */
                         /* drive                                      */
   curDir = directory()
 
                         /* save the current directory of the drive    */
                         /* with the directory to test                 */
   curDir1 = directory( fileSpec( "drive", testDir ) )
 
 
                         /* test if the directory exist                */
   thisRC = directory( testDir )
 
                         /* restore the current directory of the drive */
                         /* with the directory to test                 */
   call directory curDir1
 
                         /* restore the current directory of the       */
                         /* current drive                              */
   call directory curDir

   if (thisRC=testDir) then thisRC=0
   else thisRC=1

   Return thisRC

DirDoesNotExist:
 
Return 2
 
/*---------------------------------------------------------------------*/   

