/* Filename: hj11.cmd                                                      */
/* Description : Simple REXX script to execute SUN's HotJava Browser v1.1  */
/*               under OS/2 with JDK 1.1.1 or higher                       */
/* Installation: Just place it in the hojava directory (this is the        */
/*               directory with the followung sub-directories:             */
/*                    /hotjava1.1                                          */
/*                    /sun                                                 */
/*                    /sunw                                                */
/*                                                                         */
/*                                                                         */
/*                                        (w) von Alexander Hoff           */
/*                                                N.E.W.S. GbR             */
/*                                                Herrenhof 13             */
/*                                                41515 Grevenbroich       */
/*                                                Germany                  */
/*                                                Email: AHoff@news-gbr.de */
/*                                                                         */

      /* load  REXX functions */
if RxFuncQuery('SysLoadFuncs') then do
 call RxFuncAdd 'SysLoadFuncs','REXXUTIL','SysLoadFuncs'
 call SysLoadFuncs 
end

setlocal

'@echo off'

/* 'set JAVA_HOME=C:\JAVA11' */

   /* Check, if the java_home environment variable is set, if not exit */

javahome=GetValue('JAVA_HOME')

if (javahome='') then do
  say '_______________________________________________________'
  say 'JAVA_HOME environment variable not set !'
  say ' Please set JAVA_HOME in your config.sys to point to your'
  say ' JAVAOS/2 directory.'
  say '  For Example: set JAVA_HOME=C:\JAVA11'
  say '_______________________________________________________'
  endlocal
  exit
end

   /* get current drive and directory */
 parse upper source . . sourcefile
hotjavadrive = filespec('DRIVE', sourcefile)
hotjavahelp = filespec('PATH', sourcefile)
hotjavapath = hotjavadrive''hotjavahelp

   /* setup environment variables */
'set classpath='hotjavapath'HotJava1.1\lib\classes.zip;'hotjavapath'HotJava1.1\lib\ssl.jar;'hotjavapath'HotJava1.1\lib\x509v1.jar;'hotjavapath'HotJava1.1\lib;'hotjavapath'HotJava1.1\runtime\lib\rt.jar;'hotjavapath'HotJava1.1\runtime\lib\i18n.jar;%CLASSPATH%'
'set hotjava_home='hotjavajpath'HotJava1.1'

   /* check, if the tmp environment variable is set */
tmppath=GetValue('TMP')
if tmppath='' then do
  say '_______________________________________________________'
  say 'TMP environment variable not set!'
  say ' Please set TMP in your config.sys to point to your'
  say ' TMP directory.'
  say '  For Example: SET TMP=D:\TMP\BAK'
  say '_______________________________________________________'
  say ''
  endlocal
  exit
end

    /* update tmppath variable. it may have changed */
tmppath=GetValue('TMP')

   /* now setup the remaining environment variables */
'set weblog='tmppath''

     /* start the HotJava Browser */
'java -Dhotjava.home='hotjavapath'HotJava1.1 -Djava.home='javahome' sunw.hotjava.Main'

endlocal
exit


/*---------------------------------------------------------------------*/
/* Subroutines                                                         */
/*---------------------------------------------------------------------*/
GetValue: Procedure             /* Obtain an environment variable      */
  Arg EnvVal .
  res  = value(EnvVal,,'OS2ENVIRONMENT')
Return res
