/*
 * Decompiled with CFR 0.152.
 */
package emsl.tools.lineAndArrow;

import java.applet.Applet;
import java.awt.Button;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.Serializable;

public class LineAndArrow
extends Applet
implements Serializable,
ActionListener {
    public static final int SINGLE_LINE = 0;
    public static final int DOUBLE_LINE = 1;
    public static final int TRIPLE_LINE = 2;
    public static final int RIGHT_ARROW = 3;
    public static final int LEFT_ARROW = 4;
    public static final int DOUBLE_ARROW = 5;
    public static final int EQUILIBRIUM_ARROW = 6;
    public static final String[] lineTypeTags = new String[]{"Single Line", "Double Line", "Triple Line", "Right Arrow", "Left Arrow", "Double Arrow", "Equilibrium Arrow"};
    public static final int ARROW_LINE = 0;
    public static final int ARROW_HOLLOW = 1;
    public static final int ARROW_FILL = 2;
    public static final String[] arrowTypeTags = new String[]{"Lines Only", "Hollow Fill", "Solid Fill"};
    private int lineType;
    private int arrowType;
    private int lineThickness;
    private Button lineButton;
    private Button thicknessButton;
    private Button fillButton;

    public LineAndArrow() {
        this.setLineType(0);
        this.setArrowType(0);
        this.setLineThickness(1);
        this.lineButton = new Button("Line Type");
        this.add(this.lineButton);
        this.thicknessButton = new Button("Thickness");
        this.add(this.thicknessButton);
        this.fillButton = new Button("Fill");
        this.add(this.fillButton);
        this.lineButton.addActionListener(this);
        this.thicknessButton.addActionListener(this);
        this.fillButton.addActionListener(this);
        this.setControlVisible(false);
    }

    public static void main(String[] stringArray) {
        Frame frame = new Frame("Application Wrapper");
        ((Component)frame).setSize(300, 300);
        LineAndArrow lineAndArrow = new LineAndArrow();
        frame.add(lineAndArrow);
        ((Component)frame).setVisible(true);
        lineAndArrow.setControlVisible(true);
    }

    public void setControlVisible(boolean bl) {
        this.lineButton.setVisible(bl);
        this.thicknessButton.setVisible(bl);
        this.fillButton.setVisible(bl);
        this.doLayout();
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.thicknessButton) {
            this.setLineThickness(this.getLineThickness() + 1);
        }
        if (object == this.fillButton) {
            this.setArrowType(this.getArrowType() + 1);
        }
        if (object == this.lineButton) {
            this.setLineType(this.getLineType() + 1);
        }
    }

    public int getLineType() {
        return this.lineType;
    }

    public void setLineType(int n) {
        if (n < 0 || n > 6) {
            n = 0;
        }
        this.lineType = n;
        this.repaint();
    }

    public String getLineTypeName() {
        try {
            return lineTypeTags[this.getLineType()];
        }
        catch (Exception exception) {
            return lineTypeTags[0];
        }
    }

    public void setLineTypeName(String string) {
        int n = 0;
        while (n < lineTypeTags.length) {
            if (string.equals(lineTypeTags[n])) {
                this.setLineType(n);
            }
            ++n;
        }
    }

    public int getLineThickness() {
        return this.lineThickness;
    }

    public void setLineThickness(int n) {
        if (n < 1 || n > 15) {
            n = 1;
        }
        this.lineThickness = n;
        this.repaint();
    }

    public int getArrowType() {
        return this.arrowType;
    }

    public void setArrowType(int n) {
        if (n < 0 || n > 2) {
            n = 0;
        }
        this.arrowType = n;
        this.repaint();
    }

    public String getArrowTypeName() {
        try {
            return arrowTypeTags[this.getArrowType()];
        }
        catch (Exception exception) {
            return arrowTypeTags[0];
        }
    }

    public void setArrowTypeName(String string) {
        int n = 0;
        while (n < arrowTypeTags.length) {
            if (string.equals(arrowTypeTags[n])) {
                this.setArrowType(n);
            }
            ++n;
        }
    }

    public void paint(Graphics graphics) {
        int n;
        Dimension dimension = this.getSize();
        if (this.getForeground() != null) {
            graphics.setColor(this.getForeground());
        }
        int n2 = dimension.height / 2;
        int n3 = this.getLineType();
        if (n3 == 0 || n3 == 2 || n3 == 3 || n3 == 4 || n3 == 5) {
            this.paintHorizontalLine(graphics, n2, "Right", "Up");
            if (n3 == 4 || n3 == 5) {
                this.paintArrowHead(graphics, n2, "Left", "Both");
            }
            if (n3 == 3 || n3 == 5) {
                this.paintArrowHead(graphics, n2, "Right", "Both");
            }
        }
        if (n3 == 1 || n3 == 6) {
            n = n2 - this.getLineThickness();
            this.paintHorizontalLine(graphics, n, "Right", "Up");
            if (n3 == 6) {
                this.paintArrowHead(graphics, n, "Right", "Up");
            }
            this.paintHorizontalLine(graphics, n += this.getLineThickness() * 2, "Left", "Down");
            if (n3 == 6) {
                this.paintArrowHead(graphics, n, "Left", "Down");
            }
        }
        if (n3 == 2) {
            n = n2 - this.getLineThickness() * 2;
            this.paintHorizontalLine(graphics, n, "Left", "Down");
            this.paintHorizontalLine(graphics, n + this.getLineThickness() * 4, "Left", "Down");
        }
    }

    private void paintHorizontalLine(Graphics graphics, int n, String string, String string2) {
        Polygon polygon = new Polygon();
        this.getSize();
        polygon.addPoint(this.getStartX(string, string2), n);
        polygon.addPoint(this.getEndX(string, string2), n);
        this.drawPolyline(graphics, polygon);
    }

    private void paintArrowHead(Graphics graphics, int n, String string, String string2) {
        Polygon polygon = new Polygon();
        this.getSize();
        polygon.addPoint(this.getStartX(string, string2), n);
        polygon.addPoint(this.getEndX(string, string2), n);
        this.drawArrowHead(graphics, polygon, string, string2);
    }

    private int getStartX(String string, String string2) {
        int n = 4;
        if (this.getLineTypeName().indexOf("Line") >= 0) {
            return n;
        }
        if (this.getLineType() == 3) {
            return n;
        }
        if (this.getLineType() == 6 && string.equals("Right")) {
            return n + this.getLineThickness() * 2 / 3;
        }
        return n += this.getLineThickness() * 2;
    }

    private int getEndX(String string, String string2) {
        int n = this.getSize().width - 5;
        if (this.getLineTypeName().indexOf("Line") >= 0) {
            return n;
        }
        if (this.getLineType() == 4) {
            return n;
        }
        if (this.getLineType() == 6 && string.equals("Left")) {
            return n - this.getLineThickness() * 2 / 3;
        }
        return n -= this.getLineThickness() * 2;
    }

    private double getScaledLineWidth() {
        return (double)this.getLineThickness() / 2.0;
    }

    private double getScaledArrowWidth() {
        double d = (double)this.getSize().height * 2.0 / 3.0;
        return d;
    }

    private void drawArrowHead(Graphics graphics, Polygon polygon, String string, String string2) {
        this.getScaledLineWidth();
        double d = this.getScaledArrowWidth();
        double d2 = 0.5235987755982988;
        int n = polygon.xpoints[0];
        int n2 = polygon.ypoints[0];
        int n3 = polygon.xpoints[1];
        int n4 = polygon.ypoints[1];
        if (string.equals("Right")) {
            n = polygon.xpoints[1];
            n2 = polygon.ypoints[1];
            n3 = polygon.xpoints[0];
            n4 = polygon.ypoints[0];
        }
        double d3 = n3 - n;
        double d4 = n4 - n2;
        double d5 = Math.atan2(d4, d3);
        Math.round(d * Math.sin(d2) * Math.sin(d5));
        Math.round(d * Math.sin(d2) * Math.cos(d5));
        int n5 = (int)Math.round(d * Math.cos(d5 + d2));
        int n6 = (int)Math.round(d * Math.sin(d5 + d2));
        int n7 = (int)Math.round(d * Math.cos(d5 - d2));
        int n8 = (int)Math.round(d * Math.sin(d5 - d2));
        Polygon polygon2 = new Polygon();
        if (string.equals("Right")) {
            if (string2.equals("Up")) {
                polygon2.addPoint(n + n5, n2 + n6);
                polygon2.addPoint(n, n2);
                polygon2.addPoint(n + n5, n2);
            }
            if (string2.equals("Down")) {
                polygon2.addPoint(n + n7, n2 + n8);
                polygon2.addPoint(n, n2);
                polygon2.addPoint(n + n5, n2);
            }
            if (string2.equals("Both")) {
                polygon2.addPoint(n + n5, n2 + n6);
                polygon2.addPoint(n, n2);
                polygon2.addPoint(n + n7, n2 + n8);
            }
        } else {
            if (string2.equals("Down")) {
                polygon2.addPoint(n + n5, n2 + n6);
                polygon2.addPoint(n, n2);
                polygon2.addPoint(n + n5, n2);
            }
            if (string2.equals("Up")) {
                polygon2.addPoint(n + n7, n2 + n8);
                polygon2.addPoint(n, n2);
                polygon2.addPoint(n + n5, n2);
            }
            if (string2.equals("Both")) {
                polygon2.addPoint(n + n5, n2 + n6);
                polygon2.addPoint(n, n2);
                polygon2.addPoint(n + n7, n2 + n8);
            }
        }
        Polygon polygon3 = new Polygon();
        Polygon polygon4 = new Polygon();
        this.getPolylines(polygon2, polygon3, polygon4);
        if (this.getForeground() != null) {
            graphics.setColor(this.getForeground());
        }
        if (this.getArrowType() == 0) {
            this.drawPolyline(graphics, polygon2);
        }
        if (this.getArrowType() == 2) {
            graphics.fillPolygon(polygon3);
        }
        if (this.getArrowType() != 1) {
            return;
        }
        polygon2.addPoint(polygon2.xpoints[0], polygon2.ypoints[0]);
        polygon3 = new Polygon();
        polygon4 = new Polygon();
        this.getPolylines(polygon2, polygon3, polygon4);
        if (this.getBackground() != null) {
            graphics.setColor(this.getBackground());
        }
        graphics.fillPolygon(polygon3);
        if (this.getForeground() != null) {
            graphics.setColor(this.getForeground());
        }
        this.drawPolyline(graphics, polygon2);
        if (this.getForeground() != null) {
            graphics.setColor(this.getForeground());
        }
    }

    private void drawPolyline(Graphics graphics, Polygon polygon) {
        Polygon polygon2 = new Polygon();
        boolean bl = this.getPolygonPerimeter(polygon, polygon2);
        if (bl) {
            graphics.fillPolygon(polygon2);
            return;
        }
        graphics.drawPolyline(polygon2.xpoints, polygon2.ypoints, polygon2.npoints);
    }

    private boolean getPolygonPerimeter(Polygon polygon, Polygon polygon2) {
        Polygon polygon3 = new Polygon();
        Polygon polygon4 = new Polygon();
        this.getPolylines(polygon, polygon3, polygon4);
        int n = 0;
        while (n < polygon3.npoints) {
            polygon2.addPoint(polygon3.xpoints[n], polygon3.ypoints[n]);
            ++n;
        }
        if (polygon4.npoints <= 0) {
            return false;
        }
        int n2 = 0;
        while (n2 < polygon4.npoints) {
            polygon2.addPoint(polygon4.xpoints[polygon4.npoints - n2 - 1], polygon4.ypoints[polygon4.npoints - n2 - 1]);
            ++n2;
        }
        polygon2.addPoint(polygon2.xpoints[0], polygon2.ypoints[0]);
        return true;
    }

    private void getPolylines(Polygon polygon, Polygon polygon2, Polygon polygon3) {
        double d = this.getScaledLineWidth();
        if (d < 0.75) {
            int n = 0;
            while (n < polygon.npoints) {
                polygon2.addPoint(polygon.xpoints[n], polygon.ypoints[n]);
                ++n;
            }
            return;
        }
        boolean bl = false;
        if (polygon.xpoints[0] == polygon.xpoints[polygon.npoints - 1] && polygon.ypoints[0] == polygon.ypoints[polygon.npoints - 1]) {
            bl = true;
        }
        int n = 0;
        while (n < polygon.npoints) {
            int n2;
            int n3 = n - 1;
            if (n3 < 0 && !bl) {
                n3 = 0;
            }
            if (n3 < 0 && bl) {
                n3 = polygon.npoints - 2;
            }
            if ((n2 = n + 1) > polygon.npoints - 1 && !bl) {
                n2 = n;
            }
            if (n2 > polygon.npoints - 1 && bl) {
                n2 = 1;
            }
            Point point = new Point(polygon.xpoints[n3], polygon.ypoints[n3]);
            Point point2 = new Point(polygon.xpoints[n], polygon.ypoints[n]);
            Point point3 = new Point(polygon.xpoints[n2], polygon.ypoints[n2]);
            double d2 = point2.x - point.x;
            double d3 = point2.y - point.y;
            double d4 = point3.x - point2.x;
            double d5 = point3.y - point2.y;
            if (d2 == 0.0 && d3 == 0.0) {
                d2 = d4;
                d3 = d5;
            }
            if (d4 == 0.0 && d5 == 0.0) {
                d4 = d2;
                d5 = d3;
            }
            double d6 = 100000.0;
            if (d2 != 0.0) {
                d6 = d3 / d2;
            }
            double d7 = 100000.0;
            if (d4 != 0.0) {
                d7 = d5 / d4;
            }
            double d8 = Math.atan2(d3, d2);
            double d9 = d * Math.sin(d8);
            double d10 = d * Math.cos(d8);
            double d11 = Math.atan2(d5, d4);
            double d12 = d * Math.sin(d11);
            double d13 = d * Math.cos(d11);
            double d14 = (double)point.x + d9;
            double d15 = (double)point.y - d10;
            double d16 = (double)point3.x + d12;
            double d17 = (double)point3.y - d13;
            double d18 = (double)point2.x + d9;
            double d19 = (double)point2.y - d10;
            if (d6 - d7 != 0.0) {
                d18 = (d17 - d15 - d7 * d16 + d6 * d14) / (d6 - d7);
                d19 = d6 * (d18 - d14) + d15;
            }
            polygon2.addPoint((int)Math.round(d18), (int)Math.round(d19));
            d14 = (double)point.x - d9;
            d15 = (double)point.y + d10;
            d16 = (double)point3.x - d12;
            d17 = (double)point3.y + d13;
            d18 = (double)point2.x - d9;
            d19 = (double)point2.y + d10;
            if (d6 - d7 != 0.0) {
                d18 = (d17 - d15 - d7 * d16 + d6 * d14) / (d6 - d7);
                d19 = d6 * (d18 - d14) + d15;
            }
            polygon3.addPoint((int)Math.round(d18), (int)Math.round(d19));
            ++n;
        }
    }
}

