/*
 * Decompiled with CFR 0.152.
 */
package emsl.text;

import emsl.system.ClipboardManager;
import emsl.system.UndoGroup;
import emsl.text.TextCursor;
import emsl.text.TextData;
import emsl.text.TextPanel;
import emsl.text.TextSelector;
import emsl.text.TextTransfer;
import emsl.text.TextUndo;
import java.awt.MenuItem;
import java.awt.PopupMenu;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;

public class TextClipboard
implements ActionListener {
    private TextPanel textPanel;
    private PopupMenu popUpMenu;
    private ClipboardManager clipboardManager;
    private TextSelector textSelector;
    private TextCursor textCursor;
    private int selectionStart;
    private int selectionEnd;
    private int cursorPosition;

    public TextClipboard(TextPanel textPanel) {
        this.textPanel = textPanel;
        this.createPopUpMenu();
        textPanel.add(this.popUpMenu);
        this.clipboardManager = new ClipboardManager("JavaTextPanelClipboard");
    }

    public void setClipboardManager(ClipboardManager clipboardManager) {
        this.clipboardManager = clipboardManager;
    }

    public ClipboardManager getClipboardManager() {
        return this.clipboardManager;
    }

    private void createPopUpMenu() {
        this.popUpMenu = new PopupMenu("Edit");
        this.addPopUpOption("Undo");
        this.addPopUpOption("Redo");
        this.addPopUpOption("-");
        this.addPopUpOption("Cut");
        this.addPopUpOption("Copy");
        this.addPopUpOption("Paste");
        this.addPopUpOption("-");
        this.addPopUpOption("Delete");
        this.addPopUpOption("-");
        this.addPopUpOption("Select All");
    }

    private MenuItem addPopUpOption(String string) {
        MenuItem menuItem = new MenuItem(string);
        menuItem.addActionListener(this);
        this.popUpMenu.add(menuItem);
        return menuItem;
    }

    private void setMenuState(String string, boolean bl) {
        int n = 0;
        while (n < this.popUpMenu.getItemCount()) {
            MenuItem menuItem = this.popUpMenu.getItem(n);
            if (menuItem.getLabel().startsWith(string)) {
                menuItem.setEnabled(bl);
            }
            ++n;
        }
    }

    public void displayPopUp(MouseEvent mouseEvent) {
        this.getTextPanelState();
        TextUndo textUndo = this.textPanel.getTextUndo();
        boolean bl = true;
        if (this.textPanel.getEditable() != 2) {
            bl = false;
        }
        this.setMenuState("Undo", textUndo.getUndoManager().isUndoable(textUndo) & bl);
        this.setMenuState("Redo", textUndo.getUndoManager().isRedoable(textUndo) & bl);
        this.setMenuState("Cut", this.textSelector.isSelected() & bl);
        this.setMenuState("Copy", this.textSelector.isSelected());
        this.setMenuState("Paste", bl);
        this.setMenuState("Delete", this.textSelector.isSelected() & bl);
        this.setMenuState("Select All", true);
        this.popUpMenu.show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object;
        String string = actionEvent.getActionCommand();
        if (actionEvent.getSource() instanceof MenuItem) {
            object = (MenuItem)actionEvent.getSource();
            string = ((MenuItem)object).getLabel();
        }
        this.textPanel.setMouseBusy();
        object = this.textPanel.getTextUndo().getUndoGroup("Paste");
        if (string.startsWith("Undo")) {
            this.undo();
        }
        if (string.startsWith("Redo")) {
            this.redo();
        }
        if (string.startsWith("Cut")) {
            this.cut((UndoGroup)object);
        }
        if (string.startsWith("Copy")) {
            this.copy();
        }
        if (string.startsWith("Paste")) {
            this.paste((UndoGroup)object);
        }
        if (string.startsWith("Delete")) {
            this.delete((UndoGroup)object);
        }
        if (string.startsWith("Select All")) {
            this.selectAll();
        }
        this.textPanel.getTextUndo().setUndoGroup((UndoGroup)object);
        this.textPanel.setMouseNormal();
    }

    private void getTextPanelState() {
        this.textSelector = this.textPanel.getTextSelector();
        this.textCursor = this.textPanel.getTextCursor();
        this.selectionStart = this.textSelector.getSelectionStart();
        this.selectionEnd = this.textSelector.getSelectionEnd();
        if (this.selectionStart > this.selectionEnd) {
            int n = this.selectionStart;
            this.selectionStart = this.selectionEnd;
            this.selectionEnd = n;
        }
        this.cursorPosition = this.textCursor.getCursorPosition();
    }

    public void undo() {
        this.textPanel.getTextUndo().getUndoManager().undo();
        this.textPanel.sendActionEvent("Action Undone");
    }

    public void redo() {
        this.textPanel.getTextUndo().getUndoManager().redo();
        this.textPanel.sendActionEvent("Action Redone");
    }

    public void cut(UndoGroup undoGroup) {
        this.copy();
        this.delete(undoGroup);
        undoGroup.setGroupName("Cut");
    }

    public void copy() {
        this.getTextPanelState();
        if (!this.textSelector.isSelected()) {
            return;
        }
        try {
            TextData textData = this.textPanel.getTextData();
            TextData textData2 = textData.getTextData(this.selectionStart, this.selectionEnd, true);
            TextTransfer textTransfer = new TextTransfer(textData2);
            this.clipboardManager.setClipboardData(textTransfer);
            return;
        }
        catch (Exception exception) {
            System.out.println("Error copying to clipboard");
            System.out.println(exception.toString());
            return;
        }
    }

    public void paste(UndoGroup undoGroup) {
        this.getTextPanelState();
        Transferable transferable = this.clipboardManager.getClipboardData();
        if (transferable == null) {
            return;
        }
        TextData textData = null;
        String string = null;
        try {
            string = (String)transferable.getTransferData(DataFlavor.stringFlavor);
            textData = (TextData)transferable.getTransferData(TextTransfer.richTextFlavor);
            if (textData != null) {
                string = null;
                textData = textData.getTextData(1, textData.getSize() - 1, true);
            }
        }
        catch (Exception exception) {}
        int n = -1;
        if (textData != null) {
            n = this.textPanel.insert(textData, this.cursorPosition + 1, undoGroup);
        }
        if (string != null) {
            n = this.textPanel.insert(string, this.cursorPosition + 1, undoGroup);
        }
        if (n != -1) {
            this.textPanel.layoutAfterChange(Math.max(0, n - 1));
        }
        if (textData == null && string == null) {
            System.out.println("Clipboard data not in recognised format - could not paste");
        }
        this.textPanel.sendActionEvent("Action Paste");
    }

    public void delete(UndoGroup undoGroup) {
        this.getTextPanelState();
        undoGroup.setGroupName("Delete");
        int n = this.textPanel.delete(this.cursorPosition, 1, undoGroup);
        this.textPanel.layoutAfterChange(n);
        this.textPanel.sendActionEvent("Action Delete");
    }

    public void selectAll() {
        this.getTextPanelState();
        this.textSelector.selectAll();
        this.textPanel.repaint();
        this.textPanel.sendActionEvent("Action SelectAll");
    }
}

