/*
 * Decompiled with CFR 0.152.
 */
package emsl.io;

import emsl.awt.GUIAlertBox;
import java.awt.Frame;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.net.Socket;

public class DataBaseSockets {
    private Frame parentFrame;
    private String serverName;
    private int negotiatedFreePort;
    private Socket socket;
    private DataInputStream input;
    private DataOutputStream output;
    private String error = null;
    private String errorLocation;
    private boolean debug = true;
    private static final int ERROR_CODE = -1;
    private static final int REQUEST_FREE_PORT = 1;
    private static final int OPEN_CONNECTION = 2;
    private static final int CLOSE_CONNECTION = 3;
    private static final int DIRECTORY_GET_ROOT = 10;
    private static final int DIRECTORY_GET_CONTENTS = 11;
    private static final int DIRECTORY_CREATE = 12;
    private static final int FILE_GET_DATA = 20;
    private static final int FILE_SET_DATA = 21;
    private static final int FILE_EXISTS = 22;
    private static final int FILE_SET_READER_LIST = 30;
    private static final int FILE_GET_READER_LIST = 31;
    private static final int FILE_SET_WRITER_LIST = 35;
    private static final int FILE_GET_WRITER_LIST = 36;
    private static final int DELETE = 40;
    private static final int GET_SEPARATOR = 41;

    public DataBaseSockets(Frame frame, String string, int n) {
        this.serverName = string;
        this.parentFrame = frame;
        this.errorLocation = "Establising a communication with the server";
        this.negotiatedFreePort = -1;
        try {
            this.debug("Creating socket for " + string + " at port " + n);
            this.socket = new Socket(string, n);
            this.input = new DataInputStream(this.socket.getInputStream());
            this.output = new DataOutputStream(this.socket.getOutputStream());
            this.debug("Sending request for free port");
            if (this.socketTalk(1, null, null) != -1 && this.ok()) {
                this.negotiatedFreePort = this.socketReceiveInt();
                this.debug("Got free port = " + this.negotiatedFreePort);
                if (this.negotiatedFreePort <= 0) {
                    this.error = "Server is busy and cannot allocate a free port";
                }
            }
            this.debug("Closed initial socket at port " + n);
            this.socket.close();
            this.socket = null;
        }
        catch (Exception exception) {
            this.error = exception.toString();
        }
        this.displayError();
    }

    public int openConnection(String string, String string2) {
        this.error = null;
        int n = -1;
        if (this.socket != null) {
            this.debug("Old socket still open....closing it before opening a new one");
            this.closeConnection();
        }
        try {
            this.debug("Opening socket at " + this.serverName + " at port " + this.negotiatedFreePort);
            this.socket = new Socket(this.serverName, this.negotiatedFreePort);
            this.input = new DataInputStream(this.socket.getInputStream());
            this.output = new DataOutputStream(this.socket.getOutputStream());
            String[] stringArray = new String[]{string, string2};
            this.debug("Asking to OPEN_CONNECTION for user " + string);
            n = this.socketTalk(2, stringArray, null);
            if (n != -1 && !this.ok()) {
                n = -1;
            }
        }
        catch (Exception exception) {
            this.error = exception.toString();
            this.errorLocation = "Establishing a negotiated socket connection";
            this.socket = null;
        }
        this.displayError();
        return n;
    }

    public int closeConnection() {
        this.error = null;
        this.errorLocation = "Closing a connection";
        if (this.socket == null) {
            return 0;
        }
        int n = this.socketTalk(3, null, null);
        this.debug("Closing socket");
        try {
            this.socket.close();
            this.socket = null;
        }
        catch (Exception exception) {
            this.error = exception.toString();
        }
        this.displayError();
        return n;
    }

    public String getDirectoryRoot() {
        this.error = null;
        this.errorLocation = "Getting the user's root directory";
        String string = null;
        int n = this.socketTalk(10, null, null);
        if (n != -1 && this.ok()) {
            string = this.socketReceiveString();
        }
        this.displayError();
        return string;
    }

    public String[] getDirectoryContents(String string) {
        this.error = null;
        this.errorLocation = "Getting the contents of a directory";
        String[] stringArray = null;
        int n = this.socketTalk(11, this.getStringArray(string), null);
        if (n != -1 && this.ok()) {
            stringArray = this.socketReceiveStringArray();
        }
        this.displayError();
        return stringArray;
    }

    public int createDirectory(String string) {
        this.error = null;
        this.errorLocation = "Creating a new directory";
        int n = this.socketTalk(12, this.getStringArray(string), null);
        if (n != -1 && !this.ok()) {
            n = -1;
        }
        this.displayError();
        return n;
    }

    public byte[] getFileData(String string) {
        this.error = null;
        this.errorLocation = "Reading the contents of a file";
        byte[] byArray = null;
        int n = this.socketTalk(20, this.getStringArray(string), null);
        if (n != -1 && this.ok()) {
            byArray = this.socketReceiveByteArray();
        }
        this.displayError();
        return byArray;
    }

    public int setFileData(String string, byte[] byArray) {
        this.error = null;
        this.errorLocation = "Writing the contents of a file";
        int n = this.socketTalk(21, this.getStringArray(string), byArray);
        if (n != -1 && !this.ok()) {
            n = -1;
        }
        this.displayError();
        return n;
    }

    public boolean fileExists(String string) {
        this.error = null;
        this.errorLocation = "File Exists";
        int n = this.socketTalk(22, this.getStringArray(string), null);
        if (n != -1 && this.ok()) {
            return this.socketReceiveBoolean();
        }
        this.displayError();
        return false;
    }

    public int setFileReaders(String string, String[] stringArray) {
        this.error = null;
        this.errorLocation = "Writing the file reader access list";
        String[] stringArray2 = new String[1 + stringArray.length];
        stringArray2[0] = string;
        int n = 0;
        while (n < stringArray.length) {
            stringArray2[n + 1] = stringArray[n];
            ++n;
        }
        int n2 = this.socketTalk(30, stringArray2, null);
        if (n2 != -1 && !this.ok()) {
            n2 = -1;
        }
        this.displayError();
        return n2;
    }

    public String[] getFileReaders(String string) {
        this.error = null;
        this.errorLocation = "Reading the file reader access list";
        int n = this.socketTalk(31, this.getStringArray(string), null);
        if (n != -1 && this.ok()) {
            return this.socketReceiveStringArray();
        }
        this.displayError();
        return null;
    }

    public int setFileWriters(String string, String[] stringArray) {
        this.error = null;
        this.errorLocation = "Writing the file writer access list";
        String[] stringArray2 = new String[1 + stringArray.length];
        stringArray2[0] = string;
        int n = 0;
        while (n < stringArray.length) {
            stringArray2[n + 1] = stringArray[n];
            ++n;
        }
        int n2 = this.socketTalk(35, stringArray2, null);
        if (n2 != -1 && !this.ok()) {
            n2 = -1;
        }
        this.displayError();
        return n2;
    }

    public String[] getFileWriters(String string) {
        this.error = null;
        this.errorLocation = "Reading the file writer access list";
        int n = this.socketTalk(36, this.getStringArray(string), null);
        if (n != -1 && this.ok()) {
            return this.socketReceiveStringArray();
        }
        this.displayError();
        return null;
    }

    public int deleteFile(String string) {
        this.error = null;
        this.errorLocation = "Deleting a file";
        int n = this.socketTalk(40, this.getStringArray(string), null);
        if (n != -1 && this.ok()) {
            return n;
        }
        this.displayError();
        return -1;
    }

    public String getSeparator() {
        this.error = null;
        this.errorLocation = "Get Separator Character";
        int n = this.socketTalk(41, null, null);
        if (n != -1 && this.ok()) {
            return this.socketReceiveString();
        }
        this.displayError();
        return null;
    }

    private int socketTalk(int n, String[] stringArray, byte[] byArray) {
        int n2 = -1;
        try {
            this.socket.setSoTimeout(5000);
            this.output.writeInt(n);
            if (stringArray != null) {
                this.output.writeInt(stringArray.length);
                int n3 = 0;
                while (n3 < stringArray.length) {
                    this.output.writeUTF(stringArray[n3]);
                    ++n3;
                }
            } else {
                this.output.writeInt(0);
            }
            if (byArray != null) {
                this.output.writeInt(byArray.length);
                this.output.write(byArray);
            } else {
                this.output.writeInt(0);
            }
            this.output.flush();
            n2 = this.input.readInt();
            if (n2 != n) {
                this.error = "Command not received by server";
                n2 = -1;
            }
        }
        catch (Exception exception) {
            this.error = exception.toString();
        }
        return n2;
    }

    private boolean ok() {
        int n = this.socketReceiveInt();
        if (n != -1) {
            return true;
        }
        this.error = this.socketReceiveString();
        return false;
    }

    private boolean socketReceiveBoolean() {
        boolean bl = false;
        try {
            bl = this.input.readBoolean();
        }
        catch (Exception exception) {
            this.error = exception.toString();
        }
        return bl;
    }

    private String socketReceiveString() {
        String string = null;
        try {
            string = this.input.readUTF();
        }
        catch (Exception exception) {
            this.error = exception.toString();
        }
        return string;
    }

    private int socketReceiveInt() {
        int n = 0;
        try {
            n = this.input.readInt();
        }
        catch (Exception exception) {
            this.error = exception.toString();
        }
        return n;
    }

    private String[] socketReceiveStringArray() {
        String[] stringArray = null;
        try {
            int n = this.socketReceiveInt();
            stringArray = new String[n];
            int n2 = 0;
            while (n2 < n) {
                stringArray[n2] = this.socketReceiveString();
                ++n2;
            }
        }
        catch (Exception exception) {
            this.error = exception.toString();
        }
        return stringArray;
    }

    private byte[] socketReceiveByteArray() {
        byte[] byArray = null;
        try {
            int n = this.socketReceiveInt();
            byArray = new byte[n];
            int n2 = this.input.read(byArray);
            if (n2 != n) {
                byArray = null;
            }
        }
        catch (Exception exception) {
            this.error = exception.toString();
        }
        return byArray;
    }

    public String getError() {
        return this.error;
    }

    public boolean isError() {
        return this.error != null;
    }

    public String getErrorLocation() {
        return this.errorLocation;
    }

    private void displayError() {
        if (this.error == null) {
            return;
        }
        GUIAlertBox gUIAlertBox = new GUIAlertBox(this.parentFrame, "DataBase Connection Message");
        gUIAlertBox.addExitButtons("OK");
        gUIAlertBox.addText("An error has occured whilst trying to communicate with the DataBase server");
        gUIAlertBox.addText("Error : " + this.error);
        gUIAlertBox.addText("Location : " + this.errorLocation);
        gUIAlertBox.addText(" ");
        gUIAlertBox.display();
    }

    private String[] getStringArray(String string) {
        String[] stringArray = new String[]{string};
        if (string == null) {
            return null;
        }
        return stringArray;
    }

    private void debug(String string) {
        if (this.debug) {
            System.out.println(string);
        }
    }
}

