/*
 * Decompiled with CFR 0.152.
 */
package emsl.feedback;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.StringReader;
import java.net.Socket;
import java.util.Vector;

public class Email
implements Runnable {
    public static final int MESSAGE = 0;
    public static final int ERROR = 1;
    private int mailPort;
    private String mailServer;
    private String mailFrom;
    private String[] mailTo;
    private String mailSubject;
    private String mailMessage;
    private Socket socket;
    private BufferedReader dataInput;
    private PrintWriter dataOutput;
    private String heloHost;
    private ActionListener actionListener;
    private Thread timer;

    public Email() {
        this.setMailPort(25);
        this.setMailServer("pnl.gov");
    }

    public void setMailPort(int n) {
        this.mailPort = n;
    }

    public void setMailServer(String string) {
        this.mailServer = new String(string);
    }

    public void setMailFrom(String string) {
        this.mailFrom = new String(string);
    }

    public void setMailTo(String string) {
        this.mailTo = new String[1];
        this.mailTo[0] = new String(string);
    }

    public void setMailTo(String[] stringArray) {
        int n = 0;
        while (n < stringArray.length) {
            this.addMailTo(stringArray[n]);
            ++n;
        }
    }

    public void addMailTo(String string) {
        String[] stringArray = new String[this.mailTo.length + 1];
        int n = 0;
        while (n < this.mailTo.length) {
            stringArray[n + 1] = this.mailTo[n];
            ++n;
        }
        stringArray[0] = new String(string);
        this.mailTo = stringArray;
    }

    public void setMailSubject(String string) {
        this.mailSubject = new String(string);
    }

    public void setMailMessage(String string) {
        this.mailMessage = new String(string);
    }

    public void addMailMessage(String string) {
        this.mailMessage = String.valueOf(this.mailMessage) + "\r\n" + new String(string);
    }

    public void setActionListener(ActionListener actionListener) {
        this.actionListener = actionListener;
    }

    public boolean sendMail() {
        if (!this.isDataValid()) {
            return false;
        }
        this.sendActionMessage("Connecting to server (" + this.mailServer + ")...");
        if (!this.openConnection()) {
            return false;
        }
        this.sendActionMessage("Waiting for response from server (" + this.mailServer + ")...");
        if (!this.greetServer()) {
            return false;
        }
        if (!this.sendHeader()) {
            return false;
        }
        if (!this.sendData()) {
            return false;
        }
        this.closeConnection();
        this.sendActionMessage("Connection closed");
        this.sendActionMessage("Mail sent !");
        return true;
    }

    private boolean sendHeader() {
        if (!this.sendToServer("HELO", this.heloHost, 250, true)) {
            return false;
        }
        if (!this.sendToServer("MAIL FROM:", this.mailFrom, 250, true)) {
            return false;
        }
        int n = 0;
        while (n < this.mailTo.length) {
            if (!this.sendToServer("RCPT TO:", this.mailTo[n], 250, true)) {
                return false;
            }
            ++n;
        }
        return true;
    }

    private boolean sendData() {
        if (!this.sendToServer("DATA", null, 354, true)) {
            return false;
        }
        String[] stringArray = this.validateMailData(this.mailSubject);
        this.sendActionMessage("Sending data to server...");
        if (!this.sendToServer("Subject:", stringArray[0], 0, false)) {
            return false;
        }
        if (!this.sendToServer("", null, 0, false)) {
            return false;
        }
        stringArray = this.validateMailData(this.mailMessage);
        int n = 0;
        while (n < stringArray.length) {
            this.sendActionMessage("Sending data to server...");
            if (!this.sendToServer(stringArray[n], null, 0, false)) {
                return false;
            }
            ++n;
        }
        if (!this.sendToServer("\r\n.", null, 250, false)) {
            return false;
        }
        this.sendActionMessage("Sent data");
        return this.sendToServer("QUIT", null, 221, true);
    }

    /*
     * Unable to fully structure code
     */
    private boolean greetServer() {
        var1_1 = this.getServerLine(true);
        if (var1_1 == null) {
            return false;
        }
        if (!var1_1.startsWith("220")) {
            return this.sendActionError("Server not able to accept connection - Try again later");
        }
        try {
            var2_2 = var1_1.indexOf(" ");
            var3_3 = var1_1.indexOf(" ", var2_2 + 1);
            this.heloHost = var1_1.substring(var2_2, var3_3).trim();
            if (true) ** GOTO lbl15
        }
        catch (Exception v0) {
            return this.sendActionError("Unknown reply from mail server");
        }
        do {
            var1_1 = this.getServerLine(false);
lbl15:
            // 2 sources

        } while (var1_1.startsWith("220"));
        return var1_1 != null;
    }

    private boolean sendToServer(String string, String string2, int n, boolean bl) {
        String string3 = new String(string);
        if (string2 != null) {
            string3 = String.valueOf(string3) + " " + string2;
        }
        if (bl) {
            this.sendActionMessage(string3);
        }
        try {
            this.timer = new Thread(this);
            this.timer.start();
            this.dataOutput.println(string3);
            this.dataOutput.flush();
            this.timer.stop();
        }
        catch (Exception exception) {
            return this.sendActionError("Could not write to mail server");
        }
        if (n != 0) {
            return this.receiveFromServer(String.valueOf(n), string);
        }
        return true;
    }

    /*
     * Unable to fully structure code
     */
    private boolean receiveFromServer(String var1_1, String var2_2) {
        var3_3 = this.getServerLine(true);
        if (var3_3 == null) {
            return false;
        }
        if (var3_3.startsWith(var1_1)) ** GOTO lbl7
        return this.sendActionError(var3_3);
lbl-1000:
        // 1 sources

        {
            var3_3 = this.getServerLine(false);
lbl7:
            // 2 sources

            ** while (var3_3.startsWith((String)var1_1))
        }
lbl8:
        // 1 sources

        return true;
    }

    private String getServerLine(boolean bl) {
        try {
            if (!bl && !this.dataInput.ready()) {
                return "";
            }
            this.timer = new Thread(this);
            this.timer.start();
            String string = this.dataInput.readLine();
            this.timer.stop();
            return string;
        }
        catch (Exception exception) {
            this.sendActionError("Could not read from mail server");
            return null;
        }
    }

    public void run() {
        try {
            Thread.sleep(15000L);
            this.socket.close();
            this.socket = null;
            return;
        }
        catch (Exception exception) {
            return;
        }
    }

    private boolean openConnection() {
        try {
            this.timer = new Thread(this);
            this.timer.start();
            this.socket = new Socket(this.mailServer, this.mailPort);
            this.socket.setSoTimeout(10000);
            this.dataInput = new BufferedReader(new InputStreamReader(this.socket.getInputStream()));
            this.dataOutput = new PrintWriter(this.socket.getOutputStream());
            this.timer.stop();
            return true;
        }
        catch (Exception exception) {
            return this.sendActionError("Can't connect to mail server " + exception.toString());
        }
    }

    public void closeConnection() {
        try {
            this.dataOutput.close();
            this.dataInput.close();
            this.socket.close();
            return;
        }
        catch (Exception exception) {
            return;
        }
    }

    private boolean isDataValid() {
        String string = null;
        if (this.mailMessage == null) {
            string = "No Mail Message";
        }
        if (this.mailSubject == null) {
            string = "No Mail Subject Line";
        }
        if (this.mailTo.length <= 0) {
            string = "No Mail 'To' Address";
        }
        if (this.mailFrom == null) {
            string = "No Mail 'From' Address";
        }
        if (this.mailServer == null) {
            string = "No Server Name";
        }
        if (string != null) {
            return this.sendActionError(string);
        }
        return true;
    }

    private boolean sendActionError(String string) {
        this.closeConnection();
        ActionEvent actionEvent = new ActionEvent(this, 1, string);
        if (this.actionListener != null) {
            this.actionListener.actionPerformed(actionEvent);
        }
        return false;
    }

    private boolean sendActionMessage(String string) {
        ActionEvent actionEvent = new ActionEvent(this, 0, string);
        if (this.actionListener != null) {
            this.actionListener.actionPerformed(actionEvent);
        }
        return false;
    }

    private String[] validateMailData(String string) {
        Object[] objectArray;
        Vector<String> vector = new Vector<String>();
        try {
            objectArray = new StringReader(string);
            BufferedReader bufferedReader = new BufferedReader((Reader)objectArray);
            String string2 = null;
            do {
                if ((string2 = bufferedReader.readLine()) == null) continue;
                if (string2.equals(".")) {
                    string2 = ". ";
                }
                vector.addElement(string2);
            } while (string2 != null);
        }
        catch (Exception exception) {}
        objectArray = new String[vector.size()];
        vector.copyInto(objectArray);
        return objectArray;
    }
}

