/*
 * Decompiled with CFR 0.152.
 */
import emsl.awt.GUIPanel;
import emsl.text.TextBook;
import java.awt.Adjustable;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.ScrollPane;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.ComponentListener;

public class PageManager
extends GUIPanel
implements AdjustmentListener,
ActionListener {
    private GUIRuler horizontalRuler;
    private GUIRuler verticalRuler;
    private ScrollPane scrollPane;
    private GUIPanel topPanel;
    private PagePanel pagePanel;
    private TextBook textBook;
    private String viewScaleString;
    private int borderSize = 25;

    public PageManager(ComponentListener componentListener) {
        this.setLayout(new BorderLayout(0, 0));
        this.horizontalRuler = new GUIRuler(0);
        this.verticalRuler = new GUIRuler(1);
        this.add("North", this.horizontalRuler);
        this.add("West", this.verticalRuler);
        this.horizontalRuler.setVisible(false);
        this.verticalRuler.setVisible(false);
        this.scrollPane = new ScrollPane(0);
        this.add("Center", this.scrollPane);
        this.scrollPane.getHAdjustable().addAdjustmentListener(this);
        this.scrollPane.getVAdjustable().addAdjustmentListener(this);
        this.scrollPane.addComponentListener(componentListener);
        this.topPanel = new GUIPanel();
        this.topPanel.setLayout(new FlowLayout(1, this.borderSize, this.borderSize));
        this.scrollPane.add(this.topPanel);
        this.textBook = new TextBook();
        this.textBook.addActionListener(this);
        this.pagePanel = new PagePanel();
        this.pagePanel.setContentPanel(this.textBook);
        this.pagePanel.setContentBorder(3);
        this.pagePanel.setBackground(Color.white);
        this.topPanel.add(this.pagePanel);
    }

    public void setViewScale(String string) {
        if (string == null) {
            return;
        }
        this.viewScaleString = string;
    }

    public int getViewScale() {
        try {
            String string = this.viewScaleString;
            if (string.endsWith("%")) {
                string = string.substring(0, string.length() - 2);
            }
            return new Integer(string);
        }
        catch (Exception exception) {
            Dimension dimension = this.scrollPane.getViewportSize();
            Rectangle rectangle = this.pagePanel.getPixelBounds();
            int n = (dimension.width - this.borderSize - this.borderSize) * 100 / rectangle.width;
            int n2 = (dimension.height - this.borderSize - this.borderSize) * 100 / rectangle.height;
            return Math.min(n, n2);
        }
    }

    public void setBackground(Color color) {
        this.topPanel.setBackground(color);
        this.scrollPane.setBackground(color);
        super.setBackground(color);
    }

    public TextBook getTextBook() {
        return (TextBook)this.pagePanel.getContentPanel();
    }

    public PagePanel getPagePanel() {
        return this.pagePanel;
    }

    public void adjustmentValueChanged(AdjustmentEvent adjustmentEvent) {
        Adjustable adjustable = adjustmentEvent.getAdjustable();
        int n = adjustable.getOrientation();
        if (n == 0) {
            this.horizontalRuler.setRulerView(this.scrollPane, this.pagePanel, this.getViewScale());
            return;
        }
        this.verticalRuler.setRulerView(this.scrollPane, this.pagePanel, this.getViewScale());
    }

    public void setHRulerVisible(boolean bl) {
        this.horizontalRuler.setVisible(bl);
        this.redrawCurrentPage();
    }

    public void setVRulerVisible(boolean bl) {
        this.verticalRuler.setVisible(bl);
        this.redrawCurrentPage();
    }

    public boolean isHRulerVisible() {
        return this.horizontalRuler.isVisible();
    }

    public boolean isVRulerVisible() {
        return this.verticalRuler.isVisible();
    }

    public void redrawCurrentPage() {
        this.textBook.setComponentVisible(false);
        this.pagePanel.setVisible(false);
        this.pagePanel.setViewScale(this.getViewScale());
        this.pagePanel.setVisible(true);
        this.invalidate();
        this.validate();
        this.horizontalRuler.setRulerView(this.scrollPane, this.pagePanel, this.getViewScale());
        this.verticalRuler.setRulerView(this.scrollPane, this.pagePanel, this.getViewScale());
        this.textBook.setComponentVisible(true);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent == null) {
            return;
        }
        String string = actionEvent.getActionCommand();
        if (!string.equals("Cursor Position Changed")) {
            return;
        }
        Rectangle rectangle = this.textBook.getTextCursor().getCursorBounds();
        if (rectangle == null) {
            return;
        }
        rectangle.y = rectangle.y * this.textBook.getViewScale() / 100;
        rectangle.y = rectangle.y + this.textBook.getLocation().y + this.borderSize;
        Dimension dimension = this.scrollPane.getViewportSize();
        Point point = this.scrollPane.getScrollPosition();
        if (rectangle.y - 50 < point.y) {
            this.scrollPane.setScrollPosition(point.x, rectangle.y - 200);
        }
        if (rectangle.y + 50 > point.y + dimension.height) {
            this.scrollPane.setScrollPosition(point.x, rectangle.y - 100);
        }
    }
}

