/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.io.Serializable;

public class MVAtom
implements Serializable {
    private int atomicNumber;
    private double[] xyz;
    private MVProperties properties;
    private double radius;
    private String label;
    private double screenRadius;
    private double[] screenXYZ;
    private int lastFontHeight;
    private int lastFontWidth;
    private Font lastFont;

    public MVAtom(int n, double d, double d2, double d3) {
        if (this.properties == null) {
            this.properties = new MVProperties();
        }
        this.setDetails(n, d, d2, d3);
    }

    public MVAtom(String string, double d, double d2, double d3) {
        if (this.properties == null) {
            this.properties = new MVProperties();
        }
        int n = this.properties.getAtomicNumber(string);
        this.setDetails(n, d, d2, d3);
    }

    private void setDetails(int n, double d, double d2, double d3) {
        this.atomicNumber = n;
        this.xyz = new double[3];
        this.screenXYZ = new double[3];
        this.xyz[0] = this.screenXYZ[0] = d;
        this.xyz[1] = this.screenXYZ[1] = d2;
        this.xyz[2] = this.screenXYZ[2] = d3;
        this.radius = this.screenRadius = this.properties.getRadius(this.atomicNumber);
        this.lastFont = new Font("Dialog", 0, 0);
        this.label = this.properties.getLabel(this.atomicNumber);
    }

    public double[] getXYZ() {
        double[] dArray = new double[]{this.xyz[0], this.xyz[1], this.xyz[2]};
        return dArray;
    }

    public void setXYZ(double[] dArray) {
        this.xyz[0] = dArray[0];
        this.xyz[1] = dArray[1];
        this.xyz[2] = dArray[2];
    }

    public double[] getScreenXYZ() {
        double[] dArray = new double[]{this.screenXYZ[0], this.screenXYZ[1], this.screenXYZ[2]};
        return dArray;
    }

    public void setScreenXYZ(double[] dArray) {
        this.screenXYZ[0] = dArray[0];
        this.screenXYZ[1] = dArray[1];
        this.screenXYZ[2] = dArray[2];
    }

    public double getZ() {
        return this.xyz[2];
    }

    public void setZ(double d) {
        this.xyz[2] = d;
    }

    public double getRadius() {
        return this.radius;
    }

    public void setScreenRadius(double d) {
        this.screenRadius = d;
    }

    public double getScreenRadius() {
        return this.screenRadius;
    }

    public Color getColor() {
        return this.properties.getColor(this.atomicNumber);
    }

    public void paint(Graphics graphics, Color color, Color color2, boolean bl, boolean bl2, boolean bl3, boolean bl4) {
        int n = (int)Math.rint(this.screenXYZ[0]);
        int n2 = (int)Math.rint(this.screenXYZ[1]);
        int n3 = (int)Math.rint(this.screenRadius);
        if (!bl2) {
            if (!bl) {
                graphics.setColor(color2);
            } else {
                graphics.setColor(this.properties.getColor(this.atomicNumber));
            }
            graphics.fillOval(n - n3, n2 - n3, n3 * 2, n3 * 2);
            graphics.setColor(color);
            graphics.drawOval(n - n3, n2 - n3, n3 * 2, n3 * 2);
            if (bl4) {
                double d = n3;
                double d2 = d * 0.9;
                do {
                    d2 = Math.floor(d2);
                    double d3 = Math.asin(d2 / d);
                    int n4 = (int)Math.rint(d * Math.cos(d3)) + n;
                    int n5 = n2 - (int)d2;
                    int n6 = n4 - (int)Math.rint(0.3 * d * Math.abs(Math.cos(d3 + 0.5)));
                    int n7 = n5;
                    graphics.drawLine(n4, n5, n6, n7);
                } while ((d2 -= 2.2) > d * -0.98);
            }
        }
        if (bl3) {
            int n8;
            graphics.setColor(color);
            if (bl2 && bl) {
                graphics.setColor(this.properties.getColor(this.atomicNumber));
            }
            if ((n8 = n3) > 14) {
                n8 = 14;
            }
            if (n8 < 6) {
                return;
            }
            if (n8 != this.lastFont.getSize()) {
                Font font = graphics.getFont();
                this.lastFont = new Font(font.getName(), font.getStyle(), n8);
                graphics.setFont(this.lastFont);
                FontMetrics fontMetrics = graphics.getFontMetrics();
                this.lastFontWidth = this.label.length() == 1 ? fontMetrics.charWidth(this.label.charAt(0)) : fontMetrics.stringWidth(this.label);
                this.lastFontHeight = fontMetrics.getAscent();
            } else {
                graphics.setFont(this.lastFont);
            }
            graphics.drawString(this.label, n - this.lastFontWidth / 2, n2 + this.lastFontHeight / 2);
        }
    }
}

