/*
 * Decompiled with CFR 0.152.
 */
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Hashtable;
import java.util.Properties;

public class Options {
    String fileName;
    Properties options = new Properties();

    Options(String string) {
        this.setDefaults();
        this.fileName = string;
        try {
            FileInputStream fileInputStream = new FileInputStream(string);
            this.options.load(fileInputStream);
            fileInputStream.close();
            return;
        }
        catch (FileNotFoundException fileNotFoundException) {
            return;
        }
        catch (IOException iOException) {
            return;
        }
    }

    Options() {
        this.setDefaults();
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(System.getProperty("user.home"));
        stringBuffer.append(System.getProperty("file.separator"));
        stringBuffer.append("cqoptions.ini");
        this.fileName = stringBuffer.toString();
        try {
            FileInputStream fileInputStream = new FileInputStream(this.fileName);
            this.options.load(fileInputStream);
            fileInputStream.close();
            return;
        }
        catch (FileNotFoundException fileNotFoundException) {
            return;
        }
        catch (IOException iOException) {
            return;
        }
    }

    public boolean isSearchCaseIndependent() {
        Boolean bl = new Boolean(this.options.getProperty("SEARCH_CASE_INDEPENDENT"));
        return bl;
    }

    public void setSearchCaseIndependent(boolean bl) {
        Boolean bl2 = new Boolean(bl);
        ((Hashtable)this.options).put("SEARCH_CASE_INDEPENDENT", bl2.toString());
    }

    public boolean isDefaultTabCompression() {
        Boolean bl = new Boolean(this.options.getProperty("DEFAULT_TAB_COMPRESSION"));
        return bl;
    }

    public void setDefaultTabCompression(boolean bl) {
        Boolean bl2 = new Boolean(bl);
        ((Hashtable)this.options).put("DEFAULT_TAB_COMPRESSION", bl2.toString());
    }

    public boolean isForceSpaceExpansion() {
        Boolean bl = new Boolean(this.options.getProperty("FORCE_SPACE_EXPANSION"));
        return bl;
    }

    public void setForceSpaceExpansion(boolean bl) {
        Boolean bl2 = new Boolean(bl);
        ((Hashtable)this.options).put("FORCE_SPACE_EXPANSION", bl2.toString());
    }

    public boolean isForceTabCompression() {
        Boolean bl = new Boolean(this.options.getProperty("FORCE_TAB_COMPRESSION"));
        return bl;
    }

    public void setForceTabCompression(boolean bl) {
        Boolean bl2 = new Boolean(bl);
        ((Hashtable)this.options).put("FORCE_TAB_COMPRESSION", bl2.toString());
    }

    public int getFontPoint() {
        Integer n = new Integer(this.options.getProperty("FONT_POINT"));
        return n;
    }

    public void setFontPoint(int n) {
        new Integer(this.options.getProperty("FONT_POINT"));
        ((Hashtable)this.options).put("FONT_POINT", Integer.toString(n));
    }

    public boolean isFontBold() {
        Boolean bl = new Boolean(this.options.getProperty("FONT_BOLD"));
        return bl;
    }

    public void setFontBold(boolean bl) {
        Boolean bl2 = new Boolean(bl);
        ((Hashtable)this.options).put("FONT_BOLD", bl2.toString());
    }

    public String getSyntaxFile() {
        return this.options.getProperty("SYNTAX_DEFAULT");
    }

    public void setSyntaxFile(String string) {
        ((Hashtable)this.options).put("SYNTAX_DEFAULT", string);
    }

    public String getFontName() {
        return this.options.getProperty("FONT_NAME");
    }

    public void setFontName(String string) {
        ((Hashtable)this.options).put("FONT_NAME", string);
    }

    public int getDefaultHeight() {
        Integer n = new Integer(this.options.getProperty("DEFAULT_HEIGHT"));
        return n;
    }

    public void setDefaultHeight(int n) {
        ((Hashtable)this.options).put("DEFAULT_HEIGHT", Integer.toString(n));
    }

    public int getDefaultWidth() {
        Integer n = new Integer(this.options.getProperty("DEFAULT_WIDTH"));
        return n;
    }

    public void setDefaultWidth(int n) {
        ((Hashtable)this.options).put("DEFAULT_WIDTH", Integer.toString(n));
    }

    public int getTabInterval() {
        Integer n = new Integer(this.options.getProperty("TAB_INTERVAL"));
        return n;
    }

    public void setTabInterval(int n) {
        ((Hashtable)this.options).put("TAB_INTERVAL", Integer.toString(n));
    }

    public boolean isAutoIndent() {
        Boolean bl = new Boolean(this.options.getProperty("AUTO_INDENT"));
        return bl;
    }

    public void setAutoIndent(boolean bl) {
        Boolean bl2 = new Boolean(bl);
        ((Hashtable)this.options).put("AUTO_INDENT", bl2.toString());
    }

    public boolean isStripEolSpaces() {
        Boolean bl = new Boolean(this.options.getProperty("STRIP_EOL_SPACES"));
        return bl;
    }

    public void setStripEolSpaces(boolean bl) {
        Boolean bl2 = new Boolean(bl);
        ((Hashtable)this.options).put("STRIP_EOL_SPACES", bl2.toString());
    }

    public boolean isFileCaseSensitive() {
        Boolean bl = new Boolean(this.options.getProperty("FILE_CASE_SENSITIVE"));
        return bl;
    }

    public void setFileCaseSensitive(boolean bl) {
        Boolean bl2 = new Boolean(bl);
        ((Hashtable)this.options).put("FILE_CASE_SENSITIVE", bl2.toString());
    }

    public boolean isEolIndependentCursor() {
        Boolean bl = new Boolean(this.options.getProperty("EOL_INDEPENDENT_CURSOR"));
        return bl;
    }

    public void setEolIndependentCursor(boolean bl) {
        Boolean bl2 = new Boolean(bl);
        ((Hashtable)this.options).put("EOL_INDEPENDENT_CURSOR", bl2.toString());
    }

    public boolean save() {
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(this.fileName);
            this.options.save(fileOutputStream, "CodeQuill Options");
            fileOutputStream.close();
        }
        catch (FileNotFoundException fileNotFoundException) {
            return false;
        }
        catch (IOException iOException) {
            return false;
        }
        return true;
    }

    public void setDefaults() {
        ((Hashtable)this.options).put("FONT_NAME", "Monospaced");
        ((Hashtable)this.options).put("FONT_POINT", "14");
        ((Hashtable)this.options).put("FONT_BOLD", "true");
        ((Hashtable)this.options).put("DEFAULT_TAB_COMPRESSION", "false");
        ((Hashtable)this.options).put("TAB_INTERVAL", "4");
        ((Hashtable)this.options).put("FORCE_SPACE_EXPANSION", "false");
        ((Hashtable)this.options).put("FORCE_TAB_COMPRESSION", "false");
        ((Hashtable)this.options).put("SYNTAX_DEFAULT", "cqsyntax");
        ((Hashtable)this.options).put("DEFAULT_WIDTH", "600");
        ((Hashtable)this.options).put("DEFAULT_HEIGHT", "400");
        ((Hashtable)this.options).put("AUTO_INDENT", "true");
        ((Hashtable)this.options).put("STRIP_EOL_SPACES", "true");
        ((Hashtable)this.options).put("SEARCH_CASE_INDEPENDENT", "false");
        ((Hashtable)this.options).put("EOL_INDEPENDENT_CURSOR", "false");
        String string = System.getProperty("os.name");
        if (string.compareTo("Windows NT") == 0 || string.compareTo("Windows 95") == 0 || string.compareTo("OS/2") == 0) {
            ((Hashtable)this.options).put("FILE_CASE_SENSITIVE", "false");
            return;
        }
        ((Hashtable)this.options).put("FILE_CASE_SENSITIVE", "true");
    }
}

