/*
 * Decompiled with CFR 0.152.
 */
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Panel;
import java.awt.Scrollbar;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.StringReader;
import java.io.StringWriter;

public class EditSession
extends Panel
implements EditEngineInt,
EditDisplayInt,
KeyListener {
    private EditDisplay editDisplay;
    private InformationBar informationBar;
    private EditEngine editEngine;
    private LinkedList lineList;
    private File file;
    private boolean tabCompression = false;
    private RepeatQueue repeatQueue;
    private Options options;
    static final int WRITE_BUFFER_SIZE = 256;
    static final int EXPAND_BUFFER_SIZE = 256;
    static final char REQUEST_NONE = '\u0000';
    static final char REQUEST_EXIT = '\u0001';
    static final char REQUEST_COMMAND_LINE = '\u0002';
    static final char REQUEST_SEARCH_FORWARD = '\u0003';
    static final char REQUEST_SEARCH_BACK = '\u0004';
    static final int MAX_COLUMN = 512;
    char pendingRequest = '\u0000';
    StringBuffer commandLineText = new StringBuffer();
    EditSessionInt sessionMgr;
    static final char FILE_WRITE_COMPLETE = '\u0000';
    static final char FILE_WRITE_ERROR_OVERWRITE = '\u0001';
    static final char FILE_WRITE_ERROR_READONLY = '\u0002';
    static final char FILE_WRITE_ERROR_DIRECTORY = '\u0003';
    static final char FILE_WRITE_ERROR = '\u0004';
    Scrollbar verticalScrollbar;
    Scrollbar horizontalScrollbar;
    BufferMgr bufferMgr;

    public EditSession(KeyListener keyListener, EditSessionInt editSessionInt, String string, SyntaxMgr syntaxMgr, BufferMgr bufferMgr, Options options, InformationBar informationBar, SearchMgr searchMgr) {
        this.options = options;
        this.informationBar = informationBar;
        this.sessionMgr = editSessionInt;
        this.bufferMgr = bufferMgr;
        this.tabCompression = options.isDefaultTabCompression();
        this.file = new File(string);
        if (this.file.canRead()) {
            this.lineList = this.getFile(this.file);
        } else {
            this.lineList = new LinkedList();
            Line line = new Line("");
            this.lineList.add(line);
        }
        this.repeatQueue = new RepeatQueue();
        this.editEngine = new EditEngine(this, this.lineList, 0, 0, this.repeatQueue, bufferMgr, syntaxMgr, informationBar, searchMgr);
        this.editEngine.setTabInterval(options.getTabInterval());
        this.editEngine.setAutoIndent(options.isAutoIndent());
        this.editEngine.setEolIndependentCursor(options.isEolIndependentCursor());
        this.setLayout(new BorderLayout());
        this.verticalScrollbar = new Scrollbar(1);
        this.horizontalScrollbar = new Scrollbar(0);
        this.editDisplay = new EditDisplay(this, this.lineList, this.editEngine, options, this.horizontalScrollbar, this.verticalScrollbar);
        this.add((Component)this.editDisplay, "Center");
        this.editDisplay.addKeyListener(this);
        this.editDisplay.addKeyListener(keyListener);
        this.editDisplay.setCursorStyle(1);
        this.add((Component)this.verticalScrollbar, "East");
        this.add((Component)this.horizontalScrollbar, "South");
    }

    public EditSession(KeyListener keyListener, EditSessionInt editSessionInt, SyntaxMgr syntaxMgr, BufferMgr bufferMgr, Options options, InformationBar informationBar, SearchMgr searchMgr) {
        this.options = options;
        this.informationBar = informationBar;
        this.sessionMgr = editSessionInt;
        this.bufferMgr = bufferMgr;
        this.tabCompression = options.isDefaultTabCompression();
        this.lineList = new LinkedList();
        Line line = new Line("");
        this.lineList.add(line);
        this.repeatQueue = new RepeatQueue();
        this.editEngine = new EditEngine(this, this.lineList, 0, 0, this.repeatQueue, bufferMgr, syntaxMgr, informationBar, searchMgr);
        this.editEngine.setTabInterval(options.getTabInterval());
        this.editEngine.setAutoIndent(options.isAutoIndent());
        this.editEngine.setEolIndependentCursor(options.isEolIndependentCursor());
        this.setLayout(new BorderLayout());
        this.verticalScrollbar = new Scrollbar(1);
        this.horizontalScrollbar = new Scrollbar(0);
        this.editDisplay = new EditDisplay(this, this.lineList, this.editEngine, options, this.horizontalScrollbar, this.verticalScrollbar);
        this.add((Component)this.editDisplay, "Center");
        this.editDisplay.addKeyListener(this);
        this.editDisplay.addKeyListener(keyListener);
        this.editDisplay.setCursorStyle(1);
        this.add((Component)this.verticalScrollbar, "East");
        this.add((Component)this.horizontalScrollbar, "South");
    }

    public void requestFocus() {
        this.informationBar.setLineNumber(this.editEngine.getLineNumber());
        this.informationBar.setColumn(this.editEngine.getColumn());
        this.editDisplay.requestFocus();
    }

    public boolean processCommandLine(String string) {
        boolean bl = this.editEngine.processCommandLine(string);
        return bl;
    }

    public void search() {
        this.editEngine.search();
    }

    private LinkedList getFile(File file) {
        LinkedList linkedList;
        try {
            FileReader fileReader = new FileReader(file);
            BufferedReader bufferedReader = new BufferedReader(fileReader);
            linkedList = this.getData(bufferedReader);
        }
        catch (IOException iOException) {
            return null;
        }
        return linkedList;
    }

    public void undo() {
        this.editEngine.undo();
    }

    public void paste(Transferable transferable) {
        LinkedList linkedList = this.getPasteData(transferable);
        this.editEngine.paste(linkedList);
    }

    public String getCopyBuffer() {
        LinkedList linkedList = new LinkedList();
        linkedList.add(this.bufferMgr.getBuffer('\u0000'));
        StringWriter stringWriter = new StringWriter();
        BufferedWriter bufferedWriter = new BufferedWriter(stringWriter);
        this.putData(bufferedWriter, linkedList, 0, -1);
        return stringWriter.toString();
    }

    public String getMarkArea(boolean bl) {
        LinkedList linkedList;
        if (bl) {
            linkedList = this.editEngine.getCutList(this.editDisplay.getMarkAreaStartLine(), this.editDisplay.getMarkAreaStartColumn(), this.editDisplay.getMarkAreaEndLine(), this.editDisplay.getMarkAreaEndColumn());
            this.editDisplay.setWindowUpdate();
            this.editEngineUpdateCursor(this.editEngine.getLineNumber(), this.editEngine.getColumn());
        } else {
            linkedList = this.editEngine.getCopyList(this.editDisplay.getMarkAreaStartLine(), this.editDisplay.getMarkAreaStartColumn(), this.editDisplay.getMarkAreaEndLine(), this.editDisplay.getMarkAreaEndColumn());
        }
        if (linkedList == null) {
            return null;
        }
        StringWriter stringWriter = new StringWriter();
        BufferedWriter bufferedWriter = new BufferedWriter(stringWriter);
        this.putData(bufferedWriter, linkedList, 0, -1);
        return stringWriter.toString();
    }

    private LinkedList getPasteData(Transferable transferable) {
        LinkedList linkedList;
        try {
            StringReader stringReader = (StringReader)transferable.getTransferData(DataFlavor.plainTextFlavor);
            BufferedReader bufferedReader = new BufferedReader(stringReader);
            linkedList = this.getData(bufferedReader);
        }
        catch (UnsupportedFlavorException unsupportedFlavorException) {
            return null;
        }
        catch (IOException iOException) {
            return null;
        }
        return linkedList;
    }

    private LinkedList getData(BufferedReader bufferedReader) {
        char[] cArray = new char[264];
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        LinkedList linkedList = new LinkedList();
        try {
            CharSequence charSequence;
            String string = bufferedReader.readLine();
            if (string == null) {
                linkedList.add(new Line(""));
                return linkedList;
            }
            do {
                Line line;
                if (string.indexOf(9) != -1) {
                    n2 = 0;
                    n = 0;
                    String string2 = null;
                    int n4 = string.length();
                    int n5 = 0;
                    while (n4-- > 0) {
                        char c;
                        if ((c = string.charAt(n5++)) == '\t') {
                            this.tabCompression = true;
                            n2 = 8 - n2;
                            while (n2 > 0) {
                                cArray[n++] = 32;
                                --n2;
                            }
                            if (n < 256) continue;
                            string2 = string2 == null ? new String(cArray, 0, n) : string2.concat(new String(cArray, 0, n));
                            n = 0;
                            continue;
                        }
                        if (++n2 >= 8) {
                            n2 = 0;
                            if (n >= 256) {
                                string2 = string2 == null ? new String(cArray, 0, n) : string2.concat(new String(cArray, 0, n));
                                n = 0;
                            }
                        }
                        cArray[n++] = c;
                    }
                    string2 = string2 == null ? new String(cArray, 0, n) : string2.concat(new String(cArray, 0, n));
                    line = new Line();
                    line.setText(string2);
                } else {
                    line = new Line();
                    line.setText(string);
                }
                if (line.textLength() > 512) {
                    ++n3;
                    while (line.textLength() > 512) {
                        charSequence = line.cutCharacter(512);
                        linkedList.add(line);
                        line = new Line((String)charSequence);
                    }
                }
                linkedList.add(line);
            } while ((string = bufferedReader.readLine()) != null);
            if (n3 > 0) {
                charSequence = new StringBuffer();
                ((StringBuffer)charSequence).append(n3);
                ((StringBuffer)charSequence).append(" lines in read file have been split");
                this.sessionMgr.editSessionInformationMessage(((StringBuffer)charSequence).toString());
            }
        }
        catch (IOException iOException) {
            return null;
        }
        return linkedList;
    }

    private boolean writeFile(File file, int n, int n2) {
        try {
            FileWriter fileWriter = new FileWriter(file);
            BufferedWriter bufferedWriter = new BufferedWriter(fileWriter);
            this.putData(bufferedWriter, this.lineList, n, n2);
            this.editEngine.resetModified();
        }
        catch (IOException iOException) {
            return false;
        }
        return true;
    }

    /*
     * Unable to fully structure code
     */
    private boolean putData(BufferedWriter var1_1, LinkedList var2_2, int var3_3, int var4_4) {
        var8_5 = new char[256];
        var17_6 = this.options.isStripEolSpaces();
        var18_7 = var4_4 == -1 ? -1 : var4_4 - var3_3 + 1;
        var16_8 = this.tabCompression;
        if (this.options.isForceTabCompression()) {
            var16_8 = true;
        } else if (this.options.isForceSpaceExpansion()) {
            var16_8 = false;
        }
        try {
            var7_9 = 0;
            var2_2.push();
            var2_2.setTo(var3_3);
            var5_10 = (Line)var2_2.get();
            while (var5_10 != null && var18_7 == -1 || var18_7-- > 0) {
                var11_14 = var5_10.textLength();
                var12_15 = 0;
                ++var7_9;
                var6_11 = var5_10.getText();
                if (var17_6) {
                    while (var11_14 > 0) {
                        if (var6_11.charAt(var11_14 - 1) != ' ') break;
                        --var11_14;
                    }
                }
                while (var11_14 > 0) {
                    block18: {
                        if (var11_14 > 256) {
                            var13_16 = 256;
                            var11_14 -= 256;
                            var6_11 = var5_10.getText();
                        } else {
                            var13_16 = var11_14;
                            var11_14 = 0;
                        }
                        var6_11.getChars(var12_15, var12_15 + var13_16, var8_5, 0);
                        var12_15 += var13_16;
                        if (!var16_8) break block18;
                        var9_12 = 0;
                        var10_13 = 0;
                        var14_17 = 0;
                        var15_18 = 0;
                        while (var9_12 < var13_16) {
                            block19: {
                                if (var15_18++ == 8) {
                                    var15_18 = 1;
                                    if (var14_17 > 1) {
                                        var8_5[var10_13++] = 9;
                                    } else if (var14_17 == 1) {
                                        var8_5[var10_13++] = 32;
                                    }
                                    var14_17 = 0;
                                }
                                if (var8_5[var9_12] != ' ') ** GOTO lbl56
                                ++var14_17;
                                break block19;
lbl-1000:
                                // 1 sources

                                {
                                    --var14_17;
                                    var8_5[var10_13++] = 32;
lbl56:
                                    // 2 sources

                                    ** while (var14_17 > 0)
                                }
lbl57:
                                // 1 sources

                                var8_5[var10_13++] = var8_5[var9_12];
                            }
                            ++var9_12;
                        }
                        if (var14_17 > 0) {
                            var8_5[var10_13++] = 9;
                        }
                        var13_16 = var10_13;
                    }
                    var1_1.write(var8_5, 0, var13_16);
                }
                var1_1.newLine();
                var5_10 = (Line)var2_2.getNext();
            }
            var1_1.close();
        }
        catch (IOException v0) {
            return false;
        }
        var2_2.pop();
        return true;
    }

    public void keyPressed(KeyEvent keyEvent) {
        if (keyEvent.getKeyChar() != '\u0000' || keyEvent.getKeyCode() == 155 || keyEvent.getKeyCode() == 127 || keyEvent.getKeyCode() == 36 || keyEvent.getKeyCode() == 35 || keyEvent.getKeyCode() == 37 || keyEvent.getKeyCode() == 39 || keyEvent.getKeyCode() == 40 || keyEvent.getKeyCode() == 38 || keyEvent.getKeyCode() == 33 || keyEvent.getKeyCode() == 34 || keyEvent.getKeyCode() == 27 || keyEvent.getKeyCode() == 10 || keyEvent.getKeyCode() == 116 || keyEvent.getKeyCode() == 117 || keyEvent.getKeyCode() == 118 || keyEvent.getKeyCode() == 119) {
            Key key = new Key(keyEvent);
            if (key.isControl()) {
                if (key.isShift()) {
                    return;
                }
                if (key.getKeyCode() == 155 || key.getKeyCode() == 127) {
                    return;
                }
            }
            if (this.processKeys(key)) {
                keyEvent.consume();
            }
        }
    }

    public void keyTyped(KeyEvent keyEvent) {
    }

    public void keyReleased(KeyEvent keyEvent) {
    }

    private boolean processKeys(Key key) {
        key.getKeyChar();
        int n = this.editEngine.process(key);
        if (n == 2) {
            switch (this.editEngine.request()) {
                case '\u0002': {
                    this.pendingRequest = (char)2;
                    return false;
                }
                case '\u0003': {
                    this.pendingRequest = (char)3;
                    return false;
                }
                case '\u0004': {
                    this.pendingRequest = (char)4;
                    return false;
                }
            }
            this.pendingRequest = '\u0000';
            return false;
        }
        return true;
    }

    public char request() {
        char c = this.pendingRequest;
        this.pendingRequest = '\u0000';
        return c;
    }

    public char write() {
        if (!this.writeFile(this.file, 0, -1)) {
            return '\u0004';
        }
        return '\u0000';
    }

    public char write(String string, boolean bl) {
        boolean bl2 = false;
        this.file = new File(string);
        if (this.file.exists() && !bl) {
            return '\u0001';
        }
        bl2 = this.writeFile(this.file, 0, -1);
        if (!bl2) {
            return '\u0004';
        }
        return '\u0000';
    }

    public boolean isModified() {
        return this.editEngine.isModified();
    }

    public boolean isDuplicateFile(String string) {
        String string2;
        if (this.file == null) {
            return false;
        }
        try {
            string2 = this.file.getCanonicalPath();
        }
        catch (IOException iOException) {
            return false;
        }
        return string.compareTo(string2) == 0;
    }

    public String getCanonicalPath() {
        if (this.file == null) {
            return null;
        }
        try {
            return this.file.getCanonicalPath();
        }
        catch (IOException iOException) {
            return null;
        }
    }

    public String getName() {
        if (this.file == null) {
            return null;
        }
        if (this.file.getAbsolutePath() == null) {
            return "";
        }
        return this.file.getAbsolutePath();
    }

    public String getFileInformation() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("Lines: ");
        stringBuffer.append(this.lineList.getSize());
        if (this.editEngine.isModified()) {
            stringBuffer.append(", Modified ");
        } else {
            stringBuffer.append(", Unmodified ");
        }
        if (this.tabCompression) {
            stringBuffer.append(", Tab Compression");
        }
        return stringBuffer.toString();
    }

    public char editEngineWrite() {
        if (this.file == null) {
            return '\u0003';
        }
        if (this.write() != '\u0000') {
            return '\u0001';
        }
        return '\u0000';
    }

    public char editEngineWrite(String string, boolean bl) {
        File file = new File(string);
        if (file.exists() && !bl) {
            return '\u0002';
        }
        if (this.writeFile(file, 0, -1)) {
            this.file = file;
            this.sessionMgr.editSessionSetFileName(string);
            return '\u0000';
        }
        return '\u0001';
    }

    public char editEngineWrite(int n, int n2) {
        return '\u0001';
    }

    public char editEngineWrite(int n, int n2, String string, boolean bl) {
        File file = new File(string);
        if (file.exists() && !bl) {
            return '\u0002';
        }
        if (this.writeFile(file, n, n2)) {
            this.file = file;
            this.sessionMgr.editSessionSetFileName(string);
            return '\u0000';
        }
        return '\u0001';
    }

    public char editEngineRead(String string, int n) {
        File file = new File(string);
        if (!file.canRead()) {
            return '\u0005';
        }
        LinkedList linkedList = this.getFile(file);
        this.lineList.push();
        this.lineList.append(linkedList.cut());
        this.lineList.pop();
        return '\u0000';
    }

    public void editEngineQuit() {
        this.sessionMgr.editSessionQuit();
    }

    public void editEngineUpdateWindow() {
        this.editDisplay.setWindowUpdate();
        this.editEngineUpdateCursor(this.editEngine.getLineNumber(), this.editEngine.getColumn());
    }

    public void editEngineUpdateLine(int n) {
        this.editDisplay.setLineUpdate(n);
        this.editEngineUpdateCursor(this.editEngine.getLineNumber(), this.editEngine.getColumn());
    }

    public void editEngineUpdateCursor(int n, int n2) {
        if (this.editEngine.getMode() == 0) {
            this.editDisplay.setCursorStyle(1);
        } else {
            this.editDisplay.setCursorStyle(0);
        }
        this.editDisplay.setCursor(n, n2);
        this.informationBar.setLineNumber(n);
        this.informationBar.setColumn(n2);
        this.editDisplay.repaint();
    }

    public void editEngineProcessRequest(char c) {
    }

    public void editEngineSetMarkArea(int n, int n2, int n3) {
        this.editDisplay.setMarkArea(n, n2, n3);
    }

    public void editEngineResetMarkArea() {
        this.editDisplay.resetMarkArea();
    }

    public void setEnableTabCompression(boolean bl) {
        this.tabCompression = bl;
    }

    public boolean isTabCompression() {
        return this.tabCompression;
    }

    public void updateOptions() {
        this.editEngine.setAutoIndent(this.options.isAutoIndent());
        this.editEngine.setTabInterval(this.options.getTabInterval());
        this.editEngine.setEolIndependentCursor(this.options.isEolIndependentCursor());
        this.editDisplay.updateOptions();
    }

    public void setSyntaxMgr(SyntaxMgr syntaxMgr) {
        this.editEngine.setSyntaxMgr(syntaxMgr);
    }

    public void editDisplayMarkAreaSetEnabled(boolean bl) {
        this.sessionMgr.editSessionMarkAreaSetEnabled(bl);
    }

    public boolean isMarkAreaEnabled() {
        return this.editDisplay.isMarkAreaValid();
    }

    public void disableCursor() {
        this.editDisplay.disableCursor();
    }
}

