/*
 * Decompiled with CFR 0.152.
 */
public class EditEngine {
    private static final int SEARCH_OBJECT_FOUND = 0;
    private static final int SEARCH_OBJECT_NOT_FOUND = 1;
    private static final int SEARCH_OBJECT_SHORT = 2;
    private static final int SEARCH_OBJECT_REQUEST = 3;
    public static final int COMPLETE = 0;
    public static final int HANDLED = 1;
    public static final int NOT_HANDLED = 2;
    private static final int NOT_HANDLED_INHIBIT_RESET = 3;
    public static final int COMMAND_MODE = 0;
    public static final int INPUT_MODE = 1;
    private int mode;
    private Line editLine;
    private Key commandKey;
    private StringBuffer inputQueue;
    private LinkedList lineList;
    private int lineNumber;
    private int column;
    private int commandNumber;
    private int rawCommandNumber;
    private int windowStartLine;
    private int windowSizeInLines = 1;
    private boolean defaultCommandNumber;
    private int tabInterval = 8;
    private boolean autoIndent = false;
    private static final int REPLACE = 0;
    private static final int INSERT = 1;
    private static final int CHANGE = 2;
    private int editType;
    private EditAtom editAtom;
    private int replaceCount;
    private int changeCount;
    private StringBuffer numberBuffer;
    private RepeatQueue repeatQueue;
    private char addressedBuffer;
    private BufferMgr bufferMgr;
    private SearchMgr searchMgr;
    private SyntaxMgr syntaxMgr;
    private CommandMgr commandMgr;
    private InformationBar informationBar;
    private boolean fileModified = false;
    int searchColumn;
    int searchLine;
    int searchLength;
    boolean searchWrap;
    int textAreaStartColumn;
    int textAreaStartLine;
    int textAreaEndColumn;
    int textAreaEndLine;
    boolean textAreaWholeLine;
    static final char REQUEST_NONE = '\u0000';
    static final char REQUEST_EXIT = '\u0001';
    static final char REQUEST_COMMAND_LINE = '\u0002';
    static final char REQUEST_SEARCH_FORWARD = '\u0003';
    static final char REQUEST_SEARCH_BACK = '\u0004';
    char pendingRequest = '\u0000';
    private static final char CMD_ABBREV = '\u0001';
    private static final char CMD_APPEND = '\u0002';
    private static final char CMD_ARGS = '\u0003';
    private static final char CMD_CHANGE = '\u0004';
    private static final char CMD_COPY = '\u0005';
    private static final char CMD_DELETE = '\u0006';
    private static final char CMD_EDIT = '\u0007';
    private static final char CMD_FILE = '\b';
    private static final char CMD_GLOBAL = '\t';
    private static final char CMD_INSERT = '\u0010';
    private static final char CMD_JOIN = '\u0011';
    private static final char CMD_LIST = '\u0012';
    private static final char CMD_MAP = '\u0013';
    private static final char CMD_MARK = '\u0014';
    private static final char CMD_MOVE = '\u0015';
    private static final char CMD_NEXT = '\u0010';
    private static final char CMD_NUMBER = '\u0010';
    private static final char CMD_PRESERVE = '\u0010';
    private static final char CMD_PRINT = '\u0016';
    private static final char CMD_PUT = '\u0017';
    private static final char CMD_QUIT = '\u0018';
    private static final char CMD_QUITFORCE = 'B';
    private static final char CMD_READ = '\u0019';
    private static final char CMD_RECOVER = ' ';
    private static final char CMD_REWIND = '!';
    private static final char CMD_SET = '\"';
    private static final char CMD_SHELL = '#';
    private static final char CMD_SOURCE = '$';
    private static final char CMD_SUBSTITUTE = '%';
    private static final char CMD_UNABBREV = '&';
    private static final char CMD_UNDO = '\'';
    private static final char CMD_UNMAP = '(';
    private static final char CMD_VERSION = ')';
    private static final char CMD_VISUAL = '0';
    private static final char CMD_WRITE = '1';
    private static final char CMD_WRITEFORCE = 'C';
    private static final char CMD_WRITEQUIT = '2';
    private static final char CMD_XIT = '3';
    private static final char CMD_YANK = '4';
    private static final char CMD_WINDOW = '5';
    private static final char CMD_ESCAPE = '6';
    private static final char CMD_LSHIFT = '7';
    private static final char CMD_RSHIFT = '8';
    private static final char CMD_RESUBST = '9';
    private static final char CMD_SCROLL = '@';
    private static final char CMD_LINE_NO = 'A';
    int rangeStartLine;
    int rangeStartColumn;
    int rangeEndLine;
    int rangeEndColumn;
    boolean rangeDefault;
    String substituteSearchPattern = new String();
    String substituteReplacePattern = new String();
    boolean substituteGlobal;
    boolean updateCursor = false;
    int updateLine = -1;
    boolean updateWindow = false;
    boolean setMarkArea = false;
    boolean resetMarkArea = false;
    EditEngineInt session;
    private boolean useSavedCursorColumn = false;
    private int savedCursorColumn;
    private boolean eolIndependentCursor = false;
    private static final char MAX_COLUMN = '\u0200';
    private String undoLine;
    private boolean commandQuit = false;

    EditEngine(EditEngineInt editEngineInt, LinkedList linkedList, int n, int n2, RepeatQueue repeatQueue, BufferMgr bufferMgr, SyntaxMgr syntaxMgr, InformationBar informationBar, SearchMgr searchMgr) {
        this.commandMgr = new CommandMgr();
        this.setupCommands();
        this.session = editEngineInt;
        this.lineList = linkedList;
        this.column = n2;
        this.lineNumber = n;
        this.repeatQueue = repeatQueue;
        this.bufferMgr = bufferMgr;
        this.syntaxMgr = syntaxMgr;
        this.informationBar = informationBar;
        this.searchMgr = searchMgr;
        linkedList.setTo(n);
        this.inputQueue = new StringBuffer();
        this.numberBuffer = new StringBuffer();
        this.numberBuffer.setLength(0);
        this.numberBuffer.append("0");
        this.mode = 0;
        this.setCommandNumber(0);
    }

    public int process(Key key) {
        int n = 0;
        int n2 = 0;
        if (this.mode == 0) {
            if (this.inputQueue.length() == 0) {
                if (Character.isDigit(key.getKeyChar()) && !(key.getKeyChar() == '0' && this.numberBuffer.length() == 1)) {
                    this.numberBuffer.append(key.getKeyChar());
                    try {
                        n2 = Integer.parseInt(this.numberBuffer.toString());
                    }
                    catch (NumberFormatException numberFormatException) {
                        StringBuffer stringBuffer = new StringBuffer("Invalid command number: ");
                        stringBuffer.append(this.numberBuffer.toString());
                        this.postUserMessage(stringBuffer.toString());
                        this.numberBuffer.setLength(0);
                        this.numberBuffer.append("0");
                    }
                    return 1;
                }
                n2 = Integer.parseInt(this.numberBuffer.toString());
                this.setCommandNumber(n2);
                this.numberBuffer.setLength(0);
                this.numberBuffer.append("0");
                if (key.getKeyChar() == '.') {
                    this.inputQueue.setLength(0);
                    if (n2 == 0) {
                        this.setCommandNumber(this.repeatQueue.getCommandNumber());
                    } else {
                        this.repeatQueue.setCommandNumber(n2);
                    }
                    this.commandKey = this.repeatQueue.getCommandKey();
                    if (this.commandKey != null) {
                        this.inputQueue.setLength(0);
                        this.inputQueue.append(this.repeatQueue.getCommandQueue());
                        this.repeatQueue.setInhibitUpdate(true);
                        n = this.processQueue();
                        int n3 = 0;
                        char c = this.repeatQueue.getCharacter(n3);
                        while (c != '\u0000') {
                            this.commandKey = new Key(c, false, false, false);
                            this.processQueue();
                            c = this.repeatQueue.getCharacter(++n3);
                        }
                        this.repeatQueue.setInhibitUpdate(false);
                    }
                } else {
                    this.commandKey = key;
                    this.inputQueue.append(key.getKeyChar());
                    n = this.processQueue();
                }
            } else {
                this.inputQueue.append(key.getKeyChar());
                n = this.processQueue();
            }
        } else if (this.mode == 1) {
            this.commandKey = key;
            n = this.processQueue();
        }
        if (this.updateWindow) {
            this.updateWindow = false;
            this.updateLine = -1;
            this.updateCursor = false;
            this.session.editEngineUpdateWindow();
        } else if (this.updateLine != -1) {
            this.updateLine = -1;
            this.updateCursor = false;
            this.session.editEngineUpdateLine(this.lineNumber);
        } else if (this.updateCursor) {
            this.updateCursor = false;
            this.session.editEngineUpdateCursor(this.lineNumber, this.column);
        }
        if (this.setMarkArea) {
            this.setMarkArea = false;
            this.session.editEngineSetMarkArea(this.searchLine, this.searchColumn, this.searchLength);
        } else if (this.resetMarkArea) {
            this.resetMarkArea = false;
            this.session.editEngineResetMarkArea();
        }
        if (n == 3) {
            n = 2;
        } else if (n != 1) {
            this.inputQueue.setLength(0);
            this.numberBuffer.setLength(0);
            this.numberBuffer.append('0');
            this.setCommandNumber(0);
        }
        return n;
    }

    public void setCommandNumber(int n) {
        this.commandNumber = n;
        this.rawCommandNumber = n;
        if (this.commandNumber == 0) {
            this.commandNumber = 1;
            this.defaultCommandNumber = true;
            return;
        }
        this.defaultCommandNumber = false;
    }

    public void setCommandNumber(String string) {
        int n;
        try {
            n = Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            n = 0;
        }
        this.commandNumber = n;
        this.rawCommandNumber = n;
        if (this.commandNumber == 0) {
            this.commandNumber = 1;
            this.defaultCommandNumber = true;
            return;
        }
        this.defaultCommandNumber = false;
    }

    public void stop() {
    }

    public int getLineNumber() {
        return this.lineNumber;
    }

    public int getColumn() {
        return this.column;
    }

    public void setWindowCursorPosition(int n, int n2, int n3, int n4) {
        if (n3 != this.lineNumber) {
            this.resetUndoLine();
        }
        if (this.mode == 1) {
            Key key = new Key('\u001b', false, false, false);
            this.process(key);
        }
        this.windowStartLine = n2;
        this.windowSizeInLines = n;
        this.lineNumber = n3;
        this.lineList.setTo(this.lineNumber);
        this.column = n4;
        this.adjustWindow();
        this.informationBar.setLineNumber(this.lineNumber);
        this.informationBar.setColumn(this.column);
    }

    public void setWindowPosition(int n) {
        this.windowStartLine = n;
    }

    public void setWindowSizeInLines(int n) {
        this.windowSizeInLines = n;
        this.adjustWindow();
    }

    public int getWindowStartLine() {
        return this.windowStartLine;
    }

    public void setTabInterval(int n) {
        this.tabInterval = n;
    }

    public void setEolIndependentCursor(boolean bl) {
        this.eolIndependentCursor = bl;
    }

    /*
     * Unable to fully structure code
     */
    private int processQueue() {
        block303: {
            block302: {
                var2_1 = 0;
                var3_2 = this.lineNumber;
                var4_3 = false;
                var5_4 = this.useSavedCursorColumn;
                this.useSavedCursorColumn = false;
                var3_2 = this.lineNumber;
                if (this.mode != 0) break block302;
                block0 : switch (this.commandKey.getKeyChar()) {
                    case '\u001b': {
                        this.informationBar.clearMessage();
                        this.resetMarkArea = true;
                        break;
                    }
                    case '\u0007': {
                        var6_5 = new StringBuffer();
                        var6_5.append("Lines: ");
                        var6_5.append(this.lineList.getSize());
                        if (this.isModified()) {
                            var6_5.append(", Modified ");
                        } else {
                            var6_5.append(", Unmodified ");
                        }
                        this.informationBar.setMessage(var6_5.toString());
                    }
                    case 'H': {
                        this.updateCursor = true;
                        this.lineNumber = this.windowStartLine;
                        this.lineList.setTo(this.lineNumber);
                        this.incrementLine(this.commandNumber - 1);
                        this.column = ((Line)this.lineList.get()).firstNonSpace(0);
                        break;
                    }
                    case 'M': {
                        this.updateCursor = true;
                        this.lineNumber = this.windowStartLine;
                        this.lineList.setTo(this.lineNumber);
                        this.incrementLine(this.windowSizeInLines / 2);
                        this.column = ((Line)this.lineList.get()).firstNonSpace(0);
                        break;
                    }
                    case 'L': {
                        this.updateCursor = true;
                        this.lineNumber = this.windowStartLine;
                        this.lineList.setTo(this.lineNumber);
                        this.incrementLine(this.windowSizeInLines - 1);
                        this.column = ((Line)this.lineList.get()).firstNonSpace(0);
                        break;
                    }
                    case '\b': 
                    case 'h': {
                        this.updateCursor = true;
                        this.decrementColumn(this.commandNumber);
                        break;
                    }
                    case ' ': 
                    case 'l': {
                        this.updateCursor = true;
                        this.incrementColumn(this.commandNumber);
                        break;
                    }
                    case '^': {
                        this.updateCursor = true;
                        this.column = ((Line)this.lineList.get()).firstNonSpace(0);
                        break;
                    }
                    case '0': {
                        this.updateCursor = true;
                        this.column = 0;
                        break;
                    }
                    case '\n': {
                        this.updateCursor = true;
                        this.incrementLine(this.commandNumber);
                        this.column = ((Line)this.lineList.get()).firstNonSpace(0);
                        break;
                    }
                    case '+': 
                    case 'j': {
                        this.updateCursor = true;
                        this.incrementLine(this.commandNumber);
                        this.checkCursorColumn(var5_4);
                        this.updateCursor = true;
                        break;
                    }
                    case '-': 
                    case 'k': {
                        this.updateCursor = true;
                        this.decrementLine(this.commandNumber);
                        this.checkCursorColumn(var5_4);
                        break;
                    }
                    case 'G': {
                        this.updateCursor = true;
                        if (this.commandNumber > this.lineList.getSize()) {
                            this.postUserMessage("Addressed line number exceeds size");
                            break;
                        }
                        if (this.defaultCommandNumber) {
                            this.commandNumber = this.lineList.getSize();
                        }
                        this.lineNumber = this.commandNumber - 1;
                        this.lineList.setTo(this.lineNumber);
                        this.column = 0;
                        break;
                    }
                    case 'z': {
                        this.updateWindow = true;
                        if (this.inputQueue.length() == 1) {
                            var2_1 = 1;
                            break;
                        }
                        if (this.inputQueue.charAt(1) == '.') {
                            this.windowStartLine = this.lineNumber - this.windowSizeInLines / 2;
                            break;
                        }
                        if (this.inputQueue.charAt(1) == '+') {
                            this.windowStartLine = this.lineNumber;
                            break;
                        }
                        if (this.inputQueue.charAt(1) == '\n') {
                            this.windowStartLine = this.lineNumber;
                            break;
                        }
                        if (this.inputQueue.charAt(1) == '-') {
                            this.windowStartLine = this.lineNumber - (this.windowSizeInLines - 1);
                            break;
                        }
                        break block303;
                    }
                    case '>': {
                        if (this.inputQueue.length() == 1) {
                            var2_1 = 1;
                            break;
                        }
                        this.setUndoLine();
                        this.updateWindow = true;
                        var10_34 = 1;
                        var9_43 = '.';
                        if (this.inputQueue.length() <= 1) ** GOTO lbl132
                        if (!Character.isDigit(this.inputQueue.charAt(var10_34))) ** GOTO lbl130
                        while (Character.isDigit(this.inputQueue.charAt(var10_34))) {
                            if (this.inputQueue.length() <= var10_34 + 1) {
                                var2_1 = 1;
                                break;
                            }
                            ++var10_34;
                        }
                        if (var2_1 == 1) break block303;
                        this.setCommandNumber(this.inputQueue.toString().substring(1, var10_34));
lbl130:
                        // 2 sources

                        if ((var9_43 = (int)this.inputQueue.charAt(var10_34)) == this.inputQueue.charAt(0)) {
                            var9_43 = 46;
                        }
lbl132:
                        // 4 sources

                        this.fileModified = true;
                        if (this.inputQueue.length() <= var10_34 + 1) {
                            var7_52 = false;
                            var8_66 = '\u0000';
                        } else {
                            var7_52 = true;
                            var8_66 = this.inputQueue.charAt(var10_34 + 1);
                        }
                        var6_6 = this.defineTextArea((char)var9_43, var8_66, var7_52, this.lineList, this.lineNumber, this.column, this.commandNumber);
                        if (var6_6 == 0) {
                            this.textAreaWholeLine = true;
                            this.lineList.setTo(this.textAreaStartLine);
                            this.editAtom = new EditAtom(this.lineList, this.textAreaStartLine);
                            var11_79 = this.textAreaEndLine - this.textAreaStartLine + 1;
                            this.editAtom.addSaveLine(this.copyLine(this.lineList, var11_79));
                            this.bufferMgr.saveBuffer(this.addressedBuffer, this.copyTextArea(this.lineList, this.textAreaStartLine, this.textAreaStartColumn, this.textAreaEndLine, this.textAreaEndColumn, this.textAreaWholeLine), this.textAreaWholeLine);
                            this.editAtom.setEditLineCount(var11_79);
                            this.lineNumber = this.textAreaStartLine;
                            this.lineList.setTo(this.lineNumber);
                            var12_90 = this.textAreaEndLine - this.textAreaStartLine;
                            while (var12_90-- >= 0) {
                                if (((Line)this.lineList.get()).firstNonSpace(-1) != -1) {
                                    ((Line)this.lineList.get()).insertCharacter(' ', 0, this.tabInterval);
                                }
                                this.lineList.next();
                            }
                            this.lineList.setTo(this.textAreaStartLine);
                            this.column = ((Line)this.lineList.get()).firstNonSpace(0);
                            if (var12_90 > 0) {
                                var13_96 = new StringBuffer("Shifted ");
                                var13_96.append(var12_90);
                                var13_96.append(" lines.");
                                this.postUserMessage(var13_96.toString());
                            }
                            this.addressedBuffer = '\u0000';
                            this.repeatQueue.setCommandKey(this.commandKey, this.rawCommandNumber);
                            this.repeatQueue.setCommandQueue(this.inputQueue.toString());
                            break;
                        }
                        if (var6_6 == 2) {
                            var2_1 = 1;
                            break;
                        }
                        if (var6_6 == 3) {
                            var2_1 = 3;
                            break;
                        }
                        this.addressedBuffer = '\u0000';
                        break;
                    }
                    case '<': {
                        if (this.inputQueue.length() == 1) {
                            var2_1 = 1;
                            break;
                        }
                        this.setUndoLine();
                        this.updateWindow = true;
                        var10_35 = 1;
                        var9_44 = '.';
                        if (this.inputQueue.length() <= 1) ** GOTO lbl202
                        if (!Character.isDigit(this.inputQueue.charAt(var10_35))) ** GOTO lbl200
                        while (Character.isDigit(this.inputQueue.charAt(var10_35))) {
                            if (this.inputQueue.length() <= var10_35 + 1) {
                                var2_1 = 1;
                                break;
                            }
                            ++var10_35;
                        }
                        if (var2_1 == 1) break block303;
                        this.setCommandNumber(this.inputQueue.toString().substring(1, var10_35));
lbl200:
                        // 2 sources

                        if ((var9_44 = (int)this.inputQueue.charAt(var10_35)) == this.inputQueue.charAt(0)) {
                            var9_44 = 46;
                        }
lbl202:
                        // 4 sources

                        this.fileModified = true;
                        if (this.inputQueue.length() <= var10_35 + 1) {
                            var7_53 = false;
                            var8_67 = '\u0000';
                        } else {
                            var7_53 = true;
                            var8_67 = this.inputQueue.charAt(var10_35 + 1);
                        }
                        var6_7 = this.defineTextArea((char)var9_44, var8_67, var7_53, this.lineList, this.lineNumber, this.column, this.commandNumber);
                        if (var6_7 == 0) {
                            this.textAreaWholeLine = true;
                            this.lineList.setTo(this.textAreaStartLine);
                            this.editAtom = new EditAtom(this.lineList, this.textAreaStartLine);
                            var11_80 = this.textAreaEndLine - this.textAreaStartLine + 1;
                            this.editAtom.addSaveLine(this.copyLine(this.lineList, var11_80));
                            this.bufferMgr.saveBuffer(this.addressedBuffer, this.copyTextArea(this.lineList, this.textAreaStartLine, this.textAreaStartColumn, this.textAreaEndLine, this.textAreaEndColumn, this.textAreaWholeLine), this.textAreaWholeLine);
                            this.editAtom.setEditLineCount(var11_80);
                            this.lineNumber = this.textAreaStartLine;
                            this.lineList.setTo(this.lineNumber);
                            var13_97 = this.textAreaEndLine - this.textAreaStartLine;
                            while (var13_97-- >= 0) {
                                var12_91 = ((Line)this.lineList.get()).firstNonSpace(0);
                                if (var12_91 > 0) {
                                    if (var12_91 > this.tabInterval) {
                                        var12_91 = this.tabInterval;
                                    }
                                    ((Line)this.lineList.get()).deleteCharacter(0, var12_91);
                                }
                                this.lineList.next();
                            }
                            this.lineList.setTo(this.textAreaStartLine);
                            this.column = ((Line)this.lineList.get()).firstNonSpace(0);
                            if (var13_97 > 0) {
                                var14_99 = new StringBuffer("Shifted ");
                                var14_99.append(var13_97);
                                var14_99.append(" lines.");
                                this.postUserMessage(var14_99.toString());
                            }
                            this.addressedBuffer = '\u0000';
                            this.repeatQueue.setCommandKey(this.commandKey, this.rawCommandNumber);
                            this.repeatQueue.setCommandQueue(this.inputQueue.toString());
                            break;
                        }
                        if (var6_7 == 2) {
                            var2_1 = 1;
                            break;
                        }
                        if (var6_7 == 3) {
                            var2_1 = 3;
                            break;
                        }
                        this.addressedBuffer = '\u0000';
                        break;
                    }
                    case '&': {
                        this.updateWindow = true;
                        var6_8 = this.defineTextArea('.', '\u0000', false, this.lineList, this.lineNumber, 0, this.commandNumber);
                        if (var6_8 == 0) {
                            this.textAreaWholeLine = true;
                            this.setUndoLine();
                            this.lineList.setTo(this.textAreaStartLine);
                            this.editAtom = new EditAtom(this.lineList, this.textAreaStartLine);
                            var7_54 = this.textAreaEndLine - this.textAreaStartLine + 1;
                            this.editAtom.addSaveLine(this.copyLine(this.lineList, var7_54));
                            this.editAtom.setEditLineCount(var7_54);
                            this.lineNumber = this.textAreaStartLine;
                            this.lineList.setTo(this.lineNumber);
                            var11_81 = this.textAreaEndLine - this.textAreaStartLine;
                            var12_92 = true;
                            var8_68 = this.substituteSearchPattern.length();
                            var9_45 = this.substituteReplacePattern.length();
                            if (var8_68 == 0 || var9_45 == 0) {
                                this.postUserMessage("Substitute pattern not valid");
                                break;
                            }
                            var13_98 = new ReEngine(this.substituteSearchPattern);
                            while (var11_81-- >= 0) {
                                var10_36 = 0;
                                while (var13_98.find(((Line)this.lineList.get()).getText(), var10_36)) {
                                    if (!var12_92) {
                                        var12_92 = true;
                                    }
                                    ((Line)this.lineList.get()).deleteCharacter(var13_98.getIndex(), var13_98.getLength());
                                    ((Line)this.lineList.get()).insert(this.substituteReplacePattern, var13_98.getIndex());
                                    var10_36 = var13_98.getIndex() + var9_45;
                                    if (!this.substituteGlobal || var10_36 >= ((Line)this.lineList.get()).textLength()) break;
                                }
                                this.lineList.next();
                            }
                            this.lineList.setTo(this.textAreaStartLine);
                            var10_36 = ((Line)this.lineList.get()).firstNonSpace(0);
                            if (var11_81 > 0) {
                                var14_100 = new StringBuffer("Substitutions on ");
                                var14_100.append(var11_81);
                                var14_100.append(" lines");
                                this.postUserMessage(var14_100.toString());
                            }
                            this.addressedBuffer = '\u0000';
                            this.repeatQueue.setCommandKey(this.commandKey, this.rawCommandNumber);
                            this.repeatQueue.setCommandQueue(this.inputQueue.toString());
                            break;
                        }
                        if (var6_8 == 2) {
                            var2_1 = 1;
                            break;
                        }
                        if (var6_8 == 3) {
                            var2_1 = 3;
                            break;
                        }
                        this.addressedBuffer = '\u0000';
                        break;
                    }
                    case '$': {
                        this.updateCursor = true;
                        this.column = ((Line)this.lineList.get()).textLength();
                        if (this.column > 0) {
                            --this.column;
                        }
                        this.useSavedCursorColumn = true;
                        this.savedCursorColumn = 512;
                        break;
                    }
                    case 'W': 
                    case 'w': {
                        this.updateCursor = true;
                        var6_9 = this.inputQueue.charAt(0) != 'w';
                        if (this.searchForwardWord(this.lineList, this.lineNumber, this.column, var6_9, this.commandNumber, false)) {
                            this.lineNumber = this.searchLine;
                            this.column = this.searchColumn;
                            this.lineList.setTo(this.lineNumber);
                            break;
                        }
                        break block303;
                    }
                    case 'B': 
                    case 'b': {
                        this.updateCursor = true;
                        var6_10 = this.inputQueue.charAt(0) != 'b';
                        if (this.searchBackWord(this.lineList, this.lineNumber, this.column, var6_10, this.commandNumber)) {
                            this.lineNumber = this.searchLine;
                            this.column = this.searchColumn;
                            this.lineList.setTo(this.lineNumber);
                            break;
                        }
                        break block303;
                    }
                    case 'E': 
                    case 'e': {
                        this.updateWindow = true;
                        var6_11 = this.inputQueue.charAt(0) != 'e';
                        if (this.searchForwardWordEnd(this.lineList, this.lineNumber, this.column, var6_11, this.commandNumber, false)) {
                            this.lineNumber = this.searchLine;
                            this.column = this.searchColumn;
                            this.lineList.setTo(this.lineNumber);
                            break;
                        }
                        break block303;
                    }
                    case 't': {
                        if (this.inputQueue.length() == 1) {
                            var2_1 = 1;
                            break;
                        }
                        this.updateWindow = true;
                        if (this.searchForwardCharacter(this.lineList, this.lineNumber, this.column, this.inputQueue.charAt(1), this.commandNumber, false)) {
                            this.lineNumber = this.searchLine;
                            this.column = this.searchColumn;
                            this.lineList.setTo(this.lineNumber);
                            break;
                        }
                        break block303;
                    }
                    case 'f': {
                        if (this.inputQueue.length() == 1) {
                            var2_1 = 1;
                            break;
                        }
                        this.updateWindow = true;
                        if (this.searchForwardCharacter(this.lineList, this.lineNumber, this.column, this.inputQueue.charAt(1), this.commandNumber, true)) {
                            this.lineNumber = this.searchLine;
                            this.column = this.searchColumn;
                            this.lineList.setTo(this.lineNumber);
                            break;
                        }
                        break block303;
                    }
                    case 'm': {
                        if (this.inputQueue.length() == 1) {
                            var2_1 = 1;
                            break;
                        }
                        var6_12 = this.findMarkLine(this.inputQueue.charAt(1));
                        if (var6_12 != -1) {
                            this.lineList.setTo(var6_12);
                            ((Line)this.lineList.get()).resetMark();
                        }
                        this.lineList.setTo(this.lineNumber);
                        ((Line)this.lineList.get()).setMark(this.inputQueue.charAt(1));
                        break;
                    }
                    case '\'': {
                        if (this.inputQueue.length() == 1) {
                            var2_1 = 1;
                            break;
                        }
                        this.updateCursor = true;
                        var6_13 = this.findMarkLine(this.inputQueue.charAt(1));
                        if (var6_13 != -1) {
                            this.lineNumber = var6_13;
                            this.lineList.setTo(var6_13);
                            break;
                        }
                        break block303;
                    }
                    case '\t': {
                        this.updateCursor = true;
                        if (!this.commandKey.isShift()) {
                            var6_14 = this.column % this.tabInterval;
                            var6_14 = var6_14 == 0 ? this.tabInterval : this.tabInterval - var6_14;
                            this.incrementColumn(var6_14);
                            break;
                        }
                        if (this.column > this.tabInterval) {
                            var6_15 = this.column % this.tabInterval;
                            if (var6_15 == 0) {
                                var6_15 = this.tabInterval;
                            }
                            this.column -= var6_15;
                            break;
                        }
                        this.column = 0;
                        break;
                    }
                    case '\u0002': 
                    case '\u0015': {
                        this.updateWindow = true;
                        var6_16 = this.windowSizeInLines - 1;
                        if (this.commandKey.getKeyChar() == '\u0015') {
                            var6_16 /= 2;
                        }
                        this.decrementLine(var6_16 *= this.commandNumber);
                        this.windowStartLine -= var6_16;
                        this.column = ((Line)this.lineList.get()).firstNonSpace(0);
                        break;
                    }
                    case '\u0004': 
                    case '\u0006': {
                        this.updateWindow = true;
                        var6_17 = this.windowSizeInLines - 1;
                        if (this.commandKey.getKeyChar() == '\u0004') {
                            var6_17 /= 2;
                        }
                        this.incrementLine(var6_17 *= this.commandNumber);
                        this.windowStartLine += var6_17;
                        this.column = ((Line)this.lineList.get()).firstNonSpace(0);
                        break;
                    }
                    case 'I': {
                        this.updateCursor = true;
                        this.fileModified = true;
                        this.editLine = (Line)this.lineList.get();
                        this.editAtom = new EditAtom(this.lineList, this.lineNumber);
                        this.setUndoLine();
                        this.editAtom.addSaveLine((Line)this.lineList.get());
                        this.mode = 1;
                        this.editType = 1;
                        this.replaceCount = 0;
                        this.repeatQueue.setCommandKey(this.commandKey, this.rawCommandNumber);
                        break;
                    }
                    case 'A': {
                        this.column = ((Line)this.lineList.get()).textLength() - 1;
                    }
                    case 'a': {
                        ++this.column;
                        if (this.column >= 512) {
                            this.column = 511;
                        }
                    }
                    case 'i': {
                        this.fileModified = true;
                        this.editLine = (Line)this.lineList.get();
                        this.editAtom = new EditAtom(this.lineList, this.lineNumber);
                        this.editAtom.addSaveLine((Line)this.lineList.get());
                        this.setUndoLine(this.editLine.getText());
                        this.updateCursor = true;
                        this.mode = 1;
                        this.editType = 1;
                        this.replaceCount = 0;
                        this.repeatQueue.setCommandKey(this.commandKey, this.rawCommandNumber);
                        break;
                    }
                    case 'O': {
                        this.updateWindow = true;
                        this.fileModified = true;
                        this.mode = 1;
                        this.editType = 1;
                        this.replaceCount = 0;
                        this.editAtom = new EditAtom(this.lineList, this.lineNumber);
                        this.setUndoLine();
                        this.lineList.insert(new Line(""));
                        this.lineList.previous();
                        this.editLine = (Line)this.lineList.get();
                        this.column = this.findNestColumn();
                        this.repeatQueue.setCommandKey(this.commandKey, this.rawCommandNumber);
                        break;
                    }
                    case 'o': {
                        this.updateWindow = true;
                        this.fileModified = true;
                        this.mode = 1;
                        this.editType = 1;
                        this.replaceCount = 0;
                        this.lineList.append(new Line(""));
                        this.incrementLine();
                        this.editLine = (Line)this.lineList.get();
                        this.column = this.findNestColumn();
                        this.editAtom = new EditAtom(this.lineList, this.lineNumber);
                        this.repeatQueue.setCommandKey(this.commandKey, this.rawCommandNumber);
                        break;
                    }
                    case '~': {
                        this.setUndoLine();
                        this.updateWindow = true;
                        this.fileModified = true;
                        this.editAtom = new EditAtom(this.lineList, this.lineNumber);
                        this.editAtom.addSaveLine((Line)this.lineList.get());
                        var6_18 = this.commandNumber;
                        while (var6_18-- > 0) {
                            var7_55 = ((Line)this.lineList.get()).getCharacter(this.column);
                            if (var7_55 == '\u0000') break;
                            if (Character.isUpperCase(var7_55)) {
                                ((Line)this.lineList.get()).replaceCharacter(Character.toLowerCase(var7_55), this.column);
                            } else if (Character.isLowerCase(var7_55)) {
                                ((Line)this.lineList.get()).replaceCharacter(Character.toUpperCase(var7_55), this.column);
                            }
                            ++this.column;
                        }
                        this.repeatQueue.setCommandKey(this.commandKey, this.rawCommandNumber);
                        break;
                    }
                    case 'r': {
                        if (this.inputQueue.length() == 1) {
                            var2_1 = 1;
                            break;
                        }
                        this.setUndoLine();
                        if (this.column + this.commandNumber > 512) {
                            this.postUserMessage("Replace would exceed maximum line length");
                            break;
                        }
                        if (this.inputQueue.charAt(1) >= ' ') {
                            this.updateWindow = true;
                            this.fileModified = true;
                            this.editAtom = new EditAtom(this.lineList, this.lineNumber);
                            this.editAtom.addSaveLine((Line)this.lineList.get());
                            ((Line)this.lineList.get()).replaceCharacter(this.inputQueue.charAt(1), this.column, this.commandNumber);
                            this.column += this.commandNumber - 1;
                            this.repeatQueue.setCommandKey(this.commandKey, this.rawCommandNumber);
                            this.repeatQueue.setCommandQueue(this.inputQueue.toString());
                            break;
                        }
                        break block303;
                    }
                    case 'R': {
                        this.updateCursor = true;
                        this.fileModified = true;
                        this.editLine = (Line)this.lineList.get();
                        this.mode = 1;
                        this.editType = 1;
                        this.replaceCount = ((Line)this.lineList.get()).textLength() - this.column;
                        this.editAtom = new EditAtom(this.lineList, this.lineNumber);
                        this.editAtom.addSaveLine((Line)this.lineList.get());
                        this.setUndoLine();
                        this.repeatQueue.setCommandKey(this.commandKey, this.rawCommandNumber);
                        break;
                    }
                    case 'u': {
                        if (this.editAtom != null) {
                            this.updateWindow = true;
                            this.editAtom.undo();
                            this.lineNumber = this.editAtom.getEditStartLine();
                            while (!this.lineList.setTo(this.lineNumber)) {
                                --this.lineNumber;
                            }
                            this.column = 0;
                            break;
                        }
                        this.postUserMessage("There is nothing to undo.");
                        break;
                    }
                    case 'U': {
                        if (this.isUndoLine()) {
                            this.editAtom = new EditAtom(this.lineList, this.lineNumber);
                            this.editAtom.addSaveLine((Line)this.lineList.get());
                            ((Line)this.lineList.get()).setText(this.getUndoLine());
                            this.column = 0;
                            this.updateWindow = true;
                            break;
                        }
                        break block303;
                    }
                    case '\"': {
                        if (this.inputQueue.length() == 1) {
                            var2_1 = 1;
                            break;
                        }
                        this.addressedBuffer = this.inputQueue.charAt(1);
                        if (!Character.isLetterOrDigit(this.addressedBuffer) && this.addressedBuffer != '/' && this.addressedBuffer != '?') {
                            this.addressedBuffer = '\u0000';
                            this.informationBar.setMessage("Addressed buffer not legal");
                            break;
                        }
                        break block303;
                    }
                    case 'D': {
                        this.updateWindow = true;
                        this.fileModified = true;
                        this.editAtom = new EditAtom(this.lineList, this.lineNumber);
                        this.editAtom.addSaveLine((Line)this.lineList.get());
                        this.setUndoLine();
                        var6_19 = ((Line)this.lineList.get()).cutCharacter(this.column);
                        var8_69 = new Line();
                        var8_69.setText(var6_19);
                        var7_56 = new ListElement();
                        var7_56.data = var8_69;
                        this.bufferMgr.saveBuffer(this.addressedBuffer, var7_56, false);
                        this.repeatQueue.setCommandKey(this.commandKey, this.rawCommandNumber);
                        this.repeatQueue.setCommandQueue(this.inputQueue.toString());
                        break;
                    }
                    case 'C': 
                    case 'c': {
                        if (this.inputQueue.length() == 1 && this.inputQueue.charAt(0) != 'C') {
                            var2_1 = 1;
                            break;
                        }
                        this.setUndoLine();
                        this.updateWindow = true;
                        this.fileModified = true;
                        var10_37 = 1;
                        var9_46 = '.';
                        if (this.inputQueue.length() <= 1) ** GOTO lbl609
                        if (!Character.isDigit(this.inputQueue.charAt(var10_37))) ** GOTO lbl607
                        while (Character.isDigit(this.inputQueue.charAt(var10_37))) {
                            if (this.inputQueue.length() <= var10_37 + 1) {
                                var2_1 = 1;
                                break;
                            }
                            ++var10_37;
                        }
                        if (var2_1 == 1) break block303;
                        this.setCommandNumber(this.inputQueue.toString().substring(1, var10_37));
lbl607:
                        // 2 sources

                        if ((var9_46 = (char)this.inputQueue.charAt(var10_37)) == this.inputQueue.charAt(0)) {
                            var9_46 = '.';
                        }
lbl609:
                        // 4 sources

                        if (this.inputQueue.charAt(0) == 'C') {
                            var9_46 = '$';
                        }
                        if (this.inputQueue.length() <= var10_37 + 1) {
                            var7_57 = false;
                            var8_70 = '\u0000';
                        } else {
                            var7_57 = true;
                            var8_70 = this.inputQueue.charAt(var10_37 + 1);
                        }
                        var6_20 = this.defineTextArea(var9_46, var8_70, var7_57, this.lineList, this.lineNumber, this.column, this.commandNumber);
                        if (var6_20 == 0) {
                            this.lineList.setTo(this.textAreaStartLine);
                            if (!this.textAreaWholeLine && this.textAreaStartColumn >= ((Line)this.lineList.get()).textLength()) {
                                this.textAreaStartColumn = 0;
                                ++this.textAreaStartLine;
                                this.lineNumber = this.textAreaStartLine;
                            }
                            if (var9_46 == 'w' || var9_46 == 'W') {
                                this.lineList.setTo(this.textAreaEndLine);
                                var1_101 = (Line)this.lineList.get();
                                while (var1_101.getCharacter(this.textAreaEndColumn) == ' ' && this.textAreaEndColumn > 0 && this.textAreaEndColumn > this.textAreaStartColumn) {
                                    --this.textAreaEndColumn;
                                }
                            }
                            this.lineList.setTo(this.textAreaStartLine);
                            this.editAtom = new EditAtom(this.lineList, this.textAreaStartLine);
                            var11_82 = this.textAreaEndLine - this.textAreaStartLine + 1;
                            this.editAtom.addSaveLine(this.copyLine(this.lineList, var11_82));
                            if (var11_82 == 1) {
                                this.changeCount = this.textAreaEndColumn - this.textAreaStartColumn + 1;
                                this.bufferMgr.saveBuffer(this.addressedBuffer, this.copyTextArea(this.lineList, this.textAreaStartLine, this.textAreaStartColumn, this.textAreaEndLine, this.textAreaEndColumn, this.textAreaWholeLine), this.textAreaWholeLine);
                                ((Line)this.lineList.get()).replaceCharacter('$', this.textAreaEndColumn);
                            } else {
                                this.bufferMgr.saveBuffer(this.addressedBuffer, this.cutTextArea(this.lineList, this.textAreaStartLine, this.textAreaStartColumn, this.textAreaEndLine, this.textAreaEndColumn, this.textAreaWholeLine), this.textAreaWholeLine);
                                this.editAtom.setEditLineCount(1);
                                this.lineNumber = this.textAreaStartLine;
                                if (this.textAreaWholeLine) {
                                    if (this.lineNumber >= this.lineList.getSize()) {
                                        this.lineList.add(new Line(""));
                                        this.lineList.last();
                                    } else {
                                        this.lineList.setTo(this.lineNumber);
                                        this.lineList.insert(new Line(""));
                                        this.lineList.previous();
                                    }
                                } else {
                                    this.lineList.setTo(this.lineNumber);
                                }
                            }
                            this.addressedBuffer = '\u0000';
                            this.editLine = (Line)this.lineList.get();
                            this.column = this.textAreaStartColumn;
                            this.mode = 1;
                            this.editType = 1;
                            this.repeatQueue.setCommandKey(this.commandKey, this.rawCommandNumber);
                            this.repeatQueue.setCommandQueue(this.inputQueue.toString());
                            break;
                        }
                        if (var6_20 == 2) {
                            var2_1 = 1;
                            break;
                        }
                        if (var6_20 == 3) {
                            var2_1 = 3;
                            break;
                        }
                        this.addressedBuffer = '\u0000';
                        break;
                    }
                    case 'd': {
                        if (this.inputQueue.length() == 1) {
                            var2_1 = 1;
                            break;
                        }
                        this.setUndoLine();
                        this.updateWindow = true;
                        var10_38 = 1;
                        var9_47 = '.';
                        if (this.inputQueue.length() <= 1) ** GOTO lbl696
                        if (!Character.isDigit(this.inputQueue.charAt(var10_38))) ** GOTO lbl694
                        while (Character.isDigit(this.inputQueue.charAt(var10_38))) {
                            if (this.inputQueue.length() <= var10_38 + 1) {
                                var2_1 = 1;
                                break;
                            }
                            ++var10_38;
                        }
                        if (var2_1 == 1) break block303;
                        this.setCommandNumber(this.inputQueue.toString().substring(1, var10_38));
lbl694:
                        // 2 sources

                        if ((var9_47 = (int)this.inputQueue.charAt(var10_38)) == this.inputQueue.charAt(0)) {
                            var9_47 = 46;
                        }
lbl696:
                        // 4 sources

                        this.fileModified = true;
                        if (this.inputQueue.length() <= var10_38 + 1) {
                            var7_58 = false;
                            var8_71 = '\u0000';
                        } else {
                            var7_58 = true;
                            var8_71 = this.inputQueue.charAt(var10_38 + 1);
                        }
                        var6_21 = this.defineTextArea((char)var9_47, var8_71, var7_58, this.lineList, this.lineNumber, this.column, this.commandNumber);
                        if (var6_21 == 0) {
                            this.lineList.setTo(this.textAreaStartLine);
                            if (!this.textAreaWholeLine && this.textAreaStartColumn >= ((Line)this.lineList.get()).textLength()) {
                                this.textAreaStartColumn = 0;
                                ++this.textAreaStartLine;
                            }
                            this.lineList.setTo(this.textAreaStartLine);
                            this.editAtom = new EditAtom(this.lineList, this.textAreaStartLine);
                            var11_83 = this.textAreaEndLine - this.textAreaStartLine + 1;
                            this.editAtom.addSaveLine(this.copyLine(this.lineList, var11_83));
                            this.bufferMgr.saveBuffer(this.addressedBuffer, this.cutTextArea(this.lineList, this.textAreaStartLine, this.textAreaStartColumn, this.textAreaEndLine, this.textAreaEndColumn, this.textAreaWholeLine), this.textAreaWholeLine);
                            this.column = this.textAreaStartColumn;
                            this.lineNumber = this.textAreaStartLine;
                            if (!this.lineList.setTo(this.lineNumber)) {
                                if (this.textAreaWholeLine && this.lineNumber != 0) {
                                    this.editAtom.setEditLineCount(0);
                                    --this.lineNumber;
                                } else {
                                    this.lineList.add(new Line(""));
                                }
                                this.lineList.last();
                            } else if (this.textAreaWholeLine) {
                                this.editAtom.setEditLineCount(0);
                            }
                            this.addressedBuffer = '\u0000';
                            this.repeatQueue.setCommandKey(this.commandKey, this.rawCommandNumber);
                            this.repeatQueue.setCommandQueue(this.inputQueue.toString());
                            break;
                        }
                        if (var6_21 == 2) {
                            var2_1 = 1;
                            break;
                        }
                        if (var6_21 == 3) {
                            var2_1 = 3;
                            break;
                        }
                        this.addressedBuffer = '\u0000';
                        break;
                    }
                    case 'y': {
                        if (this.inputQueue.length() == 1) {
                            var2_1 = 1;
                            break;
                        }
                        this.updateCursor = true;
                        var10_39 = 1;
                        var9_48 = '.';
                        if (this.inputQueue.length() <= 1) ** GOTO lbl761
                        if (!Character.isDigit(this.inputQueue.charAt(var10_39))) ** GOTO lbl759
                        while (Character.isDigit(this.inputQueue.charAt(var10_39))) {
                            if (this.inputQueue.length() <= var10_39 + 1) {
                                var2_1 = 1;
                                break;
                            }
                            ++var10_39;
                        }
                        if (var2_1 == 1) break block303;
                        this.setCommandNumber(this.inputQueue.toString().substring(1, var10_39));
lbl759:
                        // 2 sources

                        if ((var9_48 = (int)this.inputQueue.charAt(var10_39)) == this.inputQueue.charAt(0)) {
                            var9_48 = 46;
                        }
lbl761:
                        // 4 sources

                        if (this.inputQueue.length() <= var10_39 + 1) {
                            var7_59 = false;
                            var8_72 = '\u0000';
                        } else {
                            var7_59 = true;
                            var8_72 = this.inputQueue.charAt(var10_39 + 1);
                        }
                        var6_22 = this.defineTextArea((char)var9_48, var8_72, var7_59, this.lineList, this.lineNumber, this.column, this.commandNumber);
                        if (var6_22 != 0) ** GOTO lbl798
                        this.bufferMgr.saveBuffer(this.addressedBuffer, this.copyTextArea(this.lineList, this.textAreaStartLine, this.textAreaStartColumn, this.textAreaEndLine, this.textAreaEndColumn, this.textAreaWholeLine), this.textAreaWholeLine);
                        this.lineNumber = this.textAreaStartLine;
                        this.lineList.setTo(this.lineNumber);
                        var11_84 = this.textAreaEndLine - this.textAreaStartLine;
                        if (this.textAreaWholeLine) {
                            if (this.addressedBuffer == '/' || this.addressedBuffer == '?') {
                                this.informationBar.setMessage("Search string is illegal");
                            }
                            ++var11_84;
                        } else if (this.addressedBuffer == '/') {
                            this.searchMgr.setSearchForward(true);
                            this.searchMgr.setSearchString(((Line)this.bufferMgr.getBuffer((char)'/').data).getText());
                        } else if (this.addressedBuffer == '?') {
                            this.searchMgr.setSearchForward(false);
                            this.searchMgr.setSearchString(((Line)this.bufferMgr.getBuffer((char)'?').data).getText());
                        }
                        if (var11_84 > 0) {
                            var12_93 = new StringBuffer("Yanked ");
                            var12_93.append(var11_84);
                            var12_93.append(" lines.");
                            this.postUserMessage(var12_93.toString());
                        }
                        this.addressedBuffer = '\u0000';
                        if (var9_48 == 107) {
                            this.checkCursorColumn(var5_4);
                            break;
                        }
                        break block303;
lbl798:
                        // 1 sources

                        if (var6_22 == 2) {
                            var2_1 = 1;
                            break;
                        }
                        if (var6_22 == 3) {
                            var2_1 = 3;
                            break;
                        }
                        this.addressedBuffer = '\u0000';
                        break;
                    }
                    case 'Y': {
                        this.bufferMgr.saveBuffer(this.addressedBuffer, this.copyLine(this.lineList, this.commandNumber), true);
                        this.addressedBuffer = '\u0000';
                        break;
                    }
                    case 'p': {
                        if (!this.bufferMgr.isValid(this.addressedBuffer)) {
                            this.postEmptyBufferMessage(this.addressedBuffer);
                            this.addressedBuffer = '\u0000';
                            break;
                        }
                        this.updateWindow = true;
                        this.fileModified = true;
                        this.setUndoLine();
                        if (!this.bufferMgr.isWholeLine(this.addressedBuffer)) {
                            this.lineList.setTo(this.lineNumber);
                            var7_60 = (Line)this.lineList.get();
                            var10_40 = new LinkedList();
                            var10_40.add(this.bufferMgr.getBuffer(this.addressedBuffer));
                            var11_85 = this.column + 1;
                            var12_94 = var7_60.textLength() - (this.column + 1);
                            if (var12_94 < 0) {
                                var12_94 = 0;
                            }
                            if (var10_40.getSize() == 1) {
                                var10_40.first();
                                if (((Line)var10_40.get()).textLength() + var12_94 + var11_85 > 512) {
                                    this.postUserMessage("Put would exceed maximum line length");
                                    this.addressedBuffer = '\u0000';
                                    break;
                                }
                            } else {
                                var10_40.last();
                                if (((Line)var10_40.get()).textLength() + var12_94 > 512) {
                                    this.postUserMessage("Put would exceed maximum line length");
                                    this.addressedBuffer = '\u0000';
                                    break;
                                }
                                var10_40.first();
                                if (((Line)var10_40.get()).textLength() + var11_85 > 512) {
                                    this.postUserMessage("Put would exceed maximum line length");
                                    this.addressedBuffer = '\u0000';
                                    break;
                                }
                            }
                            if (var7_60.textLength() < this.column + 1) {
                                ((Line)var10_40.get()).insertCharacter(' ', 0, this.column - var7_60.textLength());
                                var8_73 = var7_60.getText(0);
                                var9_49 = new String();
                            } else {
                                var8_73 = var7_60.getText(0, this.column + 1);
                                var9_49 = var7_60.getText(this.column + 1);
                            }
                            ((Line)var10_40.get()).insert(var8_73, 0);
                            this.column = ((Line)var10_40.get()).textLength() - 1;
                            var10_40.last();
                            ((Line)var10_40.get()).append(var9_49);
                            this.editAtom = new EditAtom(this.lineList, this.lineNumber);
                            this.editAtom.addSaveLine((Line)this.lineList.remove());
                            var6_23 = this.lineNumber >= this.lineList.getSize() ? this.lineList.append(var10_40.cut()) : this.lineList.insert(var10_40.cut());
                            this.editAtom.setEditLineCount(var6_23);
                            this.lineList.setTo(this.lineNumber);
                        } else {
                            var6_23 = this.lineList.append(this.bufferMgr.getBuffer(this.addressedBuffer));
                            this.lineList.setTo(this.lineNumber);
                            this.incrementLine();
                            this.editAtom = new EditAtom(this.lineList, this.lineNumber);
                            this.editAtom.setEditLineCount(var6_23);
                        }
                        this.addressedBuffer = '\u0000';
                        if (var6_23 > 1) {
                            var11_86 = new StringBuffer("Put ");
                            var11_86.append(var6_23);
                            var11_86.append(" lines.");
                            this.postUserMessage(var11_86.toString());
                        }
                        this.repeatQueue.setCommandKey(this.commandKey, this.rawCommandNumber);
                        break;
                    }
                    case 'P': {
                        if (!this.bufferMgr.isValid(this.addressedBuffer)) {
                            this.postEmptyBufferMessage(this.addressedBuffer);
                            this.addressedBuffer = '\u0000';
                            break;
                        }
                        this.setUndoLine();
                        this.updateWindow = true;
                        this.fileModified = true;
                        if (!this.bufferMgr.isWholeLine(this.addressedBuffer)) {
                            this.lineList.setTo(this.lineNumber);
                            var7_61 = (Line)this.lineList.get();
                            var10_41 = new LinkedList();
                            var10_41.add(this.bufferMgr.getBuffer(this.addressedBuffer));
                            var11_87 = this.column;
                            var12_95 = var7_61.textLength() - this.column;
                            if (var12_95 < 0) {
                                var12_95 = 0;
                            }
                            if (var10_41.getSize() == 1) {
                                var10_41.first();
                                if (((Line)var10_41.get()).textLength() + var12_95 + var11_87 > 512) {
                                    this.postUserMessage("Put would exceed maximum line length");
                                    this.addressedBuffer = '\u0000';
                                    break;
                                }
                            } else {
                                var10_41.last();
                                if (((Line)var10_41.get()).textLength() + var12_95 > 512) {
                                    this.postUserMessage("Put would exceed maximum line length");
                                    this.addressedBuffer = '\u0000';
                                    break;
                                }
                                var10_41.first();
                                if (((Line)var10_41.get()).textLength() + var11_87 > 512) {
                                    this.postUserMessage("Put would exceed maximum line length");
                                    this.addressedBuffer = '\u0000';
                                    break;
                                }
                            }
                            if (var7_61.textLength() < this.column + 1) {
                                ((Line)var10_41.get()).insertCharacter(' ', 0, this.column - var7_61.textLength());
                                var8_74 = var7_61.getText(0);
                                var9_50 = new String();
                            } else {
                                var8_74 = var7_61.getText(0, this.column);
                                var9_50 = var7_61.getText(this.column);
                            }
                            ((Line)var10_41.get()).insert(var8_74, 0);
                            var10_41.last();
                            ((Line)var10_41.get()).append(var9_50);
                            this.editAtom = new EditAtom(this.lineList, this.lineNumber);
                            this.editAtom.addSaveLine((Line)this.lineList.remove());
                            var6_24 = this.lineNumber >= this.lineList.getSize() ? this.lineList.append(var10_41.cut()) : this.lineList.insert(var10_41.cut());
                            this.editAtom.setEditLineCount(var6_24);
                            this.lineList.setTo(this.lineNumber);
                        } else {
                            var6_24 = this.lineList.insert(this.bufferMgr.getBuffer(this.addressedBuffer));
                            this.lineList.setTo(this.lineNumber);
                            this.editAtom = new EditAtom(this.lineList, this.lineNumber);
                            this.editAtom.setEditLineCount(var6_24);
                        }
                        this.addressedBuffer = '\u0000';
                        if (var6_24 > 1) {
                            var11_88 = new StringBuffer("Put ");
                            var11_88.append(var6_24);
                            var11_88.append(" lines.");
                            this.postUserMessage(var11_88.toString());
                        }
                        this.repeatQueue.setCommandKey(this.commandKey, this.rawCommandNumber);
                        break;
                    }
                    case 'X': {
                        this.updateWindow = true;
                        this.fileModified = true;
                        if (this.column > 0) {
                            --this.column;
                            this.editAtom = new EditAtom(this.lineList, this.lineNumber);
                            this.editAtom.addSaveLine((Line)this.lineList.get());
                            this.setUndoLine();
                            ((Line)this.lineList.get()).cutCharacter(this.column, this.commandNumber);
                        }
                        this.repeatQueue.setCommandKey(this.commandKey, this.rawCommandNumber);
                        break;
                    }
                    case 'x': 
                    case '\u007f': {
                        this.updateWindow = true;
                        this.fileModified = true;
                        if (((Line)this.lineList.get()).textLength() > this.column) {
                            this.editAtom = new EditAtom(this.lineList, this.lineNumber);
                            this.editAtom.addSaveLine((Line)this.lineList.get());
                            this.setUndoLine();
                            if (this.column + this.commandNumber > ((Line)this.lineList.get()).textLength()) {
                                this.commandNumber = ((Line)this.lineList.get()).textLength() - this.column;
                            }
                            var6_25 = ((Line)this.lineList.get()).cutCharacter(this.column, this.commandNumber);
                            var8_75 = new Line();
                            var8_75.setText(var6_25);
                            var7_62 = new ListElement();
                            var7_62.data = var8_75;
                            this.bufferMgr.saveBuffer(this.addressedBuffer, var7_62, false);
                        }
                        if (((Line)this.lineList.get()).textLength() <= this.column && this.column > 0) {
                            --this.column;
                        }
                        this.repeatQueue.setCommandKey(this.commandKey, this.rawCommandNumber);
                        break;
                    }
                    case 'J': {
                        this.updateWindow = true;
                        this.fileModified = true;
                        if (this.lineNumber + this.commandNumber >= this.lineList.getSize()) ** GOTO lbl1015
                        this.editAtom = new EditAtom(this.lineList, this.lineNumber);
                        this.editAtom.addSaveLine(this.copyLine(this.lineList, this.commandNumber + 1));
                        this.setUndoLine();
                        var6_26 = (Line)this.lineList.get();
                        this.lineList.setTo(this.lineNumber + 1);
                        if (var6_26.textLength() + ((Line)this.lineList.get()).textLength() < 512) ** GOTO lbl1012
                        this.postUserMessage("Joining the lines would exceed line length limit");
                        this.lineList.setTo(this.lineNumber);
                        break;
lbl-1000:
                        // 1 sources

                        {
                            var7_63 = (Line)this.lineList.remove();
                            var8_76 = var7_63.firstNonSpace(-1);
                            if (var8_76 < 0) continue;
                            if (var6_26.textLength() > 0 && var6_26.getCharacter(var6_26.textLength() - 1) != ' ') {
                                if (var8_76 == 0) {
                                    var7_63.insertCharacter(' ', 0);
                                } else {
                                    --var8_76;
                                }
                            }
                            var6_26.append(var7_63.getText(var8_76));
lbl1012:
                            // 3 sources

                            ** while (this.commandNumber-- > 0)
                        }
lbl1013:
                        // 1 sources

                        this.lineList.setTo(this.lineNumber);
lbl1015:
                        // 2 sources

                        this.repeatQueue.setCommandKey(this.commandKey, this.rawCommandNumber);
                        break;
                    }
                    case ':': {
                        this.resetUndoLine();
                        this.pendingRequest = (char)2;
                        var2_1 = 2;
                        break;
                    }
                    case '[': {
                        if (this.inputQueue.length() == 1) {
                            var2_1 = 1;
                            break;
                        }
                        if (this.inputQueue.charAt(1) == '[') {
                            this.updateCursor = true;
                            if (this.lineNumber > 0 && this.searchBackRe(this.lineList, this.lineNumber - 1, 0, "^{", false, this.commandNumber)) {
                                this.lineNumber = this.searchLine;
                                this.column = this.searchColumn;
                                this.lineList.setTo(this.lineNumber);
                                break;
                            }
                        }
                        break block303;
                    }
                    case ']': {
                        this.updateCursor = true;
                        if (this.inputQueue.length() == 1) {
                            var2_1 = 1;
                            break;
                        }
                        if (this.inputQueue.charAt(1) == ']' && this.lineNumber < this.lineList.getSize() - 1 && this.searchForwardRe(this.lineList, this.lineNumber + 1, 0, "^{", false, this.commandNumber)) {
                            this.lineNumber = this.searchLine;
                            this.column = this.searchColumn;
                            this.lineList.setTo(this.lineNumber);
                            break;
                        }
                        break block303;
                    }
                    case '/': {
                        this.resetUndoLine();
                        this.pendingRequest = (char)3;
                        var2_1 = 2;
                        break;
                    }
                    case '?': {
                        this.pendingRequest = (char)4;
                        var2_1 = 2;
                        break;
                    }
                    case '%': {
                        if (this.searchNestedSymbol(this.lineList, this.lineNumber, this.column, this.commandNumber)) {
                            this.updateCursor = true;
                            this.lineNumber = this.searchLine;
                            this.column = this.searchColumn;
                            this.lineList.setTo(this.lineNumber);
                            break;
                        }
                        this.lineList.setTo(this.lineNumber);
                        this.informationBar.setMessage("Could not find symbol match.");
                        break;
                    }
                    case 'n': {
                        var6_27 = this.searchRegularExpression(this.lineList, this.lineNumber, this.column, this.commandNumber, false);
                        if (var6_27) {
                            this.updateCursor = true;
                            if (this.searchWrap) {
                                this.informationBar.setMessage("Wrapped");
                            } else {
                                this.informationBar.clearMessage();
                            }
                            this.lineNumber = this.searchLine;
                            this.column = this.searchColumn;
                            this.lineList.setTo(this.lineNumber);
                            this.setMarkArea = true;
                            var4_3 = true;
                            break;
                        }
                        this.informationBar.setMessage("Not found");
                        break;
                    }
                    case 'N': {
                        var6_28 = this.searchRegularExpression(this.lineList, this.lineNumber, this.column, this.commandNumber, true);
                        if (var6_28) {
                            this.updateCursor = true;
                            if (this.searchWrap) {
                                this.informationBar.setMessage("Wrapped");
                            } else {
                                this.informationBar.clearMessage();
                            }
                            this.lineNumber = this.searchLine;
                            this.column = this.searchColumn;
                            this.lineList.setTo(this.lineNumber);
                            var4_3 = true;
                            this.setMarkArea = true;
                            break;
                        }
                        this.informationBar.setMessage("Not found");
                        break;
                    }
                    case '\u0000': {
                        switch (this.commandKey.getKeyCode()) {
                            case 155: {
                                this.fileModified = true;
                                this.editLine = (Line)this.lineList.get();
                                this.editAtom = new EditAtom(this.lineList, this.lineNumber);
                                this.editAtom.addSaveLine((Line)this.lineList.get());
                                this.setUndoLine();
                                this.updateCursor = true;
                                this.mode = 1;
                                this.editType = 1;
                                this.replaceCount = 0;
                                this.repeatQueue.setCommandKey(this.commandKey, this.rawCommandNumber);
                                break block0;
                            }
                            case 127: {
                                this.updateWindow = true;
                                this.fileModified = true;
                                if (((Line)this.lineList.get()).textLength() > this.column) {
                                    this.editAtom = new EditAtom(this.lineList, this.lineNumber);
                                    this.editAtom.addSaveLine((Line)this.lineList.get());
                                    this.setUndoLine();
                                    var6_29 = ((Line)this.lineList.get()).cutCharacter(this.column, this.commandNumber);
                                    var8_77 = new Line();
                                    var8_77.setText(var6_29);
                                    var7_64 = new ListElement();
                                    var7_64.data = var8_77;
                                    this.bufferMgr.saveBuffer(this.addressedBuffer, var7_64, false);
                                }
                                this.repeatQueue.setCommandKey(this.commandKey, this.rawCommandNumber);
                                break block0;
                            }
                            case 37: {
                                this.updateCursor = true;
                                this.decrementColumn(this.commandNumber);
                                break block0;
                            }
                            case 39: {
                                this.updateCursor = true;
                                this.incrementColumn(this.commandNumber);
                                break block0;
                            }
                            case 40: {
                                this.updateCursor = true;
                                this.incrementLine(this.commandNumber);
                                this.checkCursorColumn(var5_4);
                                break block0;
                            }
                            case 38: {
                                this.updateCursor = true;
                                this.decrementLine(this.commandNumber);
                                this.checkCursorColumn(var5_4);
                                break block0;
                            }
                            case 35: {
                                this.updateCursor = true;
                                if (this.commandKey.isControl()) {
                                    this.lineNumber = this.lineList.getSize() - 1;
                                    this.lineList.setTo(this.lineNumber);
                                }
                                this.column = ((Line)this.lineList.get()).textLength() - 1;
                                break block0;
                            }
                            case 36: {
                                this.updateCursor = true;
                                if (this.commandKey.isControl()) {
                                    this.lineNumber = this.commandNumber - 1;
                                    this.lineList.setTo(this.lineNumber);
                                }
                                this.column = ((Line)this.lineList.get()).firstNonSpace(0);
                                break block0;
                            }
                            case 33: {
                                if (this.lineNumber == 0) {
                                    this.updateCursor = true;
                                    break block0;
                                }
                                this.updateWindow = true;
                                var6_30 = this.windowSizeInLines - 1;
                                this.decrementLine(var6_30 *= this.commandNumber);
                                this.windowStartLine -= var6_30;
                                this.column = ((Line)this.lineList.get()).firstNonSpace(0);
                                break block0;
                            }
                            case 34: {
                                this.updateWindow = true;
                                var6_31 = this.windowSizeInLines - 1;
                                this.incrementLine(var6_31 *= this.commandNumber);
                                this.windowStartLine += var6_31;
                                this.column = ((Line)this.lineList.get()).firstNonSpace(0);
                                break block0;
                            }
                        }
                        var2_1 = 2;
                        break;
                    }
                    case '\u0019': {
                        this.scrollUp(this.commandNumber);
                        break;
                    }
                    case '\u0005': {
                        this.scrollDown(this.commandNumber);
                        break;
                    }
                    default: {
                        var2_1 = 2;
                        break;
                    }
                }
                break block303;
            }
            var2_1 = 1;
            if (this.commandKey.getKeyChar() != '\u0000') {
                this.repeatQueue.addCharacter(this.commandKey.getKeyChar());
                if (this.commandKey.getKeyChar() != '\u007f') {
                    if (this.commandKey.getKeyChar() == '\u001b') {
                        this.informationBar.clearMessage();
                        if (this.changeCount > 0) {
                            this.updateLine = this.lineNumber;
                            this.editLine.cutCharacter(this.column, this.changeCount);
                            this.changeCount = 0;
                        }
                        this.replaceCount = 0;
                        var2_1 = 0;
                        this.updateCursor = true;
                        this.resetMarkArea = true;
                        this.mode = 0;
                    } else if (this.commandKey.getKeyChar() == '\n') {
                        var2_1 = 1;
                        this.updateWindow = true;
                        this.informationBar.clearMessage();
                        if (this.changeCount > 0) {
                            this.updateLine = this.lineNumber;
                            this.editLine.cutCharacter(this.column, this.changeCount);
                            this.changeCount = 0;
                        }
                        var9_51 = null;
                        var6_32 = (Line)this.lineList.get();
                        var10_42 = var6_32.firstNonSpace(-1);
                        if (var10_42 != -1) {
                            var8_78 = var6_32.getText(var10_42);
                            var9_51 = this.syntaxMgr.get(var8_78 = var8_78.trim());
                            if (var9_51 != null && var9_51.getColumnWidth() + var10_42 > 512) {
                                var9_51 = null;
                                this.postUserMessage("Syntax expansion would exceed maximum line width");
                            }
                        }
                        if (var9_51 != null) {
                            this.editAtom = new EditAtom(this.lineList, this.lineNumber);
                            this.editAtom.addSaveLine((Line)this.lineList.remove());
                            var11_89 = this.lineNumber >= this.lineList.getSize() ? this.lineList.add(var9_51.getSyntax(var10_42)) : this.lineList.insert(var9_51.getSyntax(var10_42));
                            this.editAtom.setEditLineCount(var11_89);
                            this.column = var10_42;
                            if (var9_51.isValidCursor()) {
                                this.column += var9_51.getColumn();
                                this.lineNumber += var9_51.getLine();
                            }
                            this.lineList.setTo(this.lineNumber);
                            this.editLine = (Line)this.lineList.get();
                            this.mode = 1;
                        } else {
                            var7_65 = new Line();
                            var7_65.setText(((Line)this.lineList.get()).cutCharacter(this.column));
                            this.lineList.append(var7_65);
                            this.editAtom.incrementEditLineCount();
                            this.incrementLine();
                            this.column = this.findNestColumn();
                            if (this.column > 0 && ((Line)this.lineList.get()).firstNonSpace(-1) != -1) {
                                ((Line)this.lineList.get()).insertCharacter(' ', 0, this.column);
                            }
                            this.editLine = (Line)this.lineList.get();
                            this.mode = 1;
                        }
                    } else if (this.commandKey.getKeyChar() == '\b') {
                        this.updateCursor = true;
                        if (this.column > 0) {
                            --this.column;
                            if (this.column < ((Line)this.lineList.get()).textLength()) {
                                if (this.replaceCount > 0) {
                                    ++this.replaceCount;
                                } else {
                                    ++this.changeCount;
                                }
                            }
                        } else {
                            this.editAtom.getEditStartLine();
                        }
                    } else if (this.commandKey.getKeyChar() == '\t') {
                        this.updateCursor = true;
                        this.updateLine = this.lineNumber;
                        if (!this.commandKey.isShift()) {
                            var6_33 = this.column % this.tabInterval;
                            var6_33 = this.tabInterval - var6_33;
                            if (this.editLine.textLength() + var6_33 >= 512) {
                                this.postUserMessage("Tab will exceed maximum line length");
                            } else {
                                if (this.replaceCount > 0) {
                                    if (var6_33 > this.replaceCount) {
                                        this.editLine.replaceCharacter(' ', this.column, this.replaceCount);
                                        this.editLine.insertCharacter(' ', this.column, var6_33 - this.replaceCount);
                                        this.replaceCount = 0;
                                    } else {
                                        this.editLine.replaceCharacter(' ', this.column, var6_33);
                                        this.replaceCount -= var6_33;
                                    }
                                } else {
                                    this.editLine.insertCharacter(' ', this.column, var6_33);
                                }
                                this.column += var6_33;
                            }
                        } else {
                            this.postUserMessage("Backtab is not legal in insert mode");
                        }
                    } else if (!this.commandKey.isControl()) {
                        if (this.changeCount != 0) {
                            this.updateLine = this.lineNumber;
                            --this.changeCount;
                            this.editLine.replaceCharacter(this.commandKey.getKeyChar(), this.column++);
                        } else if (this.replaceCount != 0) {
                            this.updateLine = this.lineNumber;
                            --this.replaceCount;
                            this.editLine.replaceCharacter(this.commandKey.getKeyChar(), this.column++);
                        } else if (this.editType == 1) {
                            if (this.editLine.textLength() + 1 >= 512) {
                                this.postUserMessage("Character will exceed maximum line length");
                            } else {
                                this.updateLine = this.lineNumber;
                                this.editLine.insertCharacter(this.commandKey.getKeyChar(), this.column++);
                            }
                        }
                    }
                }
            } else {
                var2_1 = 2;
            }
        }
        this.adjustWindow(var4_3);
        if (var3_2 != this.lineNumber) {
            this.resetUndoLine();
        }
        return var2_1;
    }

    private void incrementLine(int n) {
        while (n-- > 0) {
            if (!this.lineList.next()) {
                return;
            }
            ++this.lineNumber;
        }
    }

    private boolean incrementLine() {
        if (!this.lineList.next()) {
            return false;
        }
        ++this.lineNumber;
        return true;
    }

    private void decrementLine(int n) {
        while (n-- > 0) {
            if (!this.lineList.previous()) {
                return;
            }
            --this.lineNumber;
        }
    }

    private boolean decrementLine() {
        if (!this.lineList.previous()) {
            return false;
        }
        --this.lineNumber;
        return true;
    }

    /*
     * Unable to fully structure code
     */
    private void incrementColumn(int var1_1) {
        if (var1_1 + this.column < 512) ** GOTO lbl5
        this.postUserMessage("Cannot exceed maximum column size");
        return;
lbl-1000:
        // 1 sources

        {
            ++this.column;
lbl5:
            // 2 sources

            ** while (var1_1-- > 0)
        }
lbl6:
        // 1 sources

    }

    private void decrementColumn(int n) {
        while (n-- > 0) {
            if (this.column == 0) {
                return;
            }
            --this.column;
        }
    }

    private int findMarkLine(char c) {
        this.lineList.push();
        this.lineList.first();
        int n = 0;
        int n2 = -1;
        do {
            if (((Line)this.lineList.get()).equalsMark(c)) {
                n2 = n;
                break;
            }
            ++n;
        } while (this.lineList.next());
        this.lineList.pop();
        return n2;
    }

    private boolean searchForwardWord(LinkedList linkedList, int n, int n2, boolean bl, int n3, boolean bl2) {
        int n4 = n;
        int n5 = n2;
        linkedList.push();
        block0: while (n3-- > 0) {
            n2 = ((Line)linkedList.get()).nextWord(n2, bl);
            while (n2 == -1) {
                if (n3 == 0 && bl2) {
                    n2 = ((Line)linkedList.get()).textLength();
                    if (n != n4 || n2 > n5) continue block0;
                    return false;
                }
                if (!linkedList.next()) {
                    linkedList.pop();
                    return false;
                }
                ++n;
                n2 = ((Line)linkedList.get()).firstNonSpace(-1);
            }
        }
        this.searchColumn = n2;
        if (bl2) {
            --this.searchColumn;
        }
        this.searchLine = n;
        this.textAreaWholeLine = false;
        linkedList.pop();
        return true;
    }

    private boolean searchBackWord(LinkedList linkedList, int n, int n2, boolean bl, int n3) {
        linkedList.push();
        while (n3-- > 0) {
            n2 = ((Line)linkedList.get()).previousWord(n2, bl);
            while (n2 == -1) {
                if (!linkedList.previous()) {
                    linkedList.pop();
                    return false;
                }
                --n;
                n2 = ((Line)linkedList.get()).textLength();
                n2 = ((Line)linkedList.get()).previousWord(n2, bl);
            }
        }
        this.searchColumn = n2;
        this.searchLine = n;
        this.textAreaWholeLine = false;
        linkedList.pop();
        return true;
    }

    private boolean searchForwardWordEnd(LinkedList linkedList, int n, int n2, boolean bl, int n3, boolean bl2) {
        linkedList.push();
        while (n3-- > 0) {
            if (n2 == -1) {
                this.column = 0;
            }
            n2 = ((Line)linkedList.get()).wordEnd(n2, bl, bl2);
            while (n2 == -1) {
                if (!linkedList.next()) {
                    linkedList.pop();
                    return false;
                }
                ++n;
                n2 = ((Line)linkedList.get()).wordEnd(n2, bl, bl2);
            }
        }
        this.searchColumn = n2;
        this.searchLine = n;
        this.textAreaWholeLine = false;
        linkedList.pop();
        return true;
    }

    private boolean searchForwardCharacter(LinkedList linkedList, int n, int n2, char c, int n3, boolean bl) {
        n2 = ((Line)linkedList.get()).findSymbol(n2, c, n3);
        if (n2 == -1) {
            return false;
        }
        if (bl) {
            ++n2;
        }
        this.searchColumn = n2;
        this.searchLine = n;
        this.textAreaWholeLine = false;
        return true;
    }

    private boolean searchMarkLine(LinkedList linkedList, int n, int n2, char c) {
        int n3 = this.findMarkLine(c);
        if (n3 == -1) {
            return false;
        }
        this.searchLine = n3;
        this.searchColumn = n2;
        this.textAreaWholeLine = true;
        return true;
    }

    private boolean searchFirstNonWhiteSpace(LinkedList linkedList, int n, int n2) {
        if (((Line)linkedList.get()).textLength() == 0) {
            return false;
        }
        int n3 = ((Line)this.lineList.get()).firstNonSpace(0);
        if (n2 == n3) {
            return false;
        }
        this.searchLine = n;
        this.searchColumn = n3;
        this.textAreaWholeLine = false;
        return true;
    }

    private boolean searchStartOfLine(LinkedList linkedList, int n, int n2) {
        if (n2 == 0) {
            return false;
        }
        int n3 = 0;
        this.searchLine = n;
        this.searchColumn = n3;
        this.textAreaWholeLine = false;
        return true;
    }

    private boolean searchEndOfLine(LinkedList linkedList, int n, int n2) {
        int n3 = ((Line)linkedList.get()).textLength() - 1;
        if (n2 > n3) {
            return false;
        }
        this.searchLine = n;
        this.searchColumn = n3;
        this.textAreaWholeLine = false;
        return true;
    }

    private boolean searchRight(LinkedList linkedList, int n, int n2, int n3) {
        if (n2 + n3 >= ((Line)linkedList.get()).textLength()) {
            return false;
        }
        this.searchLine = n;
        this.searchColumn = n2 + n3;
        this.textAreaWholeLine = false;
        return true;
    }

    private boolean searchLeft(LinkedList linkedList, int n, int n2, int n3) {
        if (n2 - n3 < 0) {
            return false;
        }
        this.searchLine = n;
        this.searchColumn = n2 - n3;
        this.textAreaWholeLine = false;
        return true;
    }

    private boolean searchUp(LinkedList linkedList, int n, int n2, int n3) {
        if (n - n3 < 0) {
            return false;
        }
        this.searchLine = n - n3;
        this.searchColumn = n2;
        this.textAreaWholeLine = true;
        return true;
    }

    private boolean searchDown(LinkedList linkedList, int n, int n2, int n3) {
        if (n + n3 >= this.lineList.getSize()) {
            return false;
        }
        this.searchLine = n + n3;
        this.searchColumn = n2;
        this.textAreaWholeLine = true;
        return true;
    }

    private boolean searchGoToLine(LinkedList linkedList, int n, int n2, int n3) {
        if (n3 >= linkedList.getSize()) {
            return false;
        }
        this.searchLine = n = n3;
        this.searchColumn = n2;
        this.textAreaWholeLine = true;
        return true;
    }

    private boolean searchForwardLine(LinkedList linkedList, int n, int n2, int n3) {
        this.lineList.push();
        while (n3-- > 0) {
            if (!linkedList.next()) {
                this.lineList.pop();
                return false;
            }
            ++n;
        }
        this.lineList.pop();
        this.searchLine = n;
        this.searchColumn = n2;
        this.textAreaWholeLine = true;
        return true;
    }

    private boolean searchForwardRe(LinkedList linkedList, int n, int n2, String string, boolean bl, int n3) {
        ReEngine reEngine = new ReEngine(string);
        int n4 = n;
        int n5 = n2;
        linkedList.push();
        linkedList.setTo(n);
        while (n3-- > 0) {
            n2 = reEngine.find(((Line)linkedList.get()).getText(), n2, 0, bl);
            while (n2 == -1) {
                if (!linkedList.next()) {
                    linkedList.pop();
                    return false;
                }
                ++n;
                n2 = reEngine.find(((Line)linkedList.get()).getText(), 0, 0, bl);
            }
        }
        this.searchColumn = n2;
        this.searchLine = n;
        this.searchLength = reEngine.getLength();
        this.textAreaWholeLine = false;
        linkedList.pop();
        return true;
    }

    private boolean searchForwardRe(LinkedList linkedList, int n, int n2, int n3, String string, boolean bl, int n4) {
        ReEngine reEngine = new ReEngine(string);
        int n5 = n;
        int n6 = n2;
        linkedList.push();
        linkedList.setTo(n);
        while (n4-- > 0) {
            n2 = reEngine.find(((Line)linkedList.get()).getText(), n2, 0, bl);
            while (n2 == -1) {
                if (n == n3) {
                    linkedList.pop();
                    return false;
                }
                if (!linkedList.next()) {
                    linkedList.pop();
                    return false;
                }
                ++n;
                n2 = reEngine.find(((Line)linkedList.get()).getText(), 0, 0, bl);
            }
        }
        this.searchColumn = n2;
        this.searchLine = n;
        this.searchLength = reEngine.getLength();
        this.textAreaWholeLine = false;
        linkedList.pop();
        return true;
    }

    private boolean searchBackRe(LinkedList linkedList, int n, int n2, String string, boolean bl, int n3) {
        ReEngine reEngine = new ReEngine(string);
        int n4 = n;
        int n5 = n2;
        linkedList.push();
        linkedList.setTo(n);
        while (n3-- > 0) {
            n2 = reEngine.findLast(((Line)linkedList.get()).getText(), n2, 0, bl);
            while (n2 == -1) {
                if (!linkedList.previous()) {
                    linkedList.pop();
                    return false;
                }
                --n;
                n2 = reEngine.findLast(((Line)linkedList.get()).getText(), ((Line)linkedList.get()).textLength(), 0, bl);
            }
        }
        this.searchColumn = n2;
        this.searchLine = n;
        this.searchLength = reEngine.getLength();
        this.textAreaWholeLine = false;
        linkedList.pop();
        return true;
    }

    private boolean searchBackRe(LinkedList linkedList, int n, int n2, int n3, String string, boolean bl, int n4) {
        ReEngine reEngine = new ReEngine(string);
        int n5 = n;
        int n6 = n2;
        linkedList.push();
        linkedList.setTo(n);
        while (n4-- > 0) {
            n2 = reEngine.findLast(((Line)linkedList.get()).getText(), n2, 0, bl);
            while (n2 == -1) {
                if (n == n3) {
                    linkedList.pop();
                    return false;
                }
                if (!linkedList.previous()) {
                    linkedList.pop();
                    return false;
                }
                --n;
                n2 = reEngine.findLast(((Line)linkedList.get()).getText(), ((Line)linkedList.get()).textLength(), 0, bl);
            }
        }
        this.searchColumn = n2;
        this.searchLine = n;
        this.searchLength = reEngine.getLength();
        this.textAreaWholeLine = false;
        linkedList.pop();
        return true;
    }

    /*
     * Unable to fully structure code
     */
    boolean searchNestedSymbol(LinkedList var1_1, int var2_2, int var3_3, int var4_4) {
        block12: {
            var8_5 = false;
            var5_6 = ((Line)var1_1.get()).getCharacter(var3_3);
            switch (var5_6) {
                case '{': {
                    var8_5 = true;
                }
                case '}': {
                    var6_7 = "[{}]";
                    break;
                }
                case '(': {
                    var8_5 = true;
                }
                case ')': {
                    var6_7 = "[()]";
                    break;
                }
                case '[': {
                    var8_5 = true;
                }
                case ']': {
                    var6_7 = "[\\[\\]]";
                    break;
                }
                default: {
                    return false;
                }
            }
            var7_8 = 1;
            if (!var8_5) ** GOTO lbl46
            while (this.searchForwardRe(var1_1, var2_2, var3_3 + 1, var6_7, false, var4_4)) {
                var1_1.setTo(this.searchLine);
                var7_8 = ((Line)var1_1.get()).getCharacter(this.searchColumn) == var5_6 ? ++var7_8 : --var7_8;
                if (var7_8 == 0) {
                    this.searchColumn = this.searchColumn;
                    this.searchLine = this.searchLine;
                    this.textAreaWholeLine = false;
                    return true;
                }
                var2_2 = this.searchLine;
                var3_3 = this.searchColumn;
            }
            break block12;
lbl-1000:
            // 1 sources

            {
                var1_1.setTo(this.searchLine);
                var7_8 = ((Line)var1_1.get()).getCharacter(this.searchColumn) == var5_6 ? ++var7_8 : --var7_8;
                if (var7_8 == 0) {
                    this.searchColumn = this.searchColumn;
                    this.searchLine = this.searchLine;
                    this.textAreaWholeLine = false;
                    return true;
                }
                var2_2 = this.searchLine;
                var3_3 = this.searchColumn;
lbl46:
                // 2 sources

                ** while (this.searchBackRe((LinkedList)var1_1, (int)var2_2, (int)(var3_3 - 1), (String)var6_7, (boolean)false, (int)var4_4))
            }
        }
        return false;
    }

    /*
     * Unable to fully structure code
     */
    private boolean searchRegularExpression(LinkedList var1_1, int var2_2, int var3_3, int var4_4, boolean var5_5) {
        block10: {
            var7_6 = false;
            var8_7 = false;
            if (!this.searchMgr.isValidString()) {
                this.informationBar.setMessage("Search string is not set.");
                return false;
            }
            var6_8 = this.searchMgr.isSearchForward();
            if (var5_5) {
                var6_8 = var6_8 != true;
            }
            if (!var6_8) ** GOTO lbl39
            while (var4_4-- > 0) {
                v0 = var7_6 = this.searchForwardRe(var1_1, var2_2, var3_3 + 1, this.searchMgr.getSearchString(), this.searchMgr.isCaseIndependent(), 1) == true;
                if (!var7_6) {
                    var7_6 = this.searchForwardRe(var1_1, 0, 0, var2_2, this.searchMgr.getSearchString(), this.searchMgr.isCaseIndependent(), 1);
                    if (var7_6) {
                        var8_7 = true;
                    } else {
                        return false;
                    }
                }
                var2_2 = this.searchLine;
                var3_3 = this.searchColumn + 1;
            }
            break block10;
lbl-1000:
            // 1 sources

            {
                v1 = var7_6 = this.searchBackRe(var1_1, var2_2, var3_3 - 1, this.searchMgr.getSearchString(), this.searchMgr.isCaseIndependent(), 1) == true;
                if (!var7_6) {
                    var1_1.push();
                    var9_9 = var1_1.getSize() - 1;
                    var1_1.setTo(var9_9);
                    var10_10 = ((Line)var1_1.get()).textLength();
                    var1_1.pop();
                    var7_6 = this.searchBackRe(var1_1, var9_9, var10_10, var2_2, this.searchMgr.getSearchString(), this.searchMgr.isCaseIndependent(), 1);
                    if (var7_6) {
                        var8_7 = true;
                    } else {
                        return false;
                    }
                }
                var2_2 = this.searchLine;
                var3_3 = this.searchColumn - 1;
lbl39:
                // 2 sources

                ** while (var4_4-- > 0)
            }
        }
        this.searchWrap = var8_7;
        return var7_6;
    }

    private int defineTextArea(char c, char c2, boolean bl, LinkedList linkedList, int n, int n2, int n3) {
        boolean bl2 = false;
        int n4 = 1;
        switch (c) {
            case '.': {
                if (!this.searchDown(linkedList, n, n2, n3 - 1)) break;
                n4 = 0;
                break;
            }
            case 'w': {
                if (!this.searchForwardWord(linkedList, n, n2, false, n3, true)) break;
                n4 = 0;
                break;
            }
            case 'W': {
                if (!this.searchForwardWord(linkedList, n, n2, true, n3, true)) break;
                n4 = 0;
                break;
            }
            case 'b': {
                if (!this.searchBackWord(linkedList, n, n2, false, n3)) break;
                if (n2 > 0) {
                    --n2;
                }
                n4 = 0;
                break;
            }
            case 'B': {
                if (!this.searchBackWord(linkedList, n, n2, true, n3)) break;
                if (n2 > 0) {
                    --n2;
                }
                n4 = 0;
                break;
            }
            case 'e': {
                if (!this.searchForwardWordEnd(linkedList, n, n2, false, n3, false)) break;
                n4 = 0;
                break;
            }
            case 'E': {
                if (!this.searchForwardWordEnd(linkedList, n, n2, true, n3, false)) break;
                n4 = 0;
                break;
            }
            case '\'': {
                if (!bl) {
                    n4 = 2;
                    break;
                }
                if (!this.searchMarkLine(linkedList, n, n2, c2)) break;
                n4 = 0;
                break;
            }
            case 't': {
                if (!bl) {
                    n4 = 2;
                    break;
                }
                if (!this.searchForwardCharacter(linkedList, n, n2, c2, n3, false)) break;
                n4 = 0;
                break;
            }
            case 'f': {
                if (!bl) {
                    n4 = 2;
                    break;
                }
                if (!this.searchForwardCharacter(linkedList, n, n2, c2, n3, true)) break;
                n4 = 0;
                break;
            }
            case '$': 
            case 'D': {
                if (!this.searchEndOfLine(linkedList, n, n2)) break;
                n4 = 0;
                break;
            }
            case '0': {
                if (!this.searchStartOfLine(linkedList, n, n2)) break;
                n4 = 0;
                break;
            }
            case '^': {
                if (!this.searchFirstNonWhiteSpace(linkedList, n, n2)) break;
                n4 = 0;
                break;
            }
            case 'l': {
                if (!this.searchRight(linkedList, n, n2, n3)) break;
                n4 = 0;
                break;
            }
            case '+': 
            case 'j': {
                if (!this.searchDown(linkedList, n, n2, n3)) break;
                n4 = 0;
                break;
            }
            case '-': 
            case 'k': {
                if (!this.searchUp(linkedList, n, n2, n3)) break;
                n4 = 0;
                break;
            }
            case 'h': {
                if (!this.searchLeft(linkedList, n, n2, n3)) break;
                n4 = 0;
                break;
            }
            case 'H': {
                if (!this.searchGoToLine(linkedList, n, n2, this.windowStartLine + n3 - 1)) break;
                n4 = 0;
                break;
            }
            case 'M': {
                if (this.searchGoToLine(linkedList, n, n2, this.windowStartLine + this.windowSizeInLines / 2 + n3 - 1)) {
                    n4 = 0;
                    break;
                }
                if (!this.searchGoToLine(linkedList, n, n2, this.lineList.getSize() - 1)) break;
                n4 = 0;
                break;
            }
            case 'L': {
                if (this.searchGoToLine(linkedList, n, n2, this.windowStartLine + (this.windowSizeInLines - 1) + n3 - 1)) {
                    n4 = 0;
                    break;
                }
                if (!this.searchGoToLine(linkedList, n, n2, this.lineList.getSize() - 1)) break;
                n4 = 0;
                break;
            }
            case 'G': {
                if (this.defaultCommandNumber) {
                    n3 = this.lineList.getSize();
                }
                if (this.searchGoToLine(linkedList, n, n2, n3 - 1)) {
                    n4 = 0;
                    break;
                }
                if (!this.searchGoToLine(linkedList, n, n2, this.lineList.getSize() - 1)) break;
                n4 = 0;
                break;
            }
            case '\n': {
                if (!this.searchGoToLine(linkedList, n, n2, n + n3)) break;
                n4 = 0;
                break;
            }
            case '%': {
                if (!this.searchNestedSymbol(linkedList, n, n2, n)) break;
                n4 = 0;
                break;
            }
            case 'n': {
                if (!this.searchRegularExpression(linkedList, n, n2, n3, false)) break;
                bl2 = true;
                n4 = 0;
                break;
            }
            case 'N': {
                if (!this.searchRegularExpression(linkedList, n, n2, n3, true)) break;
                bl2 = true;
                n4 = 0;
                break;
            }
            case '/': {
                this.inputQueue.setLength(this.inputQueue.length() - 1);
                this.pendingRequest = (char)3;
                n4 = 3;
                break;
            }
            case '?': {
                this.inputQueue.setLength(this.inputQueue.length() - 1);
                this.pendingRequest = (char)4;
                n4 = 3;
                break;
            }
            default: {
                n4 = 1;
            }
        }
        if (n4 == 0) {
            if (n == this.searchLine) {
                this.textAreaStartLine = this.textAreaEndLine = n;
                if (n2 < this.searchColumn) {
                    this.textAreaStartColumn = n2;
                    this.textAreaEndColumn = this.searchColumn;
                } else {
                    this.textAreaEndColumn = n2;
                    this.textAreaStartColumn = this.searchColumn;
                }
            } else if (n <= this.searchLine) {
                this.textAreaStartLine = n;
                this.textAreaStartColumn = n2;
                this.textAreaEndLine = this.searchLine;
                this.textAreaEndColumn = this.searchColumn;
            } else {
                this.textAreaStartLine = this.searchLine;
                this.textAreaStartColumn = this.searchColumn;
                this.textAreaEndLine = n;
                this.textAreaEndColumn = n2;
            }
            if (this.textAreaWholeLine) {
                this.textAreaStartColumn = 0;
                linkedList.setTo(n);
                this.textAreaEndColumn = ((Line)linkedList.get()).textLength();
                if (--this.textAreaEndColumn < 0) {
                    this.textAreaEndColumn = 0;
                }
            } else if (bl2) {
                --this.textAreaEndColumn;
            }
        }
        return n4;
    }

    private ListElement cutTextArea(LinkedList linkedList, int n, int n2, int n3, int n4, boolean bl) {
        linkedList.setTo(n);
        int n5 = n3 - n + 1;
        LinkedList linkedList2 = new LinkedList();
        linkedList.setTo(n);
        linkedList2.add(linkedList.cut(n5));
        if (!bl) {
            Line line = new Line();
            linkedList2.last();
            line.setText(((Line)linkedList2.get()).cutCharacter(n4 + 1));
            linkedList2.first();
            line.insert(((Line)linkedList2.get()).cutCharacter(0, n2), 0);
            if (linkedList.setTo(n)) {
                linkedList.insert(line);
            } else {
                linkedList.add(line);
            }
            linkedList.setTo(n);
        }
        return linkedList2.cut();
    }

    private ListElement copyTextArea(LinkedList linkedList, int n, int n2, int n3, int n4, boolean bl) {
        linkedList.setTo(n);
        int n5 = n3 - n + 1;
        LinkedList linkedList2 = new LinkedList();
        linkedList.setTo(n);
        linkedList2.add(this.copyLine(linkedList, n5));
        if (!bl) {
            linkedList2.last();
            ((Line)linkedList2.get()).cutCharacter(n4 + 1);
            linkedList2.first();
            ((Line)linkedList2.get()).cutCharacter(0, n2);
        }
        return linkedList2.cut();
    }

    private void postEmptyBufferMessage(char c) {
        if (c == '\u0000') {
            this.informationBar.setMessage("Buffer is empty");
            return;
        }
        StringBuffer stringBuffer = new StringBuffer("Buffer \"");
        stringBuffer.append(c);
        stringBuffer.append(" is empty");
        this.informationBar.setMessage(stringBuffer.toString());
    }

    private void postUserMessage(String string) {
        this.informationBar.setMessage(string);
    }

    public void adjustWindow() {
        this.adjustWindow(false);
    }

    public void adjustWindow(boolean bl) {
        if (this.windowStartLine < 0) {
            this.windowStartLine = 0;
            this.updateWindow = true;
        }
        if (this.lineNumber >= this.windowStartLine + this.windowSizeInLines) {
            this.windowStartLine = bl ? this.lineNumber - this.windowSizeInLines / 2 : this.lineNumber - (this.windowSizeInLines - 1);
            this.updateWindow = true;
            return;
        }
        if (this.lineNumber < this.windowStartLine) {
            if (bl) {
                this.windowStartLine = this.lineNumber - this.windowSizeInLines / 2;
                if (this.windowStartLine < 0) {
                    this.windowStartLine = 0;
                }
            } else {
                this.windowStartLine = this.lineNumber;
            }
            this.updateWindow = true;
        }
    }

    private ListElement copyLine(LinkedList linkedList, int n) {
        LinkedList linkedList2 = new LinkedList();
        linkedList.push();
        while (n-- > 0) {
            Line line = new Line();
            line.setText(((Line)linkedList.get()).getText());
            linkedList2.add(line);
            if (!linkedList.next()) break;
        }
        linkedList.pop();
        return linkedList2.cut();
    }

    public char request() {
        char c = this.pendingRequest;
        this.pendingRequest = '\u0000';
        return c;
    }

    public boolean processCommandLine(String string) {
        boolean bl;
        int n = 0;
        this.resetUndoLine();
        Key key = new Key('\u001b', false, false, false);
        this.process(key);
        if (string == null) {
            return false;
        }
        if ((string = string.trim()).length() == 0) {
            return true;
        }
        n = this.setCommandRange(string);
        if (n == -1) {
            this.postUserMessage("Invalid range");
            return true;
        }
        if (this.rangeStartLine > this.rangeEndLine) {
            this.postUserMessage("Start of range is after end of range");
            return true;
        }
        if (this.rangeStartLine == this.rangeEndLine && this.rangeStartColumn > this.rangeEndColumn) {
            this.postUserMessage("Start of range is after end of range");
            return true;
        }
        if (this.rangeEndLine >= this.lineList.getSize()) {
            this.postUserMessage("Address is greater than size of file");
            return true;
        }
        string = string.substring(n);
        if ((string = string.trim()).length() > 0) {
            String string2;
            char c;
            int n2 = string.indexOf(32);
            if (n2 == -1) {
                n2 = string.indexOf(47);
            } else if (string.indexOf(47) != -1 && n2 > string.indexOf(47)) {
                n2 = string.indexOf(47);
            }
            if (n2 == -1) {
                c = this.commandMgr.getCommand(string);
                string2 = "";
            } else {
                c = this.commandMgr.getCommand(string.substring(0, n2));
                string2 = string.substring(n2);
                string2 = string2.trim();
            }
            bl = this.processCommand(c, this.rangeStartLine, this.rangeStartColumn, this.rangeEndLine, this.rangeEndColumn, string2);
            if (!this.commandQuit) {
                this.adjustWindow();
            }
        } else {
            this.lineNumber = this.rangeEndLine;
            this.lineList.setTo(this.lineNumber);
            this.column = 0;
            bl = true;
            this.adjustWindow(true);
        }
        if (!this.commandQuit) {
            this.session.editEngineUpdateWindow();
        }
        return bl;
    }

    /*
     * Unable to fully structure code
     */
    private boolean processCommand(char var1_1, int var2_2, int var3_3, int var4_4, int var5_5, String var6_6) {
        var7_7 = true;
        switch (var1_1) {
            case '\u0000': {
                var7_7 = false;
                break;
            }
            case '\u0005': {
                if (this.setCommandRange(var6_6) == -1) {
                    this.postUserMessage("Target line is invalid");
                    break;
                }
                if (this.rangeDefault) {
                    this.postUserMessage("Target line must be specified");
                    break;
                }
                if (this.rangeStartLine != this.rangeEndLine) {
                    this.postUserMessage("Target cannot be a range");
                    break;
                }
                var8_8 = this.rangeStartLine;
                if (var8_8 >= this.lineList.getSize()) {
                    this.postUserMessage("Target line is invalid");
                    break;
                }
                this.bufferMgr.saveBuffer(this.addressedBuffer, this.copyTextArea(this.lineList, var2_2, 0, var4_4, 0, true), true);
                this.lineNumber = var8_8;
                this.lineList.setTo(this.lineNumber);
                this.column = 0;
                var9_23 = this.lineList.append(this.bufferMgr.getBuffer(this.addressedBuffer));
                this.incrementLine();
                this.editAtom = new EditAtom(this.lineList, this.lineNumber);
                this.editAtom.setEditLineCount(var9_23);
                break;
            }
            case '\u0006': {
                this.fileModified = true;
                this.lineList.setTo(var2_2);
                this.editAtom = new EditAtom(this.lineList, var2_2);
                var8_9 = var4_4 - var2_2 + 1;
                this.editAtom.addSaveLine(this.copyLine(this.lineList, var8_9));
                this.bufferMgr.saveBuffer(this.addressedBuffer, this.cutTextArea(this.lineList, var2_2, var3_3, var4_4, var5_5, true), true);
                this.column = 0;
                this.lineNumber = var2_2;
                if (!this.lineList.setTo(this.lineNumber)) {
                    if (this.lineNumber != 0) {
                        this.editAtom.setEditLineCount(0);
                        --this.lineNumber;
                    } else {
                        this.lineList.add(new Line(""));
                    }
                    this.lineList.last();
                    break;
                }
                this.editAtom.setEditLineCount(0);
                break;
            }
            case '\t': {
                if (var6_6.charAt(0) != '/') {
                    this.postUserMessage("Pattern not valid");
                    return false;
                }
                var8_10 = ReEngine.getReLength(var6_6, 0);
                if (var8_10 == 0) {
                    this.postUserMessage("Pattern not valid");
                    return false;
                }
                var9_24 = var6_6.substring(1, var8_10 + 1);
                var12_35 = var8_10 + 2;
                if (var12_35 == -1) {
                    return false;
                }
                var13_39 = var6_6.indexOf(47, var12_35);
                var10_43 = var13_39 == -1 ? this.commandMgr.getCommand(var6_6.substring(var12_35).trim()) : this.commandMgr.getCommand(var6_6.substring(var12_35, var13_39).trim());
                if (var10_43 == '\t') {
                    this.postUserMessage("Global cannot be a recursive command");
                    return false;
                }
                if (++var12_35 >= var6_6.length()) {
                    var11_50 = new String();
                } else {
                    var11_50 = var6_6.substring(var12_35 + 1);
                    var11_50.trim();
                }
                var14_56 = var2_2;
                var15_60 = new ReEngine(var9_24);
                switch (var10_43) {
                    case '\u0006': {
                        this.fileModified = true;
                        this.lineList.setTo(var2_2);
                        this.editAtom = new EditAtom(this.lineList, var2_2);
                        var16_63 = var4_4 - var2_2 + 1;
                        this.editAtom.addSaveLine(this.copyLine(this.lineList, var16_63));
                        this.editAtom.setEditLineCount(var4_4 - var2_2 + 1);
                        break;
                    }
                    default: {
                        this.postUserMessage("Command not supported with global");
                        return false;
                    }
                }
                var16_63 = 0;
                while (var14_56 <= var4_4) {
                    this.lineList.setTo(var14_56);
                    if (!var15_60.find(((Line)this.lineList.get()).getText(), 0)) ** GOTO lbl-1000
                    switch (var10_43) {
                        case '\u0006': {
                            this.bufferMgr.saveBuffer(this.addressedBuffer, this.cutTextArea(this.lineList, var14_56, 0, var14_56, 0, true), true);
                            this.editAtom.decrementEditLineCount();
                            --var16_63;
                            break;
                        }
                        default: lbl-1000:
                        // 2 sources

                        {
                            ++var14_56;
                        }
                    }
                }
                this.column = 0;
                this.lineNumber = var4_4 + var16_63;
                this.lineList.setTo(this.lineNumber);
                break;
            }
            case '\u0011': {
                var11_51 = var4_4 - var2_2;
                this.fileModified = true;
                this.lineList.setTo(var2_2);
                this.editAtom = new EditAtom(this.lineList, var2_2);
                this.editAtom.addSaveLine(this.copyLine(this.lineList, var11_51 + 1));
                this.lineList.setTo(var2_2);
                var8_11 = (Line)this.lineList.get();
                this.lineList.setTo(var2_2 + 1);
                while (var11_51-- > 0) {
                    var9_25 = (Line)this.lineList.remove();
                    var10_44 = var9_25.firstNonSpace(-1);
                    if (var10_44 < 0) continue;
                    if (var8_11.textLength() > 0 && var8_11.getCharacter(var8_11.textLength() - 1) != ' ') {
                        if (var10_44 == 0) {
                            var9_25.insertCharacter(' ', 0);
                        } else {
                            --var10_44;
                        }
                    }
                    var8_11.append(var9_25.getText(var10_44));
                }
                this.lineNumber = var2_2;
                this.lineList.setTo(this.lineNumber);
                break;
            }
            case '\u0014': {
                if (var6_6.length() != 1) {
                    this.postUserMessage("Invalid mark.");
                    break;
                }
                var8_12 = this.findMarkLine(var6_6.charAt(0));
                if (var8_12 != -1) {
                    this.lineList.setTo(var8_12);
                    ((Line)this.lineList.get()).resetMark();
                }
                this.lineList.setTo(var2_2);
                ((Line)this.lineList.get()).setMark(var6_6.charAt(0));
                this.lineList.setTo(this.lineNumber);
                break;
            }
            case '\u0015': {
                if (this.setCommandRange(var6_6) == -1) {
                    this.postUserMessage("Target line is invalid");
                    break;
                }
                if (this.rangeDefault) {
                    this.postUserMessage("Target line must be specified");
                    break;
                }
                if (this.rangeStartLine != this.rangeEndLine) {
                    this.postUserMessage("Target cannot be a range");
                    break;
                }
                var8_13 = this.rangeStartLine;
                if (var8_13 >= this.lineList.getSize()) {
                    this.postUserMessage("Target line is invalid");
                    break;
                }
                if (var8_13 >= var2_2 && var8_13 <= var4_4) {
                    this.postUserMessage("Target line is invalid");
                    break;
                }
                var9_26 = var4_4 - var2_2 + 1;
                this.lineList.setTo(var2_2);
                this.editAtom = new EditAtom(this.lineList, var2_2);
                this.editAtom.addSaveLine(this.copyLine(this.lineList, var9_26));
                this.bufferMgr.saveBuffer(this.addressedBuffer, this.cutTextArea(this.lineList, var2_2, 0, var4_4, 0, true), true);
                if (var8_13 > var4_4) {
                    var8_13 -= var9_26;
                }
                this.lineNumber = var8_13;
                this.lineList.setTo(this.lineNumber);
                this.column = 0;
                var9_26 = this.lineList.append(this.bufferMgr.getBuffer(this.addressedBuffer));
                this.incrementLine();
                this.editAtom.setEditStartLine(this.lineNumber);
                this.editAtom.setEditLineCount(var9_26);
                break;
            }
            case '\u0017': {
                if (var6_6.length() == 0) {
                    var13_40 = '\u0000';
                } else if (var6_6.length() > 1) {
                    var13_40 = var6_6.charAt(0);
                } else {
                    this.postUserMessage("Invalid mark.");
                    break;
                }
                if (!this.bufferMgr.isValid(var13_40)) {
                    this.postUserMessage("Buffer empty");
                    break;
                }
                this.fileModified = true;
                if (!this.bufferMgr.isWholeLine(var13_40)) {
                    this.lineList.setTo(var2_2);
                    var9_27 = (Line)this.lineList.get();
                    if (var9_27.textLength() < this.column + 1) {
                        var9_27.fill(' ', this.column - var9_27.textLength() + 1);
                    }
                    var10_45 = var9_27.getText(0, this.column + 1);
                    var11_52 = var9_27.getText(this.column + 1);
                    var12_36 = new LinkedList();
                    var12_36.add(this.bufferMgr.getBuffer(var13_40));
                    var12_36.first();
                    this.column += ((Line)var12_36.get()).textLength();
                    ((Line)var12_36.get()).insert(var10_45, 0);
                    var12_36.last();
                    ((Line)var12_36.get()).append(var11_52);
                    this.editAtom = new EditAtom(this.lineList, var2_2);
                    this.editAtom.addSaveLine((Line)this.lineList.remove());
                    var8_14 = var2_2 >= this.lineList.getSize() ? this.lineList.append(var12_36.cut()) : this.lineList.insert(var12_36.cut());
                    this.editAtom.setEditLineCount(var8_14);
                    this.lineList.setTo(var2_2);
                    this.addressedBuffer = '\u0000';
                } else {
                    this.lineNumber = var2_2;
                    this.lineList.setTo(this.lineNumber);
                    var8_14 = this.lineList.append(this.bufferMgr.getBuffer(this.addressedBuffer));
                    this.incrementLine();
                    this.editAtom = new EditAtom(this.lineList, this.lineNumber);
                    this.editAtom.setEditLineCount(var8_14);
                    this.addressedBuffer = '\u0000';
                }
                if (var8_14 <= 0) break;
                var14_57 = new StringBuffer("Put ");
                var14_57.append(var8_14);
                var14_57.append(" lines.");
                this.postUserMessage(var14_57.toString());
                break;
            }
            case '\u0018': {
                if (this.fileModified) {
                    this.postUserMessage("File has been modified, use q! or wq to exit.");
                    break;
                }
                this.session.editEngineQuit();
                this.commandQuit = true;
                break;
            }
            case 'B': {
                this.session.editEngineQuit();
                this.commandQuit = true;
                break;
            }
            case '\u0019': {
                if (var2_2 != var4_4) {
                    this.postUserMessage("Range is not allowed with the read command.");
                    break;
                }
                if (var6_6.startsWith("!")) {
                    this.postUserMessage("Read escape is not currently supported.");
                    break;
                }
                var9_28 = this.lineList.getSize();
                var8_15 = this.session.editEngineRead(var6_6, var2_2);
                if (var8_15 == '\u0000') {
                    this.fileModified = true;
                    this.incrementLine();
                    this.editAtom = new EditAtom(this.lineList, this.lineNumber);
                    this.editAtom.setEditLineCount(this.lineList.getSize() - var9_28);
                    this.addressedBuffer = '\u0000';
                    break;
                }
                if (var8_15 == '\u0005') {
                    this.postUserMessage("Could not read file");
                    break;
                }
                if (var8_15 != '\u0006') break;
                this.postUserMessage("Could not read file, file does not exist");
                break;
            }
            case '%': {
                var10_46 = false;
                var15_61 = 0;
                this.substituteGlobal = false;
                if (var6_6.charAt(0) != '/') {
                    this.postUserMessage("Pattern not valid");
                    break;
                }
                var11_53 = ReEngine.getReLength(var6_6, 0);
                if (var11_53 == 0) {
                    this.postUserMessage("Pattern not valid");
                    break;
                }
                var12_37 = ReEngine.getReLength(var6_6, var11_53 + 1);
                if (var11_53 + var12_37 + 3 < var6_6.length()) {
                    var16_64 = var6_6.substring(var11_53 + var12_37 + 3);
                    var16_64.trim();
                    if (var16_64.compareTo("g") == 0) {
                        this.substituteGlobal = true;
                    } else {
                        this.postUserMessage("Substitute pattern not valid");
                        break;
                    }
                }
                this.substituteSearchPattern = var6_6.substring(1, var11_53 + 1);
                this.substituteReplacePattern = var6_6.substring(var11_53 + 2, var11_53 + var12_37 + 2);
                var13_41 = var2_2;
                var16_64 = new ReEngine(this.substituteSearchPattern);
                this.editAtom = new EditAtom(this.lineList, var2_2);
                while (var13_41 <= var4_4) {
                    this.lineList.setTo(var13_41);
                    var14_58 = 0;
                    while (var16_64.find(((Line)this.lineList.get()).getText(), var14_58)) {
                        if (!var10_46) {
                            this.editAtom.addSaveLine(this.copyTextArea(this.lineList, var2_2, 0, var4_4, 0, true));
                            this.editAtom.setEditLineCount(var4_4 - var2_2 + 1);
                            this.lineList.setTo(var13_41);
                            var10_46 = true;
                        }
                        var8_16 = ((Line)this.lineList.get()).cutCharacter(var16_64.getIndex(), var16_64.getLength());
                        var9_29 = ReEngine.getReLiteral(this.substituteReplacePattern, var8_16);
                        ((Line)this.lineList.get()).insert(var9_29, var16_64.getIndex());
                        var14_58 = var16_64.getIndex() + var9_29.length();
                        if (((Line)this.lineList.get()).textLength() > 512) {
                            ((Line)this.lineList.get()).cutCharacter(512);
                            ++var15_61;
                            break;
                        }
                        if (!this.substituteGlobal || var14_58 >= ((Line)this.lineList.get()).textLength()) break;
                    }
                    ++var13_41;
                }
                if (var15_61 > 0) {
                    var17_66 = new StringBuffer();
                    var17_66.append(var15_61);
                    var17_66.append(" substitute lines have been truncated");
                    this.postUserMessage(var17_66.toString());
                }
                var14_58 = 0;
                this.lineNumber = var4_4;
                this.lineList.setTo(this.lineNumber);
                break;
            }
            case '\'': {
                if (this.editAtom != null) {
                    this.editAtom.undo();
                    this.lineNumber = this.editAtom.getEditStartLine();
                    while (!this.lineList.setTo(this.lineNumber)) {
                        --this.lineNumber;
                    }
                    this.column = 0;
                    break;
                }
                this.postUserMessage("There is nothing to undo.");
                break;
            }
            case '1': 
            case 'C': {
                v0 = var9_30 = var1_1 == 'C';
                var8_17 = this.rangeDefault ? (var6_6.length() == 0 ? this.session.editEngineWrite() : this.session.editEngineWrite(var6_6, var9_30)) : (var6_6.length() == 0 ? this.session.editEngineWrite(this.rangeStartLine, this.rangeEndLine) : this.session.editEngineWrite(this.rangeStartLine, this.rangeEndLine, var6_6, var9_30));
                if (var8_17 == '\u0000') {
                    this.postUserMessage("File write complete");
                    break;
                }
                if (var8_17 == '\u0002') {
                    this.postUserMessage("File exists, use w! to overwrite");
                    break;
                }
                if (var8_17 == '\u0003') {
                    this.postUserMessage("File has no name, use w <filename>");
                    break;
                }
                this.postUserMessage("Could not write file.");
                break;
            }
            case '2': {
                var8_18 = var6_6.length() == 0 ? this.session.editEngineWrite() : this.session.editEngineWrite(var6_6, false);
                if (var8_18 != '\u0000') break;
                this.session.editEngineQuit();
                break;
            }
            case '4': {
                if (var6_6.length() == 1) {
                    this.addressedBuffer = var6_6.charAt(0);
                }
                if (var6_6.length() > 1) {
                    this.informationBar.setMessage("Illegal buffer");
                    this.addressedBuffer = '\u0000';
                    break;
                }
                this.bufferMgr.saveBuffer(this.addressedBuffer, this.copyTextArea(this.lineList, var2_2, var3_3, var4_4, var5_5, true), true);
                this.lineNumber = var2_2;
                this.lineList.setTo(this.lineNumber);
                this.column = 0;
                var8_19 = var4_4 - var2_2;
                if (this.addressedBuffer == '/' || this.addressedBuffer == '?') {
                    this.informationBar.setMessage("Search string is illegal");
                }
                if (++var8_19 > 0) {
                    var9_31 = new StringBuffer("Yanked ");
                    var9_31.append(var8_19);
                    var9_31.append(" lines.");
                    this.postUserMessage(var9_31.toString());
                }
                this.addressedBuffer = '\u0000';
                break;
            }
            case '6': {
                this.postUserMessage("Escape is not currently supported.");
            }
            case '7': {
                this.textAreaWholeLine = true;
                this.lineList.setTo(var2_2);
                this.editAtom = new EditAtom(this.lineList, var2_2);
                var8_20 = var4_4 - var2_2 + 1;
                this.editAtom.addSaveLine(this.copyLine(this.lineList, var8_20));
                this.bufferMgr.saveBuffer(this.addressedBuffer, this.copyTextArea(this.lineList, this.textAreaStartLine, this.textAreaStartColumn, this.textAreaEndLine, this.textAreaEndColumn, true), true);
                this.editAtom.setEditLineCount(var8_20);
                this.lineNumber = var2_2;
                this.lineList.setTo(this.lineNumber);
                var10_47 = var4_4 - var2_2;
                while (var10_47-- >= 0) {
                    var9_32 = ((Line)this.lineList.get()).firstNonSpace(0);
                    if (var9_32 > 0) {
                        if (var9_32 > this.tabInterval) {
                            var9_32 = this.tabInterval;
                        }
                        ((Line)this.lineList.get()).deleteCharacter(0, var9_32);
                    }
                    this.lineList.next();
                }
                this.lineList.setTo(var2_2);
                this.column = ((Line)this.lineList.get()).firstNonSpace(0);
                if (var10_47 > 0) {
                    var11_54 = new StringBuffer("Shifted ");
                    var11_54.append(var10_47);
                    var11_54.append(" lines.");
                    this.postUserMessage(var11_54.toString());
                }
                this.addressedBuffer = '\u0000';
                this.repeatQueue.setCommandKey(this.commandKey, this.rawCommandNumber);
                this.repeatQueue.setCommandQueue(this.inputQueue.toString());
                break;
            }
            case '8': {
                this.textAreaWholeLine = true;
                this.lineList.setTo(var2_2);
                this.editAtom = new EditAtom(this.lineList, var2_2);
                var8_21 = var4_4 - var2_2 + 1;
                this.editAtom.addSaveLine(this.copyLine(this.lineList, var8_21));
                this.bufferMgr.saveBuffer(this.addressedBuffer, this.copyTextArea(this.lineList, var2_2, var3_3, var4_4, var5_5, true), true);
                this.editAtom.setEditLineCount(var8_21);
                this.lineNumber = var2_2;
                this.lineList.setTo(this.lineNumber);
                var9_33 = var4_4 - var2_2;
                while (var9_33-- >= 0) {
                    if (((Line)this.lineList.get()).firstNonSpace(-1) != -1) {
                        ((Line)this.lineList.get()).insertCharacter(' ', 0, this.tabInterval);
                    }
                    this.lineList.next();
                }
                this.lineList.setTo(var2_2);
                this.column = ((Line)this.lineList.get()).firstNonSpace(0);
                if (var9_33 > 0) {
                    var10_48 = new StringBuffer("Shifted ");
                    var10_48.append(var9_33);
                    var10_48.append(" lines.");
                    this.postUserMessage(var10_48.toString());
                }
                this.addressedBuffer = '\u0000';
                this.repeatQueue.setCommandKey(this.commandKey, this.rawCommandNumber);
                this.repeatQueue.setCommandQueue(this.inputQueue.toString());
                break;
            }
            case '9': {
                var10_49 = false;
                var15_62 = 0;
                var11_55 = this.substituteSearchPattern.length();
                var12_38 = this.substituteReplacePattern.length();
                if (var11_55 == 0) {
                    this.postUserMessage("Substitute pattern not valid");
                    break;
                }
                var13_42 = var2_2;
                var16_65 = new ReEngine(this.substituteSearchPattern);
                this.editAtom = new EditAtom(this.lineList, var2_2);
                while (var13_42 <= var4_4) {
                    this.lineList.setTo(var13_42);
                    var14_59 = 0;
                    while (var16_65.find(((Line)this.lineList.get()).getText(), var14_59)) {
                        if (!var10_49) {
                            this.editAtom.addSaveLine(this.copyTextArea(this.lineList, var2_2, 0, var4_4, 0, true));
                            this.editAtom.setEditLineCount(var4_4 - var2_2 + 1);
                            this.lineList.setTo(var13_42);
                            var10_49 = true;
                        }
                        var8_22 = ((Line)this.lineList.get()).cutCharacter(var16_65.getIndex(), var16_65.getLength());
                        var9_34 = ReEngine.getReLiteral(this.substituteReplacePattern, var8_22);
                        ((Line)this.lineList.get()).insert(var9_34, var16_65.getIndex());
                        var14_59 = var16_65.getIndex() + var9_34.length();
                        if (((Line)this.lineList.get()).textLength() > 512) {
                            ((Line)this.lineList.get()).cutCharacter(512);
                            ++var15_62;
                            break;
                        }
                        if (!this.substituteGlobal || var14_59 >= ((Line)this.lineList.get()).textLength()) break;
                    }
                    ++var13_42;
                }
                if (var15_62 <= 0) break;
                var17_67 = new StringBuffer();
                var17_67.append(var15_62);
                var17_67.append(" substitute lines have been truncated");
                this.postUserMessage(var17_67.toString());
                break;
            }
            default: {
                var7_7 = false;
            }
        }
        return var7_7;
    }

    /*
     * Unable to fully structure code
     */
    public int setCommandRange(String var1_1) {
        var6_2 = 0;
        var7_3 = 0;
        try {
            block45: {
                var2_4 = this.lineNumber;
                var4_5 = this.lineNumber;
                var3_6 = this.column;
                var5_7 = this.column;
                this.rangeDefault = true;
                if (var1_1.charAt(var6_2) == '%') {
                    this.rangeDefault = false;
                    this.rangeStartLine = 0;
                    this.rangeStartColumn = 0;
                    this.rangeEndLine = this.lineList.getSize() - 1;
                    this.rangeEndColumn = 0;
                    return var6_2 + 1;
                }
                if (Character.isDigit(var1_1.charAt(var6_2))) {
                    var7_3 = var6_2;
                    this.rangeDefault = false;
                    while (var7_3 < var1_1.length() && Character.isDigit(var1_1.charAt(var7_3))) {
                        ++var7_3;
                    }
                    var2_4 = Integer.parseInt(var1_1.substring(var6_2, var7_3));
                    if (var2_4 > 0) {
                        --var2_4;
                    }
                    var6_2 = var7_3;
                } else if (var1_1.charAt(var6_2) == '/' || var1_1.charAt(var6_2) == '?') {
                    this.rangeDefault = false;
                    var9_8 = var1_1.charAt(var6_2) != '/' ? 0 : 1;
                    var8_9 = ReEngine.getReLength(var1_1, var6_2);
                    if (var8_9 == 0) {
                        return -1;
                    }
                    var7_3 = ++var6_2 + var8_9;
                    this.searchMgr.setSearchString(var1_1.substring(var6_2, var7_3));
                    this.searchMgr.setSearchForward((boolean)var9_8);
                    this.searchMgr.setCaseIndependent(true);
                    if (!this.searchRegularExpression(this.lineList, this.lineNumber, this.column, 1, false)) {
                        return -1;
                    }
                    var2_4 = this.searchLine;
                    var3_6 = this.searchColumn;
                    if (var7_3 < var1_1.length()) {
                        ++var7_3;
                    }
                } else if (var1_1.charAt(var6_2) == '.') {
                    this.rangeDefault = false;
                    var2_4 = this.lineNumber;
                    ++var7_3;
                } else if (var1_1.charAt(var6_2) == '$') {
                    this.rangeDefault = false;
                    var2_4 = this.lineList.getSize() - 1;
                    ++var7_3;
                } else if (var1_1.charAt(var6_2) == '\'') {
                    this.rangeDefault = false;
                    if (var1_1.length() < 2) {
                        return -1;
                    }
                    var2_4 = this.findMarkLine(var1_1.charAt(var6_2 + 1));
                    var7_3 += 2;
                }
                if (var7_3 < var1_1.length() && (var1_1.charAt(var7_3) == '+' || var1_1.charAt(var7_3) == '-')) {
                    this.rangeDefault = false;
                    var9_8 = var1_1.charAt(var7_3) != '+' ? 0 : 1;
                    var6_2 = ++var7_3;
                    if (var7_3 < var1_1.length() && Character.isDigit(var1_1.charAt(var6_2))) {
                        while (var7_3 < var1_1.length() && Character.isDigit(var1_1.charAt(var7_3))) {
                            ++var7_3;
                        }
                        var8_9 = Integer.parseInt(var1_1.substring(var6_2, var7_3));
                    } else {
                        var8_9 = 1;
                    }
                    var2_4 = var9_8 != 0 ? (var2_4 += var8_9) : (var2_4 -= var8_9);
                }
                var4_5 = var2_4;
                this.rangeStartLine = var2_4;
                this.rangeStartColumn = var3_6;
                this.rangeEndLine = var2_4;
                this.rangeEndColumn = var3_6;
                if (var1_1.length() == var7_3) {
                    return var7_3;
                }
                if (var1_1.charAt(var7_3) != ',' && var1_1.charAt(var7_3) != ';') break block45;
                var8_9 = this.lineNumber;
                var9_8 = this.column;
                this.rangeDefault = false;
                if (var1_1.charAt(var7_3) == ';') {
                    var8_9 = var2_4;
                    var9_8 = var3_6;
                } else {
                    var8_9 = this.lineNumber;
                    var9_8 = this.column;
                }
                var6_2 = var7_3 + 1;
                if (var6_2 != var1_1.length()) ** GOTO lbl94
                return var6_2;
lbl-1000:
                // 1 sources

                {
                    if (++var6_2 != var1_1.length()) continue;
                    return var6_2;
lbl94:
                    // 2 sources

                    ** while (var1_1.charAt((int)var6_2) == ' ')
                }
lbl95:
                // 1 sources

                var7_3 = var6_2;
                if (Character.isDigit(var1_1.charAt(var6_2))) {
                    while (var7_3 < var1_1.length() && Character.isDigit(var1_1.charAt(var7_3))) {
                        ++var7_3;
                    }
                    var4_5 = Integer.parseInt(var1_1.substring(var6_2, var7_3));
                    if (var4_5 > 0) {
                        --var4_5;
                    }
                } else if (var1_1.charAt(var6_2) == '/' || var1_1.charAt(var6_2) == '?') {
                    var11_10 = var1_1.charAt(var6_2) == '/';
                    var10_11 = ReEngine.getReLength(var1_1, var6_2);
                    if (var10_11 == 0) {
                        return -1;
                    }
                    var7_3 = ++var6_2 + var10_11;
                    this.searchMgr.setSearchString(var1_1.substring(var6_2, var7_3));
                    this.searchMgr.setSearchForward(var11_10);
                    this.searchMgr.setCaseIndependent(true);
                    if (!this.searchRegularExpression(this.lineList, var8_9, var9_8, 1, false)) {
                        return -1;
                    }
                    var4_5 = this.searchLine;
                    var5_7 = this.searchColumn;
                    if (var7_3 < var1_1.length()) {
                        ++var7_3;
                    }
                } else if (var1_1.charAt(var6_2) == '.') {
                    var4_5 = this.lineNumber;
                    ++var7_3;
                } else if (var1_1.charAt(var6_2) == '$') {
                    var4_5 = this.lineList.getSize() - 1;
                    ++var7_3;
                } else if (var1_1.charAt(var6_2) == '\'') {
                    if (var1_1.length() < 2) {
                        return -1;
                    }
                    var4_5 = this.findMarkLine(var1_1.charAt(var6_2 + 1));
                    var7_3 += 2;
                }
            }
            if (var7_3 < var1_1.length() && (var1_1.charAt(var7_3) == '+' || var1_1.charAt(var7_3) == '-')) {
                var9_8 = var1_1.charAt(var7_3) != '+' ? 0 : 1;
                var6_2 = ++var7_3;
                if (var7_3 < var1_1.length() && Character.isDigit(var1_1.charAt(var6_2))) {
                    while (var7_3 < var1_1.length() && Character.isDigit(var1_1.charAt(var7_3))) {
                        ++var7_3;
                    }
                    var8_9 = Integer.parseInt(var1_1.substring(var6_2, var7_3));
                } else {
                    var8_9 = 1;
                }
                var4_5 = var9_8 != 0 ? (var4_5 += var8_9) : (var4_5 -= var8_9);
            }
            this.rangeStartLine = var2_4;
            this.rangeStartColumn = var3_6;
            this.rangeEndLine = var4_5;
            this.rangeEndColumn = var5_7;
            return var7_3;
        }
        catch (NumberFormatException v0) {
            return -1;
        }
    }

    public void undo() {
        Key key = new Key('\u001b', false, false, false);
        this.process(key);
        key = new Key('u', false, false, false);
        this.process(key);
    }

    public void paste(LinkedList linkedList) {
        int n;
        boolean bl = false;
        int n2 = this.column;
        this.resetUndoLine();
        Key key = new Key('\u001b', false, false, false);
        this.process(key);
        if (linkedList == null) {
            return;
        }
        this.updateWindow = true;
        this.fileModified = true;
        this.lineList.setTo(this.lineNumber);
        Line line = (Line)this.lineList.get();
        int n3 = this.column + 1;
        int n4 = line.textLength() - (this.column + 1);
        if (n4 < 0) {
            n4 = 0;
        }
        if (linkedList.getSize() == 1) {
            linkedList.first();
            if (((Line)linkedList.get()).textLength() + n4 + n3 > 512) {
                bl = true;
            } else {
                n2 = this.column + ((Line)linkedList.get()).textLength() - 1;
            }
        } else {
            linkedList.last();
            if (((Line)linkedList.get()).textLength() + n4 > 512) {
                bl = true;
            }
            linkedList.first();
            if (((Line)linkedList.get()).textLength() + n3 > 512) {
                bl = true;
            }
        }
        if (bl) {
            n2 = 0;
            n = this.lineList.append(linkedList.cut());
            this.lineList.setTo(this.lineNumber);
            this.incrementLine();
            this.editAtom = new EditAtom(this.lineList, this.lineNumber);
            this.editAtom.setEditLineCount(n);
            this.addressedBuffer = '\u0000';
        } else {
            String string;
            String string2;
            if (line.textLength() < this.column + 1) {
                line.fill(' ', this.column - line.textLength());
                string2 = line.getText(0, this.column);
                string = new String();
            } else {
                string2 = line.getText(0, this.column);
                string = line.getText(this.column);
            }
            ((Line)linkedList.get()).insert(string2, 0);
            linkedList.last();
            ((Line)linkedList.get()).append(string);
            this.editAtom = new EditAtom(this.lineList, this.lineNumber);
            this.editAtom.addSaveLine((Line)this.lineList.remove());
            n = this.lineNumber >= this.lineList.getSize() ? this.lineList.append(linkedList.cut()) : this.lineList.insert(linkedList.cut());
            this.editAtom.setEditLineCount(n);
            this.lineList.setTo(this.lineNumber);
        }
        if (n > 0) {
            StringBuffer stringBuffer = new StringBuffer("Pasted ");
            stringBuffer.append(n);
            stringBuffer.append(" lines.");
            this.postUserMessage(stringBuffer.toString());
        }
        this.column = n2;
        this.adjustWindow();
        this.session.editEngineUpdateWindow();
    }

    public boolean search() {
        Key key = new Key('n', false, false, false);
        this.process(key);
        return true;
    }

    public boolean isModified() {
        return this.fileModified;
    }

    public void resetModified() {
        this.editAtom = null;
        this.fileModified = false;
    }

    public void setAutoIndent(boolean bl) {
        this.autoIndent = bl;
    }

    public int getMode() {
        return this.mode;
    }

    public void setMode() {
    }

    private int findNestColumn() {
        int n = 0;
        if (!this.autoIndent) {
            return 0;
        }
        this.lineList.push();
        while (this.lineList.previous()) {
            if (((Line)this.lineList.get()).textLength() <= 0 || (n = ((Line)this.lineList.get()).firstNonSpace(-1)) == -1) continue;
            this.lineList.pop();
            return n;
        }
        this.lineList.pop();
        return 0;
    }

    private void scrollDown(int n) {
        if (this.windowStartLine + n < this.lineList.getSize()) {
            this.updateWindow = true;
            this.windowStartLine += n;
            if (this.lineNumber < this.windowStartLine) {
                this.lineNumber = this.windowStartLine;
            }
            this.lineList.setTo(this.lineNumber);
        }
    }

    private void scrollUp(int n) {
        if (this.windowStartLine - n >= 0) {
            this.updateWindow = true;
            this.windowStartLine -= n;
            if (this.lineNumber > this.windowStartLine + this.windowSizeInLines - 1) {
                this.lineNumber = this.windowStartLine + this.windowSizeInLines - 1;
            }
            this.lineList.setTo(this.lineNumber);
        }
    }

    public void setSyntaxMgr(SyntaxMgr syntaxMgr) {
        this.syntaxMgr = syntaxMgr;
    }

    private void setupCommands() {
        this.commandMgr.addCommand("abbrev", '\u0001');
        this.commandMgr.addCommand("append", '\u0002');
        this.commandMgr.addCommand("args", '\u0003');
        this.commandMgr.addCommand("copy", '\u0005');
        this.commandMgr.addCommand("change", '\u0004');
        this.commandMgr.addCommand("delete", '\u0006');
        this.commandMgr.addCommand("edit", '\u0000');
        this.commandMgr.addCommand("!", '\u0000');
        this.commandMgr.addCommand("file", '\b');
        this.commandMgr.addCommand("global", '\t');
        this.commandMgr.addCommand("insert", '\u0010');
        this.commandMgr.addCommand("join", '\u0011');
        this.commandMgr.addCommand("line_no", 'A');
        this.commandMgr.addCommand("list", '\u0012');
        this.commandMgr.addCommand("<", '7');
        this.commandMgr.addCommand("move", '\u0015');
        this.commandMgr.addCommand("mark", '\u0014');
        this.commandMgr.addCommand("map", '\u0013');
        this.commandMgr.addCommand("next", '\u0010');
        this.commandMgr.addCommand("new", '\u0000');
        this.commandMgr.addCommand("number", '\u0010');
        this.commandMgr.addCommand("put", '\u0017');
        this.commandMgr.addCommand("preserve", '\u0010');
        this.commandMgr.addCommand("print", '\u0016');
        this.commandMgr.addCommand("quit", '\u0018');
        this.commandMgr.addCommand("q!", 'B');
        this.commandMgr.addCommand("read", '\u0019');
        this.commandMgr.addCommand("recover", ' ');
        this.commandMgr.addCommand("&", '9');
        this.commandMgr.addCommand("rewind", '!');
        this.commandMgr.addCommand(">", '8');
        this.commandMgr.addCommand("substitute", '%');
        this.commandMgr.addCommand("scroll", '@');
        this.commandMgr.addCommand("set", '\"');
        this.commandMgr.addCommand("shell", '#');
        this.commandMgr.addCommand("source", '$');
        this.commandMgr.addCommand("undo", '\'');
        this.commandMgr.addCommand("unabbrev", '&');
        this.commandMgr.addCommand("unmap", '(');
        this.commandMgr.addCommand("version", ')');
        this.commandMgr.addCommand("visual", '0');
        this.commandMgr.addCommand("write", '1');
        this.commandMgr.addCommand("w!", 'C');
        this.commandMgr.addCommand("wq", '2');
        this.commandMgr.addCommand("window", '5');
        this.commandMgr.addCommand("xit", '3');
        this.commandMgr.addCommand("yank", '4');
    }

    public LinkedList getCutList(int n, int n2, int n3, int n4) {
        this.lineList.setTo(n);
        if (n2 >= ((Line)this.lineList.get()).textLength()) {
            if (n == n3) {
                this.lineList.setTo(this.lineNumber);
                return null;
            }
            this.lineList.setTo(++n);
            n2 = 0;
        }
        this.editAtom = new EditAtom(this.lineList, n);
        int n5 = n3 - n + 1;
        this.editAtom.addSaveLine(this.copyLine(this.lineList, n5));
        ListElement listElement = this.cutTextArea(this.lineList, n, n2, n3, n4, false);
        this.editAtom.setEditLineCount(1);
        this.column = n2;
        this.lineNumber = n;
        this.lineList.setTo(this.lineNumber);
        this.adjustWindow();
        LinkedList linkedList = new LinkedList();
        linkedList.add(listElement);
        return linkedList;
    }

    public LinkedList getCopyList(int n, int n2, int n3, int n4) {
        this.lineList.setTo(n);
        if (n2 >= ((Line)this.lineList.get()).textLength()) {
            if (n == n3) {
                this.lineList.setTo(this.lineNumber);
                return null;
            }
            ++n;
            n2 = 0;
        }
        ListElement listElement = this.copyTextArea(this.lineList, n, n2, n3, n4, false);
        LinkedList linkedList = new LinkedList();
        linkedList.add(listElement);
        this.lineList.setTo(this.lineNumber);
        return linkedList;
    }

    private void checkCursorColumn(boolean bl) {
        if (!this.eolIndependentCursor) {
            if (bl) {
                this.column = this.savedCursorColumn;
            } else {
                this.savedCursorColumn = this.column;
            }
            if (this.column > ((Line)this.lineList.get()).textLength() - 1) {
                this.column = ((Line)this.lineList.get()).textLength() - 1;
                if (this.column < 0) {
                    this.column = 0;
                }
            }
            this.useSavedCursorColumn = true;
        }
    }

    private boolean isUndoLine() {
        return this.undoLine != null;
    }

    private void resetUndoLine() {
        this.undoLine = null;
    }

    private void setUndoLine() {
        if (this.undoLine == null) {
            this.undoLine = new String(((Line)this.lineList.get()).getText());
        }
    }

    private void setUndoLine(String string) {
        if (this.undoLine == null) {
            this.undoLine = new String(string);
        }
    }

    private String getUndoLine() {
        String string = this.undoLine;
        this.undoLine = null;
        return string;
    }
}

