/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Canvas;
import java.awt.Color;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Rectangle;

class EditCursor
extends Thread {
    public static final int VERTICAL_BAR = 0;
    public static final int UNDERLINE = 1;
    private int cursorHeight;
    private int cursorVerticalOffset;
    private int cursorWidth;
    private boolean displayed = false;
    private boolean blinkEnabled = false;
    private boolean enabled = false;
    private boolean inhibit = false;
    private Rectangle cursor;
    private Canvas canvas;

    public EditCursor(Canvas canvas) {
        this.canvas = canvas;
        this.cursor = new Rectangle();
    }

    public void setBlinkEnabled(boolean bl) {
        this.blinkEnabled = bl;
    }

    public void setEnabled(boolean bl) {
        this.enabled = bl;
    }

    public void setInhibit(boolean bl) {
        this.inhibit = bl;
    }

    public void erase(Graphics graphics) {
        if (this.displayed) {
            this.drawCursor(graphics, this.cursor);
        }
    }

    public synchronized void erase() {
        Graphics graphics;
        if (this.displayed && (graphics = this.canvas.getGraphics()) != null) {
            this.drawCursor(graphics, this.cursor);
            graphics.dispose();
        }
    }

    public synchronized void draw(Graphics graphics, int n, int n2) {
        if (this.displayed) {
            this.erase(graphics);
        }
        if (this.enabled) {
            this.cursor.height = this.cursorHeight;
            this.cursor.width = this.cursorWidth;
            this.cursor.x = n;
            this.cursor.y = n2 - this.cursorVerticalOffset;
            this.drawCursor(graphics, this.cursor);
        }
    }

    public void reset() {
        this.displayed = false;
    }

    public void run() {
        while (true) {
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException interruptedException) {}
            this.blinkCursor();
        }
    }

    private synchronized void blinkCursor() {
        if (!this.blinkEnabled || !this.enabled || this.inhibit) {
            return;
        }
        Graphics graphics = this.canvas.getGraphics();
        if (graphics != null) {
            this.drawCursor(graphics, this.cursor);
            graphics.dispose();
        }
    }

    private void drawCursor(Graphics graphics, Rectangle rectangle) {
        if (graphics != null) {
            graphics.setColor(Color.black);
            graphics.setXORMode(Color.white);
            graphics.fillRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
            graphics.setPaintMode();
            this.displayed = !this.displayed;
        }
    }

    public void setStyle(int n, FontMetrics fontMetrics) {
        if (fontMetrics == null) {
            return;
        }
        switch (n) {
            case 1: {
                this.cursorVerticalOffset = 0;
                this.cursorHeight = fontMetrics.getHeight() / 5;
                this.cursorWidth = fontMetrics.charWidth('a');
                break;
            }
            default: {
                this.cursorVerticalOffset = fontMetrics.getAscent();
                this.cursorHeight = fontMetrics.getHeight();
                this.cursorWidth = fontMetrics.charWidth('a') / 4;
            }
        }
        if (this.cursorWidth == 0) {
            this.cursorWidth = 1;
        }
        if (this.cursorHeight <= 1) {
            this.cursorHeight = 2;
        }
    }
}

