/*
 * Decompiled with CFR 0.152.
 */
import java.awt.CheckboxMenuItem;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FileDialog;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Menu;
import java.awt.MenuBar;
import java.awt.MenuItem;
import java.awt.MenuShortcut;
import java.awt.Point;
import java.awt.Window;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;

public class CodeQuill
extends Frame
implements EditSessionInt,
ActionListener,
ItemListener,
KeyListener,
WindowListener,
FocusListener {
    private static final char CMD_NEW = '\u0001';
    private static final char CMD_EDIT = '\u0002';
    private static final char CMD_VERSION = '\u0003';
    private EditSession session;
    private SearchMgr searchMgr;
    private SyntaxMgr syntaxMgr;
    private BufferMgr bufferMgr;
    private CommandLine commandLine;
    private Font defaultFont;
    private LinkedList sessionList = new LinkedList();
    private Options options;
    private StringBuffer titleLine = new StringBuffer("CodeQuill");
    private InformationBar informationBar;
    private InformationArea informationArea;
    private String fileDialogPath;
    private CommandMgr commandMgr;
    private boolean firstFocus = true;
    private Clipboard clipboard;
    private Transferable clipboardData;
    private boolean markAreaValid = false;
    RecallMenu recallMenu;
    Menu fileMenu = new Menu("File");
    MenuItem newFileMenuItem = new MenuItem("New");
    MenuItem openFileMenuItem = new MenuItem("Open...");
    MenuItem saveFileMenuItem = new MenuItem("Save");
    MenuItem saveAsFileMenuItem = new MenuItem("Save as...");
    MenuItem closeFileMenuItem = new MenuItem("Close");
    CheckboxMenuItem compressFileMenuItem = new CheckboxMenuItem("Tab compression");
    MenuItem quitFileMenuItem = new MenuItem("Quit");
    MenuItem undoEditMenuItem = new MenuItem("Undo");
    MenuItem copyEditMenuItem = new MenuItem("Copy");
    MenuItem copyBufferEditMenuItem = new MenuItem("Copy buffer");
    MenuItem cutEditMenuItem = new MenuItem("Cut");
    MenuItem pasteEditMenuItem = new MenuItem("Paste");
    MenuItem searchEditMenuItem = new MenuItem("Search...");
    RadioMenu fontNameOptionMenu = new RadioMenu("Font name");
    RadioMenu fontPointOptionMenu = new RadioMenu("Font point size");
    CheckboxMenuItem fontBoldOptionMenuItem = new CheckboxMenuItem("Font bold");
    CheckboxMenuItem autoIndentOptionMenuItem = new CheckboxMenuItem("Auto indent");
    RadioMenu tabColumnOptionMenu = new RadioMenu("Tab column");
    RadioMenu newFileDefaultFormatOptionMenu = new RadioMenu("New file format");
    CheckboxMenuItem defaultTabCompressionOptionMenuItem = new CheckboxMenuItem("Save with tabs");
    CheckboxMenuItem defaultSpaceExpansionOptionMenuItem = new CheckboxMenuItem("Save with spaces");
    RadioMenu fileSaveFormatOptionMenu = new RadioMenu("File save format");
    CheckboxMenuItem saveDefaultCompressionOptionMenuItem = new CheckboxMenuItem("Use existing format");
    CheckboxMenuItem saveTabCompressionOptionMenuItem = new CheckboxMenuItem("Save with tabs");
    CheckboxMenuItem saveSpaceExpansionOptionMenuItem = new CheckboxMenuItem("Save with spaces");
    CheckboxMenuItem stripEolSpacesOptionMenuItem = new CheckboxMenuItem("Strip EOL spaces");
    Menu searchOptionMenu = new Menu("Search");
    CheckboxMenuItem matchCaseSearchOptionMenuItem = new CheckboxMenuItem("Match case");
    Menu cursorOptionMenu = new Menu("Cursor");
    CheckboxMenuItem eolIndependentCursorOptionMenuItem = new CheckboxMenuItem("EOL independent");
    MenuItem syntaxFileOptionMenuItem = new MenuItem("Syntax file...");
    MenuItem saveOptionMenuItem = new MenuItem("Save options");
    MenuItem helpHelpMenuItem = new MenuItem("Help...");
    MenuItem aboutHelpMenuItem = new MenuItem("About...");
    MenuItem registrationHelpMenuItem = new MenuItem("Registration...");
    MenuShortcut copyShortcut = new MenuShortcut(155);
    MenuShortcut pasteShortcut = new MenuShortcut(155, true);
    MenuShortcut cutShortcut = new MenuShortcut(127, true);
    MenuShortcut newShortcut = new MenuShortcut(78, true);
    MenuShortcut openShortcut = new MenuShortcut(79, true);
    MenuShortcut saveShortcut = new MenuShortcut(83, true);
    MenuShortcut saveAsShortcut = new MenuShortcut(65, true);
    MenuShortcut closeShortcut = new MenuShortcut(67, true);
    MenuShortcut quitShortcut = new MenuShortcut(81, true);
    String version = new String("1.0");
    String licenseNumber = new String();
    String registrationKey = new String();
    Integer cqObjectFormatId = new Integer(0);
    Dimension windowStartSize;
    boolean registered;

    public CodeQuill(String[] stringArray) {
        this.updateTitleLine();
        this.options = new Options();
        this.windowStartSize = new Dimension(this.options.getDefaultWidth(), this.options.getDefaultHeight());
        this.restoreCodeQuill();
        this.initializeMenus();
        this.commandMgr = new CommandMgr();
        this.setupCommands();
        this.defaultFont = new Font("Monospaced", 1, this.options.getFontPoint());
        this.informationBar = new InformationBar();
        this.fileDialogPath = System.getProperty("user.dir");
        this.syntaxMgr = new SyntaxMgr();
        this.syntaxMgr.add(this.options.getSyntaxFile());
        this.bufferMgr = new BufferMgr();
        this.searchMgr = new SearchMgr();
        this.searchMgr.setCaseIndependent(this.options.isSearchCaseIndependent());
        this.commandLine = new CommandLine();
        this.commandLine.setFont(this.defaultFont);
        this.informationArea = new InformationArea(this.commandLine, this.informationBar);
        int n = 0;
        while (n < stringArray.length) {
            this.openSession(stringArray[n++]);
        }
        this.sessionList.first();
        this.session = (EditSession)this.sessionList.get();
        if (this.session != null) {
            this.add((Component)this.session, "Center");
        }
        this.add((Component)this.informationArea, "South");
        this.setSessionMenu();
        this.updateTitleLine();
        this.commandLine.addKeyListener(this);
        this.commandLine.addActionListener(this);
        this.addWindowListener(this);
        this.addFocusListener(this);
        ((Component)this).setSize(this.windowStartSize);
        this.clipboard = this.getToolkit().getSystemClipboard();
        this.registered = false;
        this.checkRegistration();
    }

    public void focusGained(FocusEvent focusEvent) {
        if (this.firstFocus) {
            this.firstFocus = false;
            this.setCurrentSessionFocus();
        }
    }

    public void focusLost(FocusEvent focusEvent) {
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() instanceof MenuItem) {
            if (((MenuItem)actionEvent.getSource()).getParent() == this.recallMenu) {
                this.openSession(((MenuItem)actionEvent.getSource()).getLabel());
                return;
            }
            this.menuItemActionPerformed(actionEvent);
            return;
        }
        if (actionEvent.getSource() == this.commandLine) {
            this.commandLineActionPerformed(actionEvent);
        }
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        MenuItem menuItem = (MenuItem)itemEvent.getSource();
        if (menuItem.getParent() == this.fontNameOptionMenu) {
            this.setFontName();
        }
        if (menuItem.getParent() == this.fontPointOptionMenu) {
            this.setFontPoint();
            return;
        }
        if (menuItem.getParent() == this.tabColumnOptionMenu) {
            this.setTabColumn();
            return;
        }
        if (menuItem.getParent() == this.newFileDefaultFormatOptionMenu) {
            this.options.setDefaultTabCompression(this.defaultTabCompressionOptionMenuItem.getState());
            return;
        }
        if (menuItem.getParent() == this.fileSaveFormatOptionMenu) {
            this.setFileSaveFormat(menuItem);
            return;
        }
        if (menuItem == this.compressFileMenuItem) {
            this.session.setEnableTabCompression(this.compressFileMenuItem.getState());
            return;
        }
        if (menuItem == this.fontBoldOptionMenuItem) {
            this.options.setFontBold(this.fontBoldOptionMenuItem.getState());
            this.updateSessionOptions();
            return;
        }
        if (menuItem == this.autoIndentOptionMenuItem) {
            this.options.setAutoIndent(this.autoIndentOptionMenuItem.getState());
            this.updateSessionOptions();
            return;
        }
        if (menuItem == this.stripEolSpacesOptionMenuItem) {
            this.options.setStripEolSpaces(this.stripEolSpacesOptionMenuItem.getState());
            return;
        }
        if (menuItem == this.matchCaseSearchOptionMenuItem) {
            this.options.setSearchCaseIndependent(!this.matchCaseSearchOptionMenuItem.getState());
            this.searchMgr.setCaseIndependent(!this.matchCaseSearchOptionMenuItem.getState());
            return;
        }
        if (menuItem == this.eolIndependentCursorOptionMenuItem) {
            this.options.setEolIndependentCursor(this.eolIndependentCursorOptionMenuItem.getState());
            this.updateSessionOptions();
        }
    }

    private void updateSessionOptions() {
        this.sessionList.push();
        this.sessionList.first();
        EditSession editSession = (EditSession)this.sessionList.get();
        while (editSession != null) {
            editSession.updateOptions();
            editSession.setSyntaxMgr(this.syntaxMgr);
            editSession = (EditSession)this.sessionList.getNext();
        }
        this.sessionList.pop();
    }

    private void commandLineActionPerformed(ActionEvent actionEvent) {
        if (this.session != null) {
            this.session.requestFocus();
        }
        switch (this.commandLine.getSearchRequest()) {
            case 0: 
            case 3: {
                String string = this.commandLine.getCommandString();
                string = string.trim();
                this.informationBar.clearMessage();
                if (this.session != null && this.session.processCommandLine(string) || this.processCommandLine(string)) break;
                if (this.session == null) {
                    this.informationBar.setMessage("Invalid system command, use \"new\" \"edit\" or \"e\" to start session");
                    break;
                }
                this.informationBar.setMessage("Invalid command");
                break;
            }
            case 1: {
                if (this.session == null) {
                    this.informationBar.setMessage("Must have open file to search");
                    break;
                }
                this.searchMgr.setSearchString(this.commandLine.getSearchString());
                this.searchMgr.setSearchForward(true);
                this.session.search();
                break;
            }
            case 2: {
                if (this.session == null) {
                    this.informationBar.setMessage("Must have open file to search");
                    break;
                }
                this.searchMgr.setSearchString(this.commandLine.getSearchString());
                this.searchMgr.setSearchForward(false);
                this.session.search();
                break;
            }
        }
        this.commandLine.clear();
    }

    public void setVisible(boolean bl) {
        super.setVisible(bl);
        if (bl) {
            if (this.session != null) {
                this.session.requestFocus();
                return;
            }
            this.commandLine.requestFocus();
        }
    }

    public static void main(String[] stringArray) {
        CodeQuill codeQuill = new CodeQuill(stringArray);
        codeQuill.setVisible(true);
    }

    public void keyTyped(KeyEvent keyEvent) {
    }

    public void keyReleased(KeyEvent keyEvent) {
    }

    public void keyPressed(KeyEvent keyEvent) {
        new Key(keyEvent);
        if (keyEvent.isConsumed()) {
            return;
        }
        if (this.processSystemKey(keyEvent)) {
            keyEvent.consume();
            return;
        }
        if (keyEvent.getComponent() == this.commandLine) {
            if (keyEvent.getKeyCode() == 27) {
                this.informationBar.clearMessage();
                this.commandLine.clear();
                if (this.session != null) {
                    this.session.requestFocus();
                }
                keyEvent.consume();
                return;
            }
        } else if (this.processKey(keyEvent)) {
            keyEvent.consume();
            return;
        }
    }

    private boolean processSystemKey(KeyEvent keyEvent) {
        keyEvent.getKeyChar();
        boolean bl = false;
        if (keyEvent.getKeyCode() == 112) {
            this.informationBar.setMessage("F2 - Next file, F3 - Previous file, F4 - File information");
            bl = true;
        } else if (keyEvent.getKeyCode() == 113) {
            if (this.session == null) {
                this.informationBar.setMessage("No current sessions");
            } else if (keyEvent.getComponent() != this.commandLine) {
                if (this.sessionList.getSize() == 1) {
                    this.informationBar.setMessage("Only one session");
                } else {
                    this.informationBar.clearMessage();
                    this.nextSession();
                    this.setSessionMenu();
                }
            }
            bl = true;
        } else if (keyEvent.getKeyCode() == 114) {
            if (this.session == null) {
                this.informationBar.setMessage("No current sessions");
            } else if (keyEvent.getComponent() != this.commandLine) {
                if (this.sessionList.getSize() == 1) {
                    this.informationBar.setMessage("Only one session");
                } else {
                    this.informationBar.clearMessage();
                    this.previousSession();
                }
            }
            bl = true;
        } else if (keyEvent.getKeyCode() == 115) {
            if (this.session == null) {
                this.informationBar.setMessage("No current sessions");
            } else {
                this.informationBar.setMessage(this.session.getFileInformation());
            }
            bl = true;
        }
        return bl;
    }

    private boolean processKey(KeyEvent keyEvent) {
        keyEvent.getKeyChar();
        if (this.session == null) {
            return false;
        }
        char c = this.session.request();
        if (c != '\u0000') {
            switch (c) {
                case '\u0002': {
                    this.commandLine.requestCommand();
                    this.informationBar.setMessage("Command line");
                    return true;
                }
                case '\u0003': {
                    this.commandLine.requestSearchForward();
                    this.informationBar.setMessage("Search forward");
                    return true;
                }
                case '\u0004': {
                    this.commandLine.requestSearchBack();
                    this.informationBar.setMessage("Search back");
                    return true;
                }
                case '\u0001': {
                    this.closeSession(true);
                    return true;
                }
            }
        }
        return false;
    }

    void postMessage(String string) {
        MessageDialog messageDialog = new MessageDialog((Frame)this, "CodeQuill message", string);
        ((Component)messageDialog).setVisible(true);
        messageDialog.dispose();
        this.setCurrentSessionFocus();
    }

    void postSyntaxReadFail(String string) {
        String[] stringArray = new String[]{"Could not read syntax file:", string};
        MessageDialog messageDialog = new MessageDialog((Frame)this, "Syntax file read failure", stringArray);
        ((Component)messageDialog).setVisible(true);
        messageDialog.dispose();
        this.setCurrentSessionFocus();
    }

    void postRegistrationThankYou(String string) {
        String[] stringArray = new String[3];
        stringArray[0] = "CodeQuill registration validated.";
        stringArray[1] = "Registered to: ";
        stringArray[1] = stringArray[1].concat(string);
        stringArray[2] = "Thank you for registering!";
        MessageDialog messageDialog = new MessageDialog((Frame)this, "CodeQuill registration thank you", stringArray);
        ((Component)messageDialog).setVisible(true);
        messageDialog.dispose();
        this.setCurrentSessionFocus();
    }

    void postAboutMessage() {
        String[] stringArray = new String[4];
        stringArray[0] = "CodeQuill";
        stringArray[1] = "version ";
        stringArray[1] = stringArray[1].concat(this.version);
        stringArray[2] = "Copyright (c) 1998 Sonoran Software Guild, Inc.";
        stringArray[3] = "All rights reserved.";
        MessageDialog messageDialog = new MessageDialog((Frame)this, "About Code Quill", stringArray);
        ((Component)messageDialog).setVisible(true);
        messageDialog.dispose();
        this.setCurrentSessionFocus();
    }

    void postHelpMessage() {
        String[] stringArray = new String[]{"F1 - Help", "F2 - Next file", "F3 - Previous file", "F4 - File information"};
        HelpDialog helpDialog = new HelpDialog((Frame)this, stringArray);
        ((Component)helpDialog).setVisible(true);
        helpDialog.dispose();
        this.setCurrentSessionFocus();
    }

    private boolean openSession(String string) {
        if (string != null && string.length() > 0) {
            String string2;
            new StringBuffer(string);
            File file = new File(string);
            try {
                string2 = file.getCanonicalPath();
            }
            catch (Exception exception) {
                this.informationBar.setMessage("Could not open, illegal file path");
                return false;
            }
            if (file.isDirectory()) {
                this.informationBar.setMessage("Could not open, file is a directory");
                return false;
            }
            this.sessionList.push();
            this.sessionList.first();
            EditSession editSession = (EditSession)this.sessionList.get();
            while (editSession != null) {
                String string3 = editSession.getCanonicalPath();
                if (string3 != null && (!this.options.isFileCaseSensitive() && string3.toLowerCase().compareTo(string2.toLowerCase()) == 0 || string3.compareTo(string2) == 0)) {
                    this.sessionList.pop();
                    this.setSession(editSession);
                    this.recallMenu.insert(editSession.getName(), this);
                    return true;
                }
                editSession = (EditSession)this.sessionList.getNext();
            }
            this.sessionList.pop();
            if (this.checkOpenFileLimit()) {
                return false;
            }
            EditSession editSession2 = new EditSession(this, this, string2, this.syntaxMgr, this.bufferMgr, this.options, this.informationBar, this.searchMgr);
            if (editSession2 != null) {
                this.sessionList.append(editSession2);
                editSession2.addKeyListener(this);
                this.nextSession();
                this.setSessionMenu();
                this.recallMenu.insert(this.session.getName(), this);
                return true;
            }
        }
        return false;
    }

    private boolean openSession() {
        FileDialog fileDialog = new FileDialog((Frame)this, "Open", 0);
        fileDialog.setDirectory(this.fileDialogPath);
        ((Component)fileDialog).setVisible(true);
        String string = fileDialog.getFile();
        this.fileDialogPath = fileDialog.getDirectory();
        if (string != null && string.length() > 0) {
            String string2;
            StringBuffer stringBuffer = new StringBuffer(this.fileDialogPath);
            stringBuffer.append(string);
            File file = new File(stringBuffer.toString());
            try {
                string2 = file.getCanonicalPath();
            }
            catch (Exception exception) {
                this.postMessage("Could not open, invalid file path");
                return false;
            }
            this.sessionList.push();
            this.sessionList.first();
            EditSession editSession = (EditSession)this.sessionList.get();
            while (editSession != null) {
                String string3 = editSession.getCanonicalPath();
                if (string3 != null && (!this.options.isFileCaseSensitive() && string3.toLowerCase().compareTo(string2.toLowerCase()) == 0 || string3.compareTo(string2) == 0)) {
                    this.sessionList.pop();
                    this.setSession(editSession);
                    this.recallMenu.insert(this.session.getName(), this);
                    return true;
                }
                editSession = (EditSession)this.sessionList.getNext();
            }
            this.sessionList.pop();
            if (this.checkOpenFileLimit()) {
                return false;
            }
            EditSession editSession2 = new EditSession(this, this, string2, this.syntaxMgr, this.bufferMgr, this.options, this.informationBar, this.searchMgr);
            if (editSession2 != null) {
                this.sessionList.append(editSession2);
                editSession2.addKeyListener(this);
                this.nextSession();
                this.setSessionMenu();
                this.recallMenu.insert(this.session.getName(), this);
                return true;
            }
        }
        this.setCurrentSessionFocus();
        return false;
    }

    private boolean closeSession(boolean bl) {
        if (this.session == null) {
            return false;
        }
        if (this.session.isModified() && !bl) {
            DecisionDialog decisionDialog = new DecisionDialog((Frame)this, "CodeQuill - Warning", "File is modified. Close file anyway?");
            decisionDialog.show();
            if (!decisionDialog.getDecision()) {
                this.setCurrentSessionFocus();
                decisionDialog.dispose();
                return false;
            }
            decisionDialog.dispose();
        }
        if (!this.sessionList.isPrevious()) {
            this.remove((EditSession)this.sessionList.remove());
            this.sessionList.last();
        } else {
            this.remove((EditSession)this.sessionList.remove());
        }
        if (!this.currentSession()) {
            this.setSessionMenu();
            this.informationBar.setLineNumber(-1);
            this.informationBar.setColumn(-1);
            this.informationBar.clearMessage();
            this.commandLine.requestCommand();
        }
        return true;
    }

    private void setCurrentSessionFocus() {
        if (this.session == null) {
            this.commandLine.requestFocus();
            return;
        }
        this.session.requestFocus();
    }

    private boolean currentSession() {
        this.session = (EditSession)this.sessionList.get();
        if (this.session == null) {
            this.updateTitleLine();
            return false;
        }
        this.add((Component)this.session, "Center");
        this.validate();
        this.updateTitleLine();
        this.session.requestFocus();
        this.setSessionMenu();
        return true;
    }

    private void setSession(EditSession editSession) {
        EditSession editSession2 = this.session;
        this.sessionList.first();
        this.session = (EditSession)this.sessionList.get();
        while (this.session != editSession) {
            this.session = (EditSession)this.sessionList.getNext();
        }
        if (editSession2 != editSession) {
            this.remove(editSession2);
            this.add((Component)this.session, "Center");
            this.validate();
            this.updateTitleLine();
        }
        this.setSessionMenu();
        this.session.requestFocus();
    }

    private void nextSession() {
        EditSession editSession;
        if (this.session == null) {
            editSession = null;
            this.session = (EditSession)this.sessionList.get();
        } else {
            editSession = this.session;
            if (this.sessionList.next()) {
                this.session = (EditSession)this.sessionList.get();
            } else {
                this.sessionList.first();
                this.session = (EditSession)this.sessionList.get();
            }
        }
        if (this.session != null) {
            if (editSession != null) {
                this.remove(editSession);
            }
            this.add((Component)this.session, "Center");
            this.validate();
            this.updateTitleLine();
            this.session.requestFocus();
            return;
        }
        this.postMessage("session == null");
        this.updateTitleLine();
    }

    private void previousSession() {
        EditSession editSession;
        if (this.session == null) {
            editSession = null;
            this.session = (EditSession)this.sessionList.get();
        } else {
            editSession = this.session;
            if (this.sessionList.previous()) {
                this.session = (EditSession)this.sessionList.get();
            } else {
                this.sessionList.last();
                this.session = (EditSession)this.sessionList.get();
            }
        }
        if (this.session != null) {
            if (editSession != null) {
                this.remove(editSession);
            }
            this.add((Component)this.session, "Center");
            this.validate();
            this.updateTitleLine();
            this.session.requestFocus();
        } else {
            this.postMessage("session == null");
            this.updateTitleLine();
        }
        this.setSessionMenu();
    }

    private void menuItemActionPerformed(ActionEvent actionEvent) {
        Object object;
        Object object2 = actionEvent.getSource();
        if (object2 == this.registrationHelpMenuItem) {
            object = new Registration((Frame)this, "CodeQuill registration", this.registered);
            ((Dialog)object).show();
            ((Window)object).dispose();
        }
        if (object2 == this.aboutHelpMenuItem) {
            this.postAboutMessage();
        }
        if (object2 == this.helpHelpMenuItem) {
            this.postHelpMessage();
        }
        if (object2 == this.quitFileMenuItem) {
            this.codeQuillExit(false);
            return;
        }
        if (object2 == this.closeFileMenuItem) {
            this.closeSession(false);
            return;
        }
        if (object2 == this.openFileMenuItem) {
            this.openSession();
            return;
        }
        if (object2 == this.saveFileMenuItem) {
            this.saveSession();
            return;
        }
        if (object2 == this.saveAsFileMenuItem) {
            this.saveAsSession();
            return;
        }
        if (object2 == this.newFileMenuItem) {
            if (this.checkOpenFileLimit()) {
                return;
            }
            object = new EditSession(this, this, this.syntaxMgr, this.bufferMgr, this.options, this.informationBar, this.searchMgr);
            if (object != null) {
                this.sessionList.append(object);
                ((Component)object).addKeyListener(this);
                this.nextSession();
                this.setSessionMenu();
                return;
            }
            this.postMessage("Could not create a new session");
            return;
        }
        if (object2 == this.undoEditMenuItem) {
            this.session.undo();
            return;
        }
        if (object2 == this.copyEditMenuItem) {
            object = new StringSelection(this.session.getMarkArea(false));
            this.clipboard.setContents((Transferable)object, (ClipboardOwner)object);
            return;
        }
        if (object2 == this.copyBufferEditMenuItem) {
            if (this.bufferMgr.isValid('\u0000')) {
                object = new StringSelection(this.session.getCopyBuffer());
                this.clipboard.setContents((Transferable)object, (ClipboardOwner)object);
                return;
            }
            this.postMessage("Copy buffer is empty");
            return;
        }
        if (object2 == this.saveOptionMenuItem) {
            if (!this.options.save()) {
                this.postMessage("Could not save options");
                return;
            }
        } else {
            if (object2 == this.cutEditMenuItem) {
                object = new StringSelection(this.session.getMarkArea(true));
                this.clipboard.setContents((Transferable)object, (ClipboardOwner)object);
                return;
            }
            if (object2 == this.pasteEditMenuItem) {
                this.paste();
                return;
            }
            if (object2 != this.searchEditMenuItem && object2 == this.syntaxFileOptionMenuItem) {
                this.setSyntaxFile();
            }
        }
    }

    private void setSyntaxFile() {
        FileDialog fileDialog = new FileDialog((Frame)this, "Open syntax file", 0);
        ((Component)fileDialog).setVisible(true);
        String string = fileDialog.getFile();
        this.fileDialogPath = fileDialog.getDirectory();
        if (string != null && this.fileDialogPath != null && string.length() > 0) {
            StringBuffer stringBuffer = new StringBuffer(this.fileDialogPath);
            stringBuffer.append(string);
            this.options.setSyntaxFile(stringBuffer.toString());
            SyntaxMgr syntaxMgr = new SyntaxMgr();
            if (!syntaxMgr.add(this.options.getSyntaxFile())) {
                this.postSyntaxReadFail(stringBuffer.toString());
                return;
            }
            this.syntaxMgr = syntaxMgr;
            this.updateSessionOptions();
            return;
        }
        if (string == null) {
            this.postMessage("New syntax file was not opened");
        }
    }

    private void paste() {
        this.clipboardData = this.clipboard.getContents(this);
        if (this.clipboardData == null) {
            this.postMessage("Clipboard is empty");
            return;
        }
        this.session.paste(this.clipboardData);
    }

    private void saveSession() {
        if (this.session.write() != '\u0000') {
            this.postMessage("Could not save file");
        }
    }

    private void saveAsSession() {
        FileDialog fileDialog = new FileDialog((Frame)this, "Save As", 1);
        fileDialog.setDirectory(this.fileDialogPath);
        ((Component)fileDialog).setVisible(true);
        String string = fileDialog.getFile();
        this.fileDialogPath = fileDialog.getDirectory();
        if (string != null && string.length() > 0) {
            StringBuffer stringBuffer = new StringBuffer(this.fileDialogPath);
            stringBuffer.append(string);
            char c = this.session.write(stringBuffer.toString(), false);
            if (c == '\u0000') {
                this.updateTitleLine();
            } else if (c == '\u0001') {
                DecisionDialog decisionDialog = new DecisionDialog((Frame)this, "CodeQuill - Warning", "File exists. Overwrite the file?");
                decisionDialog.show();
                if (decisionDialog.getDecision()) {
                    c = this.session.write(stringBuffer.toString(), true);
                    if (c != '\u0000') {
                        this.postMessage("Could not save file");
                    }
                    c = this.session.write(stringBuffer.toString(), false);
                }
                this.setCurrentSessionFocus();
                decisionDialog.dispose();
            } else {
                this.postMessage("Could not save file");
            }
            this.setSessionMenu();
        }
    }

    private void setSessionMenu() {
        boolean bl;
        if (this.session == null) {
            bl = false;
            if (this.options.isForceTabCompression() || this.options.isForceSpaceExpansion()) {
                this.compressFileMenuItem.setState(this.options.isForceTabCompression());
                this.compressFileMenuItem.setEnabled(false);
            } else {
                this.compressFileMenuItem.setState(false);
                this.compressFileMenuItem.setEnabled(false);
            }
            this.saveFileMenuItem.setEnabled(false);
        } else {
            bl = true;
            if (this.session.getName() != null) {
                this.saveFileMenuItem.setEnabled(true);
            } else {
                this.saveFileMenuItem.setEnabled(false);
            }
            if (this.options.isForceTabCompression() || this.options.isForceSpaceExpansion()) {
                this.compressFileMenuItem.setState(this.options.isForceTabCompression());
                this.compressFileMenuItem.setEnabled(false);
            } else {
                this.compressFileMenuItem.setState(this.session.isTabCompression());
                this.compressFileMenuItem.setEnabled(true);
            }
        }
        this.saveAsFileMenuItem.setEnabled(bl);
        this.closeFileMenuItem.setEnabled(bl);
        this.undoEditMenuItem.setEnabled(bl);
        this.copyEditMenuItem.setEnabled(false);
        this.copyBufferEditMenuItem.setEnabled(bl);
        this.cutEditMenuItem.setEnabled(false);
        this.pasteEditMenuItem.setEnabled(bl);
        this.searchEditMenuItem.setEnabled(false);
    }

    private void updateTitleLine() {
        this.titleLine.setLength(9);
        if (this.session != null) {
            this.titleLine.append(" - ");
            if (this.session.getName() == null) {
                this.titleLine.append("unnamed");
            } else {
                this.titleLine.append(this.session.getName());
            }
        }
        this.setTitle(this.titleLine.toString());
    }

    private void initializeMenus() {
        MenuBar menuBar = new MenuBar();
        this.fileMenu.add(this.newFileMenuItem);
        this.fileMenu.add(this.openFileMenuItem);
        if (this.recallMenu == null) {
            this.recallMenu = new RecallMenu("Recall");
        }
        this.fileMenu.add(this.recallMenu);
        this.fileMenu.add(this.saveFileMenuItem);
        this.fileMenu.add(this.saveAsFileMenuItem);
        this.fileMenu.add(this.closeFileMenuItem);
        this.fileMenu.addSeparator();
        this.fileMenu.add(this.compressFileMenuItem);
        this.fileMenu.addSeparator();
        if (this.options.isForceTabCompression() || this.options.isForceSpaceExpansion()) {
            this.compressFileMenuItem.setState(this.options.isForceTabCompression());
            this.compressFileMenuItem.setEnabled(false);
        }
        this.fileMenu.add(this.quitFileMenuItem);
        this.newFileMenuItem.addActionListener(this);
        this.openFileMenuItem.addActionListener(this);
        this.saveFileMenuItem.addActionListener(this);
        this.saveAsFileMenuItem.addActionListener(this);
        this.closeFileMenuItem.addActionListener(this);
        this.compressFileMenuItem.addItemListener(this);
        this.quitFileMenuItem.addActionListener(this);
        this.newFileMenuItem.setShortcut(this.newShortcut);
        this.openFileMenuItem.setShortcut(this.openShortcut);
        this.saveFileMenuItem.setShortcut(this.saveShortcut);
        this.saveAsFileMenuItem.setShortcut(this.saveAsShortcut);
        this.quitFileMenuItem.setShortcut(this.quitShortcut);
        this.closeFileMenuItem.setShortcut(this.closeShortcut);
        Menu menu = new Menu("Edit");
        menu.add(this.undoEditMenuItem);
        menu.add(this.copyEditMenuItem);
        menu.add(this.copyBufferEditMenuItem);
        menu.add(this.cutEditMenuItem);
        menu.add(this.pasteEditMenuItem);
        this.undoEditMenuItem.addActionListener(this);
        this.copyEditMenuItem.addActionListener(this);
        this.copyBufferEditMenuItem.addActionListener(this);
        this.cutEditMenuItem.addActionListener(this);
        this.pasteEditMenuItem.addActionListener(this);
        this.copyEditMenuItem.setShortcut(this.copyShortcut);
        this.cutEditMenuItem.setShortcut(this.cutShortcut);
        this.pasteEditMenuItem.setShortcut(this.pasteShortcut);
        Menu menu2 = new Menu("Options");
        menu2.add(this.fontNameOptionMenu);
        String[] stringArray = this.getToolkit().getFontList();
        int n = 0;
        while (n < stringArray.length) {
            this.fontNameOptionMenu.add(stringArray[n], false).addItemListener(this);
            ++n;
        }
        this.fontNameOptionMenu.selectItem(this.options.getFontName());
        menu2.add(this.fontPointOptionMenu);
        this.fontPointOptionMenu.add(8).addItemListener(this);
        this.fontPointOptionMenu.add(9).addItemListener(this);
        this.fontPointOptionMenu.add(10).addItemListener(this);
        this.fontPointOptionMenu.add(11).addItemListener(this);
        this.fontPointOptionMenu.add(12).addItemListener(this);
        this.fontPointOptionMenu.add(13).addItemListener(this);
        this.fontPointOptionMenu.add(14).addItemListener(this);
        this.fontPointOptionMenu.add(15).addItemListener(this);
        this.fontPointOptionMenu.add(16).addItemListener(this);
        this.fontPointOptionMenu.add(17).addItemListener(this);
        this.fontPointOptionMenu.add(18).addItemListener(this);
        this.fontPointOptionMenu.add(20).addItemListener(this);
        this.fontPointOptionMenu.add(24).addItemListener(this);
        this.fontPointOptionMenu.selectItem(this.options.getFontPoint());
        this.fontPointOptionMenu.addActionListener(this);
        menu2.add(this.fontBoldOptionMenuItem);
        this.fontBoldOptionMenuItem.setState(this.options.isFontBold());
        this.fontBoldOptionMenuItem.addItemListener(this);
        menu2.add(this.autoIndentOptionMenuItem);
        this.autoIndentOptionMenuItem.setState(this.options.isAutoIndent());
        this.autoIndentOptionMenuItem.addItemListener(this);
        menu2.add(this.tabColumnOptionMenu);
        this.tabColumnOptionMenu.add(2).addItemListener(this);
        this.tabColumnOptionMenu.add(3).addItemListener(this);
        this.tabColumnOptionMenu.add(4).addItemListener(this);
        this.tabColumnOptionMenu.add(5).addItemListener(this);
        this.tabColumnOptionMenu.add(6).addItemListener(this);
        this.tabColumnOptionMenu.add(7).addItemListener(this);
        this.tabColumnOptionMenu.add(8).addItemListener(this);
        this.tabColumnOptionMenu.selectItem(this.options.getTabInterval());
        menu2.add(this.newFileDefaultFormatOptionMenu);
        this.newFileDefaultFormatOptionMenu.add(this.defaultSpaceExpansionOptionMenuItem);
        this.defaultSpaceExpansionOptionMenuItem.addItemListener(this);
        this.defaultSpaceExpansionOptionMenuItem.setState(!this.options.isDefaultTabCompression());
        this.newFileDefaultFormatOptionMenu.add(this.defaultTabCompressionOptionMenuItem);
        this.defaultTabCompressionOptionMenuItem.setState(this.options.isDefaultTabCompression());
        this.defaultTabCompressionOptionMenuItem.addItemListener(this);
        menu2.add(this.fileSaveFormatOptionMenu);
        this.fileSaveFormatOptionMenu.add(this.saveDefaultCompressionOptionMenuItem);
        this.fileSaveFormatOptionMenu.add(this.saveSpaceExpansionOptionMenuItem);
        this.fileSaveFormatOptionMenu.add(this.saveTabCompressionOptionMenuItem);
        this.saveDefaultCompressionOptionMenuItem.addItemListener(this);
        this.saveTabCompressionOptionMenuItem.addItemListener(this);
        this.saveSpaceExpansionOptionMenuItem.addItemListener(this);
        if (this.options.isForceTabCompression()) {
            this.setFileSaveFormat(this.saveTabCompressionOptionMenuItem);
        } else if (this.options.isForceSpaceExpansion()) {
            this.setFileSaveFormat(this.saveSpaceExpansionOptionMenuItem);
        } else {
            this.setFileSaveFormat(this.saveDefaultCompressionOptionMenuItem);
        }
        menu2.add(this.stripEolSpacesOptionMenuItem);
        this.stripEolSpacesOptionMenuItem.addItemListener(this);
        this.stripEolSpacesOptionMenuItem.setState(this.options.isStripEolSpaces());
        menu2.add(this.searchOptionMenu);
        this.searchOptionMenu.add(this.matchCaseSearchOptionMenuItem);
        this.matchCaseSearchOptionMenuItem.addItemListener(this);
        this.matchCaseSearchOptionMenuItem.setState(!this.options.isSearchCaseIndependent());
        menu2.add(this.cursorOptionMenu);
        this.cursorOptionMenu.add(this.eolIndependentCursorOptionMenuItem);
        this.eolIndependentCursorOptionMenuItem.addItemListener(this);
        this.eolIndependentCursorOptionMenuItem.setState(this.options.isEolIndependentCursor());
        menu2.add(this.syntaxFileOptionMenuItem);
        this.syntaxFileOptionMenuItem.addActionListener(this);
        menu2.addSeparator();
        menu2.add(this.saveOptionMenuItem);
        this.saveOptionMenuItem.addActionListener(this);
        Menu menu3 = new Menu("Help");
        menu3.add(this.helpHelpMenuItem);
        menu3.add(this.aboutHelpMenuItem);
        menu3.add(this.registrationHelpMenuItem);
        this.helpHelpMenuItem.addActionListener(this);
        this.aboutHelpMenuItem.addActionListener(this);
        this.registrationHelpMenuItem.addActionListener(this);
        menuBar.add(this.fileMenu);
        menuBar.add(menu);
        menuBar.add(menu2);
        menuBar.add(menu3);
        this.setMenuBar(menuBar);
    }

    private void setFileSaveFormat(Object object) {
        boolean bl = false;
        boolean bl2 = false;
        if (object == this.saveDefaultCompressionOptionMenuItem) {
            this.saveDefaultCompressionOptionMenuItem.setState(true);
            this.compressFileMenuItem.setEnabled(true);
            if (this.session != null) {
                bl = this.session.isTabCompression();
                bl2 = true;
            }
        } else if (object == this.saveTabCompressionOptionMenuItem) {
            bl = true;
        }
        this.compressFileMenuItem.setEnabled(bl2);
        this.compressFileMenuItem.setState(bl);
        this.options.setForceSpaceExpansion(this.saveSpaceExpansionOptionMenuItem.getState());
        this.options.setForceTabCompression(this.saveTabCompressionOptionMenuItem.getState());
    }

    private void setFontPoint() {
        this.options.setFontPoint(this.fontPointOptionMenu.getValue());
        this.updateSessionOptions();
    }

    private void setFontName() {
        this.options.setFontName(this.fontNameOptionMenu.getSelectedLabel());
        this.updateSessionOptions();
    }

    private void setTabColumn() {
        this.options.setTabInterval(this.tabColumnOptionMenu.getValue());
        this.updateSessionOptions();
    }

    public void editSessionQuit() {
        this.closeSession(true);
    }

    public void editSessionQuit(boolean bl) {
        this.closeSession(bl);
    }

    public void editSessionMarkAreaSetEnabled(boolean bl) {
        this.copyEditMenuItem.setEnabled(bl);
        this.cutEditMenuItem.setEnabled(bl);
    }

    public void codeQuillExit(boolean bl) {
        if (!bl) {
            this.sessionList.push();
            this.sessionList.first();
            EditSession editSession = (EditSession)this.sessionList.get();
            while (editSession != null) {
                if (editSession.isModified()) {
                    this.sessionList.pop();
                    ExitClient exitClient = new ExitClient(this, this, this.sessionList);
                    EditSession editSession2 = exitClient.getEditSession();
                    if (editSession2 != null) {
                        this.setSession(editSession2);
                        return;
                    }
                    this.setCurrentSessionFocus();
                    return;
                }
                editSession = (EditSession)this.sessionList.getNext();
            }
            this.sessionList.pop();
        }
        if (this.session != null) {
            this.session.disableCursor();
        }
        this.saveCodeQuill();
        this.setVisible(false);
        System.exit(0);
    }

    public void editSessionEdit(String string) {
        this.openSession(string);
    }

    public void editSessionSetFileName(String string) {
        this.updateTitleLine();
        this.setSessionMenu();
    }

    public boolean overwriteFile(String string) {
        if (this.session.write(string, true) != '\u0000') {
            this.postMessage("Could not write to file");
            return false;
        }
        return true;
    }

    public void editSessionInformationMessage(String string) {
        this.postMessage(string);
    }

    private boolean processCommandLine(String string) {
        boolean bl;
        String string2;
        boolean bl2 = true;
        int n = string.indexOf(" ");
        if (n != -1) {
            string2 = string.substring(0, n);
            bl = true;
        } else {
            string2 = string;
            bl = false;
        }
        switch (this.commandMgr.getCommand(string2)) {
            case '\u0001': {
                if (this.checkOpenFileLimit()) break;
                EditSession editSession = new EditSession(this, this, this.syntaxMgr, this.bufferMgr, this.options, this.informationBar, this.searchMgr);
                if (editSession != null) {
                    this.sessionList.append(editSession);
                    editSession.addKeyListener(this);
                    this.nextSession();
                    this.setSessionMenu();
                    break;
                }
                this.informationBar.setMessage("Could not create a new session");
                break;
            }
            case '\u0002': {
                if (bl) {
                    this.openSession(string.substring(n + 1));
                    break;
                }
                this.informationBar.setMessage("Edit requests a file name.");
                break;
            }
            case '\u0003': {
                this.informationBar.setMessage("Version not implemented");
                break;
            }
            default: {
                this.informationBar.setMessage("Command not supported");
            }
        }
        return bl2;
    }

    public void windowDeiconified(WindowEvent windowEvent) {
    }

    public void windowIconified(WindowEvent windowEvent) {
    }

    public void windowActivated(WindowEvent windowEvent) {
    }

    public void windowDeactivated(WindowEvent windowEvent) {
    }

    public void windowOpened(WindowEvent windowEvent) {
    }

    public void windowClosed(WindowEvent windowEvent) {
        System.exit(0);
    }

    public void windowClosing(WindowEvent windowEvent) {
        this.codeQuillExit(false);
    }

    private void setupCommands() {
        this.commandMgr.addCommand("new", '\u0001');
        this.commandMgr.addCommand("edit", '\u0002');
        this.commandMgr.addCommand("version", '\u0003');
    }

    private boolean checkOpenFileLimit() {
        if (this.sessionList.getSize() >= 6) {
            String[] stringArray = new String[]{"CodeQuill is limited to six open files"};
            MessageDialog messageDialog = new MessageDialog((Frame)this, "CodeQuill Open File Limit", stringArray);
            ((Component)messageDialog).setVisible(true);
            messageDialog.dispose();
            this.setCurrentSessionFocus();
            return true;
        }
        return false;
    }

    private void restoreCodeQuill() {
        Object object;
        String[] stringArray = null;
        String string = null;
        Dimension dimension = null;
        Point point = null;
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(System.getProperty("user.home"));
        stringBuffer.append(System.getProperty("file.separator"));
        stringBuffer.append("cqobject");
        try {
            object = new FileInputStream(stringBuffer.toString());
            ObjectInputStream objectInputStream = new ObjectInputStream((InputStream)object);
            this.cqObjectFormatId = (Integer)objectInputStream.readObject();
            string = (String)objectInputStream.readObject();
            this.registered = (Boolean)objectInputStream.readObject();
            this.licenseNumber = (String)objectInputStream.readObject();
            dimension = (Dimension)objectInputStream.readObject();
            point = (Point)objectInputStream.readObject();
            stringArray = (String[])objectInputStream.readObject();
            objectInputStream.close();
        }
        catch (Exception exception) {}
        object = this.getToolkit().getScreenSize();
        if (dimension != null) {
            if (object != null) {
                if (dimension.width > ((Dimension)object).width) {
                    dimension.width = ((Dimension)object).width;
                }
                if (dimension.height > ((Dimension)object).height) {
                    dimension.height = ((Dimension)object).height;
                }
            }
            this.windowStartSize = dimension;
        }
        if (point != null) {
            if (object != null) {
                if (point.x + dimension.width > ((Dimension)object).width) {
                    point.x = ((Dimension)object).width - dimension.width;
                }
                if (point.y + dimension.height > ((Dimension)object).height) {
                    point.y = ((Dimension)object).height - dimension.height;
                }
                if (point.x < 0) {
                    point.x = 0;
                }
                if (point.y < 0) {
                    point.y = 0;
                }
            }
            ((Component)this).setLocation(point);
        }
        if (stringArray != null) {
            this.recallMenu = new RecallMenu("Recall", stringArray, this);
        }
    }

    private void saveCodeQuill() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(System.getProperty("user.home"));
        stringBuffer.append(System.getProperty("file.separator"));
        stringBuffer.append("cqobject");
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(stringBuffer.toString());
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(fileOutputStream);
            objectOutputStream.writeObject(this.cqObjectFormatId);
            objectOutputStream.writeObject(this.version);
            objectOutputStream.writeObject(new Boolean(this.registered));
            objectOutputStream.writeObject(this.licenseNumber);
            objectOutputStream.writeObject(this.getSize());
            objectOutputStream.writeObject(this.getLocationOnScreen());
            objectOutputStream.writeObject(this.recallMenu.getList());
            objectOutputStream.flush();
            objectOutputStream.close();
            return;
        }
        catch (IOException iOException) {
            return;
        }
    }

    private void checkRegistration() {
        if (!this.registered) {
            String[] stringArray = new String[]{"CodeQuill", "Unregistered version 1.0", "Copyright (c) 1998 Sonoran Software Guild, Inc.", "All rights reserved.", "View registration information?"};
            DecisionDialog decisionDialog = new DecisionDialog((Frame)this, "Unregistered CodeQuill", stringArray, true);
            decisionDialog.show();
            if (decisionDialog.getDecision()) {
                decisionDialog.dispose();
                Registration registration = new Registration((Frame)this, "CodeQuill registration", this.registered);
                registration.show();
                registration.dispose();
                return;
            }
            decisionDialog.dispose();
        }
    }
}

