/*
 * Decompiled with CFR 0.152.
 */
package sunw.demo.encapsulatedEvents.ClassFile;

import java.io.DataOutputStream;
import java.io.IOException;
import sunw.demo.encapsulatedEvents.ClassFile.ClassFile;
import sunw.demo.encapsulatedEvents.ClassFile.ConstantPoolEntry;
import sunw.demo.encapsulatedEvents.ClassFile.UTF8Constant;

class ClassConstant
extends ConstantPoolEntry {
    private UTF8Constant name;

    ClassConstant(String string, ClassFile classFile) {
        super((byte)7, classFile);
        this.name = classFile.addUTF8Constant(ClassFile.fullyQualifiedForm(string));
        this.addToConstantPool();
    }

    void write(DataOutputStream dataOutputStream) throws IOException {
        if (ConstantPoolEntry.debug()) {
            System.err.println(String.valueOf(this.getConstantPoolIndex()) + " CLASS: " + this.name.getConstantPoolIndex());
        }
        dataOutputStream.writeByte(this.getTag());
        dataOutputStream.writeShort(this.name.getConstantPoolIndex());
    }

    String getClassName() {
        return this.name.getString();
    }

    Class getClassObject() throws ClassNotFoundException {
        return Class.forName(this.name.getString());
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (object instanceof String) {
            return ((String)object).equals(this.name.getString());
        }
        if (object instanceof ClassConstant) {
            ClassConstant classConstant = (ClassConstant)object;
            return this.name.getString().equals(classConstant.getClassName());
        }
        return false;
    }
}

