/*
 * Decompiled with CFR 0.152.
 */
package sunw.demo.select;

import java.awt.Button;
import java.awt.Font;
import java.awt.Label;
import java.awt.List;
import java.awt.Panel;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.beans.Customizer;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Vector;
import sunw.demo.select.Select;
import sunw.demo.select.Util;

public class SelectCustomizer
extends Panel
implements Customizer {
    PropertyChangeSupport support = new PropertyChangeSupport(this);
    TextField urlField;
    TextField userField;
    TextField passwordField;
    Label status = new Label("");
    int buttonOffset;
    static final int NO_WORK = 0;
    static final int DO_USER_TABLES = 1;
    static final int DO_ALL_TABLES = 2;
    static final int DO_VIEW = 3;
    int work = 0;
    String spaces = "                                                                                                                             ";
    Connection con;
    String url;
    String user;
    String password;
    Vector tableNames;
    List tableList;
    List columnList;
    String tableName;
    String selectString;
    Vector columnNames;
    Vector columnTypes;
    Select target;

    public SelectCustomizer() {
        this.setLayout(null);
        this.setBounds(200, 200, 400, 500);
        WorkerThread workerThread = new WorkerThread();
        workerThread.start();
    }

    public void setObject(Object object) {
        this.target = (Select)object;
        this.url = this.target.getURL();
        this.user = this.target.getUser();
        this.password = this.target.getPassword();
        this.createStartupScreen();
        this.setVisible(true);
    }

    void doWork() {
        while (true) {
            int n = this.getWork();
            this.con = Util.connect(this.url, this.user, this.password, this.status);
            if (this.con == null) continue;
            if (n == 1) {
                this.getTables(false);
            } else if (n == 2) {
                this.getTables(true);
            } else if (n == 3) {
                this.getInfo(this.tableName);
            }
            Util.disconnect(this.con);
        }
    }

    private synchronized int getWork() {
        this.work = 0;
        while (this.work == 0) {
            try {
                this.wait();
            }
            catch (Exception exception) {}
        }
        int n = this.work;
        return n;
    }

    synchronized void setWork(int n) {
        this.work = n;
        this.notify();
    }

    private void getTables(boolean bl) {
        try {
            String[] stringArray;
            this.setStatus("Opened connection OK, searching for tables...");
            DatabaseMetaData databaseMetaData = this.con.getMetaData();
            if (bl) {
                stringArray = new String[]{"TABLE", "SYSTEM TABLE"};
            } else {
                stringArray = new String[2];
                stringArray[0] = "TABLE";
            }
            ResultSet resultSet = databaseMetaData.getTables(null, "%", "%", stringArray);
            this.tableNames = new Vector();
            int n = 0;
            while (resultSet.next()) {
                String string = String.valueOf(resultSet.getString(2)) + "." + resultSet.getString(3);
                this.tableNames.addElement(string);
                ++n;
            }
            resultSet.close();
            this.setStatus("Got " + n + " tables");
            this.createTableScreen();
            return;
        }
        catch (SQLException sQLException) {
            this.setStatus(sQLException);
            System.err.println("Caught SQLException : " + sQLException);
            sQLException.printStackTrace();
            return;
        }
        catch (Exception exception) {
            this.setStatus("Couldn't load JDBC-ODBC bridge driver");
            System.err.println("Caught Exception : " + exception);
            exception.printStackTrace();
            return;
        }
    }

    public void getInfo(String string) {
        this.createInfoScreen(string);
        this.columnNames = new Vector();
        this.columnTypes = new Vector();
        try {
            int n = string.indexOf(46);
            String string2 = string.substring(0, n);
            String string3 = string.substring(n + 1, string.length());
            DatabaseMetaData databaseMetaData = this.con.getMetaData();
            ResultSet resultSet = databaseMetaData.getColumns(null, string2, string3, "%");
            while (resultSet.next()) {
                String string4;
                String string5 = resultSet.getString(4);
                this.columnNames.addElement(string5);
                short s = resultSet.getShort(5);
                short s2 = resultSet.getShort(7);
                short s3 = resultSet.getShort(9);
                switch (s) {
                    case -7: {
                        string4 = "BIT";
                        break;
                    }
                    case -6: {
                        string4 = "TINYINT";
                        break;
                    }
                    case 5: {
                        string4 = "SMALLINT";
                        break;
                    }
                    case 4: {
                        string4 = "INTEGER";
                        break;
                    }
                    case -5: {
                        string4 = "BIGINT";
                        break;
                    }
                    case 6: {
                        string4 = "FLOAT";
                        break;
                    }
                    case 8: {
                        string4 = "DOUBLE";
                        break;
                    }
                    case 7: {
                        string4 = "REAL";
                        break;
                    }
                    case 2: {
                        string4 = "NUMERIC(" + s2 + "," + s3 + ")";
                        break;
                    }
                    case 3: {
                        string4 = "DECIMAL(" + s2 + "," + s3 + ")";
                        break;
                    }
                    case 1: {
                        string4 = "CHAR(" + s2 + ")";
                        break;
                    }
                    case 12: {
                        string4 = "CHAR(" + s2 + ")";
                        break;
                    }
                    case -1: {
                        string4 = "LONGVARCHAR";
                        break;
                    }
                    case -2: {
                        string4 = "BINARY(" + s2 + ")";
                        break;
                    }
                    case -3: {
                        string4 = "VARBINARY(" + s2 + ")";
                        break;
                    }
                    case -4: {
                        string4 = "LONGVARBINARY";
                        break;
                    }
                    case 91: {
                        string4 = "DATE";
                        break;
                    }
                    case 92: {
                        string4 = "TIME";
                        break;
                    }
                    case 93: {
                        string4 = "TIMESTAMP";
                        break;
                    }
                    case 1111: {
                        string4 = "OTHER";
                        break;
                    }
                    default: {
                        string4 = "???";
                    }
                }
                this.columnTypes.addElement(string4);
            }
            resultSet.close();
            this.finishInfoScreen();
            return;
        }
        catch (SQLException sQLException) {
            this.setStatus(sQLException);
            return;
        }
    }

    synchronized void resetScreen() {
        this.removeAll();
        int n = this.getSize().width;
        int n2 = this.getSize().height;
        this.buttonOffset = 10;
        this.status = new Label("", 0);
        this.add(this.status);
        this.status.setBounds(15, n2 - 30, 2 * n, 25);
    }

    synchronized void addButton(Button button) {
        int n = this.getSize().height;
        this.add(button);
        button.setBounds(this.buttonOffset, n - 65, 80, 30);
        this.buttonOffset += 80;
    }

    synchronized void createStartupScreen() {
        this.resetScreen();
        int n = this.getSize().width;
        Label label = new Label("Welcome to the Select Customizer.", 1);
        this.add(label);
        label.setFont(new Font("Dialog", 0, 16));
        label.setBounds(10, 100, n - 20, 50);
        Label label2 = new Label("JDBC URL:", 2);
        this.add(label2);
        label2.setBounds(20, 250, 70, 30);
        this.urlField = new TextField(this.url, 40);
        this.urlField.addKeyListener(new UrlListener());
        this.add(this.urlField);
        this.urlField.setBounds(100, 250, 280, 30);
        Label label3 = new Label("User:", 2);
        this.add(label3);
        label3.setBounds(20, 300, 70, 30);
        this.userField = new TextField(this.user, 40);
        this.userField.addKeyListener(new UserListener());
        this.add(this.userField);
        this.userField.setBounds(100, 300, 280, 30);
        Label label4 = new Label("Password:", 2);
        this.add(label4);
        label4.setBounds(20, 350, 70, 30);
        this.passwordField = new TextField(this.password, 40);
        this.passwordField.setEchoChar('*');
        this.passwordField.addKeyListener(new PasswordListener());
        this.add(this.passwordField);
        this.passwordField.setBounds(100, 350, 280, 30);
        this.setStatus("Enter login info and push \"user tables\" or \"all tables\"");
        Button button = new Button("User Tables");
        button.addActionListener(new UserTablesListener());
        this.addButton(button);
        Button button2 = new Button("All Tables");
        button2.addActionListener(new AllTablesListener());
        this.addButton(button2);
    }

    synchronized void createTableScreen() {
        this.resetScreen();
        int n = this.getSize().width;
        int n2 = this.getSize().height;
        String string = "Database \"" + this.url + "\" has " + this.tableNames.size() + " tables.";
        Label label = new Label(string, 0);
        this.add(label);
        label.setBounds(30, 10, n - 20, 25);
        Button button = new Button("Back");
        button.addActionListener(new BackToStartListener());
        this.addButton(button);
        this.tableList = new List();
        this.tableList.addItemListener(new TableListener());
        this.add(this.tableList);
        int n3 = 0;
        while (n3 < this.tableNames.size()) {
            String string2 = (String)this.tableNames.elementAt(n3);
            this.tableList.addItem(string2);
            ++n3;
        }
        this.tableList.setBounds(30, 40, 240, n2 - 110);
        this.setStatus("Please chose a table");
    }

    synchronized void createInfoScreen(String string) {
        this.resetScreen();
        int n = this.getSize().width;
        this.getSize();
        Label label = new Label("Database:  " + this.url, 0);
        this.add(label);
        label.setBounds(30, 35, n - 40, 20);
        Label label2 = new Label("Table:    " + string, 0);
        this.add(label2);
        label2.setBounds(30, 55, n - 20, 20);
        Button button = new Button("Back");
        button.addActionListener(new BackToTableListener());
        this.addButton(button);
        this.setStatus("Loading table info...");
    }

    synchronized void finishInfoScreen() {
        int n = this.getSize().width;
        int n2 = this.getSize().height;
        Label label = new Label("Number of columns:  " + this.columnNames.size(), 0);
        this.add(label);
        label.setBounds(30, 75, n - 20, 20);
        this.columnList = new List();
        this.columnList.setFont(new Font("Courier", 0, 12));
        this.columnList.setMultipleMode(true);
        this.columnList.addItemListener(new ColumnListener());
        this.add(this.columnList);
        int n3 = 0;
        while (n3 < this.columnNames.size()) {
            String string = (String)this.columnNames.elementAt(n3);
            String string2 = (String)this.columnTypes.elementAt(n3);
            int n4 = 22 - string.length();
            String string3 = string;
            if (n4 > 0) {
                string3 = String.valueOf(string3) + this.spaces.substring(0, n4);
            }
            string3 = String.valueOf(string3) + string2;
            this.columnList.addItem(string3);
            ++n3;
        }
        this.columnList.setBounds(30, 120, 260, n2 - 200);
        this.setStatus("Choose the columns you want in the SQL SELECT.");
    }

    synchronized void setStatus(String string) {
        this.status.setText(string);
    }

    synchronized void setStatus(SQLException sQLException) {
        System.err.println("Caught " + sQLException);
        this.setStatus(String.valueOf(sQLException));
    }

    void updateSelect() {
        int n = this.columnList.getItemCount();
        String string = null;
        int n2 = 0;
        while (n2 < n) {
            if (this.columnList.isIndexSelected(n2)) {
                String string2 = (String)this.columnNames.elementAt(n2);
                string = string == null ? string2 : String.valueOf(string) + ", " + string2;
            }
            ++n2;
        }
        this.selectString = string == null ? "" : "SELECT " + string + " FROM " + this.tableName;
        System.err.println(this.selectString);
        this.target.setSQL(this.selectString);
        this.support.firePropertyChange("SQL", null, this.selectString);
        this.target.update();
    }

    static void println(String string) {
        System.out.println(string);
    }

    static void print(String string) {
        System.out.print(string);
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.support.addPropertyChangeListener(propertyChangeListener);
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.support.removePropertyChangeListener(propertyChangeListener);
    }

    class WorkerThread
    extends Thread {
        public void run() {
            SelectCustomizer.this.doWork();
        }

        WorkerThread() {
            SelectCustomizer.this = SelectCustomizer.this;
        }
    }

    class UrlListener
    extends KeyAdapter {
        public void keyReleased(KeyEvent keyEvent) {
            SelectCustomizer.this.url = SelectCustomizer.this.urlField.getText();
            SelectCustomizer.this.target.setURL(SelectCustomizer.this.url);
            SelectCustomizer.this.support.firePropertyChange("URL", null, SelectCustomizer.this.url);
        }

        UrlListener() {
            SelectCustomizer.this = SelectCustomizer.this;
        }
    }

    class UserListener
    extends KeyAdapter {
        public void keyReleased(KeyEvent keyEvent) {
            SelectCustomizer.this.user = SelectCustomizer.this.userField.getText();
            SelectCustomizer.this.target.setUser(SelectCustomizer.this.user);
            SelectCustomizer.this.support.firePropertyChange("user", null, SelectCustomizer.this.user);
        }

        UserListener() {
            SelectCustomizer.this = SelectCustomizer.this;
        }
    }

    class PasswordListener
    extends KeyAdapter {
        public void keyReleased(KeyEvent keyEvent) {
            SelectCustomizer.this.password = SelectCustomizer.this.passwordField.getText();
            SelectCustomizer.this.target.setPassword(SelectCustomizer.this.password);
            SelectCustomizer.this.support.firePropertyChange("password", null, SelectCustomizer.this.password);
        }

        PasswordListener() {
            SelectCustomizer.this = SelectCustomizer.this;
        }
    }

    class ColumnListener
    implements ItemListener {
        public void itemStateChanged(ItemEvent itemEvent) {
            SelectCustomizer.this.updateSelect();
        }

        ColumnListener() {
            SelectCustomizer.this = SelectCustomizer.this;
        }
    }

    class TableListener
    implements ItemListener {
        public void itemStateChanged(ItemEvent itemEvent) {
            SelectCustomizer.this.tableName = SelectCustomizer.this.tableList.getSelectedItem();
            SelectCustomizer.this.setWork(3);
        }

        TableListener() {
            SelectCustomizer.this = SelectCustomizer.this;
        }
    }

    class UserTablesListener
    implements ActionListener {
        public void actionPerformed(ActionEvent actionEvent) {
            SelectCustomizer.this.setWork(1);
        }

        UserTablesListener() {
            SelectCustomizer.this = SelectCustomizer.this;
        }
    }

    class AllTablesListener
    implements ActionListener {
        public void actionPerformed(ActionEvent actionEvent) {
            SelectCustomizer.this.setWork(2);
        }

        AllTablesListener() {
            SelectCustomizer.this = SelectCustomizer.this;
        }
    }

    class BackToStartListener
    implements ActionListener {
        public void actionPerformed(ActionEvent actionEvent) {
            SelectCustomizer.this.createStartupScreen();
        }

        BackToStartListener() {
            SelectCustomizer.this = SelectCustomizer.this;
        }
    }

    class BackToTableListener
    implements ActionListener {
        public void actionPerformed(ActionEvent actionEvent) {
            SelectCustomizer.this.createTableScreen();
        }

        BackToTableListener() {
            SelectCustomizer.this = SelectCustomizer.this;
        }
    }
}

