// This is a configuration file for named (from BIND 8.1 or later).
// It would normally be installed as c:\mptn\etc\named.conf.

options {
	directory "c:\mptn\etc\namedb";
	check-names master warn;        /* default. */
	datasize 16M;
	deallocate-on-exit yes;
	listen-on { 127.0.0.1; 11.11.11.11; };
};

logging {
	channel default_syslog {
		syslog daemon;
		severity info;
	};

	channel xfer-log {
		file "c:\mptn\etc\namedb\bind-xfer.log" versions unlimited size 10m;
		print-category yes;
		print-severity yes;
		print-time yes;
		severity info;
	};

	channel load-log {
		file "c:\mptn\etc\namedb\bind-load.log" versions 1 size 10m;
		print-category yes;
		print-severity yes;
		print-time yes;
		severity info;
	};

	category xfer-in { xfer-log; };
	category xfer-out { xfer-log; };
	category default { default_syslog; };
	category load { load-log; };
};

/* The next two entries will catch some bogus request made by stupid resolvers */

zone "0.in-addr.arpa" IN {
    type master;
    file "bogus.mzone";
};

zone "255.in-addr.arpa" IN {
    type master;
    file "bogus.mzone";
};

zone "0.0.127.in-addr.arpa" IN {
    type master;
    file "0.0.127.in-addr.arpa.mzone";
};

zone "localhost" IN {
    type master;
    file "localhost.mzone";
};

zone "." IN {
    type hint;
    file "root.hint";
};

