Program Yep;
{$M 32762}
{&Delphi-}
{$R-}
{$DEFINE ZEBUG}

Uses Dos, tm_dos, tm_str, strings, tm_strgs, crt, tm_exit, pomu, dtu, tm_Date;

Type
    MsgHeaders = (hd_ng, hd_to, hd_date, hd_subj, hd_xg, hd_refs, hd_from, hd_repto, hd_sender, hd_cc, hd_bcc, hd_nil);

Const
     MaxStr  = 50000;
     MaxPath = 80;
     MaxLine = 80;
     cmtChar = ';';
     MaxHead = 50;
     MaxSubst= 100;
     MaxXUrl = 20;
     MaxPrem = 25;
     MaxBlocks = 15;
     nntp_strlen = 512; {defined in uqwk and rfc}

     StartLineMode : byte = 0;   {0=line 1, 1=past header, 2=past quote}
     CursorAdjust  : integer = 0;

     processfiles  : string[128] = '*.snd\*.msg\message$.r*\*.pop'; {pattern of filenames to process}

     HeadNum  : byte = 0;
     PremNum  : byte = 0;
     StartLine: byte = 1;
     SubNum   : byte = 0;
     BlockNum : byte = 0;
     RepTags = (4)-1;
     RepTag  : array[0..RepTags] of Pchar = (
                                    '{RNDN:',
                                    '{YPDEC:',
                                    '{DATE:',
                                    '{RNDC:'
                                    );
     YepTags = (23)-1;
     YepTag  : array[0..YepTags] of Pchar = (
                                    '{$cx:',
                                    '{RNDL:',
                                    '{RNDF:',
                                    '{IMPF:',
                                    '{EXEC:',
                                    '{IFFLAG:',
                                    '{IMPL:',
                                    '{IFTO:',
                                    '{IFSUBJ:',
                                    '{IFDATE:',
                                    '{IFNG:',
                                    '{SETFLAG:',
                                    '{IMPLS:',
                                    '{IMPLR:',
                                    '{UUEN:',
                                    '{IFXN:',
                                    '{IFCC:',
                                    '{POM:',
                                    '{IFBCC:',
                                    '{EXPD:',
                                    '{HEADER:',
                                    '{IFRT:',
                                    '{IFSD:');

(*     SpecialTags = 1;                               { 1        2        3        4   }
     SpecialTag  : array[1..SpecialTags] of Pchar = ('{moond}');*)

     XUrlNum  : byte = 0;
     YepUrls = 4;
     YepUrl  : array[1..YepUrls] of Pchar = ('HTTP://','FTP://','TELNET://','GOPHER://');

     BlockTags = 5;
     BlockTag : array [1..BlockTags, 1..2] of pchar = (('[HEADE', '[END HE'),
                                                       ('[SUBST', '[END SU'),
                                                       ('[URL E', '[END UR'),
                                                       ('[PRE M', '[END PR'),
                                                       ('[BLOCK', '[END BL'));
     CfgTags = 12;
     CfgTag  : array [1..CfgTags] of pchar = ('EDITOR', 'CLEANHE', 'ROOTSIG',
                     'PGPPAS','SHOWDOT','CURSORA','URLLOG','EMACSH','PREMESS',
                     'QUOTEC','RIGHTM','PROCES');

     RightMargin : byte = 0;
     QuoteChar : char = '>';
     EmacsHeaderLine : pchar = nil;
     BlockEnd : pchar = '[TheEnd]';

     fnEdit  : string[maxPath] = '';
     fnTmp   : string[maxPath] = '';
     fnUrlLog: string[maxPath] = '';
     Fnpgp   : string[maxPath+30] = '';
     fnCfg   : string[maxPath] = 'yep.cfg';
     EdCmdLn : string = '';
     RootSig : string[maxPath] = '';
     ShowDots: boolean = True;
     PgpPassword : pchar = nil;
     pgpPassStr : pchar = 'PGPPASS=';

     GLOBALFLAG : boolean = FALSE;

     TogSubst: boolean = true;
     TogAutoDePgp : boolean = false;
     CleanHeader : boolean = False;
     PostPrem : boolean = False;

     LastHeader : MsgHeaders = hd_nil;
     FstHdr = hd_ng;
     LstHdr = hd_Bcc;
     MsgHdr : array[fsthdr..lsthdr,1..2] of pchar = (
                                        {1} ('Newsgroups:',nil),
                                        {2} ('To:',nil),
                                        {3} ('Date:',nil),
                                        {4} ('Subject:',nil),
                                        {5} ('X-NewsGroups:',nil),
                                        {6} ('References:',nil),
                                        {7} ('From:',nil),
                                        {8} ('Reply-To:',nil),
                                        {9} ('Sender:',nil),
                                       {10} ('Cc:',nil),
                                       {11} ('Bcc:',nil)
                                        );


     y_pac = 'Press any key';

     tmpNamePrefix : boolean = false; { prefix temp file instead of change extention? }
     tmpPrefix = 'Y!';
     tmpExt = 'Yep';

(*
{1}  Hd_NewsGroups : Pchar = nil;
{2}  Hd_To : Pchar = nil;
{3}  Hd_Date : Pchar = nil;
{4}  Hd_Subject : Pchar = nil;
{5}  Hd_x_group : Pchar = nil;
{6}  Hd_Refs : Pchar = nil;

     str_NewsGroups : Pchar = 'Newsgroups:';
     str_X_Group : Pchar = 'X-Newsgroups:';
     str_To : Pchar = 'To:';
     str_Date : Pchar = 'Date:';
     str_Subject : Pchar = 'Subject:';
     str_Refs : Pchar = 'References:';
*)

type
     tHeadAdd = array[1..maxHead] of Pchar;
     tYepTarg = array[1..maxSubst] of Pchar;
     tYepSub  = array[1..maxSubst] of Pchar;
     tXUrlList= array[1..maxXUrl] of Pchar;
     tPreM    = array[1..maxPrem] of Pchar;
     tBlkTag  = array[1..maxBlocks] of Pchar;
     tBlkCmd  = array[1..maxBlocks] of Pchar;
     tBlkclose= array[1..maxBlocks] of char;

     sarray = array[0..25] of char;

Var
{   f : text;
   fout: text;
   faux: text;}
   fbuf : array[1..6144] of byte;

   HeadAdd : theadadd;
   YepTarg : tyeptarg;
   YepSub  : tyepsub;
   XUrlList: txurllist;
   Prem    : tPrem;
   BlkTag  : tBlkTag;
   BlkCmd  : tBlkCmd;
   Blkclose: tBlkClose;
   UrlCap  : pchar;

   st   : array[0..MaxStr] of char;
   hr   : MsgHeaders;

(***********************************************************************)
(***********************************************************************)
Procedure WriteConfigFileValues;
var x : byte;
begin
     writeln(EdCmdLn);
     Writeln('cleanheader=',CleanHeader);
     Writeln('startlinemode=',StartLineMode);
     Writeln('showdots=',StartLineMode);
     Writeln('rightMargin=',RightMargin);
     Writeln('quotechar=',QuoteChar);
     if HeadNum>0 then begin
        writeln('-----------headers-------------');
        for x:=1 to HeadNum do Writeln(HeadAdd[x]);
     end;
     if SubNum>0 then begin
        writeln('--- ------substitutes----------');
        for x:=1 to SubNum do Writeln(YepTarg[x],' <> ',YepSub[x]);
     end;
     if PremNum>0 then begin
        writeln('---=------pre message----------');
        for x:=1 to PremNum do Writeln(Prem[x]);
     end;
     if BlockNum>0 then begin
        writeln('---+------Block Defs----------');
        for x:=1 to BlockNum do Writeln(blkTag[x],blkclose[x],'  ',blkCmd[x]);
     end;
     if XurlNum>0 then begin
        writeln('----- ----Url Excludes----------');
        for x:=1 to XurlNum do Writeln(XurlList[x]);
        if fnUrlLog[0]<>#0 then writeln('Enabled: ',fnUrlLog) else writeln('DISABLED.');
     end;
end;

Procedure WriteMessageData;
begin
     writeln;
     for hr := fstHdr to lsthdr do if MsgHdr[hr,2]<>nil then writeln(MsgHdr[hr,1],MsgHdr[hr,2]);
     delay(750);

{     writeln(MsgHdr[hd_to,1],MsgHdr[hd_to,2]);
     writeln(MsgHdr[hd_Subj,1],MsgHdr[hd_Subj,2]);
     writeln(MsgHdr[hd_date,1],MsgHdr[hd_date,2]);
     writeln(MsgHdr[hd_ng,1],MsgHdr[hd_ng,2]);}
end;


(***********************************************************************)
(***********************************************************************)
function b_or_e(s,c:string) : boolean; {simplified wildcard... begin or end with *}
begin
     b_or_e :=false;
     if c[1]='*' then begin
        if length(c)=1 then b_or_e:=true
        else
        b_or_e:=(upstr(copy(c,2,255))=upstr(copy(s,length(s)-(length(c)-2),length(c)-1)));
     end
     else if c[length(c)]='*' then begin
        b_or_e:=(upstr(copy(c,1,length(c)-1))=upstr(copy(s,1,length(c)-1)));
     end
     else begin
        b_or_e:=(upstr(c)=upstr(s));
     end;
end;
{----------------------------------------------------------------------}

Function YepSubstOut(var f: text; s : pchar; cr : boolean) : boolean; forward;

Function SplitTheDamnQuotes(s: pchar; var ns1,ns2 : pchar) : boolean;
var
   ps : pchar;
   sc : pchar;
begin
     ErrorID := 'split quotes';
     ns2:=nil; sc:=nil;
     SplitTheDamnQuotes:=false;
     ps:=StrNew(Strquoted(s,'"','"'));
     if ps<>nil then sc:=StrPos(ps,'"::"');
     if sc<>nil then begin
        sc^:=#0;
        ns1:=StrNew(ps);
        ns2:=StrNew(sc+4);
        StrDispose(ps);
        ps:=Nil;
        SplitTheDamnQuotes:=true;
     end else ns1:=ps;
end;

Procedure WriteDot(c : integer);
var x : byte;
begin
     if showdots then begin
        if (c>=0) then TextColor(c);
        write('.');
        if (c>=0) then textcolor(lightgray);
     end;
end;

procedure StrDJoinC(var original : pchar; add : pchar; joint : char);
var
   pc : pchar;
   tc : pchar;
begin
     ErrorID := 'StrDJoinC';
     getmem(pc,strLen(original)+strLen(add)+2);
     tc := strECopy(pc,original);
     tc^ := joint;
     inc(tc);
     StrCopy(tc,add);
     strDispose(original);
     Original:=nil;
     original := pc;
end;

Function IsAHeaderLine(s : pchar) : boolean;
var
   cp : pointer;
   sp : pointer;
begin
     IsAHeaderLine:=False;
     if s=nil then exit;
     cp := StrScan(s,':');
     if (cp<>nil)and(cp<>s) then begin
        sp := StrScan(s,' ');
        if (longint(sp)>Longint(cp))or(sp=nil) then IsAHeaderLine:=True;
     end;
end;


{-----8-8-8-8-8-8-8-8-8-8-8-8-8-8-8-8-8-8-8-8-8-8-8-8-8-8-8-8-8-8-8-8-----}
Function ReadCfg : boolean;
var
   someblock : byte; {1=header 2=subst}
   f : text;
   c : byte;
   ch: char;
   s : PCHAR;
   ptmp : pchar;
   stmp : string[4];
   i : longint;
begin
     ErrorID := 'read cfg';
     fnCfg:=GetEnv('HOME')+'\yarn\'+forceExt(fnOnly(paramstr(0)),'cfg');
     if not NameExist(fnCfg) then fnCfg:=forceExt(Paramstr(0),'cfg');
     ReadCfg:=False;  SomeBlock:=0; UrlCap:=nil;
     filemode:=fmReadOnly+fmDenyWrite;
     assign(f,fnCfg); SetTextBuf(f,fbuf, sizeof(fbuf));{$I-}Reset(f);{$I+}
     if ioresult=0 then begin
        while not Eof(f) do begin
              readln(f,st);
              S:=Ltrim(@st,' ');
              if (s^<>CmtChar)and(StrLen(s)>0) then begin
                 {if s[1]=' ' then s:=LTrim(s,' ');}
                    if someBlock=0 then begin
                       if StrIPos(s,BlockTag[1][1])=s then SomeBlock:=1
                       else if StrIPos(s,BlockTag[2][1])=s then SomeBlock:=2
                       else if StrIPos(s,BlockTag[3][1])=s then SomeBlock:=3
                       else if StrIPos(s,BlockTag[4][1])=s then SomeBlock:=4
                       else if StrIPos(s,BlockTag[5][1])=s then SomeBlock:=5
                       else if StrIPos(s,cfgTag[1])=s then begin
                            ptmp:=StrQuoted(s,'"','"');
                            if ptmp<>nil then EdCmdLn:=StrPas(ptmp);
                            StrDispose(ptmp);
                            if pos('$L',EdCmdLn)>2 then StartLineMode:=1
                            else if pos('$l',EdCmdLn)>2 then StartLineMode:=2;
                       end
                       else if StrIPos(s,cfgTag[2])=s then begin
                               ptmp:=Strquoted(s,'"','"');
                               CleanHeader:=upcase(ptmp^)='Y';
                               StrDispose(ptmp);
                            end
                       else if StrIPos(s,cfgTag[4])=s then begin
                               PgpPassword:=Strquoted(s,'"','"');
                               ptmp:=PgpPassword;
                               i:=0;
                               while Ptmp^<>#0 do begin
                                     if (ptmp^<'0')or(ptmp^>'9') then i := 1;
                                     inc(ptmp);
                               end;
                               if (i=0)and((StrLen(PgpPassword) mod 3)=0) then begin
                                  GetMem(ptmp,Length(Pdec(PgpPassword))+1);
                                  StrPCopy(Ptmp,Pdec(PgpPassword));
                                  StrDispose(PgpPassword);
                                  PgpPassword:=ptmp;
                               end;
                            end
                       else if StrIPos(s,cfgTag[8])=s then begin
                               EmacsHeaderLine:=Strquoted(s,'"','"');
                            end
                       else if StrIPos(s,cfgTag[9])=s then begin
                               ptmp:=Strquoted(s,'"','"');
                               PostPrem:=upcase(ptmp^)='Y';
                               StrDispose(ptmp);
                            end
                       else if StrIPos(s,cfgTag[6])=s then begin
                               ptmp:=Strquoted(s,'"','"');
                               val(ptmp,CursorAdjust,i);
                               if i<>0 then begin
                                  CursorAdjust:=0;
                                  write('bad CursorAdjust: ',ptmp);
                               end;
                               StrDispose(ptmp);
                            end
                       else if StrIPos(s,cfgTag[11])=s then begin
                               ptmp:=Strquoted(s,'"','"');
                               val(ptmp,RightMargin,i);
                               if i<>0 then begin
                                  RightMargin:=76;
                                  write('bad RightMargin: ',ptmp);
                               end;
                               StrDispose(ptmp);
                            end
                       else if StrIPos(s,cfgTag[10])=s then begin
                               ptmp:=Strquoted(s,'"','"');
                               if ptmp<>nil then QuoteChar:=ptmp^;
                               StrDispose(ptmp);
                            end
                       else if StrIPos(s,cfgTag[12])=s then begin
                               ptmp:=Strquoted(s,'"','"');
                               if ptmp<>nil then processfiles := atrim(strpas(ptmp),'\');
                               while (pos('\\',processfiles)>0) do system.delete(processfiles,pos('\\',processfiles),1);
                               strdispose(ptmp);
                            end
                       else if StrIPos(s,cfgTag[5])=s then begin
                               ptmp:=Strquoted(s,'"','"');
                               ShowDots:=upcase(ptmp^)<>'N';
                               StrDispose(ptmp);
                            end
                       else if StrIPos(s,cfgTag[7])=s then begin
                               ptmp:=Strquoted(s,'"','"');
                               if ptmp<>nil then fnUrlLog:=StrPas(ptmp);
                               StrDispose(ptmp);
                            end;
                    end else if someblock=1 then begin
                        if StrIPos(s,BlockTag[1][2])=s then SomeBlock:=0
                        else if HeadNum<maxHead then begin
                           if s^<>#0 then s:=@st;
                           inc(HeadNum);
                           HeadAdd[HeadNum]:=StrNew(s);
                        end;
                    end else if someblock=2 then begin
                        if StrIPos(s,BlockTag[2][2])=s then SomeBlock:=0
                        else if SubNum<maxSubst then begin
                              inc(SubNum);
                              SplitTheDamnQuotes(s,YepTarg[SubNum],Yepsub[SubNum]);
                        end;
                    end else if someblock=3 then begin
                        if StrIPos(s,BlockTag[3][2])=s then SomeBlock:=0
                        else if XurlNum<maxXUrl then begin
                           inc(XUrlNum);
                           XUrlList[XurlNum]:=StrNew(s);
                        end;
                    end else if someblock=4 then begin
                        if StrIPos(s,BlockTag[4][2])=s then SomeBlock:=0
                        else if PremNum<maxPrem then begin
                           inc(PremNum);
                           Prem[PremNum]:=StrNew(s);
                        end;
                    end else if someblock=5 then begin
                        if StrIPos(s,BlockTag[5][2])=s then SomeBlock:=0
                        else if BlockNum<maxBlocks then begin
                              inc(BlockNum);
                              SplitTheDamnQuotes(s,BlkTag[BlockNum],BlkCmd[blocknum]);
                              ptmp:=StrENd(BlkTag[BlockNum])-1;
                              blkClose[BlockNum]:=ptmp^;
                              ptmp^:=#0;
                        end;
                    end;
              end;
        end;
        close(f);
        ReadCfg:=True;
     end else begin
         Writeln('YEP Error: can not open cfg file (',fnCfg,')');
         delay(2000);
     end;
end;
{-------------------------------------------------------------------}

Procedure ImportLine(var fout : text; fn : pchar; lineNum : longint; start, count, widthout: longint;  align : byte);
{ linenum=linenumber, start=first column, count=max number of characters
  widthout=max width to output, align=(0=left,1=right,2=center) }
var LN  : longint;
    st : array[0..4096] of char;
    stmp : pchar;
    faux : text;
begin
     ErrorID := 'ImpL';
     stmp:=@st; st[0]:=#0;
     fileMode:=fmReadOnly+fmDenyWrite;
     Assign(faux,strPas(fn)); {$I-}Reset(faux); {$I+}
     if IoResult=0 then begin
        ln:=0;
        while (not eof(faux))and(ln<LineNum) do begin
              {$I-}Readln(faux,st);{$I+}
              if IoResult<>0 then begin
                 textColor(blue);
                 writeln;write('Error reading from "',fn,'". ',y_pac);
                 readkey;
              end;
              inc(ln);
        end;
        if not((eof(faux))and(ln<>LineNum)) then begin
           TextColor(green);
           while (Start>0)and(stmp^<>#0) do begin inc(stmp); dec(start); end;
           if count>0 then begin
              if Count<StrLen(stmp) then (stmp+count)^:=#0;
           end;
           YepSubstOut(fout,stmp,false);
        end else begin
            TextColor(blue);
            writeln; write('only ', ln,' lines in "',fn,'", can''t get line ',linenum,'. ',y_pac);
            readkey;
            end;
        close(faux);
     end
     else begin
          TextColor(blue);
          writeln; write('can''t read "',fn,'". ',y_pac);
          readkey;
     end;
     writeDot(-1);
end;

Procedure InsertRndLine(var fout: text; fn : pchar);
var LN  : longint;
    faux : text;
    padding : boolean;
begin
     padding:=false;
     ErrorID := 'ImpR';
     randomize;
     ln:=CountTextLines(faux,strPas(fn),';',nil,0);
     if Ln>0 then begin
        ImportLine(fout, fn,random(ln)+1,0,0,0,0);
     end
     else begin
          TextColor(blue);
          writeln; write('no lines/file "',fn,'". ',y_pac);
          readkey;
     end;
end;

Procedure ImportLR(var fout: text; s : pchar);
var ln,strt,cnt, i : longint;
    pc : pchar;
begin
     ln:=0; strt:=0; cnt:=0;
     pc:=s;
     while (pc^<>':')and(pc^<>'}')and(pc^<>#0) do inc(pc);
     if (pc^=':') then begin
        pc^:=#0; inc(pc);
        val(s,ln,i);
        if ln>0 then begin
           s:=pc;
           while (pc^<>':')and(pc^<>'}')and(pc^<>#0) do inc(pc);
           if (pc^=':') then begin
              pc^:=#0; inc(pc);
              val(s,strt,i);
              if strt>0 then begin
                 s:=pc;
                 while (pc^<>':')and(pc^<>'}')and(pc^<>#0) do inc(pc);
                 if (pc^=':') then begin
                    pc^:=#0; inc(pc);
                    val(s,cnt,i);
                 end;
              end;
           end;
        end;
     end;
     if (ln>0) and (strt>0) and (cnt>0) and (pc^<>#0) then
        importline(fout, pc,ln,strt,cnt,0,0)
     else begin
          textcolor(blue);
          writeln;write('syntax error with {IMPLR:',pc,'}. ',y_pac);
          readkey;
     end;
end;

Procedure ImportaFile(var fout : text; fn : pchar);
var
    st : array[0..4096] of char;
    stmp : pchar;
    faux : text;
begin
     ErrorID := 'ImpF';
     stmp:=@st; st[0]:=#0;
     fileMode:=fmReadOnly+fmDenyWrite;
     Assign(faux,fn); {$I-}Reset(faux);{$I+}
     if IoResult=0 then begin
        TextColor(brown);
        while not(eof(faux)) do begin
              readln(faux,st);
              if Eof(faux) then YepSubstOut(fout,stmp,false)
              else YepSubstOut(fout,stmp,true);
        end;
        close(faux);
     end
     else begin
          writeln;
          TextColor(yellow);
          writeln; write('can''t open "',fn,'". ',y_pac);
          readkey;
     end;
     writeDot(-1);
end;

Procedure ImportRFile(var fout : text; fl : pchar);
var
   w : word;
   st : string[3];
   fn : string;
   faux: text;
begin
     ErrorID := 'RndF';
     fn:=StrPas(fl);
     {writeln('*',fn,'*');}
     randomize;
     w:=ioresult;
     w:=0;
     while (W<1000) do begin
           inc(w);
           str(w,st);
           assign(faux,fn+'.'+st); {$I-}reset(faux);{$I+}
           if IoResult>0 then break;
           {$I-}close(faux);{$I+}
     end;
     if w>1 then begin
        w:=succ(random(pred(w)));
        str(w,st);
        fn:=Fn+'.'+st;
        ImportAFile(fout, Str2Pchar(fn));
     end
     else begin
          writeln;
          write('no "',fl,'.*" files to pick from. ',y_pac);
          readkey;
     end;
end;

Procedure ImportSline(var fout : text; fn, SS :pchar; Col1Only : boolean);
var found : boolean;
    st : array[0..4096] of char;
    stmp : pchar;
    faux: text;
begin
     ErrorID := 'ImpSL';
     stmp:=@st; st[0]:=#0; Found:=False;
     fileMode:=fmReadOnly+fmDenyNone;
     Assign(faux,strPas(fn)); {$I-}Reset(faux); {$I+}
     if IoResult=0 then begin
        while (not eof(faux))and(found=False) do begin
              Readln(faux,st);
              if Col1Only then begin
                 if StrIPos(stmp,ss)=stmp then Found := TRUE;
              end else begin
                  if StrIPos(stmp,ss)<>nil then Found := TRUE;
              end;
        end;
        close(faux);
        if Found=True then begin
           TextColor(green);
           YepSubstOut(fout,stmp,false);
        end else TextColor(lightblue);
     end
     else begin
          TextColor(blue);
          writeln; write('can''t read "',fn,'". . ',y_pac);
          readkey;
     end;
     writeDot(-1);
end;

Procedure WriteExpireDate(var f : text; l : longint);
var
   s : string[80];
   y,m,d, dow : longint;
   x  : longint;
begin
     if (l<1) then exit;
     if (l>1000) then l := 1000;
     GetDate(y,m,d,dow);
     while l>0 do begin
           dec(l);
           inc(d);
           inc(dow); if dow>6 then dow:=0;
           if d>DaysInMonth(m,y) then begin inc(m); d:=1; end;
           if m>MonthsInYear then begin inc(y); m:=1; end;
    end;
    Write(f, copy(dayStr[dow],1,3),', ',LeadZero(d,2),' ',
             copy(MonthStr[m],1,3),' ',y);
    s:=strpas(msghdr[hd_Date,2]);
    if s[17]=' ' then write(f,copy(s,17,255)) else write(f,copy(s,16,255));

end;

Procedure ExecFile(s : pchar);
var
   cmd  : pchar;
   isCmd: boolean;
begin
     ErrorID := 'execf';
     ErrorDetail := StrPas(s);
     cmd:=StrScan(s,' ');
     if cmd=nil then begin
        isCmd:=False;
        cmd:=s+strLen(s);
     end else begin
         IsCmd:=True;
         cmd^:=#0;
     end;
     if (NameExist(StrPas(s)))and((upcase((cmd-3)^)='E')
                              and(upcase((cmd-2)^)='X')
                              and(upcase((cmd-1)^)='E')) then begin
        WriteDot(Darkgray);
        if IsCmd then inc(cmd);
        swapvectors;
        Exec(StrPas(s),StrPas(cmd));
        swapvectors;
     end else begin
         writedot(lightgray);
         if IsCMD then cmd^:=' ';
         swapvectors;
         Exec(getenv('COMSPEC'),'/C '+StrPas(s));
         swapvectors;
     end;
end;
{----------------------------------------------------------------------}
Function RNDN(s : pchar) : string;
var
   l,h:string[16];
   lw,hw: word;
   x : word;
   i : Longint;
begin
     rndn:='';
     s:=ltrim(s,' ');
     while StrPos(s,':')<>nil do StrPos(s,':')^:='-';
     l:=StrPas(s);
     x:=system.pos('-',l);
     if x=0 then begin
        h:=l;
        l:='1';
     end else begin
         h:=copy(l,x+1,255);
         l:=copy(l,1,x-1);
     end;
     val(l,lw,i);
     val(h,hw,i);
     if hw<lw then begin
        x:=hw;
        hw:=lw;
        lw:=x;
     end;
     if lw<0 then lw:=0;
     if hw<0 then hw:=0;
     if hw=lw then RNDN:=Long2Str(hw)
     else begin
          x:=random(hw-lw+1);
          RNDN:=Long2Str(x+lw)
     end;
end;
{----------------------------------------------------------------------}
{----------------------------------------------------------------------}
Function YepSubstOut(var f: text; s : pchar; cr : boolean) : boolean; {true if cr/lf written}
var
   c : char;
   r : longint;
   l : longint;
   b : byte;
   pc: pchar;
   StartOfLine : pchar;
   SearchString  : pchar;
   OutputLine : boolean;
   FoundTag : pchar;
   FoundTagNum : integer;
   stmp : pchar;
   stmp2: string;


Procedure FindTag(var FT : pchar; var FTN : integer; var YTg : array of Pchar; NTgs : byte);
var b : byte;
begin
           FT:=nil; FTN:=-1; stmp:=nil;
           for b:=0 to NTgs do begin
               stmp:=StrIPos(s,YTg[b]);
               if (stmp<>nil) then begin
                  if (FT=nil) then begin
                      FT:=stmp;
                      FTN:=b;
                  end
                  else begin
                       if (longint(stmp)<longint(FT)) then begin
                          FT:=stmp;
                          FTN:=b;
                       end;
                  end;
               end;
           end;
end;

begin
     ErrorID := 'sub scan';
     if s=nil then exit;
     startofline:=s; OutputLine:=TRUE;
     for b:=1 to SubNum do begin
         pc:=StrIPos(s,yeptarg[b]);
         if pc<>nil then begin
(*{}            writeln('');
{}            writeln('before:"',s,'"');
{}            writeln('before:"',yeptarg[b],'" at column ',StrIPosC(s,yeptarg[b]),' to "',yepsub[b],'"');*)
              StrSubststr(s,yeptarg[b],YepSub[b],MaxStr,false);
(*{}            writeln('after: "',s,'"');*)
            writeDot(lightgreen);
            s:=pc+strLen(yepsub[b]);
            b:=0;
         end;
     end;

     s := StartOfLine;
     ErrorID := 'sub special';
     if StrScan(s,'{')<>nil then begin

        repeat {substituion type tags}
              FindTag(FoundTag,FoundTagNum,RepTag,RepTags);

              if (FoundTag<>nil) then begin
                 pc:=FoundTag+StrLen(YepTag[FoundTagNum]);
                 stmp:=pc;
                 b:=1;
                 while (b>0)and(s^<>#0) do begin     {look for end of tag}
                    if stmp^='{' then inc(b);
                    if stmp^='}' then dec(b);
                    inc(stmp);
                 end;
                 if (stmp^<>#0)or((b=0)and((stmp-1)^='}')) then begin    {if we didn't run to the end}
                    (stmp-1)^:=#0;            (* put a #0 in place of '}' *)
                 end;

                 ErrorDetail := StrPas(YepTag[FoundTagNum])+StrPas(pc)+'}';
                 {$IFDEF DBUG}writeln(errorDetail);{$ENDIF}
                 case FoundTagNum of
                   0 : begin
                            writedot(lightmagenta);
                            stmp2:=RNDN(pc);
                            b:=StrLen(RepTag[FoundTagNum])+StrLen(pc)+1;
                            (stmp-1)^:='}';
                            strDelete(s,Longint(FoundTag-s)+1,b);
                            StrLInsert(s,Str2Pchar(Stmp2),Longint(FoundTag-s)+1,sizeof(st)-1);
                       end;
                   1 : begin  {YDec}
                             Stmp2:=PDec(pc);
                             b:=StrLen(RepTag[FoundTagNum])+StrLen(pc)+1;
                             (stmp-1)^:='}';
                             strDelete(s,Longint(FoundTag-s)+1,b);
                             StrLInsert(s,Str2Pchar(Stmp2),Longint(FoundTag-s)+1,sizeof(st)-1);
                        end;
                   2 : begin
                            stmp2:=dtString(StrPas(pc));
                            b:=StrLen(RepTag[FoundTagNum])+StrLen(pc)+1;
                            (stmp-1)^:='}';
                            strDelete(s,Longint(FoundTag-s)+1,b);
                            StrLInsert(s,Str2Pchar(Stmp2),Longint(FoundTag-s)+1,sizeof(st)-1);
                        end;
                   3 : begin
                            writedot(magenta);
                            if PC<>nil then stmp2:=(pc+random(StrLen(pc)))^ else Stmp2:=' ';
                            b:=StrLen(RepTag[FoundTagNum])+StrLen(pc)+1;
                            (stmp-1)^:='}';
                            strDelete(s,Longint(FoundTag-s)+1,b);
                            StrLInsert(s,Str2Pchar(Stmp2),Longint(FoundTag-s)+1,sizeof(st)-1);
                       end;
                 end;
              end;
        until (FoundTag=nil);

        ErrorID := 'sub tag';
        repeat {regular tags}
           FindTag(FoundTag,FoundTagNum,YepTag,YepTags);

           if (FoundTag<>nil) then begin
              if (FoundTag<>s) then begin
                 FoundTag^:=#0;
                 Write(f,s);
              end;                                  {test:something}
              s:=FoundTag+StrLen(YepTag[FoundTagNum]);
              pc:=s;
              b:=1;
              while (b>0)and(s^<>#0) do begin     {look for end of tag}
                    if s^='{' then inc(b);
                    if s^='}' then dec(b);
                    inc(s);
              end;
              if (s^<>#0)or((b=0)and((s-1)^='}')) then begin    {if we didn't run to the end}
                 (s-1)^:=#0;            (* put a #0 in place of '}' *)
              end;

              ErrorDetail := StrPas(YepTag[FoundTagNum])+StrPas(pc)+'}';
              {$IFDEF DBUG}writeln(errorDetail);{$ENDIF}
              case FoundTagNum of
                   0 : begin
                            writedot(lightmagenta);
                            Write(f,RNDN(pc));
                       end;
                   1 : InsertRndLine(f, pc);
                   2 : ImportRFile(f,pc);
                   3 : ImportaFile(f,pc);
                   4 : ExecFile(pc);
                   5 : begin  {ifflag}
                            if (pc^='F')or(pc^='f')or(pc^='N')or(pc^='n')or(pc^='0') then
                               OutputLine:=(GlobalFlag=FALSE)
                            else OutputLine:=(GlobalFlag=TRUE);
                            if OutputLine=False then s^:=#0;
                            If (OutputLine=False)and(FoundTag<>StartOfLine) then OutputLine:=TRUE;
                            if OutputLine=TRue then StartOfLine:=s;
{                            if (pc^='T')or(pc^='t')or(pc^='y')or(pc^='Y') then
                               OutputLine:=(GlobalFlag=TRUE)
                            else OutputLine:=(GlobalFlag=FALSE);
                            if OutputLine=False then s^:=#0;
                            If (OutputLine=False)and(FoundTag<>StartOfLine) then OutputLine:=TRUE;
                            if OutputLine=TRue then StartOfLine:=s;}
                       end;
                   6 : begin  {impL}
                             SearchString:=pc;
                             while (pc^<>':')and(pc^<>'}')and(pc^<>#0) do inc(pc);
                             if (pc^=':') then begin
                                 pc^:=#0; inc(pc);
                                 val(SearchString,l,r);
                                 ImportLine(f,pc,l,0,0,0,0);
                             end else begin
                                textcolor(blue);
                                write('syntax error with {IMPL:',searchstring,'}. ',y_pac);
                                readkey;
                             end;
                       end;
                   7..10,15-16,18,21..22 : begin  {ifs}
                               SearchString:=nil;
                               case FoundTagNum of
                                    7 : SearchString:=msgHdr[hd_to,2];
                                    8 : SearchString:=msgHdr[hd_subj,2];
                                    9 : SearchString:=msgHdr[hd_date,2];
                                    10: SearchString:=msgHdr[hd_ng,2];
                                    15: SearchString:=msgHdr[hd_xg,2];
                                    16: SearchString:=msgHdr[hd_cc,2];
                                    18: SearchString:=msgHdr[hd_bcc,2];
                                    21: SearchString:=msgHdr[hd_repto,2];
                                    22: SearchString:=msgHdr[hd_Sender,2];
                               end;
                               OutputLine:=StrIPos(searchstring,pc)<>nil;
                               if (OutputLine=true) then GLobalFlag:=true;
                               if OutputLine=False then s^:=#0;
                               if (OutputLine=False)and(FoundTag<>StartOfLine) then OutputLine:=TRUE;
                          end;
                   11: begin  {setflag}
                            if (pc^='F')or(pc^='f')or(pc^='N')or(pc^='n')or(pc^='0') then GlobalFlag:=false
                            else GlobalFlag:=true;
                            if s^=#0 then OutputLine:=False
                            else StartOfLine:=s;
                       end;
                   12 : begin  {impLS}
                             SplitTheDamnQuotes(pc,SearchString,pc);
                             if (SearchString<>nil)and(pc<>nil) then ImportSline(f,pc, SearchString, TRUE)
                             else begin
                                  textColor(blue);
                                  writeln;writeln('Incorrect syntax in an ImpLS tag. ',y_pac);
                                  readkey;
                             end;
                             StrDispose(SearchString); SearchString:=nil;
                             StrDispose(pc); pc := nil;
                       end;
                   13 : begin  {impLR}
                             ImportLR(f,pc);
                       end;
                   14 : begin  {uuen}
                             textColor(brown);
                             write('!');
                             pc:=Ltrim(pc,' ');
                             if UUinsert(strPas(pc),f)>0 then begin
                                writeln(f,'{uuen:',pc,'}');
                                writeln; write('uuencoding "',pc,'" error. ',y_pac);
                                readkey;
                             end;
                             OutputLine:=False;
                        end;
(*                   16 : begin  {YDec}
                             Write(f,PDec(pc));
                             writedot(lightmagenta);
                        end;         *)
                   17 : begin
                             val(pc,l,r);
                             write(f,'The Moon is ',MoonIs);
                             if MoonShape<>'' then write(f,' ',MoonShape,' (',MoonReal:0:l,'% of Full).');
                        end;
{                   18 : begin
                             write(f,dtString(StrPas(pc)));
                        end;}
                   19 : begin  {expr:}
                               if msgHdr[hd_Date,2]<>nil then begin
                                  val(pc,l,r);
                                  WriteExpireDate(f, l);
                               end;
                        end;
                   20 : begin
                             write('-',pc,'-');
                             for hr := fsthdr to lsthdr do begin
                                 if strIPos(msghdr[hr,1],pc)=msghdr[hr,1] then begin
                                    write(f,msghdr[hr,2]);
                                    break;
                                 end;
                             end;
                        end;
              end;
           end;
        until (FoundTag=nil)or(s^=#0);
     end;
     write(f,s);
     YepSubstOut:=TRUE;
     if (cr)and(Outputline) then Writeln(f,'') else YepSubstOut:=FALSE;
     ErrorDetail := '';
end;

{----------------------------------------------------------------------}
{----------------------------------------------------------------------}

Function BlankHeader(s : pchar) : Boolean;
var b,e: pchar;
begin
     ErrorID := 'blank header';
     BLankHeader:=FALSE;
     b:=StrScan(s,':');
     if B<>nil then begin
        repeat
              inc(b);
        until (b^=#0)or(b^<>' ');
        if b^=#0 then BlankHeader:=TRUE;
     end;
end;

Procedure RipUrls(s : pchar);
const
     badC = ' "<>),'#0#09;
var
   StartUrl : pchar;
   EndUrl : pchar;
   sp     : pchar;
   tc     : char;
   x,y    : byte;
   isXurl : boolean;
begin
     ErrorID := 'rip urls';
     sp:=s;
     for x:=1 to YepUrls do begin
         StartUrl:=StrIPos(sp,YepUrl[x]);
         while (StartUrl<>nil) do begin
               EndUrl:=StartUrl;
               while (pos(EndUrl^,badc)=0) do inc(EndUrl);
               if (EndUrl-1)^='.' then Dec(EndUrl);     {urls won't end in periods}
               tc:=EndUrl^; EndUrl^:=#0; y:=1;  IsXurl := false;
               while (y<=XurlNum)and(isXurl=FALSE) do begin
                   { writeln(' [ ',XurlList[y],'  -->  ',StartUrl,' ] '); }
                   if StrIPosC(StartUrl,XurlList[y])>0 then begin
                      isXurl:=True
                   end
                   else inc(y);
               end;
               if not(isXurl) then begin
                  TextColor(lightblue); write('u');
                  if UrlCap=nil then UrlCap:=StrNew(StartUrl)
                  else begin  {append url to dynaimc string}
                        StrDJoinC(UrlCap,StartUrl,#13);
                  end;
               end;
               if XurlNum<MaxXurl then begin
                  inc(XurlNum);
                  XurlList[XurlNum]:=StrNew(StartUrl);
               end;
               EndUrl^:=tc;
               sp:=StartUrl+4;
               StartUrl:=StrIPos(sp,YepUrl[x]);
         end;
      end;
end;

Procedure ExpellUrls;
var
    ep : pchar;
    sp: pchar;
    cp: pchar;
    Uend: pchar;
    openok : boolean;
    tc : char;
    faux:text;
begin
     ErrorID := 'expell urls';
     if (UrlCap=nil) then exit;
     filemode := fmWriteOnly + fmDenyWrite; OpenOk := TRUE;
     assign(faux,fnUrlLog); {$I-}append(faux);{$I+}
     if ioResult <> 0 then begin
        {$I-}rewrite(faux);{$I+}
        if IoResult <> 0 then OpenOk:=False;
     end;

     if openOk then begin
        sp := UrlCap;
        ep := sp;
        while (ep^<>#0) do begin
              ep := sp;
              while (ep^<>#13)and(ep^<>#0) do inc(ep);
              writeln(faux,'Comment: ');
              if msgHdr[hd_to,2]<>nil then writeln(faux,msgHdr[hd_to,1],' ',msgHdr[hd_to,2]);
              if msgHdr[hd_ng,2]<>nil then writeln(faux,msgHdr[hd_ng,1],' ',msgHdr[hd_ng,2]);
              if msgHdr[hd_xg,2]<>nil then writeln(faux,msgHdr[hd_ng,1],' ',msgHdr[hd_xg,2]);
              if msgHdr[hd_subj,2]<>nil then writeln(faux,msgHdr[hd_subj,1],' ',msgHdr[hd_subj,2]);
              tc := ep^; ep^:=#0;
              writeln(faux,'URL: ',sp);
              ep^:=tc;
              writeln(faux,'');
              if ep^<>#0 then sp:=ep+1;
              textcolor(green); write('u');
        end;
        close(faux);
    end else begin
        textColor(blue);
        writeln; writeln('can''t write to Url Log "',fnUrlLog,'". ',y_pac);
        textColor(lightgray);
        readkey;
    end;
    StrDispose(UrlCap); urlcap:=nil;
    ErrorDetail:='';
end;

Function PreEditor : boolean;
var line : byte;
    x    : byte;
    fs   : pchar;
    Needhead: boolean;
    InHeader: boolean;
    DoOut: boolean;
    PreMWritten : boolean;
    f    : text;
    fout : text;
    s    : pchar;
    len  : longint;
    c    : char;
    sp   : char;
begin
     ErrorID := 'pre editor'; PremWritten:=false;
     PreEditor:=True; NeedHead:=true; line:=1; DoOut:=True; InHeader:=TRUE;
     filemode:=fmReadOnly+fmDenyWrite;
     assign(f,fnEdit); SetTextBuf(f,fbuf, sizeof(fbuf)); {$I+}Reset(f);{$I-}
     if ioresult=0 then begin
     filemode:=fmWriteOnly+fmDenyWrite;
     assign(fout,fnTmp); {$I+}Rewrite(fout);{$I-}
     if IoResult=0 then begin
        while (not eof(f)) do begin
              s:=@st;
              ReadLn(f,st);
              len:=StrLen(s);
              if (fnUrlLog[0]<>#0)and(s^<>#0)and(StrScan(s,'/')<>nil) then RipUrls(s);
              if (StartLineMode=2)and(InHeader=False)and(startline=1)then
                 if (len=0) then StartLine:=line+CursorAdjust;
{              if (NeedHead=True)and(HeadNum>0) then begin
              end;}
              if (InHeader=True) then begin
                 if (NeedHead=TRUE) then begin { check for custom header there }
                    for x:=1 to HeadNum do begin
                        if HeadAdd[x]<>nil then begin
                           if headadd[x]^<>' ' then fs:=StrScan(headAdd[x],' ')
                              else fs:=strENd(HeadAdd[x]);
                           if fs<>nil then begin
                              if StrLComp(HeadAdd[x],s,longint(fs)-Longint(HeadAdd[x]))=0 then NeedHead:=False;
                           end;
                        end;
                     end;
                 end;
                 if (CleanHeader) then begin
                    if (BlankHeader(s)) then DoOut:=False;
                 end;

                 if (s^=' ')and(LastHeader<>hd_nil) then StrAppend(MsgHdr[LastHeader,2],s)
                 else
                 for hr:=fsthdr to lstHdr do begin
                     if StrIPos(s,MsgHdr[hr,1])=s then begin
                        if msgHdr[hr,2]<>nil then StrDispose(msgHdr[hr,2]);
                        msgHdr[hr,2]:=StrNew(s+strlen(msgHdr[hr,1])+1);
                        LastHeader := hr;
                        break;
                     end
                 end;


(*
                 if StrPos(s,msgHdr[hd_subj,1])=s then begin
                    if msgHdr[hd_subj,2]<>nil then StrDispose(msgHdr[hd_subj,2]);
                    msgHdr[hd_subj,2]:=StrNew(s+strlen(msgHdr[hd_subj,1])+1);
                 end else
                 if StrPos(s,msgHdr[hd_to,1])=s then begin
                    if msgHdr[hd_to,2]<>nil then StrDispose(msgHdr[hd_to,2]);
                    hd_To:=StrNew(s+strlen(msgHdr[hd_to,1])+1);
                 end else
                 if StrPos(s,str_date)=s then begin
                    if hd_Date<>nil then StrDispose(hd_Date);
                    hd_Date:=StrNew(s+strlen(str_date)+1);
                 end else
                 if StrPos(s,str_x_group)=s then begin
                    if hd_x_group<>nil then StrDispose(hd_x_group);
                    hd_x_group:=StrNew(s+strlen(str_x_group)+1);
                 end else
                 if StrPos(s,str_newsgroups)=s then begin
                    if hd_NewsGroups<>nil then StrDispose(hd_NewsGroups);
                    hd_newsgroups:=StrNew(s+strlen(str_newsgroups)+1);
                 end;
              *)
              end;

              if (InHeader=True)and(len=0) then begin
                 if Needhead=True then begin
                    for x:=1 to HeadNum do begin
                        if HeadAdd[x]<>nil then begin
                           strCopy(s,HeadAdd[x]);
                           if YepSubstOut(fout,s,true) then begin
                              Inc(Line);
                              writeDot(lightblue);
                           end;
                        end;
                    end;
                    s^:=#0;
                 end;
                 if StartLineMode=1 then StartLine:=succ(line)+CursorAdjust;
                 InHeader:=FALSE;
                 if EmacsHeaderLine<>nil then s:=EmacsHeaderLine;
{write('--');}
                 if PremNum>0 then begin
                    Writeln(fout,s);
                    for x:=1 to PremNum do begin
                        NeedHead:=YepSubstOut(fout,Prem[x],true);
                        if (PremWritten=False) and (NeedHead) then begin
                           PremWritten:=TRUE;
                        end;
                        if NeedHead then Inc(Startline);
                    end;
                    if (premWritten and PostPrem) then begin
                       s^:=#0;
                       inc(StartLine);
                    end else DoOUt:=False;
                 end;
              end;
              if DoOut then begin
                 if (s^=quotechar) then begin
                    inc(s);                           { 1   5   }
                    if (RightMargin>0) then begin     { 1234567 }
                          while (StrLen(S)>(RightMargin-1)) do begin
                                fs:=s+RightMargin;
                                while (fs<>s) and (fs^<>' ') do dec(fs);
                                if (s<>fs) then begin
                                   fs^:=#0;
                                   writeln(fout,quotechar,s);
                                   s:=fs+1;
                                end else break;
                          end;
                    end;
                    {if s^<>#0 then} Writeln(fout,quotechar,s);
                 end
                 else if YepSubstOut(fout,s,true) then inc(Line);
              end else begin
                  DoOut:=TRUE;
              end;
        end;
        close(fout); Close(f);
        if UrlCap<>nil then ExpellUrls;
     end
     else begin
          writeln(' Error: can not open file to write: ',FnTmp,'. ',y_pac);
          readkey;
     end;
     end else writeln(': new message?');
end;

Function CallEditor( fn : string) : byte;
var s : string[6];
begin
     ErrorID := 'call editor';
     str(StartLine,s);
     EdCmdLn:=Subststr(EdCmdLn,'$L',s,false);
     EdCmdLn:=Subststr(EdCmdLn,'$F',fn,false);
     {$IFDEF DEBUG}writeln('<',EdCmdLn,'>');{$ENDIF}
     ExecFile(Str2Pchar(EdCmdLn));
     callEditor:=DosError;
end;

Function PostEditor(FnOut : PathStr; BlkType : byte; already: boolean; var f : text) : boolean;
var
    line: word;
    s :  pchar;
    ec:  pchar;
    arg: pchar;
    fout : text;
    {f    : text;}
    fAlt : text;
    x : byte;
    c : char;
    fnNew: string[12];
    writeout : boolean;
    es : longint;

begin
     ErrorID := 'post editor';
     if BlkType>0 then Errordetail := 'new block '+StrPas(BlkTag[BlkType])+BlkClose[BlkType];
     s:=@st; writeout:=true;
     PostEditor:=True; Line:=0;
     if ALready=False then begin
        filemode:=fmReadOnly+fmDenyWrite;
        assign(f,fnTmp); {$I-}Reset(f);{$I+}
     end;
     if ioresult=0 then begin
     filemode:=fmWriteOnly+fmDenyWrite;
     assign(fout,fnOut); {$I-}Rewrite(fout);{$I+}
     if IoResult=0 then begin
        while (not eof(f)) do begin
              s:=@st; s^:=#0;
              inc(line);
              ReadLn(f,st);

              {emacs header}
              if (EmacsHeaderLine<>nil)and(s^=EmacsHeaderLine^) then
                 if StrComp(s,EmacsHeaderLine)=0 then begin
                    s^:=#0;
                    EmacsHeaderLine^:=#255
                 end;

              for x := 1 to BlockNum do begin
                  if StrIPos(s,BlkTag[x])=s then begin {is block mark}
{write(BlkTag[x],'=',line);}
                     arg:=s+(StrLen(blktag[x]));
{writeln(arg^);}
                     if (arg^=' ') then begin  {is followed by space get args}
                        inc(arg);
                        ec:=arg;
                        while (ec^<>blkClose[x])and(ec^<>#0) do inc(ec);
                        if ec^=#0 then continue; {no close so forget it}
                        ec^:=#0;
                        Arg:=StrNew(Arg);
                        ec^:=blkClose[x];
                     end else
                     if arg^=BlkClose[x] then arg:=nil else continue;

                     {Continue output to new file}
                     ErrorDetail := 'Outputting Block';
                     fnNew := RndFilename('ywk', 20);
                     repeat fnOut := RndFilename('ywk', 20) until fnOut<>fnNew;

                     writeout:=PostEditor(fnNew,x,true,f);   {loop}

                     {execute block process}
                     EdCmdLn:=StrPas(BlkCMD[x]);
                     if StrIpos(blkCmd[x],'*i')<>nil then EdCmdLn:=Subststr(EdCmdLn,'*I',fnNew,false);
                     if StrIpos(blkCmd[x],'*o')<>nil then EdCmdLn:=Subststr(EdCmdLn,'*O',fnOut,false);
                     if StrIpos(blkCmd[x],'*p')<>nil then EdCmdLn:=Subststr(EdCmdLn,'*P',StrPas(arg),false);
                     StrDispose(arg);
{$IFDEF DEBUG}writeln('EXECUTING: ',EdCmdLn);{$ENDIF}
                     if PgpPassword<>nil then begin
                        ec:=Environment;
                        es:=EnvSize;
                        GetMem(Environment,ES+StrLen(PgpPassStr)+StrLen(PgpPassword)+1);
                        StrCopy(Environment,PgpPassStr);
                        StrCat(Environment,PgpPassWord);
                        arg:=StrEnd(Environment);
                        inc(arg);
                        StrMove(arg,ec,ES);
                     end;
{                     writeln('Pas: ',PgpPassword);
                     writeln('ENV: ',getEnv('PGPPASS'));}
{-exec-------------} ExecFile(Str2Pchar(EdCmdLn));
                     if PgpPassword<>nil then begin
                        FreeMem(Environment,ES+StrLen(PgpPassStr)+StrLen(PgpPassword)+1);
                        Environment:=ec;
                     end;
                     if ((DosError=0)and(DosExitCode=0)) then begin
                        assign(fAlt, FnOut);
                        writeln('importing... ',fnOut);
                     end
                     else begin
                          assign(fAlt, FnNew);
                          Writeln('**ERROR** processing block: re-importing unprocessed '+fnNew);
                     end;

                     {append back to old file}
                     ErrorDetail := 'Reading Processed Block ';
                     filemode := fmReadWrite+fmDenyNone;
                     {$I-}reset(fAlt);{$I+}
                     if IoResult=0 then begin
                        if not eof(falt) then readln(falt,st);
                        while not eof(fAlt) do begin
                              writeln(fout,st);
                              readln(falt,st);
                        end;
                        close(Falt);
                        assign(fAlt, FnOut);
                        {$I-}Erase(Falt);{$I+}
                        es := ioresult;
                        assign(fAlt, FnNew);
                        {$I-}Erase(Falt);{$I+}
                        es := ioresult;
                     end else begin
                         StrCopy(s,'**ERROR** importing processed file');
                         writeln('**ERROR** importing processed file');
                     end;
                     s:=@st;
                     Break;
                  end;
              end;

              {look for close}
              if (BlkType>0)
                 and(s^<>#0)
                 and(s^=blkTag[BlkType]^) then begin
                 blockEnd^:= blkTag[BlkType]^;
                 (strEnd(BlockEnd)-1)^:= blkClose[BlkType];
                 for x := 1 to BlockNum do begin
                     if StrIPos(s,BlockEnd)=s then begin
                        close(fout);
                        exit;
                     end;
                 end;
              end;

              c := #0;
              repeat
                    if msgHdr[hd_ng,2]<>nil then begin
                       if (c<>#0)or(isAheaderLine(s)) then begin
                          if c<>#0 then begin
                             arg^:=c;
                             s:=arg-1;
                             s^:=' ';
                             c:=#0;
                          end;
                          if StrLen(s)>NNTP_STRLEN then begin
                             arg:=s+NNTP_STRLEN;
                             while (arg^<>'<')and(arg^<>',')and(arg<>s) do dec(arg);
                             if (arg<>s) then begin
                                c:=arg^;
                                arg^:=#0;
                             end else c:=#0;
                          end else c:=#0;
                       end;
                    end;
                    if (s^=quotechar) then writeln(fout,s)                          {if quote don't interpret}
                    else YepSubstOut(fout,s,true);
              until c=#0;

        end;
        if blkType>0 then begin
           close(fout);
           exit;
        end;
        close(fout); Close(f);
     end
     else begin
          writeln('Yep Error: can not open file to write: ',FnOut,'. ',y_pac);
          readkey;
     end;
     end
     else writeln('*block read error*',FnTmp);
     ErrorDetail := '';
end;

function isSnd : boolean;
var
   x : byte;
   s : string;
   c : string[15];
   m : string[15];
begin
     isSnd:=false;
     x:=1;
     while x<=length(processfiles) do begin
           m:=copy(processfiles,x,255);
           while(pos('\',m)>0) do system.delete(m,pos('\',m),sizeof(m));
           if b_or_e(fnEdit,m) then begin
              if m[length(m)]='*' then tmpnameprefix:=true;
              isSnd:=true;
              exit;
           end;
           x:=x+length(m)+1;
     end;
end;

function PrefixFilename(f,p : string) : string;
var
   x : byte;
begin
     PrefixFilename:='';
     x := pos('.',f);
     if (x<length(p)) then begin
        if x<>0 then PrefixFilename:=p+copy(f,x,255)
        else PrefixFilename:=p;
     end
     else begin
          for x:=1 to length(p) do f[x]:=p[x];
          PreFixFilename:=f;
     end;
end;

var
    x : byte;
{    isSnd : boolean;}
    FiOut : text;
BEGIN
     ProgID := 'Yarn Editor Processor [version 1.6]';
     ErrorID := 'start up';
{     assign(output,''); rewrite(output);}
     Randomize;
     TextColor(lightred);
     if ShowDots then Write('Yep');
     TextColor(red);
     {$IFDEF DEBUG}write('Debug'); checkbreak:=true;{$ENDIF}
     TextColor(lightgray);
     if (paramcount=0)or(CmdLineTog('?')) then begin
        Writeln('.... ',ProgID);
        writeln('usage: YEP <filename>.snd');
        TextColor(darkgray);
        writeln('by: Tim Middleton (as544@torfree.net)');
        halt(1);
     end;
     if not(showdots) then Writeln;
     if ReadCfg then begin
        fnEdit:=cmdLineNoTogStr(1);
        if (isSnd)and(tmpnameprefix=false) then fnTmp:=ForceExt(fnEdit,tmpext)
        else fnTmp:=PreFixFilename(fnEdit,tmpprefix);
        if isSND then PreEditor;
        if isSND then CallEditor(fnTmp) else begin
           if showdots then begin
              textcolor(darkgray);
              write('x');
           end;
           CallEditor(fnEdit);
        end;
        if isSND then Posteditor(fnEdit,0,false,fiOut);
        {$IFDEF DBUG}writeMessageData;writeConfigFileValues;{$ENDIF}
     end;
     ErrorID := 'clean up';
     for hr:=fsthdr to lsthdr do if MsgHdr[hr,2]<>nil then StrDispose(MsgHdr[hr,2]);
     if EmacsHeaderLine<>nil then StrDispose(EmacsHeaderLIne);
     if PgpPassword<>nil then StrDispose(PgpPassword);
     For x:=1 to HeadNum do StrDispose(HeadAdd[x]);
     For x:=1 to SubNum do StrDispose(YepTarg[x]);
     For x:=1 to SubNum do StrDispose(YepSub[x]);
     For x:=1 to XurlNum do StrDispose(XUrlList[x]);
     For x:=1 to PremNum do StrDispose(Prem[x]);
     For x:=1 to BlockNum do begin
         if x>blockNum then break;
         if blkTag[x]=nil then continue;
         StrEnd(BlkTag[x])^:=BlkClose[x];
         StrDispose(BlkTag[x]);
         StrDispose(BlkCmd[x]);
     end;

     if showdots then begin
        TextColor(lightred);
        Writeln('Yep');
        TextColor(lightgray);
     end;
        {$IFDEF DEBUG}
           delay(1000);
        {$ENDIF}
     Halt;
END.

{
  - YepSubst in added header line in Pre Editor.
  - CleanHeader = "Yes/NO"
  - if cfg file not found error message displayed
}

