!-------------------------------------------------------------------<Prolog>-
!   Name:       xilrwp.l
!   Title:      Dialog for xilrwp.c agent
!   Package:    Xitami
!
!   Written:    97/10/29   Robin P. Dunn   Total Control Software
!   Revised:    98/01/07
!
!   Notes:      Libero format FSM dialog for my Long Running Web Process
!               interface for plugging into the Xitami web server.  This
!               handles listening for and accepting connections from
!               an external LRWP process, (called a PEER), as well as
!               forwarding HTTP requests to the process and retrieving
!               the response.
!
!   Copyright:  Copyright (c) 1998 Total Control Software
!   License:    This is free software; you can redistribute it and/or modify
!               it under the terms of the SMT License Agreement as provided
!               in the file LICENSE.TXT.  This software is distributed in
!               the hope that it will be useful, but without any warranty.
!------------------------------------------------------------------</Prolog>-*/

-schema=smtschm.c
-idle
-nosort
-stats

!
!------------------------------------------------------------------------
! default state

After-Init:
    (--) Master                             -> Master-Input
          + Open-Master-Socket
          + Wait-For-Socket-Input
    (--) Peer                               -> Peer-Startup
          + Wait-For-Socket-Input
    (--) Router                             -> Wait-For-Router-Request
          + Setup-Router
!
!------------------------------------------------------------------------
! The listening socket

Master-Input:
    (--) Sock-Input-Ok                      -> Master-Input
          + Accept-Peer-Connection
          + Wait-For-Socket-Input
!
!------------------------------------------------------------------------
! Handles communications with the peer application

Peer-Startup:
    (--) Sock-Input-Ok                      -> Waiting-For-Request
          + Read-App-Name-And-Start-Router
          + Wait-For-Socket-Input
    (--) Sock-Closed                        ->
          + Terminate-The-Thread

Waiting-For-Request:
    (--) LRWP-Request                       -> Waiting-For-Peer-Response
          + Send-Request-Data-To-Peer
          + Wait-For-Socket-Input
    (--) Sock-Closed                        ->
          + Signal-Peer-Closed
          + Terminate-The-Thread
    (--) Sock-Error                         ->
          + Signal-Socket-Error
          + Signal-Peer-Closed
          + Terminate-The-Thread
    (--) Sock-Input-Ok                      ->
    ! While waiting on an INPUT and the peer closes the socket, we
    ! get a Sock-Input-Ok event instead of a Sock-Closed event...
          + Signal-Peer-Closed
          + Terminate-The-Thread
    (--) Startup-Error                      ->
          + Signal-startup-error
          + Terminate-The-Thread


Waiting-For-Peer-Response:
    (--) Sock-Input-Ok                      -> Wait-For-Peer-Data-Block
          + Read-Peer-Data-Size
          + Wait-For-Socket-Input
    (--) Sock-Write-Ok                      ->
          +
    (--) Sock-Closed                        ->
          + Send-Error-Reply
          + Signal-Peer-Closed
          + Terminate-The-Thread
    (--) Sock-Error                         ->
          + Send-Error-Reply
          + Signal-Socket-Error
          + Signal-Peer-Closed
          + Terminate-The-Thread

Wait-For-Peer-Data-Block:
    (--) Sock-Input-Ok                      -> Wait-For-Peer-Data-Block
          + Read-Peer-Data
          + Wait-For-Socket-Input
    (--) Finished                           -> Waiting-For-Request
          + Send-Peer-Data-To-Xitami
          + Cleanup-And-Inform-Router
          + Wait-For-Socket-Input
    (--) Sock-Closed                        ->
          + Send-Error-Reply
          + Signal-Peer-Closed
          + Terminate-The-Thread
    (--) Sock-Error                         ->
          + Send-Error-Reply
          + Signal-Socket-Error
          + Signal-Peer-Closed
          + Terminate-The-Thread
!
!------------------------------------------------------------------------
! The router thread

Wait-For-Router-Request:
    (--) WSX-Request                        -> Wait-For-Router-Request
          + Find-Available-Peer
    (--) Peer-Job-Completed                 -> Wait-For-Router-Request
          + Check-For-Saved-Requests
    (--) Peer-Closed                        -> Wait-For-Router-Request
          + Check-if-all-gone
!
!------------------------------------------------------------------------
! shared events

Defaults:
    (--) Exception                          ->
          + Terminate-The-Thread
    (--) Shutdown                           ->
          + Terminate-The-Thread
    (--) Fatal                              ->
          + Shutdown-The-Application
          + Terminate-The-Thread
    (--) Sock-Error                         ->
          + Signal-Socket-Error
          + Terminate-The-Thread

