/*  --------------------------- N O T I C E ------------------------------
    This file has been stripped of symbolic information in order to protect
    trade secrets and protected and/or confidential source code.  This file
    remains Copyright (c) 1997 iMatix and is subject to the following terms
    and conditions in addition to the license terms agreed-on between the
    user and iMatix:
    1.  All reverse-engineering, reconstruction, or partial reuse of this
        source code is forbidden.
    2.  Any modification of this source code will consitute a violation of
        the license and guarantee terms agreed between the user and iMatix.
    3.  Distribution of this source code is allowed only according to the
        terms of the respective product license agreement.
    ---------------------------------------------------------------------- */
#include "sfl.h"
#include "formio.h"
char
*form_strerror;
RANGE
range_all = { 0, -1 },
range_none = { -1, 0 };
static FORM_ITEM
*_2393;
static SYMTAB
*_2394;
static int
_2395;
enum {
_2396 = 1,
focus_field = 2,
_2397 = 3
};
static char
*_2398 = "<TABLE><TR><TD BGCOLOR=\"#FF0000\">&gt;",
*_2399 = "</TABLE>";
static FORM_ITEM *_2400 (FORM_DEFN *defn);
static char *_2401 (byte *_2402);
static void _2403 (VDESCR *buffer, byte *block, int field, int _2404);
static void _2405 (VDESCR *buffer, char *source, int size);
static void _2406 (VDESCR *buffer, char *source);
static void _2407 (VDESCR *buffer, char *format, ...);
static void _2408 (VDESCR *buffer, byte *block);
static void _2409 (VDESCR *buffer, byte *block);
static void _2410 (VDESCR *buffer, byte *block, int field, int _2404);
static void _2411 (VDESCR *buffer, byte *block, int field, int _2404);
static void _2412 (VDESCR *buffer, byte *block, int field, int _2404);
static void _2413 (VDESCR *buffer, byte *block, int field, int _2404);
static void _2414 (VDESCR *buffer, byte *block, int field, int _2404);
static void _2415 (VDESCR *buffer, byte *block, int field, int _2404);
static void _2416 (VDESCR *buffer, byte *block, int field, int _2404);
static void _2417 (VDESCR *buffer, byte *block, int field, int _2404);
static void _2418 (VDESCR *buffer, byte *block);
static void _2419 (VDESCR *buffer, char *value, int field, int _2404);
static void _2420 (byte *block, int field, int index, byte attr);
static Bool _2421 (int field);
static Bool _2422 (int field, int index);
static Bool _2423 (RANGE *range, int field);
static byte *_2424 (int field, int index);
static char *_2425 (int field, int index);
static char *_2426 (byte *block, int index);
static void _2427 (byte *block, int *flags, int *_2428, int *_2429,
int *width);
static int _2430 (byte *block, int field, int index, char *value);
static void _2431 (int field, int index);
static int _2432 (byte *block, int field, int index, char *value);
static int _2433 (byte *block, int field, int index, char *value);
static void _2434 (SYMTAB *symtab, byte *block);
static Bool _2435 (char *value);
static char *_2436 (int field, int index, int _2437, char _2438);
static char *_2439 (int field, int index, int _2437, char _2438);
static Bool _2440 (FORM_ITEM *form, byte *_2402,
int _2441, va_list _2442);
static Bool _2443 (FORM_ITEM *form, byte *_2402,
int _2441, va_list _2442);
static Bool _2444 (FORM_ITEM *form, byte *_2402,
int _2441, va_list _2442);
static Bool _2445 (FORM_ITEM *form, byte *_2402,
int _2441, va_list _2442);
static Bool _2446 (SYMBOL *symbol, ...);
static void _2447 (SYMTAB *symtab);
#define _2448(b) ((b) [0] << 8) + ((b) [1])
#define _2449(b) ((b) [2])
#define _2450(b) ((b) [3])
#define _2451(b) ((b) [4])
#define _2452(b) ((char *) ((b) + 3))
#define _2453(b) ((b) [3])
#define _2454(b) ((b) [4] << 8) + ((b) [5])
#define _2455(b) ((b) [6] << 8) + ((b) [7])
#define _2456(b) ((b) [3] << 8) + ((b) [4])
#define _2457(b) ((b) [5] << 8) + ((b) [6])
#define _2458(b) ((b) [3] << 8) + ((b) [4])
#define _2459(b) ((b) [5] << 8) + ((b) [6])
#define _2460(b) ((b) [3] << 8) + ((b) [4])
#define _2461(b) ((b) [5] << 8) + ((b) [6])
#define _2462(b) ((b) [7] << 8) + ((b) [8])
#define _2463(b) ((b) [3])
#define _2464(b) ((b) [4])
#define _2465(b) ((b) [5] << 8) + ((b) [6])
#define _2466(b) ((b) [7] << 8) + ((b) [8])
#define _2467(b) ((char *) ((b) + 9))
#define _2468(b) (_2467 (b) + strlen (_2467 (b)) + 1)
#define _2469(b) ((b) [3])
#define _2470(b) ((b) [4])
#define _2471(b) ((b) [5] << 8) + ((b) [6])
#define _2472(b) ((b) [7] << 8) + ((b) [8])
#define _2473(b) ((char *) ((b) + 9))
#define _2474(b) (_2473 (b) + strlen (_2473 (b)) + 1)
#define _2475(b) ((b) [3])
#define _2476(b) ((b) [4])
#define _2477(b) ((b) [5] << 8) + ((b) [6])
#define _2478(b) ((b) [7] << 8) + ((b) [8])
#define _2479(b) ((b) [9])
#define _2480(b) ((b) [10])
#define _2481(b) ((b) [11])
#define _2482(b) ((b) [12])
#define _2483(b) ((b) [13])
#define _2484(b) ((b) [14])
#define _2485(b) ((char *) ((b) + 15))
#define _2486(b) (_2485 (b) + strlen (_2485 (b)) + 1)
#define _2487(b) ((b) [3])
#define _2488(b) ((b) [4])
#define _2489(b) ((b) [5] << 8) + ((b) [6])
#define _2490(b) ((b) [7])
#define _2491(b) ((b) [8])
#define _2492(b) ((b) [9])
#define _2493(b) ((b) [10])
#define _2494(b) ((b) [11])
#define _2495(b) (char *) ((b) + 12)
#define _2496(b) (_2495 (b) + strlen (_2495 (b)) + 1)
#define _2497(b) (_2496 (b) + strlen (_2496 (b)) + 1)
#define _2498(b) ((b) [3])
#define _2499(b) ((b) [4])
#define _2500(b) ((b) [5])
#define _2501(b) ((b) [6])
#define _2502(b) ((b) [7] << 8) + ((b) [8])
#define _2503(b) ((char *) ((b) + 9))
#define _2504(b) (_2503 (b) + strlen (_2503 (b)) + 1)
#define _2505(b) ((b) [3])
#define _2506(b) ((b) [4])
#define _2507(b) ((char *) ((b) + 5))
#define _2508(b) (_2507 (b) + strlen (_2507 (b)) + 1)
#define _2509(b) (_2508 (b) + strlen (_2508 (b)) + 1)
#define _2510(b) (_2509 (b) + strlen (_2509 (b)) + 1)
#define _2511(b) ((b) [3])
#define _2512(b) ((b) [4])
#define _2513(b) ((b) [5])
#define _2514(b) ((b) [6])
#define _2515(b) ((char *) ((b) + 7))
#define _2516(b) (_2515 (b) + strlen (_2515 (b)) + 1)
#define _2517(b) (_2516 (b) + strlen (_2516 (b)) + 1)
#define _2518(b) (_2517 (b) + strlen (_2517 (b)) + 1)
#define _2519(b) ((b) [3])
#define _2520(b) ((b) [4])
#define _2521(b) ((b) [5])
#define _2522(b) ((b) [6])
#define _2523(b) ((char *) ((b) + 7))
#define _2524(b) (_2523 (b) + strlen (_2523 (b)) + 1)
#define _2525(b) (_2524 (b) + strlen (_2524 (b)) + 1)
#define _2526(b) ((b) [3] << 8) + ((b) [4])
#define _2527(b) ((b) [5])
#define _2528(b) ((char *) ((b) + 6))
#define _2529(b) ((b) [3])
#define _2530(b) ((b) [4] << 8) + ((b) [5])
#define _2531(b) ((b) [6] << 8) + ((b) [7])
#define _2532(b) ((b) [8])
#define _2533(b) ((b) [9] << 8) + ((b) [10])
#define _2534(b) ((b) [11] << 8) + ((b) [12])
#define _2535(b) ((char *) ((b) + 13))
#define _2536(b) (_2535 (b) + strlen (_2535 (b)) + 1)
#define _2537(t) ((t) == BLOCK_TEXTUAL || \
(t) == BLOCK_NUMERIC || \
(t) == BLOCK_DATE || \
(t) == BLOCK_TEXTBOX || \
(t) == BLOCK_BOOLEAN || \
(t) == BLOCK_SELECT || \
(t) == BLOCK_FILE || \
(t) == BLOCK_RADIO )
#define _2538(f) ((char *) _2393-> data + \
_2393-> defn-> fields [f].data)
#define _2539(f) (_2393-> defn-> blocks + \
_2393-> defn-> fields [f].block)
#define _2540(f) (_2393-> defn-> fields [f].max)
#define _2541(b) (_2393-> data + \
_2393-> defn-> fields_size + _2531 (b))
typedef struct {
char *input;
char *output;
int _2542;
int _2543;
} _2544;
static _2544 _2545 [] = {
{ "TEXT", "%s",                 0, 0},
{ "TEXT", "%s",                 1, 0},
{ "PASSWORD", "",               0, 0},
{  NULL,  "%s",                 0, 0},
{ "HIDDEN", "",                 0, 1},
{  NULL,  "",                   0, 1},
{  NULL, "%s",                  0, 0},
{  NULL, "<EM>%s</EM>",         0, 0},
{  NULL, "<STRONG>%s</STRONG>", 0, 0},
{  NULL, "<BIG>%s</BIG>",       0, 0},
{  NULL, "%s",                  0, 0}
};
FORM_ITEM *
form_init (
FORM_DEFN *defn,
Bool values)
{
FORM_ITEM
*form;
ASSERT (defn);
if ((form = _2400 (defn)) == NULL)
return (NULL);
if (values)
{
form-> language = FLANG_ENGLISH;
form-> date_order = DATE_ORDER_DMY;
form-> date_sep = '/';
form-> dec_point = '.';
form-> input_range = range_all;
form-> blank_range = range_none;
form-> JavaScript = 1;
form-> focus_field = 0;
form-> focus_index = 0;
form-> click_field = 0;
form-> click_index = 0;
form_use (form);
form_exec (form, _2440);
}
return (form);
}
static FORM_ITEM *
_2400 (
FORM_DEFN *defn)
{
FORM_ITEM
*form;
MEMTRN
*_2546;
ASSERT (defn);
_2546 = mem_new_trans ();
if ((form = mem_alloc (sizeof (FORM_ITEM))) == NULL)
return (NULL);
memset (form, 0, sizeof (FORM_ITEM));
form-> defn = defn;
form-> data_size = defn-> fields_size + defn-> action_count;
form-> data = mem_alloc (form-> data_size);
if (form-> data == NULL)
{
mem_rollback (_2546);
return (NULL);
}
memset (form-> data, 0, form-> data_size);
mem_commit (_2546);
return (form);
}
static Bool
_2440 (
FORM_ITEM *form,
byte *_2402,
int _2441,
va_list _2442)
{
byte
_2547,
_2548;
char
*_2549,
*_2550;
int
_2551;
if (_2537 (_2449 (_2402)))
{
_2547 = _2451 (_2402);
_2548 = _2450 (_2402);
_2550 = _2401 (_2402);
_2549 = _2538 (_2441);
for (_2551 = 0; _2551 < _2547; _2551++)
*_2549++ = _2548;
ASSERT (strlen (_2550) <= _2540 (_2441));
for (_2551 = 0; _2551 < _2547; _2551++)
{
strcpy ((char *) _2549, _2550);
_2549 += _2540 (_2441) + 1;
}
}
else
if (_2449 (_2402) == BLOCK_ACTION)
*_2541 (_2402) = _2532 (_2402);
return (TRUE);
}
static char *
_2401 (byte *_2402)
{
switch (_2449 (_2402))
{
case BLOCK_TEXTUAL: return (_2468 (_2402));
case BLOCK_FILE: return (_2474 (_2402));
case BLOCK_NUMERIC: return (_2486 (_2402));
case BLOCK_DATE: return (_2496 (_2402));
case BLOCK_TEXTBOX: return (_2504 (_2402));
case BLOCK_BOOLEAN: return (_2508 (_2402));
case BLOCK_SELECT: return (_2516 (_2402));
case BLOCK_RADIO: return (_2524 (_2402));
}
return (NULL);
}
void
form_term (
FORM_ITEM *form)
{
if (form)
{
if (form-> list_values)
sym_delete_table (form-> list_values);
mem_free (form-> data);
mem_free (form);
}
}
void
form_use (
FORM_ITEM *form)
{
ASSERT (form);
_2393 = form;
}
size_t
form_put (
FORM_ITEM *form,
VDESCR *buffer,
SYMTAB *symtab)
{
byte
*_2402,
_2552,
*_2553;
int
_2441,
_2554,
_2555,
_2556,
_2557,
_2558,
_2559;
ASSERT (form);
ASSERT (buffer);
ASSERT (symtab);
buffer-> cur_size = 0;
buffer-> data = buffer-> data;
form-> status = FSTATUS_OK;
_2441 = -1;
_2555 = 0;
_2554 = 0;
_2402 = form-> defn-> blocks;
_2393 = form;
_2394 = symtab;
_2395 = 0;
sym_assume_symbol (symtab, "_focus", "jsaction");
while (_2554 < form-> defn-> block_count)
{
_2552 = _2449 (_2402);
if (_2537 (_2552))
_2441++;
if (_2555 > 0)
_2555--;
else
if (_2552 == BLOCK_IF)
{
if (_2435 (_2425 (_2456 (_2402), 0)))
_2555 = _2457 (_2402);
}
else
if (_2552 == BLOCK_UNLESS)
{
if (!_2435 (_2425 (_2458 (_2402), 0)))
_2555 = _2459 (_2402);
}
else
if (_2552 == BLOCK_REPEAT)
{
_2556 = atoi (_2425 (_2460 (_2402), 0));
for (_2557 = 0; _2557 < _2556; _2557++)
{
_2558 = _2441;
_2553 = _2402;
for (_2559 = 0;
_2559 < _2461 (_2402);
_2559++)
{
_2553 += _2448 (_2553) + 2;
if (_2537 (_2449 (_2553)))
_2558++;
_2403 (buffer, _2553, _2558,
_2557);
}
}
_2555 = _2461 (_2402);
}
else
if (!_2421 (_2441))
_2403 (buffer, _2402, _2441, 0);
_2402 += _2448 (_2402) + 2;
_2554++;
}
form-> focus_field = 0;
form-> focus_index = 0;
if (buffer-> cur_size >= buffer-> max_size)
buffer-> cur_size = buffer-> max_size - 1;
buffer-> data [buffer-> cur_size] = '\0';
return (buffer-> cur_size);
}
static Bool
_2421 (int _2441)
{
return (_2423 (&_2393-> blank_range, _2441));
}
static Bool
_2423 (RANGE *range, int _2441)
{
if (range-> first == -1)
return (FALSE);
else
if (range-> last == -1)
return (TRUE);
else
return (range-> first <= _2441 &&
_2441 <= range-> last);
}
static void
_2403 (
VDESCR *stream,
byte *_2402,
int _2441,
int index)
{
switch (_2449 (_2402))
{
case BLOCK_PLAIN:
_2408 (stream, _2402);
break;
case BLOCK_COMPRESSED:
_2409 (stream, _2402);
break;
case BLOCK_TEXTUAL:
_2410 (stream, _2402, _2441, index);
break;
case BLOCK_FILE:
_2411 (stream, _2402, _2441, index);
break;
case BLOCK_NUMERIC:
_2412 (stream, _2402, _2441, index);
break;
case BLOCK_DATE:
_2413 (stream, _2402, _2441, index);
break;
case BLOCK_TEXTBOX:
_2414 (stream, _2402, _2441, index);
break;
case BLOCK_BOOLEAN:
_2415 (stream, _2402, _2441, index);
break;
case BLOCK_SELECT:
_2416 (stream, _2402, _2441, index);
break;
case BLOCK_RLABEL:
_2417 (stream, _2402, _2441, index);
break;
case BLOCK_ACTION:
_2418 (stream, _2402);
break;
}
}
static void
_2408 (VDESCR *stream, byte *_2402)
{
_2405 (stream, _2452 (_2402), _2448 (_2402) - 1);
_2406 (stream, "\n");
}
static void
_2405 (VDESCR *stream, char *source, int size)
{
static char
_2560 [FORMIO_SYMNAME_MAX + 1];
char
*_2561,
*_2562,
*_2563;
int
_2564;
while (size > 0 && (_2561 = memchr (source, '#', size)) != NULL)
{
if (_2561 > source)
{
_2405 (stream, source, (int) (_2561 - source));
size -= (int) (_2561 - source);
source = _2561;
}
_2562 = memchr (source, ')', size);
if (source [1] == '(' && _2562)
{
_2564 = (int) (_2562 - source - 2);
if (_2564 <= FORMIO_SYMNAME_MAX)
{
memcpy (_2560, source + 2, _2564);
_2560 [_2564] = '\0';
_2563 = sym_get_value (_2394, _2560, "(?)");
_2405 (stream, _2563, strlen (_2563));
}
else
_2405 (stream, source, (int) (_2562 - source) + 1);
size -= (int) (_2562 - source) + 1;
source = _2562 + 1;
}
else
{
if ((stream-> cur_size + 1) < stream-> max_size)
{
memcpy (stream-> data + stream-> cur_size, source, 1);
stream-> cur_size += 1;
}
size--;
source++;
}
}
if ((stream-> cur_size + size) < stream-> max_size)
{
memcpy (stream-> data + stream-> cur_size, source, size);
stream-> cur_size += size;
}
}
static void
_2406 (VDESCR *stream, char *source)
{
_2405 (stream, source, strlen (source));
}
static void
_2409 (VDESCR *stream, byte *_2402)
{
byte
*_2565;
word
block_size;
_2565 = _2454 (_2402) + _2393-> defn-> blocks;
if (_2453 (_2402) == COMPR_WHOLEDICT)
block_size = _2448 (_2565) - 1;
else
if (_2453 (_2402) == COMPR_PARTDICT)
block_size = _2455 (_2402);
else
abort ();
_2405 (stream, _2452 (_2565), block_size);
_2406 (stream, "\n");
}
static void
_2410 (VDESCR *stream, byte *_2402, int _2441, int index)
{
char
*value;
_2544
*_2566;
byte
attr;
value = _2425 (_2441, index);
attr = *_2424 (_2441, index);
_2566 = &_2545 [attr];
if (_2566-> input && _2422 (_2441, index))
{
_2420 (_2402, _2441, index, attr);
if (_2566-> _2542)
_2406 (stream, _2398);
_2407 (stream,
"<INPUT TYPE=%s NAME=%s SIZE=%d MAXLENGTH=%d VALUE=\"%s\">\n",
_2566-> input,
_2426 (_2402, index),
_2465 (_2402),
_2466 (_2402),
attr == FATTR_SECURE? "": value);
if (_2566-> _2542)
_2406 (stream, _2399);
}
else
if (attr == FATTR_OPTION)
_2419 (stream, value, _2441, index);
else
if (!_2566-> _2543)
_2407 (stream, _2566-> output, *value? value: "&nbsp;");
}
static void
_2420 (byte *block, int field, int index, byte attr)
{
char
*name;
if ((name = _2426 (block, index)) == NULL)
return;
if (attr == FATTR_ERROR
&& _2395 < _2397)
{
_2395 = _2397;
sym_assume_symbol (_2394, "_focus", name);
}
else
if (field == _2393-> focus_field
&& index == _2393-> focus_index
&& _2395 < focus_field)
{
_2395 = focus_field;
sym_assume_symbol (_2394, "_focus", name);
}
else
if (attr != FATTR_HIDDEN
&& _2395 < _2396)
{
_2395 = _2396;
sym_assume_symbol (_2394, "_focus", name);
}
}
static void
_2411 (VDESCR *stream, byte *_2402, int _2441, int index)
{
char
*_2567,
*value;
_2544
*_2566;
byte
attr;
value = _2425 (_2441, index);
attr = *_2424 (_2441, index);
_2566 = &_2545 [attr];
if (_2566-> input && _2422 (_2441, index))
{
_2420 (_2402, _2441, index, attr);
if (_2566-> _2542)
_2406 (stream, _2398);
_2407 (stream,
"<INPUT TYPE=FILE NAME=%s SIZE=%d MAXLENGTH=%d VALUE=\"%s\">\n",
_2426 (_2402, index),
_2465 (_2402),
_2466 (_2402),
attr == FATTR_SECURE? "": value);
if (_2566-> _2542)
_2406 (stream, _2399);
}
else
if (attr == FATTR_OPTION
|| attr == FATTR_LABEL
|| attr == FATTR_HILITE)
{
_2567 = strrchr (value, '/');
if (_2567 == NULL)
_2567 = strrchr (value, '\\');
if (_2567 == NULL)
_2567 = value;
else
_2567++;
_2407 (stream,
"<A HREF=\"%s\">%s</A>\n", value, _2567);
}
else
if (!_2566-> _2543)
_2407 (stream, _2566-> output, *value? value: "&nbsp;");
}
static Bool
_2422 (int _2441, int index)
{
if (*_2424 (_2441, index) == FATTR_HIDDEN
|| _2423 (&_2393-> input_range, _2441))
return (TRUE);
else
return (FALSE);
}
static char *
_2426 (byte *_2402, int index)
{
static
char _2568 [LINE_MAX + 8];
switch (_2449 (_2402))
{
case BLOCK_TEXTUAL:
strncpy (_2568, _2467 (_2402), LINE_MAX);
break;
case BLOCK_FILE:
strncpy (_2568, _2473 (_2402), LINE_MAX);
break;
case BLOCK_NUMERIC:
strncpy (_2568, _2485 (_2402), LINE_MAX);
break;
case BLOCK_DATE:
strncpy (_2568, _2495 (_2402), LINE_MAX);
break;
case BLOCK_TEXTBOX:
strncpy (_2568, _2503 (_2402), LINE_MAX);
break;
case BLOCK_BOOLEAN:
strncpy (_2568, _2507 (_2402), LINE_MAX);
break;
case BLOCK_SELECT:
strncpy (_2568, _2515 (_2402), LINE_MAX);
break;
case BLOCK_RADIO:
strncpy (_2568, _2523 (_2402), LINE_MAX);
break;
default:
return (NULL);
}
if (index)
sprintf (_2568 + strlen (_2568), "_%d", index);
return (_2568);
}
static void
_2419 (VDESCR *stream, char *value, int _2441, int index)
{
if (strnull (value))
value = "&lt;Empty&gt;";
if (_2393-> JavaScript)
_2407 (stream,
"<A HREF=\"javascript:submit('~C%d.%d')\">%s</A>\n",
_2441, index, value);
else
_2407 (stream,
"<A HREF=\"#(uri)&~C%d.%d=1\">%s</A>\n",
_2441, index, value);
}
static byte *
_2424 (int _2441, int index)
{
ASSERT (_2441 < _2393-> defn-> field_count);
return (_2393-> data +
_2393-> defn-> fields [_2441].data + index);
}
static char *
_2425 (int _2441, int index)
{
ASSERT (_2441 < _2393-> defn-> field_count);
ASSERT (index < _2451 (_2539 (_2441)));
return (_2538 (_2441)
+ _2451 (_2539 (_2441))
+ (_2540 (_2441) + 1) * index);
}
static Bool
_2435 (char *value)
{
while (*value == '0')
value++;
return (*value == '\0');
}
static void
_2407 (VDESCR *stream, char *format, ...)
{
static char
_2569 [LINE_MAX];
va_list
_2442;
va_start (_2442, format);
vsprintf (_2569, format, _2442);
va_end (_2442);
_2405 (stream, _2569, strlen (_2569));
}
static void
_2412 (VDESCR *stream, byte *_2402, int _2441, int index)
{
_2544
*_2566;
char
*value;
byte
attr;
int
_2570,
sign_format,
_2571,
_2572;
_2427 (
_2402,
&_2570,
&sign_format,
&_2571,
&_2572);
value = conv_number_str (
_2425 (_2441, index),
_2570,
_2393-> dec_point,
_2479 (_2402),
_2571,
_2572,
sign_format);
if (value == NULL)
value = conv_reason_text [conv_reason];
attr = *_2424 (_2441, index);
_2566 = &_2545 [attr];
if (_2566-> input && _2422 (_2441, index))
{
_2420 (_2402, _2441, index, attr);
if (_2566-> _2542)
_2406 (stream, _2398);
_2407 (stream,
"<INPUT TYPE=%s NAME=%s SIZE=%d MAXLENGTH=%d VALUE=\"%s\">\n",
_2566-> input,
_2426 (_2402, index),
_2477 (_2402),
_2478 (_2402),
attr == FATTR_SECURE? "": value);
if (_2566-> _2542)
_2406 (stream, _2399);
}
else
if (attr == FATTR_OPTION)
_2419 (stream, value, _2441, index);
else
if (!_2566-> _2543)
_2407 (stream, _2566-> output, *value? value: "&nbsp;");
}
static void
_2427 (byte *_2402, int *flags, int *_2428, int *_2429, int *width)
{
*flags = 0;
switch (_2480 (_2402))
{
case FSIGN_NONE:
*_2428 = 0;
break;
case FSIGN_POST:
*flags += FLAG_N_SIGNED;
*_2428 = SIGN_NEG_TRAIL;
break;
case FSIGN_PRE:
*flags += FLAG_N_SIGNED;
*_2428 = SIGN_NEG_LEAD;
break;
case FSIGN_POSTPLUS:
*flags += FLAG_N_SIGNED;
*_2428 = SIGN_ALL_TRAIL;
break;
case FSIGN_PREPLUS:
*flags += FLAG_N_SIGNED;
*_2428 = SIGN_ALL_LEAD;
break;
case FSIGN_FINANCIAL:
*flags += FLAG_N_SIGNED;
*_2428 = SIGN_FINANCIAL;
break;
}
switch (_2481 (_2402))
{
case FDECFMT_NONE:
*_2429 = 0;
break;
case FDECFMT_ALL:
*flags += FLAG_N_DECIMALS;
*_2429 = DECS_SHOW_ALL;
break;
case FDECFMT_DROP:
*flags += FLAG_N_DECIMALS;
*_2429 = DECS_DROP_ZEROS;
break;
}
switch (_2482 (_2402))
{
case FFILL_NONE:
*width = 0;
break;
case FFILL_SPACE:
*width = _2477 (_2402);
break;
case FFILL_ZERO:
*width = _2477 (_2402);
*flags += FLAG_N_ZERO_FILL;
break;
}
if (_2483 (_2402))
*flags += FLAG_N_ZERO_BLANK;
if (_2484 (_2402))
*flags += FLAG_N_THOUSANDS;
}
static void
_2413 (VDESCR *stream, byte *_2402, int _2441, int index)
{
char
*picture;
int
flags,
format;
long
_2573;
char
*value;
_2544
*_2566;
byte
attr;
_2573 = atol (_2425 (_2441, index));
picture = _2497 (_2402);
if (strused (picture))
value = conv_date_pict (_2573, picture);
else
{
if (_2490 (_2402) == FSHOW_YMD)
if (_2491 (_2402) == FFORMAT_COMPACT)
format = DATE_YMD_COMPACT;
else
if (_2491 (_2402) == FFORMAT_SLASH)
format = DATE_YMD_DELIM;
else
if (_2491 (_2402) == FFORMAT_SPACE)
format = DATE_YMD_SPACE;
else
if (_2491 (_2402) == FFORMAT_COMMA)
format = DATE_YMD_COMMA;
else
format = DATE_YMD_COMPACT;
else
if (_2490 (_2402) == FSHOW_YM)
if (_2491 (_2402) == FFORMAT_COMPACT)
format = DATE_YM_COMPACT;
else
if (_2491 (_2402) == FFORMAT_SLASH)
format = DATE_YM_DELIM;
else
if (_2491 (_2402) == FFORMAT_SPACE)
format = DATE_YM_SPACE;
else
format = DATE_YM_COMPACT;
else
if (_2490 (_2402) == FSHOW_MD)
if (_2491 (_2402) == FFORMAT_COMPACT)
format = DATE_MD_COMPACT;
else
if (_2491 (_2402) == FFORMAT_SLASH)
format = DATE_MD_DELIM;
else
if (_2491 (_2402) == FFORMAT_SPACE)
format = DATE_MD_SPACE;
else
format = DATE_MD_COMPACT;
else
format = DATE_YMD_COMPACT;
flags = 0;
if (_2492(_2402) == FYEAR_FULL)
flags += FLAG_D_CENTURY;
if (_2493 (_2402) == FMONTH_COUNTER)
flags += FLAG_D_MM_AS_M;
else
if (_2493 (_2402) == FMONTH_ALPHA)
flags += FLAG_D_MONTH_ABC;
else
if (_2493 (_2402) == FMONTH_UPPER)
flags += FLAG_D_UPPER;
if (_2494 (_2402) == FDAY_COUNTER)
flags += FLAG_D_DD_AS_D;
value = conv_date_str (_2573, flags, format,
_2393-> date_order,
_2393-> date_sep,
_2489 (_2402));
}
if (value == NULL)
value = conv_reason_text [conv_reason];
attr = *_2424 (_2441, index);
_2566 = &_2545 [attr];
if (_2566-> input && _2422 (_2441, index))
{
_2420 (_2402, _2441, index, attr);
if (_2566-> _2542)
_2406 (stream, _2398);
_2407 (stream,
"<INPUT TYPE=%s NAME=%s SIZE=%d MAXLENGTH=%d VALUE=\"%s\">\n",
_2566-> input,
_2426 (_2402, index),
_2489 (_2402),
_2489 (_2402),
attr == FATTR_SECURE? "": value);
if (_2566-> _2542)
_2406 (stream, _2399);
}
else
if (attr == FATTR_OPTION)
_2419 (stream, value, _2441, index);
else
if (!_2566-> _2543)
_2407 (stream, _2566-> output, *value? value: "&nbsp;");
}
static void
_2414 (VDESCR *stream, byte *_2402, int _2441, int index)
{
_2544
*_2566;
char
*_2574,
*value;
byte
attr;
attr = *_2424 (_2441, index);
_2566 = &_2545 [attr];
if (_2566-> _2543)
;
else
if (_2566-> input && _2422 (_2441, index))
{
_2420 (_2402, _2441, index, attr);
if (_2566-> _2542)
_2406 (stream, _2398);
_2407 (stream,
"<TEXTAREA NAME=%s ROWS=%d COLS=%d MAXLENGTH=%d WRAP=\"VIRTUAL\">",
_2426 (_2402, index),
_2500 (_2402),
_2501 (_2402),
_2502 (_2402));
value = (attr == FATTR_SECURE? "": _2425 (_2441, index));
while (*value)
{
if (*value == '<')
_2406 (stream, "&lt;");
else
if (*value == '>')
_2406 (stream, "&gt;");
else
_2405 (stream, value, 1);
value++;
}
_2406 (stream, "</TEXTAREA>\n");
if (_2566-> _2542)
_2406 (stream, _2399);
}
else
if (attr == FATTR_OPTION)
_2419 (stream, _2425 (_2441, index), _2441, index);
else
{
_2574 = _2566-> output;
while (*_2574)
{
if (*_2574 == '%')
{
_2574 += 2;
break;
}
_2405 (stream, _2574, 1);
_2574++;
}
value = _2425 (_2441, index);
if (*value)
while (*value)
{
if (*value == '\n')
_2406 (stream, "<BR>");
else
_2405 (stream, value, 1);
value++;
}
else
_2406 (stream, "&nbsp;");
while (*_2574)
_2405 (stream, _2574++, 1);
}
}
static void
_2415 (VDESCR *stream, byte *_2402, int _2441, int index)
{
_2544
*_2566;
char
*value;
byte
attr;
attr = *_2424 (_2441, index);
_2566 = &_2545 [attr];
if (_2566-> _2543)
;
else
if (_2566-> input && _2422 (_2441, index))
{
if (_2566-> _2542)
_2406 (stream, _2398);
_2407 (stream,
"<INPUT TYPE=CHECKBOX %sNAME=%s>\n",
_2425 (_2441, index) [0] == '1'? "CHECKED ": "",
_2426 (_2402, index));
if (_2566-> _2542)
_2406 (stream, _2399);
}
else
{
value = _2425 (_2441, index) [0] == '1'?
_2509 (_2402): _2510 (_2402);
if (attr == FATTR_OPTION)
_2419 (stream, value, _2441, index);
else
_2407 (stream, _2566-> output, *value? value: "&nbsp;");
}
}
static void
_2416 (VDESCR *stream, byte *_2402, int _2441, int index)
{
_2544
*_2566;
int
_2575,
_2576,
_2577;
char
*value,
*_2578;
byte
attr;
_2577 = atoi (_2425 (_2441, index));
attr = *_2424 (_2441, index);
_2566 = &_2545 [attr];
if (_2566-> _2543)
;
else
if (_2566-> input && _2422 (_2441, index))
{
if (_2566-> _2542)
_2406 (stream, _2398);
_2407 (stream, "<SELECT NAME=%s SIZE=%d>\n",
_2426 (_2402, index),
_2513 (_2402));
if (_2514 (_2402) == 0)
{
_2576 = fxlist_size (_2441, index);
for (_2575 = 1; _2575 <= _2576; _2575++)
_2407 (stream, "<OPTION VALUE=\"%d\"%s>%s\n", _2575,
_2575 == _2577? " SELECTED": "",
_2436 (_2441, index, _2575, 'v'));
}
else
{
_2407 (stream, "<OPTION VALUE=\"0\"%s>%s\n",
_2577 == 0? " SELECTED": "",
_2517 (_2402));
_2578 = _2518 (_2402);
for (_2575 = 1; _2575 <= _2514 (_2402); _2575++)
{
_2407 (stream, "<OPTION VALUE=\"%d\"%s>%s\n", _2575,
_2575 == _2577? " SELECTED": "",
_2578);
_2578 += strlen (_2578) + 1;
}
}
_2406 (stream, "</SELECT>\n");
if (_2566-> _2542)
_2406 (stream, _2399);
}
else
if (_2577 == 0)
_2407 (stream, _2566-> output, _2517 (_2402));
else
{
if (_2514 (_2402) == 0)
value = _2436 (_2441, index, _2577, 'v');
else
{
_2578 = _2517 (_2402);
for (_2575 = 0; _2575 < _2577; _2575++)
_2578 += strlen (_2578) + 1;
value = _2578;
}
if (attr == FATTR_OPTION)
_2419 (stream, value, _2441, index);
else
_2407 (stream, _2566-> output, *value? value: "&nbsp;");
}
}
static void
_2417 (VDESCR *stream, byte *_2402, int _2441, int index)
{
_2544
*_2566;
int
_2579;
byte
*_2580;
char
*value;
byte
attr;
_2579 = atoi (_2425 (_2441, index));
_2580 = _2393-> defn-> blocks + _2526 (_2402);
attr = *_2424 (_2441, index);
_2566 = &_2545 [attr];
if (_2566-> _2543)
;
else
if (_2566-> input && _2422 (_2441, index))
{
if (_2527 (_2402) > 1 && _2522 (_2580))
_2406 (stream, "<BR>");
if (_2566-> _2542)
_2406 (stream, _2398);
_2407 (stream, "<INPUT TYPE=RADIO VALUE=\"%d\" NAME=%s%s>%s\n",
_2527 (_2402),
_2426 (_2580, index),
_2527 (_2402) == _2579? " CHECKED": "",
_2528 (_2402));
if (_2566-> _2542)
_2406 (stream, _2399);
}
else
if (_2521 (_2580))
{
if (_2527 (_2402) > 1 && _2522 (_2580))
_2406 (stream, "<BR>");
value = xstrcpy (NULL,
_2527 (_2402) == _2579?
" (*) ": " (&nbsp;) ",
_2528 (_2402),
NULL);
if (attr == FATTR_OPTION)
_2419 (stream, value, _2441, index);
else
_2407 (stream, _2566-> output, value);
mem_free (value);
}
else
if (_2579 == 0 && _2527 (_2402) == 1)
{
if (attr == FATTR_OPTION)
_2419 (stream, _2525 (_2580), _2441, index);
else
_2407 (stream, _2566-> output, _2525 (_2580));
}
else
if (_2527 (_2402) == _2579)
{
if (attr == FATTR_OPTION)
_2419 (stream, _2528 (_2402), _2441, index);
else
_2407 (stream, _2566-> output, _2528 (_2402));
}
}
static void
_2418 (VDESCR *stream, byte *_2402)
{
if (*_2541 (_2402) == FACTION_ENABLED)
{
if (_2529 (_2402) == FTYPE_BUTTON)
_2407 (stream, "<INPUT TYPE=SUBMIT VALUE=\"%s\" NAME=%s>\n",
_2536 (_2402), _2535 (_2402));
else
if (_2529 (_2402) == FTYPE_PLAIN)
if (_2393-> JavaScript)
_2407 (stream,
"<A HREF=\"javascript:submit('~A%d')\">%s</A>\n",
_2530 (_2402),
_2536 (_2402));
else
_2407 (stream, "<A HREF=\"#(uri)&~A%d=1\">%s</A>\n",
_2530 (_2402),
_2536 (_2402));
else
if (_2529 (_2402) == FTYPE_IMAGE)
{
_2407 (stream, "<INPUT TYPE=IMAGE BORDER=0 SRC=%s NAME=%s",
_2536 (_2402), _2535 (_2402));
if (_2533 (_2402))
_2407 (stream, " HEIGHT=%d WIDTH=%d",
_2533 (_2402), _2534 (_2402));
_2406 (stream, ">\n");
}
}
else
if (*_2541 (_2402) == FACTION_DISABLED)
{
if (_2529 (_2402) == FTYPE_BUTTON)
_2407 (stream, "&nbsp;[ %s ]&nbsp;\n", _2536 (_2402));
else
if (_2529 (_2402) == FTYPE_PLAIN)
_2407 (stream, "%s\n", _2536 (_2402));
else
if (_2529 (_2402) == FTYPE_IMAGE)
{
_2407 (stream, "<IMG BORDER=0 SRC=%s ALT=%s",
_2536 (_2402), _2535 (_2402));
if (_2533 (_2402))
_2407 (stream, " HEIGHT=%d WIDTH=%d",
_2533 (_2402), _2534 (_2402));
_2406 (stream, ">\n");
}
}
}
int
form_get (
FORM_ITEM *form,
const char *query)
{
SYMTAB
*symtab;
int
_2581 = 0;
ASSERT (form);
ASSERT (query);
if ((symtab = http_query2symb (query)) == NULL)
return 0;
form-> status = FSTATUS_OK;
form-> image_x = 0;
form-> image_y = 0;
form-> click_field = 0;
form-> click_index = 0;
strclr (form-> livelink);
form-> event = form-> click_event;
mem_check (form-> data);
form_use (form);
if (*query == '&' || *query == '~')
sym_exec_all (symtab, _2446);
else
{
form_exec (form, _2443, symtab, &_2581);
_2447 (symtab);
}
sym_delete_table (symtab);
return (form-> status == FSTATUS_OK? _2581: -1);
}
static Bool
_2443 (
FORM_ITEM *form,
byte *_2402,
int _2441,
va_list _2442)
{
static int
_2582,
_2583 = 0;
SYMTAB
*symtab;
SYMBOL
*symbol;
byte
_2552;
int
_2584,
*_2585,
_2586,
index;
symtab = va_arg (_2442, SYMTAB *);
_2585 = va_arg (_2442, int *);
if (_2441 == -1)
_2582 = 0;
mem_check (form-> data);
_2552 = _2449 (_2402);
if (_2537 (_2552))
{
_2586 = _2582? _2583: 1;
for (index = 0; index < _2586; index++)
{
if (_2552 == BLOCK_BOOLEAN)
strcpy (_2425 (_2441, index), "0");
_2431 (_2441, index);
symbol = sym_lookup_symbol (symtab, _2426 (_2402, index));
if (symbol)
{
_2584 = _2430 (_2402, _2441, index,
symbol-> value);
if (_2584 == -1)
form-> status = FSTATUS_FIELD;
else
*_2585 += _2584;
}
}
}
else
if (_2552 == BLOCK_ACTION)
_2434 (symtab, _2402);
else
if (_2552 == BLOCK_REPEAT)
{
_2582 = _2461 (_2402) + 1;
_2583 = atoi (_2425 (_2460 (_2402), 0));
}
if (_2582)
_2582--;
return (TRUE);
}
static int
_2430 (byte *_2402, int _2441, int index, char *value)
{
switch (_2449 (_2402))
{
case BLOCK_TEXTUAL:
case BLOCK_TEXTBOX:
case BLOCK_SELECT:
case BLOCK_RADIO:
case BLOCK_FILE:
return (fxputn_text (_2441, index, value));
case BLOCK_NUMERIC:
return (_2432 (_2402, _2441, index, value));
case BLOCK_DATE:
return (_2433 (_2402, _2441, index, value));
case BLOCK_BOOLEAN:
return (fxputn_text (_2441, index, "1"));
}
return (0);
}
static int
_2432 (byte *_2402, int _2441, int index, char *value)
{
static char
_2587 [LINE_MAX];
int
_2570,
sign_format,
_2571,
_2588;
char
*_2589;
byte
*attr;
_2427 (
_2402,
&_2570,
&sign_format,
&_2571,
&_2588);
_2588 = _2477 (_2402);
_2589 = conv_str_number
(
value,
_2570,
_2393-> dec_point,
_2479 (_2402),
_2571,
_2588
);
if (_2589 == NULL)
{
xstrcpy (_2587, "Invalid number (", value, "): ",
conv_reason_text [conv_reason], NULL);
form_strerror = _2587;
attr = _2424 (_2441, index);
if (*attr == FATTR_INPUT)
*attr = FATTR_ERROR;
return (-1);
}
else
return (fxputn_text (_2441, index, _2589));
}
static int
_2433 (byte *_2402, int _2441, int index, char *value)
{
static char
_2590 [LINE_MAX];
int
format;
long
_2573 = -1;
byte
*attr;
if (_2490 (_2402) == FSHOW_YMD)
format = DATE_YMD_DELIM;
else
if (_2490 (_2402) == FSHOW_YM)
format = DATE_YM_DELIM;
else
format = DATE_MD_DELIM;
_2573 = conv_str_date (value, 0, format, _2393-> date_order);
if (_2573 == -1)
{
xstrcpy (_2590, "Invalid date (", value, "): ",
conv_reason_text [conv_reason], NULL);
form_strerror = _2590;
attr = _2424 (_2441, index);
if (*attr == FATTR_INPUT)
*attr = FATTR_ERROR;
return (-1);
}
else
return (fxputn_date (_2441, index, _2573));
}
static void
_2431 (int _2441, int index)
{
byte
*attr;
attr = _2424 (_2441, index);
if (*attr == FATTR_ERROR)
*attr = FATTR_INPUT;
}
static void
_2434 (SYMTAB *symtab, byte *_2402)
{
SYMBOL
*symbol;
char
*_2591;
if (_2529 (_2402) == FTYPE_IMAGE)
{
_2591 = xstrcpy (NULL, _2535 (_2402), ".x", NULL);
symbol = sym_lookup_symbol (symtab, _2591);
if (symbol)
{
_2393-> event = _2530 (_2402);
_2393-> image_x = atoi (symbol-> value);
strlast (_2591) = 'y';
symbol = sym_lookup_symbol (symtab, _2591);
if (symbol)
_2393-> image_y = atoi (symbol-> value);
}
mem_free (_2591);
}
else
{
symbol = sym_lookup_symbol (symtab, _2535 (_2402));
if (symbol)
_2393-> event = _2530 (_2402);
}
}
static Bool
_2446 (SYMBOL *symbol, ...)
{
char
*_2592;
if (symbol-> name [0] == '~')
{
if (symbol-> name [1] == 'C')
{
_2592 = strchr (symbol-> name + 2, '.');
if (_2592)
{
_2393-> click_field = atoi (symbol-> name + 2);
_2393-> click_index = atoi (_2592 + 1);
_2393-> event = _2393-> click_event;
return (FALSE);
}
}
else
if (symbol-> name [1] == 'L')
{
strncpy (_2393-> livelink, symbol-> name + 2,
FORMIO_LIVELINK_MAX);
_2393-> livelink [FORMIO_LIVELINK_MAX] = '\0';
_2393-> event = _2393-> click_event;
return (FALSE);
}
else
if (symbol-> name [1] == 'A')
{
_2393-> event = atoi (symbol-> name + 2);
return (FALSE);
}
}
return (TRUE);
}
static void
_2447 (SYMTAB *symtab)
{
SYMBOL
*symbol;
char
*_2592;
symbol = sym_lookup_symbol (symtab, "jsaction");
if (symbol && symbol-> value [0] == '~')
{
if (symbol-> value [1] == 'C')
{
_2592 = strchr (symbol-> value + 2, '.');
if (_2592)
{
_2393-> click_field = atoi (symbol-> value + 2);
_2393-> click_index = atoi (_2592 + 1);
_2393-> event = _2393-> click_event;
}
}
else
if (symbol-> value [1] == 'L')
{
strncpy (_2393-> livelink, symbol-> value + 2,
FORMIO_LIVELINK_MAX);
_2393-> livelink [FORMIO_LIVELINK_MAX] = '\0';
_2393-> event = _2393-> click_event;
}
else
if (symbol-> value [1] == 'A')
_2393-> event = atoi (symbol-> value + 2);
}
}
int
fxputn_text (int field, int index, const char *new_value)
{
char
*value;
ASSERT (new_value);
ASSERT (index < _2451 (_2539 (field)));
if (field < 0 || field >= _2393-> defn-> field_count)
return (0);
value = _2425 (field, index);
if (streq (value, new_value))
return (0);
else
{
strncpy (value, new_value, _2540 (field));
value [_2540 (field)] = '\0';
strcrop (value);
return (1);
}
}
int
fxputn_date (int field, int index, long new_value)
{
ASSERT (index < _2451 (_2539 (field)));
return (fxputn_long (field, index, new_value));
}
int
fxputn_int (int field, int index, int new_value)
{
ASSERT (index < _2451 (_2539 (field)));
return (fxputn_long (field, index, (long) new_value));
}
int
fxputn_long (int field, int index, long new_value)
{
static char
_2569 [20];
ASSERT (index < _2451 (_2539 (field)));
if (field < 0 || field >= _2393-> defn-> field_count)
return (0);
sprintf (_2569, "%ld", new_value);
return (fxputn_text (field, index, _2569));
}
int
fxputn_double (int field, int index, double new_value)
{
static char
_2569 [40],
format [10];
ASSERT (index < _2451 (_2539 (field)));
sprintf (format, "%%.%df", _2479 (_2539 (field)));
sprintf (_2569, format, new_value);
return (fxputn_text (field, index, _2569));
}
int
fxputn_bool (int field, int index, Bool new_value)
{
ASSERT (index < _2451 (_2539 (field)));
return (fxputn_text (field, index, new_value? "1": "0"));
}
char *
fxgetn_text (int field, int index)
{
if (field < 0 || field >= _2393-> defn-> field_count)
return (NULL);
ASSERT (index < _2451 (_2539 (field)));
return (_2425 (field, index));
}
long
fxgetn_date (int field, int index)
{
if (field < 0 || field >= _2393-> defn-> field_count)
return (0);
ASSERT (index < _2451 (_2539 (field)));
ASSERT (_2449 (_2539 (field)) == BLOCK_DATE);
return (atol (_2425 (field, index)));
}
int
fxgetn_int (int field, int index)
{
if (field < 0 || field >= _2393-> defn-> field_count)
return (0);
ASSERT (index < _2451 (_2539 (field)));
return (atoi (_2425 (field, index)));
}
long
fxgetn_long (int field, int index)
{
if (field < 0 || field >= _2393-> defn-> field_count)
return (0);
ASSERT (index < _2451 (_2539 (field)));
return (atol (_2425 (field, index)));
}
double
fxgetn_double (int field, int index)
{
if (field < 0 || field >= _2393-> defn-> field_count)
return (0);
ASSERT (index < _2451 (_2539 (field)));
return (atof (_2425 (field, index)));
}
Bool
fxgetn_bool (int field, int index)
{
ASSERT (index < _2451 (_2539 (field)));
return (fxgetn_long (field, index)? TRUE: FALSE);
}
byte
fxattr_get (
int _2441,
int index)
{
FORM_DEFN
*defn;
defn = _2393-> defn;
ASSERT (_2441 >= 0 && _2441 < defn-> field_count);
return (*_2424 (_2441, index));
}
void
fxattr_put (
int _2441,
int index,
byte attr)
{
FORM_DEFN
*defn;
defn = _2393-> defn;
ASSERT (_2441 >= 0 && _2441 < defn-> field_count);
*_2424 (_2441, index) = attr;
}
size_t
fxlist_size (int field, int index)
{
return (atoi (_2436 (field, index, 0, 'h')));
}
static char *
_2439 (int field, int index, int _2437, char _2438)
{
static char
key [11];
sprintf (key, "%02x.%02x.%02x.%c",
(byte) field, (byte) index, (byte) _2437, _2438);
return (key);
}
static char *
_2436 (int field, int index, int _2437, char _2438)
{
SYMBOL
*symbol;
if (_2393-> list_values)
{
symbol = sym_lookup_symbol (_2393-> list_values,
_2439 (field, index, _2437, _2438));
if (symbol)
return (symbol-> value);
}
return ("");
}
void
fxlist_reset (int field, int index)
{
SYMBOL
*symbol;
int
_2437;
if (_2393-> list_values == NULL)
_2393-> list_values = sym_create_table ();
_2437 = fxlist_size (field, index);
while (_2437 > 0)
{
symbol = sym_lookup_symbol (_2393-> list_values,
_2439 (field, index, _2437, 'k'));
if (symbol)
sym_delete_symbol (_2393-> list_values, symbol);
symbol = sym_lookup_symbol (_2393-> list_values,
_2439 (field, index, _2437, 'v'));
if (symbol)
sym_delete_symbol (_2393-> list_values, symbol);
_2437--;
}
sym_create_symbol (_2393-> list_values,
_2439 (field, index, 0, 'h'), "000");
}
int
fxlist_append (int field, int index, char *key, char *value)
{
SYMBOL
*symbol;
int
_2593;
ASSERT (_2393-> list_values);
symbol = sym_lookup_symbol (_2393-> list_values,
_2439 (field, index, 0, 'h'));
if (symbol == NULL)
return (0);
_2593 = fxlist_size (field, index);
if (_2593 == 999)
return (_2593);
_2593++;
sym_assume_symbol (_2393-> list_values,
_2439 (field, index, _2593, 'k'), key);
sym_assume_symbol (_2393-> list_values,
_2439 (field, index, _2593, 'v'), value);
sprintf (symbol-> value, "%d", _2593);
return (_2593);
}
char *
fxlist_key (int field, int index)
{
return (_2436 (field, index, fxgetn_int (field, index), 'k'));
}
void
fxlist_set (int field, int index, char *key)
{
int
_2437;
ASSERT (_2393-> list_values);
_2437 = fxlist_size (field, index);
while (_2437 > 0)
{
if (streq (_2436 (field, index, _2437, 'k'), key))
break;
_2437--;
}
fxputn_int (field, index, _2437);
}
int
form_exec (
FORM_ITEM *form,
blockfunc _2594,
...)
{
va_list
_2442;
byte
*_2402;
word
block_size;
int
_2441,
_2554,
count = 0;
ASSERT (form);
va_start (_2442, _2594);
_2441 = -1;
_2402 = form-> defn-> blocks;
for (_2554 = 0; _2554 < form-> defn-> block_count; _2554++)
{
block_size = _2448 (_2402);
ASSERT (block_size > 0);
if (_2537 (_2449 (_2402)))
_2441++;
if ((*_2594) (form, _2402, _2441, _2442))
count++;
else
break;
_2402 += block_size + 2;
}
va_end (_2442);
return (count);
}
void
action_enable (FORM_ITEM *form, int event)
{
form_exec (form, _2445, event, FACTION_ENABLED);
}
static Bool
_2445 (
FORM_ITEM *form,
byte *_2402,
int _2441,
va_list _2442)
{
int
event,
attr;
event = va_arg (_2442, int);
attr = va_arg (_2442, int);
_2393 = form;
if (_2449 (_2402) == BLOCK_ACTION)
{
if (event == -1
|| event == _2530 (_2402))
*_2541 (_2402) = attr;
}
return (TRUE);
}
void
action_disable (FORM_ITEM *form, int event)
{
form_exec (form, _2445, event, FACTION_DISABLED);
}
void
action_hide (FORM_ITEM *form, int event)
{
form_exec (form, _2445, event, FACTION_HIDDEN);
}
int
form_save (
const char *filename,
FORM_ITEM *form)
{
FILE
*stream;
stream = fopen (filename, FOPEN_WRITE_BINARY);
if (stream)
{
fwrite (form, sizeof (FORM_ITEM), 1, stream);
fwrite (form-> data, form-> data_size, 1, stream);
fclose (stream);
return (0);
}
else
return (-1);
}
FORM_ITEM *
form_load (
const char *filename,
FORM_DEFN *defn)
{
FILE
*stream;
FORM_ITEM
*form;
byte
*data;
stream = fopen (filename, FOPEN_READ_BINARY);
if (!stream)
return (NULL);
if ((form = _2400 (defn)) == NULL)
return (NULL);
data = form-> data;
fread (form, sizeof (FORM_ITEM), 1, stream);
form-> data = data;
form-> defn = defn;
fread (form-> data, form-> data_size, 1, stream);
mem_check (form-> data);
fclose (stream);
return (form);
}
void
form_dump (FORM_ITEM *form)
{
int
_2554 = 0;
ASSERT (form);
printf ("Dumping contents of form %s\n", form-> defn-> form_name);
printf ("Block: Size:  Type:      Details:\n");
form_exec (form, _2444, &_2554);
}
static Bool
_2444 (
FORM_ITEM *form,
byte *_2402,
int _2441,
va_list _2442)
{
byte
*_2565;
word
block_size;
int
*_2554;
_2554 = va_arg (_2442, int *);
block_size = _2448 (_2402);
printf ("%p %-6d %-6d ", _2402, *_2554, block_size);
(*_2554)++;
switch (_2449 (_2402))
{
case BLOCK_PLAIN:
printf ("plain      ");
_2402 += 2;
block_size--;
if (block_size > 50)
block_size = 50;
while (block_size-- > 0)
printf ("%c", *++_2402);
printf ("\n");
break;
case BLOCK_COMPRESSED:
printf ("compressed ");
_2565 = _2454 (_2402) + form-> defn-> blocks;
if (_2453 (_2402) == COMPR_WHOLEDICT)
block_size = _2448 (_2565) - 1;
else
if (_2453 (_2402) == COMPR_PARTDICT)
block_size = _2455 (_2402);
else
abort ();
_2565 += 2;
if (block_size > 50)
block_size = 50;
while (block_size-- > 0)
printf ("%c", *++_2565);
printf ("\n");
break;
case BLOCK_IF:
printf ("if         ");
printf ("field=%d scope=%d\n",
_2456 (_2402),
_2457 (_2402));
break;
case BLOCK_UNLESS:
printf ("unless     ");
printf ("field=%d scope=%d\n",
_2458 (_2402),
_2459 (_2402));
break;
case BLOCK_REPEAT:
printf ("repeat     ");
printf ("field=%d scope=%d occurs=%d\n",
_2460 (_2402),
_2461 (_2402),
_2462 (_2402));
break;
case BLOCK_TEXTUAL:
printf ("textual    ");
printf ("x%d attr=%d size=%d max=%d name=%s value=%s\n",
_2464 (_2402),
_2463 (_2402),
_2465 (_2402),
_2466 (_2402),
_2467 (_2402),
_2468 (_2402));
break;
case BLOCK_FILE:
printf ("file       ");
printf ("x%d attr=%d size=%d max=%d name=%s value=%s\n",
_2470 (_2402),
_2469 (_2402),
_2471 (_2402),
_2472 (_2402),
_2473 (_2402),
_2474 (_2402));
break;
case BLOCK_NUMERIC:
printf ("numeric    ");
printf ("x%d attr=%d size=%d max=%d sign=%d decs=%d ",
_2476 (_2402),
_2475 (_2402),
_2477 (_2402),
_2478 (_2402),
_2480 (_2402),
_2479 (_2402));
printf ("fill=%d blank=%d comma=%d name=%s value=%s\n",
_2482 (_2402),
_2483 (_2402),
_2484 (_2402),
_2485 (_2402),
_2486 (_2402));
break;
case BLOCK_DATE:
printf ("date       ");
printf ("x%d attr=%d size=%d show=%d format=%d year=%d ",
_2488 (_2402),
_2487 (_2402),
_2489 (_2402),
_2490 (_2402),
_2491 (_2402),
_2492 (_2402));
printf ("month=%d day=%d name=%s value=%s picture=%s\n",
_2493 (_2402),
_2494 (_2402),
_2495 (_2402),
_2496 (_2402),
_2497 (_2402));
break;
case BLOCK_TEXTBOX:
printf ("textbox    ");
printf ("x%d attr=%d rows=%d cols=%d max=%d name=%s value=%s\n",
_2499 (_2402),
_2498 (_2402),
_2500 (_2402),
_2501 (_2402),
_2502 (_2402),
_2503 (_2402),
_2504 (_2402));
break;
case BLOCK_BOOLEAN:
printf ("boolean    ");
printf ("x%d attr=%d name=%s value=%s\n",
_2506 (_2402),
_2505 (_2402),
_2507 (_2402),
_2508 (_2402));
break;
case BLOCK_SELECT:
printf ("select     ");
printf ("x%d attr=%d size=%d opts=%d name=%s value=%s first=%s\n",
_2512 (_2402),
_2511 (_2402),
_2513 (_2402),
_2514 (_2402),
_2515 (_2402),
_2516 (_2402),
_2518 (_2402));
break;
case BLOCK_RADIO:
printf ("radio      ");
printf ("x%d attr=%d detail=%d column=%d name=%s value=%s\n",
_2520 (_2402),
_2519 (_2402),
_2521 (_2402),
_2522 (_2402),
_2523 (_2402),
_2524 (_2402));
break;
case BLOCK_RLABEL:
printf ("rlabel     ");
printf ("data=%d index=%d value=%s\n",
_2526 (_2402),
_2527 (_2402),
_2528 (_2402));
break;
case BLOCK_ACTION:
printf ("action     ");
printf ("type=%d event=%d show=%d height=%d width=%d label=%s\n",
_2529 (_2402),
_2530 (_2402),
_2532 (_2402),
_2533 (_2402),
_2534 (_2402),
_2536 (_2402));
break;
default:
printf ("ERROR!\n");
abort ();
}
return (TRUE);
}
int
form_ftype (
FORM_ITEM *form,
int _2441)
{
FORM_DEFN
*defn;
ASSERT (form);
defn = form-> defn;
if (_2441 < 0 || _2441 >= defn-> field_count)
return (0);
else
return (_2449 (defn-> blocks + defn-> fields [_2441].block));
}
