!----------------------------------------------------------------------------
!   Name:       smthttp.l
!   Title:      Dialog for SMT HTTP server
!   Package:    Libero SMT 2.x
!
!   Written:    96/04/22  iMatix SMT kernel team <smt@imatix.com>
!   Revised:    97/12/31
!
!   Copyright:  Copyright (c) 1991-98 iMatix
!   License:    This is free software; you can redistribute it and/or modify
!               it under the terms of the SMT License Agreement as provided
!               in the file LICENSE.TXT.  This software is distributed in
!               the hope that it will be useful, but without any warranty.
!----------------------------------------------------------------------------
-schema=smtschm.c

After-Init:
    (--) Master                             -> Master-Input
          + Open-Server-Log-File
          + Load-Virtual-Hosts
          + Check-Rootdir-Exists
          + Open-Master-Socket
          + Wait-For-Socket-Input
    (--) Sock-Retry                         -> Master-Input
          + Open-Master-Socket
          + Wait-For-Socket-Input
    (--) Client                             -> Client-Input
          + Prepare-Client-Thread
          + Prepare-To-Read-Request
          + Wait-For-Socket-Input

Master-Input:
    (--) Ok                                 ->
          + Accept-Client-Connection
          + Wait-For-Socket-Input
    (--) Sock-Closed                        ->
          + Open-Master-Socket
          + Wait-For-Socket-Input
    (--) Timer                              ->
          + Reload-Config-If-Needed
    (--) Restart                            ->
          + Free-All-Server-Resources
          + Kill-All-Active-Connections
          + Reopen-Server-Log-File
          + Load-Virtual-Hosts
          + Check-Rootdir-Exists
          + Wait-For-Socket-Input
    (--) Sock-Retry                         ->
          + Open-Master-Socket
          + Wait-For-Socket-Input
    (--) Cancel                             ->
          +
    (--) Wsx-Install                        ->
          + Install-Wsx-Alias
    (--) Wsx-Cancel                         ->
          + Cancel-Wsx-Alias

!   Superstate defines error-handling for client threads.
!   This makes error handling a little faster in all child
!   threads; in any case the Defaults handling is secure too.

Client:
    (--) Sock-Error                         ->
          + Signal-Socket-Error
          + Terminate-The-Thread
    (--) Sock-Closed                        ->
          + Terminate-The-Thread
    (--) Sock-Timeout                       ->
          + Terminate-The-Thread
    (--) Sock-Retry                         ->
          + Terminate-The-Thread
    (--) Error                              ->
          + Write-Http-Header
          + Terminate-The-Thread

Client-Input:  <Client>
    (--) Ok                                 -> Have-Client-Request
          + Read-Http-Request-Next
          + Check-If-Request-Complete
    (--) Sock-Retry                         -> Client-Input
          + Wait-For-Socket-Input

Have-Client-Request:  <Client>
    (--) More                               -> Client-Input
          + Wait-For-Socket-Input
    (--) Post                               -> Client-Input-Post
          + Wait-For-Socket-Input
    (--) Finished                           -> Execute-Http-Request
          + Parse-Http-Request
          + Resolve-Virtual-Hostname
          + Check-Client-Ip-Allowed

Client-Input-Post: <Client>
    (--) Ok                                 -> Have-Client-Request
          + Read-Http-Posted-Data
          + Check-If-Post-Data-Complete
    (--) Sock-Retry                         -> Client-Input-Post
          + Wait-For-Socket-Input

Execute-Http-Request:  <Client>
    (--) Get-Request                        -> Process-Http-Get
          + Get-Url-Type
    (--) Post-Request                       -> Process-Http-Post
          + Get-Url-Type
    (--) Error                              ->
          + Signal-Bad-Request
          + Terminate-The-Thread

Process-Http-Get:  <Client>
    (--) Html                               -> Have-Type-Of-File
          + Check-File-Or-Directory
    (--) Imap                               -> Request-Finished
          + Get-Url-From-Map
          + Write-Http-Header
          + Check-If-Keep-Alive
    (--) Cgi                                -> Have-Type-Of-Cgi
          + Check-File-Or-Directory
    (--) Wsx                                -> Trying-To-Access-Wsx
          + Check-If-Protected
    (--) Filter                             -> Trying-To-Access-Filter
          + Check-File-Or-Directory
          + Check-If-Protected

Process-Http-Post:  <Client>
    (--) Html                               ->
          + Signal-Bad-Request
          + Terminate-The-Thread
    (--) Imap                               ->
          + Signal-Bad-Request
          + Terminate-The-Thread
    (--) Cgi                                -> Have-Type-Of-Cgi
          + Check-File-Or-Directory
    (--) Wsx                                -> Trying-To-Access-Wsx
          + Check-If-Protected
    (--) Filter                             ->
          + Signal-Bad-Request
          + Terminate-The-Thread

Have-Type-Of-File:  <Client>
    (--) File                               -> Trying-To-Access-File
          + Check-If-Protected
    (--) Executable                         -> Trying-To-Access-File
          + Check-If-Protected
    (--) Directory                          -> Trying-To-Access-Dir
          + Check-If-Protected

Trying-To-Access-File:  <Client>
    (--) Ok                                 -> After-Sending-File
          + Check-If-Send-File
          + Write-Http-Header
          + Send-File-To-Browser
    (--) Send-Header                        -> Request-Finished
          + Write-Http-Header
          + Check-If-Keep-Alive
    (--) Protected                          ->
          + Signal-Url-Unauthorised
          + Terminate-The-Thread

After-Sending-File:  <Client>
    (--) Finished                           -> Request-Finished
          + Check-If-Keep-Alive

Trying-To-Access-Dir:  <Client>
    (--) Ok                                 -> Have-Default
          + Get-Default-Web-Page
    (--) Protected                          ->
          + Signal-Url-Unauthorised
          + Terminate-The-Thread

Have-Default:  <Client>
    (--) File                               -> Process-Http-Get
          + Get-Url-Type
    (--) Send-Header                        -> Request-Finished
          + Write-Http-Header
          + Check-If-Keep-Alive
    (--) Not-Found                          -> After-Sending-File
          + Make-Directory-Listing
          + Write-Http-Header
          + Send-File-To-Browser

Trying-To-Access-Filter: <Client>
    (--) Ok                                 -> Wait-For-Filter
          + Create-Filter-Process
          + Wait-Process-End
    (--) Protected                          ->
          + Signal-Url-Unauthorised
          + Terminate-The-Thread

Wait-For-Filter: <Client>
    (--) Timer                              -> Wait-For-Filter
          + Wait-Process-End
    (--) Finished                           -> After-Sending-File
          + Close-Child-Process
          + Reparse-Process-Output
          + Write-Http-Header
          + Send-File-To-Browser
    (--) Redirect                           -> Process-Http-Get
          + Get-Url-Type
    (--) Error                              ->
          + Close-Child-Process
          + Write-Http-Header
          + Terminate-The-Thread

Have-Type-Of-Cgi:  <Client>
!   If /cgi-bin contains non-executable file (e.g. image) we just send it
    (--) File                               -> Trying-To-Access-File
          + Check-If-Protected
    (--) Executable                         -> Before-Running-Cgi
          + Check-If-Protected
    (--) Directory                          -> Trying-To-Access-Dir
          + Check-If-Protected

Before-Running-Cgi:  <Client>
    (--) Ok                                 -> Wait-For-Cgi
          + Create-Cgi-Process
          + Wait-Process-End
    (--) Protected                          ->
          + Signal-Url-Unauthorised
          + Terminate-The-Thread

Wait-For-Cgi:  <Client>
    (--) Timer                              -> Wait-For-Cgi
          + Wait-Process-End
    (--) Finished                           -> After-Sending-File
          + Close-Child-Process
          + Reparse-Process-Output
          + Write-Http-Header
          + Send-File-To-Browser
    (--) Redirect                           -> Process-Http-Get
          + Get-Url-Type
    (--) Error                              ->
          + Close-Child-Process
          + Write-Http-Header
          + Terminate-The-Thread

Trying-To-Access-Wsx: <Client>
    (--) Ok                                 -> Wait-For-Wsx
          + Pass-Request-To-Wsx-Agent
    (--) Not-Supported                      ->
          + Signal-Not-Supported
          + Terminate-The-Thread
    (--) Protected                          ->
          + Signal-Url-Unauthorised
          + Terminate-The-Thread

Wait-For-Wsx: <Client>
    (--) Ok                                 -> Process-Wsx-Response
          + Get-Wsx-Return-Fields
    (--) Error                              ->
          + Get-Wsx-Error-Fields
          + Write-Http-Header
          + Terminate-The-Thread
    (--) Redirect                           ->
          + Get-Wsx-Redirect-Fields
          + Write-Http-Header
          + Terminate-The-Thread
    (--) Restart                            -> Process-Wsx-Restart
          + Get-Wsx-Return-Fields
    (--) Kill                               -> Process-Wsx-Kill
          + Get-Wsx-Return-Fields

Process-Wsx-Response:
!   Normally the WSX response data is in the event body
    (--) Ok                                 -> Request-Finished
          + Reparse-Http-Body
          + Write-Http-Header
          + Write-Http-Body
          + Check-If-Keep-Alive
!   But it might be redirected to a file
    (--) Redirect                           -> After-Sending-File
          + Reparse-Process-Output
          + Write-Http-Header
          + Send-File-To-Browser

Process-Wsx-Restart:
    (--) Ok                                 ->
          + Reparse-Http-Body
          + Write-Http-Header
          + Write-Http-Body
          + Send-Master-Thread-Restart
          + Terminate-The-Thread
    (--) Redirect                           ->
          + Reparse-Process-Output
          + Write-Http-Header
          + Send-File-To-Browser
          + Send-Master-Thread-Restart
          + Terminate-The-Thread

Process-Wsx-Kill:
    (--) Ok                                 ->
          + Reparse-Http-Body
          + Write-Http-Header
          + Write-Http-Body
          + Send-Master-Thread-Shutdown
          + Terminate-The-Thread
    (--) Redirect                           ->
          + Reparse-Process-Output
          + Write-Http-Header
          + Send-File-To-Browser
          + Send-Master-Thread-Shutdown
          + Terminate-The-Thread

Request-Finished:         <Client>
    (--) Ok                                 -> Client-Input
          + Partial-Clear-Http-Context
          + Wait-For-Socket-Input
    (--) Close                              ->
          + Terminate-The-Thread

Defaults:
    (--) Exception                          -> End-Thread
          + Check-Socket-Type
    (--) Shutdown                           -> End-Thread
          + Check-Socket-Type
    (--) Cancel                             -> End-Thread
          + Check-Socket-Type
    (--) Fatal                              ->
          + Signal-Closing-Server
          + Free-All-Server-Resources
          + Shutdown-The-Application
          + Terminate-The-Thread
    (--) Sock-Error                         -> End-Thread
          + Signal-Socket-Error
          + Check-Socket-Type
    (--) Sock-Closed                        -> End-Thread
          + Check-Socket-Type
    (--) Sock-Timeout                       -> End-Thread
          + Check-Socket-Type
    (--) Sock-Retry                         -> End-Thread
          + Check-Socket-Type
    (--) $other                             ->
          +

End-Thread:
    (--) Master                             ->
          + Signal-Closing-Server
          + Free-All-Server-Resources
          + Shutdown-The-Application
          + Terminate-The-Thread
    (--) Client                             ->
          + Terminate-The-Thread
