!----------------------------------------------------------------------------
!   Name:       smtftpc.l
!   Title:      Dialog for SMT FTP server control agent
!   Package:    Libero SMT 2.x
!
!   Written:    96/08/20  iMatix SMT kernel team <smt@imatix.com>
!   Revised:    98/01/25
!
!   Copyright:  Copyright (c) 1991-98 iMatix
!   License:    This is free software; you can redistribute it and/or modify
!               it under the terms of the SMT License Agreement as provided
!               in the file LICENSE.TXT.  This software is distributed in
!               the hope that it will be useful, but without any warranty.
!----------------------------------------------------------------------------
-schema=smtschm.c
-idle

After-Init:
    (--) Master                             -> Master-Input
          + Load-Ftp-Users-File
          + Check-Rootdir-Exists
          + Open-Server-Log-Files
          + Open-Master-Socket
          + Wait-For-Socket-Input
    (--) Sock-Retry                         -> Master-Input
          + Open-Master-Socket
          + Wait-For-Socket-Input
    (--) Client                             -> Before-User
          + Prepare-Client-Thread
          + Check-Client-Ip-Allowed
          + Write-Service-Ready
    (--) Unauthorised                       ->
          + Write-Service-Unavailable
          + Terminate-The-Thread

Master-Input:
    (--) Input-Ok                           -> Master-Input
          + Accept-Client-Connection
          + Wait-For-Socket-Input
    (--) Reload                             ->
          + Reload-Config-If-Needed
    (--) Restart                            -> Master-Input
          + Signal-Closing-Server
          + Free-All-Server-Resources
          + Kill-All-Active-Connections
          + Load-Ftp-Users-File
          + Check-Rootdir-Exists
          + Reopen-Server-Log-Files
          + Wait-For-Socket-Input
    (--) Cancel                             -> Master-Input
          +

!   This substate gets the next FTP command from the client
!   We must have just sent something to the server; we need an Ok event.
!
Client-Input:
    (--) Input-Ok                           ->
          + Read-Ftp-Request
          + Check-If-More-Input
          + Flush-Time-Out
          + Dialog-Return
    (--) Sock-Retry                         -> Client-Input
          + Wait-For-Socket-Input
    (--) Timeout                            -> End-Thread
          + Write-Time-Out-Message
          + Check-Socket-Type
    (--) Ok                                 -> Client-Input
          + Wait-For-Socket-Input

!   These states handle the actual FTP dialogue
!
Before-User:
    (--) Ok                                 -> Client-Input
          + Set-Time-Out
          + Prepare-To-Get-Input
          + Wait-For-Socket-Input
          + Dialog-Call
    (--) Return                             -> Expect-User
          + Get-Ftp-Command

Expect-User:
    (--) User                               -> Have-User
          + Check-User-Profile
    (--) Quit                               -> End-Thread
          + Write-Closing-Connection
          + Check-Socket-Type
    (--) Help                               -> Before-User
          + Write-Help-Message
    (--) Noop                               -> Before-User
          + Write-Return-Message
    (--) Unsupported                        -> Before-User
          + Write-Unsupported-Command
    (--) Invalid                            -> Before-User
          + Write-Invalid-Command
    (--) $other                             -> Before-User
          + Write-Unexpected-Command

Have-User:
    (--) Ok                                 -> Before-Password
          + Write-Return-Message
    (--) Not-Protected                      -> Before-Command
          + Initialise-User-Session
          + Write-User-Logged-In

Before-Password:
    (--) Ok                                 -> Client-Input
          + Set-Time-Out
          + Prepare-To-Get-Input
          + Wait-For-Socket-Input
          + Dialog-Call
    (--) Return                             -> Expect-Password
          + Get-Ftp-Command

Expect-Password:
    (--) User                               -> Have-User
          + Check-User-Profile
    (--) Password                           -> Have-Password
          + Check-User-Password
    (--) Quit                               -> End-Thread
          + Write-Closing-Connection
          + Check-Socket-Type
    (--) Help                               -> Before-Password
          + Write-Help-Message
    (--) Noop                               -> Before-Password
          + Write-Return-Message
    (--) Unsupported                        -> Before-User
          + Write-Unsupported-Command
    (--) Invalid                            -> Before-User
          + Write-Invalid-Command
    (--) $other                             -> Before-User
          + Write-Unexpected-Command

Have-Password:
    (--) Ok                                 -> Before-Command
          + Initialise-User-Session
          + Write-User-Logged-In
    (--) Invalid                            -> Before-User
          + Write-Invalid-Password

Before-Command:
    (--) Ok                                 -> Client-Input
          + Set-Time-Out
          + Prepare-To-Get-Input
          + Wait-For-Socket-Input
          + Dialog-Call
    (--) Return                             -> Expect-Command
          + Get-Ftp-Command

Expect-Command:
    (--) User                               -> Have-User
          + Check-User-Profile
    (--) List                               -> File-Transfer
          + Check-Ready-For-File-Transfer
          + Make-Full-Directory-Listing
          + Send-Put-Data-File-Request
          + Prepare-To-Get-Input
          + Wait-For-Socket-Input
    (--) Names                              -> File-Transfer
          + Check-Ready-For-File-Transfer
          + Make-Brief-Directory-Listing
          + Send-Put-Data-File-Request
          + Prepare-To-Get-Input
          + Wait-For-Socket-Input
    (--) Mkdir                              -> Before-Command
          + Make-New-Directory
          + Write-Return-Message
    (--) Rmdir                              -> Before-Command
          + Remove-Directory
          + Write-Return-Message
    (--) System                             -> Before-Command
          + Write-Name-Of-System
    (--) Type                               -> Before-Command
          + Set-Representation-Type
          + Write-Return-Message
    (--) Size                               -> Check-File-For-Size
          + Make-File-Name
          + Check-If-File-Exists
    (--) Pwd                                -> Before-Command
          + Write-Working-Directory
    (--) Cwd                                -> Before-Command
          + Change-Current-Directory
          + Write-Return-Message
    (--) Cdup                               -> Before-Command
          + Directory-Move-Up
          + Write-Return-Message
    (--) Retrieve                           -> Check-File-To-Put
          + Make-File-Name
          + Check-If-File-Exists
    (--) Store                              -> File-Transfer
          + Make-File-Name
          + Check-Ready-For-File-Transfer
          + Send-Get-Data-File-Request
          + Prepare-To-Get-Input
          + Wait-For-Socket-Input
    (--) Delete                             -> Before-Command
          + Make-File-Name
          + Delete-The-File
          + Log-Access
          + Write-Return-Message
    (--) Rename-From                        -> Check-File-To-Rename
          + Make-File-Name
          + Check-If-File-Exists
    (--) Mode                               -> Before-Command
          + Set-Stream-Mode
          + Write-Return-Message
    (--) Port                               -> Before-Command
          + Get-Data-Port
          + Write-Return-Message
    (--) Quit                               -> End-Thread
          + Write-Closing-Connection
          + Check-Socket-Type
    (--) Passive                            -> After-Open-Passive
          + Open-Passive-Data-Connection
    (--) Help                               -> Before-Command
          + Write-Help-Message
    (--) Noop                               -> Before-Command
          + Write-Return-Message
    (--) Unexpected                         -> Before-Command
          + Check-If-Temporary-File
          + Write-Unexpected-Command
    (--) Unauthorised                       -> Before-Command
          + Write-User-Not-Authorised

File-Transfer:
    (--) Connected                          -> File-Transfer
          + Flush-Time-Out
          + Write-Data-Connected
    (--) Error                              -> Before-Command
          + Check-If-Temporary-File
          + Log-Access
          + Write-Return-Message
    (--) End                                -> Before-Command
          + Check-If-Temporary-File
          + Set-Transfer-Ended
          + Log-Access
          + Write-Return-Message
    (--) Input-Ok                           -> During-File-Transfer
          + Read-Ftp-Request
          + Check-If-More-Input
          + Get-Ftp-Command
    (--) Sock-Retry                         -> File-Transfer
          + Wait-For-Socket-Input
    (--) Invalid                            -> Before-Command
          + Write-Invalid-Command
    (--) $other                             -> File-Transfer
          +

During-File-Transfer:
    (--) Abort                              -> Aborting-Transfer
          + Send-Abort-To-Data-Connection

Aborting-Transfer:
    (--) Aborted                            -> Before-Command
          + Write-Transfer-Aborted
    (--) $other                             -> Aborting-Transfer
          +

Check-File-To-Put:
    (--) Ok                                 -> File-Transfer
          + Check-Ready-For-File-Transfer
          + Send-Put-Data-File-Request
          + Prepare-To-Get-Input
          + Wait-For-Socket-Input
    (--) Unexpected                         -> Before-Command
          + Check-If-Temporary-File
          + Write-Unexpected-Command
    (--) Unauthorised                       -> Before-Command
          + Log-Access
          + Write-User-Not-Authorised

Check-File-To-Rename:
    (--) Ok                                 -> Client-Input
          + Write-Pending-Action
          + Set-Time-Out
          + Prepare-To-Get-Input
          + Wait-For-Socket-Input
          + Dialog-Call
    (--) Return                             -> Expect-Rename-To
          + Get-Ftp-Command
    (--) Unauthorised                       -> Before-Command
          + Log-Access
          + Write-User-Not-Authorised

Expect-Rename-To:
    (--) Rename-To                          -> Before-Command
          + Rename-The-File
          + Log-Access
          + Write-Return-Message
    (--) Quit                               -> End-Thread
          + Write-Closing-Connection
          + Check-Socket-Type
    (--) Help                               -> Before-Command
          + Write-Help-Message
    (--) Noop                               -> Before-Command
          + Write-Return-Message

Check-File-For-Size:
    (--) Ok                                 -> Before-Command
          + Write-File-Size
    (--) Unauthorised                       -> Before-Command
          + Log-Access
          + Write-User-Not-Authorised

After-Open-Passive:
    (--) Ok                                 -> Before-Command
          + Make-Open-Passive-Message
          + Write-Open-Passive-Okay
    (--) Error                              -> Before-Command
          + Write-Open-Passive-Failed

Defaults:
    (--) Exception                          -> End-Thread
          + Check-Socket-Type
    (--) Shutdown                           -> End-Thread
          + Check-Socket-Type
    (--) Fatal                              ->
          + Free-All-Server-Resources
          + Terminate-The-Thread
    (--) Error                              -> End-Thread
          + Write-Return-Message
          + Write-Closing-Connection
          + Check-Socket-Type
    (--) Cancel                             -> End-Thread
          + Check-Socket-Type
    (--) Sock-Error                         -> End-Thread
          + Signal-Socket-Error
          + Check-Socket-Type
    (--) Sock-Closed                        -> End-Thread
          + Check-Socket-Type
    (--) Sock-Timeout                       -> End-Thread
          + Check-Socket-Type
    (--) Sock-Retry                         -> End-Thread
          + Check-Socket-Type
    (--) Connected                          -> Before-Command
          + Write-Data-Connected
    (--) Unsupported                        -> Before-Command
          + Write-Unsupported-Command
    (--) Invalid                            -> Before-Command
          + Write-Invalid-Command
    (--) $other                             -> Before-Command
          + Write-Unexpected-Command

End-Thread:
    (--) Master                             ->
          + Signal-Closing-Server
          + Close-Server-Log-Files
          + Free-All-Server-Resources
          + Terminate-The-Thread
    (--) Client                             ->
          + Cancel-Data-Thread
          + Terminate-The-Thread
