/*
 *  Build script for iMatix SMT Package, for OS/2.
 *
 *  Generated by Otto v2.11 from buildsmt.txt on 98/02/01, 12:43:07
 *  For more info see Otto documentation at http://www.imatix.com.
 *  Bug reports & questions to <ewen@imatix.com>
 *  ---------------------------------------------------------------
 */
'@echo off'

/* Configuration options */
CC     = 'gcc'
CCOPTS = '-DDEBUG -O2 -Wall -pedantic -Zsysv-signals'
ARCHIVE= 'ar rs'
OBJ    = '.o'
LIB    = '.a'
LIBRARIES = '-llibsfl -lsocket'

SAY "Building SMT kernel version 2.30"
SAY "You must already have built the SFL package and installed the"
SAY "SFL library.  If not, Ctrl-C now and get your hands on the SFL."
'pause >nul'
SAY "Checking for required files..."

/* require $LIB libsfl */
CALL AssertFileExists 'libsfl.a'

/* require smtlog.c  smtlog.l  smtlog.d  smtlog.i */
CALL AssertFileExists 'smtlog.c'
CALL AssertFileExists 'smtlog.l'
CALL AssertFileExists 'smtlog.d'
CALL AssertFileExists 'smtlog.i'

/* require smtecho.c smtecho.l smtecho.d smtecho.i */
CALL AssertFileExists 'smtecho.c'
CALL AssertFileExists 'smtecho.l'
CALL AssertFileExists 'smtecho.d'
CALL AssertFileExists 'smtecho.i'

/* require smthttp.c smthttp.l smthttp.d smthttp.i */
CALL AssertFileExists 'smthttp.c'
CALL AssertFileExists 'smthttp.l'
CALL AssertFileExists 'smthttp.d'
CALL AssertFileExists 'smthttp.i'

/* require smtoper.c smtoper.l smtoper.d smtoper.i */
CALL AssertFileExists 'smtoper.c'
CALL AssertFileExists 'smtoper.l'
CALL AssertFileExists 'smtoper.d'
CALL AssertFileExists 'smtoper.i'

/* require smtsock.c smtsock.l smtsock.d smtsock.i */
CALL AssertFileExists 'smtsock.c'
CALL AssertFileExists 'smtsock.l'
CALL AssertFileExists 'smtsock.d'
CALL AssertFileExists 'smtsock.i'

/* require smtslot.c smtslot.l smtslot.d smtslot.i */
CALL AssertFileExists 'smtslot.c'
CALL AssertFileExists 'smtslot.l'
CALL AssertFileExists 'smtslot.d'
CALL AssertFileExists 'smtslot.i'

/* require smtsimu.c smtsimu.l smtsimu.d smtsimu.i */
CALL AssertFileExists 'smtsimu.c'
CALL AssertFileExists 'smtsimu.l'
CALL AssertFileExists 'smtsimu.d'
CALL AssertFileExists 'smtsimu.i'

/* require smttime.c smttime.l smttime.d smttime.i */
CALL AssertFileExists 'smttime.c'
CALL AssertFileExists 'smttime.l'
CALL AssertFileExists 'smttime.d'
CALL AssertFileExists 'smttime.i'

/* require smttran.c smttran.l smttran.d smttran.i */
CALL AssertFileExists 'smttran.c'
CALL AssertFileExists 'smttran.l'
CALL AssertFileExists 'smttran.d'
CALL AssertFileExists 'smttran.i'

/* require smtupmc.c smtupmc.l smtupmc.d smtupmc.i */
CALL AssertFileExists 'smtupmc.c'
CALL AssertFileExists 'smtupmc.l'
CALL AssertFileExists 'smtupmc.d'
CALL AssertFileExists 'smtupmc.i'

/* require smtupmd.c smtupmd.l smtupmd.d smtupmd.i */
CALL AssertFileExists 'smtupmd.c'
CALL AssertFileExists 'smtupmd.l'
CALL AssertFileExists 'smtupmd.d'
CALL AssertFileExists 'smtupmd.i'

/* require smttst1.c smttst1.l smttst1.d smttst1.i */
CALL AssertFileExists 'smttst1.c'
CALL AssertFileExists 'smttst1.l'
CALL AssertFileExists 'smttst1.d'
CALL AssertFileExists 'smttst1.i'

/* require smttst2.c smttst2.l smttst2.d smttst2.i */
CALL AssertFileExists 'smttst2.c'
CALL AssertFileExists 'smttst2.l'
CALL AssertFileExists 'smttst2.d'
CALL AssertFileExists 'smttst2.i'

/* require smttst3.c smttst3.l smttst3.d smttst3.i */
CALL AssertFileExists 'smttst3.c'
CALL AssertFileExists 'smttst3.l'
CALL AssertFileExists 'smttst3.d'
CALL AssertFileExists 'smttst3.i'

/* require smtftpc.c smtftpc.l smtftpc.d smtftpc.i */
CALL AssertFileExists 'smtftpc.c'
CALL AssertFileExists 'smtftpc.l'
CALL AssertFileExists 'smtftpc.d'
CALL AssertFileExists 'smtftpc.i'

/* require smtftpd.c smtftpd.l smtftpd.d smtftpd.i */
CALL AssertFileExists 'smtftpd.c'
CALL AssertFileExists 'smtftpd.l'
CALL AssertFileExists 'smtftpd.d'
CALL AssertFileExists 'smtftpd.i'

/* require smtrdns.c smtrdns.l smtrdns.d smtrdns.i */
CALL AssertFileExists 'smtrdns.c'
CALL AssertFileExists 'smtrdns.l'
CALL AssertFileExists 'smtrdns.d'
CALL AssertFileExists 'smtrdns.i'

/* require smthlog.c smthlog.l smthlog.d smthlog.i */
CALL AssertFileExists 'smthlog.c'
CALL AssertFileExists 'smthlog.l'
CALL AssertFileExists 'smthlog.d'
CALL AssertFileExists 'smthlog.i'

/* require smthttpl.c smthttpl.h */
CALL AssertFileExists 'smthttpl.c'
CALL AssertFileExists 'smthttpl.h'

/* require smtrdnsl.c smtrdnsl.h */
CALL AssertFileExists 'smtrdnsl.c'
CALL AssertFileExists 'smtrdnsl.h'

/* require smtmsg.c  smtmsg.h */
CALL AssertFileExists 'smtmsg.c'
CALL AssertFileExists 'smtmsg.h'

/* require smtlib.c  smtlib.h */
CALL AssertFileExists 'smtlib.c'
CALL AssertFileExists 'smtlib.h'

/* require smtftpl.c smtftpl.h */
CALL AssertFileExists 'smtftpl.c'
CALL AssertFileExists 'smtftpl.h'

/* require xitami.c  xiadm00.c formio.h */
CALL AssertFileExists 'xitami.c'
CALL AssertFileExists 'xiadm00.c'
CALL AssertFileExists 'formio.h'

/* require xiadm01.h xiadm02.h xiadm03.h xiadm04.h xiadm05.h */
CALL AssertFileExists 'xiadm01.h'
CALL AssertFileExists 'xiadm02.h'
CALL AssertFileExists 'xiadm03.h'
CALL AssertFileExists 'xiadm04.h'
CALL AssertFileExists 'xiadm05.h'

/* require xiadm06.h xiadm07.h xiadm08.h xiadm09.h xiadm10.h */
CALL AssertFileExists 'xiadm06.h'
CALL AssertFileExists 'xiadm07.h'
CALL AssertFileExists 'xiadm08.h'
CALL AssertFileExists 'xiadm09.h'
CALL AssertFileExists 'xiadm10.h'

/* require xiadm11.h xiadm12.h xiadm13.h xiadm14.h xiadm15.h */
CALL AssertFileExists 'xiadm11.h'
CALL AssertFileExists 'xiadm12.h'
CALL AssertFileExists 'xiadm13.h'
CALL AssertFileExists 'xiadm14.h'
CALL AssertFileExists 'xiadm15.h'

/* require xiadm16.h xiadm17.h xiadm18.h xiadm18.h xiadm19.h */
CALL AssertFileExists 'xiadm16.h'
CALL AssertFileExists 'xiadm17.h'
CALL AssertFileExists 'xiadm18.h'
CALL AssertFileExists 'xiadm18.h'
CALL AssertFileExists 'xiadm19.h'

/* require xiadm20.h xiadm21.h xiadm22.h xiadm23.h xiadm24.h */
CALL AssertFileExists 'xiadm20.h'
CALL AssertFileExists 'xiadm21.h'
CALL AssertFileExists 'xiadm22.h'
CALL AssertFileExists 'xiadm23.h'
CALL AssertFileExists 'xiadm24.h'

/* require xiadm25.h xiadm26.h */
CALL AssertFileExists 'xiadm25.h'
CALL AssertFileExists 'xiadm26.h'

/* require xiadmin.c xiadmin.l xiadmin.d xiadmin.i */
CALL AssertFileExists 'xiadmin.c'
CALL AssertFileExists 'xiadmin.l'
CALL AssertFileExists 'xiadmin.d'
CALL AssertFileExists 'xiadmin.i'

/* require xierror.c xierror.l xierror.d xierror.i */
CALL AssertFileExists 'xierror.c'
CALL AssertFileExists 'xierror.l'
CALL AssertFileExists 'xierror.d'
CALL AssertFileExists 'xierror.i'

/* require xilrwp.c  xilrwp.l  xilrwp.d  xilrwp.i */
CALL AssertFileExists 'xilrwp.c'
CALL AssertFileExists 'xilrwp.l'
CALL AssertFileExists 'xilrwp.d'
CALL AssertFileExists 'xilrwp.i'

/* require echocli.c echod.c   tsttime.c tstslot.c tstrdns.c */
CALL AssertFileExists 'echocli.c'
CALL AssertFileExists 'echod.c'
CALL AssertFileExists 'tsttime.c'
CALL AssertFileExists 'tstslot.c'
CALL AssertFileExists 'tstrdns.c'

/* require xixlat.c */
CALL AssertFileExists 'xixlat.c'

/* require upmc.c upmd.c */
CALL AssertFileExists 'upmc.c'
CALL AssertFileExists 'upmd.c'

/* require sfl.h smtupm.h */
CALL AssertFileExists 'sfl.h'
CALL AssertFileExists 'smtupm.h'

/* require smtschm.c xitami.aut ftpusers.aut ftpdirs.aut xitami.cfg */
CALL AssertFileExists 'smtschm.c'
CALL AssertFileExists 'xitami.aut'
CALL AssertFileExists 'ftpusers.aut'
CALL AssertFileExists 'ftpdirs.aut'
CALL AssertFileExists 'xitami.cfg'

/* delete $lib libsmt */
'if exist libsmt.a del libsmt.a >nul'

/* library libsmt */

/* compile smtlog  smtmsg  smtecho smthttp smtoper smtsock */
CALL CompileToLib 'smtlog' 'libsmt'
CALL CompileToLib 'smtmsg' 'libsmt'
CALL CompileToLib 'smtecho' 'libsmt'
CALL CompileToLib 'smthttp' 'libsmt'
CALL CompileToLib 'smtoper' 'libsmt'
CALL CompileToLib 'smtsock' 'libsmt'

/* compile smtslot smtsimu smtupmd smtupmc smttran smttime */
CALL CompileToLib 'smtslot' 'libsmt'
CALL CompileToLib 'smtsimu' 'libsmt'
CALL CompileToLib 'smtupmd' 'libsmt'
CALL CompileToLib 'smtupmc' 'libsmt'
CALL CompileToLib 'smttran' 'libsmt'
CALL CompileToLib 'smttime' 'libsmt'

/* compile smtftpc smtftpd smtlib  smtrdns smthlog */
CALL CompileToLib 'smtftpc' 'libsmt'
CALL CompileToLib 'smtftpd' 'libsmt'
CALL CompileToLib 'smtlib' 'libsmt'
CALL CompileToLib 'smtrdns' 'libsmt'
CALL CompileToLib 'smthlog' 'libsmt'

/* compile smthttpl smtftpl smtrdnsl */
CALL CompileToLib 'smthttpl' 'libsmt'
CALL CompileToLib 'smtftpl' 'libsmt'
CALL CompileToLib 'smtrdnsl' 'libsmt'

/* compile xiadmin xiadm00 xierror xilrwp */
CALL CompileToLib 'xiadmin' 'libsmt'
CALL CompileToLib 'xiadm00' 'libsmt'
CALL CompileToLib 'xierror' 'libsmt'
CALL CompileToLib 'xilrwp' 'libsmt'

/* compile smttst1 smttst2 smttst3 */
CALL CompileToLib 'smttst1' 'libsmt'
CALL CompileToLib 'smttst2' 'libsmt'
CALL CompileToLib 'smttst3' 'libsmt'

/* library */

/* compile xitami xixlat */
CALL CompileToObj 'xitami'
CALL CompileToObj 'xixlat'

/* link    xitami xixlat */
CALL LinkProgram 'xitami'
CALL LinkProgram 'xixlat'

/* compile echocli echod tsttime tstslot tstrdns upmc upmd */
CALL CompileToObj 'echocli'
CALL CompileToObj 'echod'
CALL CompileToObj 'tsttime'
CALL CompileToObj 'tstslot'
CALL CompileToObj 'tstrdns'
CALL CompileToObj 'upmc'
CALL CompileToObj 'upmd'

/* link    echocli echod tsttime tstslot tstrdns upmc upmd */
CALL LinkProgram 'echocli'
CALL LinkProgram 'echod'
CALL LinkProgram 'tsttime'
CALL LinkProgram 'tstslot'
CALL LinkProgram 'tstrdns'
CALL LinkProgram 'upmc'
CALL LinkProgram 'upmd'

exit 0
/* End script */

/* Utility subroutines */

/* AssertFileExists <file>
 *
 * Checks to see if the specified file (argument 1) exists.  If it does the
 * subroutine returns.  If it doesn't, the subroutine displays an error
 * message, and exits the procedure.
 */

AssertFileExists:
fullpath = stream(ARG(1), 'C', 'QUERY EXISTS')
IF fullpath = "" THEN
DO
  SAY ARG(1) "missing -- aborting"
  exit 1
END

return

/* CompileToLib <source> <library>
 *
 * Compile C source file into object file, then put that object file into
 * the library.  If either of these steps fail, then abort the script.
 *
 * CC, CCOPTS, ARCHIVE, OBJ, and LIB are REXX variables defined at the top
 * of the script.
 */

CompileToLib:

/* Check to make sure the symbols we require are defined  */
/* NOTE: commas at end of line to continue onto next line */
IF (symbol('CC') \= 'VAR') | (symbol('CCOPTS') \= 'VAR') |,
   (symbol('ARCHIVE') \= 'VAR') | (symbol('OBJ') \= 'VAR') |,
   (symbol('LIB') \= 'VAR') THEN
DO
  SAY "One of the required symbols is not defined."
  SAY "CC is a " symbol('CC')
  SAY "CCOPTS is a " symbol('CCOPTS')
  SAY "ARCHIVE is a " symbol('ARCHIVE')
  SAY "OBJ is a " symbol('OBJ')
  SAY "LIB is a " symbol('LIB')
  EXIT 99
END

PARSE ARG SOURCE LIBRARY

/* Figure out the filename for the source file */
IF (right(SOURCE, 2) = '.c') | (right(SOURCE, 2 ) = '.C') THEN
DO
  sourcefile   = SOURCE
  basefilename = left(SOURCE, (length(SOURCE) - 2))
END
ELSE
DO
  sourcefile   = SOURCE'.c'
  basefilename = SOURCE
END

/* Join the strings together to get object filename */
objectfile   = basefilename''OBJ

IF (right(LIBRARY, length(LIB)) = LIB)
THEN libraryfile = LIBRARY
ELSE libraryfile = LIBRARY''LIB

SAY "Compiling" basefilename"..."
CC CCOPTS '-c' sourcefile
IF (RC > 0) THEN exit 2
ARCHIVE libraryfile objectfile
IF (RC > 0) then exit 3
'del' objectfile '>nul'
return

/* CompileToObj <source>
 *
 * Compile C source file into object file.  If this fails, abort the script.
 *
 * CC, CCOPTS, and OBJ are REXX variables defined at the top of the script.
 */

CompileToObj:

/* Check to make sure the symbols we require are defined */
/* NOTE: commas at end of line to continue onto next line */
IF (symbol('CC') \= 'VAR') | (symbol('CCOPTS') \= 'VAR') |,
   (symbol('OBJ') \= 'VAR') THEN
DO
  SAY "One of the required symbols is not defined."
  EXIT 99
END

/* Figure out the filename for the source file */
IF (right(ARG(1), 2) = '.c') | (right(ARG(1), 2 ) = '.C') THEN
DO
  sourcefile   = ARG(1)
  basefilename = left(ARG(1), (length(ARG(1)) - 2))
END
ELSE
DO
  sourcefile   = ARG(1)'.c'
  basefilename = ARG(1)
END

/* Join the strings together */
objectfile   = basefilename''OBJ

SAY "Compiling" basefilename
CC CCOPTS '-c' sourcefile
IF (RC > 0) THEN exit 2
return


/* LinkProgram <name>
 *
 * Link the object file name.OBJ to get name.EXE.  If the link fails, exit.
 *
 * CC, CCOPTS, OBJ and LIBRARIES are REXX variables defined at the top
 * of the script.
 */

LinkProgram:

/* Check to make sure the symbols we require are defined */
/* NOTE: commas at end of line to continue onto next one */
IF (symbol('CC') \= 'VAR') | (symbol('CCOPTS') \= 'VAR') |,
   (symbol('OBJ') \= 'VAR') | (symbol('LIBRARIES') \= 'VAR') THEN
DO
  SAY "One of the required symbols is not defined."
  EXIT 99
END

basefilename = ARG(1)

/* Join the strings together */
objectfile   = basefilename''OBJ
/* Join the strings together */
/* If we are linking with -Zexe, then the output filename shouldn't have     */
/* ".exe" extension, because this will be added automatically.               */
objectfile   = basefilename''OBJ
IF (POS("-Zexe", CCOPTS) > 0) THEN
  executable = basefilename
ELSE
  executable = basefilename'.exe'

/* Figure out the libraries to link against */
locallibraries = '-L.'
'if exist library.xxx del library.xxx'
'for %%f in (*'LIB') do echo %%f >>library.xxx'
fullpath = stream('library.xxx', 'C', 'QUERY EXISTS')
IF (fullpath \= '') THEN
DO
  libfilename = 'xxx'
  DO WHILE libfilename \= ''
    libfilename = LINEIN('library.xxx')
    IF libfilename \= '' THEN
    DO
      libfilename = STRIP(libfilename)      /* CMD.EXE leaves trailing spaces*/
      IF (right(libfilename, length(LIB)) = LIB)
      THEN libraryfile = left(libfilename, (length(libfilename) - length(LIB)))
      ELSE libraryfile = libfilename

      locallibraries = locallibraries '-l'libraryfile
    END
  END
  result = stream('library.xxx','c','CLOSE')
  'if exist library.xxx del library.xxx >nul'
END

SAY "Linking" basefilename
CC CCOPTS '-o' executable objectfile locallibraries LIBRARIES
IF (RC > 0) THEN exit 2
return

/* End of File */
