/*  ----------------------------------------------------------------<Prolog>-
    Name:       testuid.c
    Title:      Test program for user id functions
    Package:    Standard Function Library (SFL)

    Written:    96/05/03  iMatix SFL project team <sfl@imatix.com>
    Revised:    97/09/08

    Synopsis:   Link and set uid bit on.  Run from another account.

    Copyright:  Copyright (c) 1991-98 iMatix
    License:    This is free software; you can redistribute it and/or modify
                it under the terms of the SFL License Agreement as provided
                in the file LICENSE.TXT.  This software is distributed in
                the hope that it will be useful, but without any warranty.
 ------------------------------------------------------------------</Prolog>-*/

#include "prelude.h"
#include "sfluid.h"

int main (int argc, char *argv [])
{
#if (defined (__UNIX__))
    printf ("User id = %s\n", get_uid_name (geteuid ()));
    printf ("Setting to user...\n");
    set_uid_user ();
    printf ("User id = %s\n", get_uid_name (geteuid ()));
    printf ("Setting to root...\n");
    set_uid_root ();
    printf ("User id = %s\n", get_uid_name (geteuid ()));
#endif

    return (EXIT_SUCCESS);
}
