/*  ----------------------------------------------------------------<Prolog>-
    Name:       testfind.c
    Title:      Test program for search functions
    Package:    Standard Function Library (SFL)

    Written:    96/04/24  iMatix SFL project team <sfl@imatix.com>
    Revised:    97/09/08

    Synopsis:   Runs repeated random cases through the search functions.

    Copyright:  Copyright (c) 1991-98 iMatix
    License:    This is free software; you can redistribute it and/or modify
                it under the terms of the SFL License Agreement as provided
                in the file LICENSE.TXT.  This software is distributed in
                the hope that it will be useful, but without any warranty.
 ------------------------------------------------------------------</Prolog>-*/

#include "sfl.h"

#define BLOCK_MAX     10000
#define PATTERN_MAX     100

static int fill_random (byte *block, int maximum);

int main (int argc, char *argv [])
{
    int
        block_size,
        pattern_size;
    static byte
        block   [BLOCK_MAX],
        pattern [PATTERN_MAX];
    static byte
        *limit,
        *found,
        *naive_result;

    randomize ();
    FOREVER {
        block_size   = fill_random (block,   BLOCK_MAX);
        pattern_size = fill_random (pattern, PATTERN_MAX);

        /*  Naive search for pattern in block                                */
        limit = block + block_size - pattern_size;
        found = block;
        naive_result = NULL;
        while (found < limit)
          {
            found = memchr (found, pattern [0], (size_t) (limit - found + 1));
            if (found)
              {
                if (memcmp (found, pattern, pattern_size) == 0)
                  {
                    naive_result = found;
                    break;
                  }
                else
                    found++;
              }
            else
                break;
          }

        /*  Fast search for pattern in block                                 */
        found = memfind (block, block_size, pattern, pattern_size, FALSE);
        if (found != naive_result)
          {
            printf ("\nFailed: block=%d, pattern=%d\n",
                     block_size, pattern_size);
            printf ("Naive result=%p, memfind=%p\n", naive_result, found);
            if (found && memcmp (found, pattern, pattern_size) == 0)
              {
                puts ("The naive search failed.");
                if (found > limit)
                    puts ("The smart search looked too far.");
              }
            return (EXIT_FAILURE);
          }
        if (found)
            printf ("*");
        else
            printf (".");
    }
}


static int
fill_random (byte *block, int maximum)
{
    int
        block_size,
        byte_nbr;

    block_size = random (maximum) + 1;
    for (byte_nbr = 0; byte_nbr < block_size; byte_nbr++)
        block [byte_nbr] = random (256);
    return (block_size);
}
