/*  ----------------------------------------------------------------<Prolog>-
    Name:       sflstr.h
    Title:      String-handling functions
    Package:    Standard Function Library (SFL)

    Written:    92/10/25  iMatix SFL project team <sfl@imatix.com>
    Revised:    97/10/02

    Synopsis:   Provides various string-handling functions.  Some of these
                functions are available on some but not all platforms; others
                are useful tools for string handling.

    Copyright:  Copyright (c) 1991-98 iMatix
    License:    This is free software; you can redistribute it and/or modify
                it under the terms of the SFL License Agreement as provided
                in the file LICENSE.TXT.  This software is distributed in
                the hope that it will be useful, but without any warranty.
 ------------------------------------------------------------------</Prolog>-*/

#ifndef _SFLSTR_INCLUDED                /*  Allow multiple inclusions        */
#define _SFLSTR_INCLUDED


/*  Function prototypes                                                      */

#ifdef __cplusplus
extern "C" {
#endif

char   *strdupl            (const char *string);
char  **strfree            (char **string);
char   *strskp             (const char *string);
char   *strcset            (char *string, char ch);
char   *strpad             (char *string, char ch, int length);
char   *strlwc             (char *string);
char   *strupc             (char *string);
char   *strcrop            (char *string);
char   *stropen            (char *string, Bool align);
char   *strclose           (char *string, Bool align);
char   *strunique          (char *string, char unique);
int     strmatch           (const char *string1, const char *string2);
qbyte   strhash            (const char *string);
Bool    strprefixed        (const char *string, const char *prefix);
char   *strprefix          (const char *string, const char *delims);
char   *strdefix           (const char *string, const char *prefix);
char   *strconvch          (char *string, char from, char to);
char   *xstrcat            (char *dest, const char *src, ...);
char   *xstrcpy            (char *dest, const char *src, ...);
int     lexcmp             (const char *string1, const char *string2);
int     lexncmp            (const char *string1, const char *string2,
                            const int count);
int     lexwcmp            (const char *string1, const char *string2);
char   *soundex            (const char *string);
char   *soundexn           (const char *string, int size, Bool fold);
DESCR  *strt2descr         (char **strings);
char  **descr2strt         (const DESCR *descr);
void    strtfree           (char **strings);

#ifdef __cplusplus
}
#endif


#endif
