/*  ----------------------------------------------------------------<Prolog>-
    Name:       sflhttp.h
    Title:      HTTP and CGI Support functions
    Package:    Standard Function Library (SFL)

    Written:    96/05/31  iMatix SFL project team <sfl@imatix.com>
    Revised:    98/01/15

    Synopsis:   Provides various functions that support HTTP and CGI
                programming, including escaping/unescaping, and CGI data
                manipulation.

    Copyright:  Copyright (c) 1991-98 iMatix
    License:    This is free software; you can redistribute it and/or modify
                it under the terms of the SFL License Agreement as provided
                in the file LICENSE.TXT.  This software is distributed in
                the hope that it will be useful, but without any warranty.
 ------------------------------------------------------------------</Prolog>-*/

#ifndef _SFLHTTP_INCLUDED               /*  Allow multiple inclusions        */
#define _SFLHTTP_INCLUDED

/*  Function prototypes                                                      */

#ifdef __cplusplus
extern "C" {
#endif

char   *http_escape           (const char *string, char *result);
size_t  http_escape_size      (const char *string);
char   *http_unescape         (char *string, char *result);
char  **http_query2strt       (const char *query);
SYMTAB *http_query2symb       (const char *query);
DESCR  *http_query2descr      (const char *query);
size_t  http_encode_meta      (char *output, const char *input, size_t outmax);
int     cgi_parse_query_vars  (SYMTAB *symtab, const char *query,
                               const char *prefix);
int     cgi_parse_file_vars   (SYMTAB *symtab, FILE *file, const char *prefix,
                               size_t size);
DESCR  *http_multipart_decode (const char *mime_file, const char *store_path);
Bool    is_full_url           (const char *string);

#ifdef __cplusplus
}
#endif

#endif
