/*  ----------------------------------------------------------------<Prolog>-
    Name:       sflfind.h
    Title:      Fast string searching functions
    Package:    Standard Function Library (SFL)

    Written:    96/04/24  iMatix SFL project team <sfl@imatix.com>
    Revised:    97/09/08

    Synopsis:   Searches for a pattern within a string or block of memory
                using a variant of the Boyer-Moore algorithm (improved by
                Horspool and Sunday). As fast or faster than the normal
                Boyer-Moore algorithm for most search strings, and much
                simpler.  Includes a basic function for searching blocks of
                memory with known sizes, plus an envelope that searches
                null-delimited strings.  Provides the option of repeatedly
                searching for the same pattern without re-parsing the pattern
                each time.

    Copyright:  Copyright (c) 1991-98 iMatix
    License:    This is free software; you can redistribute it and/or modify
                it under the terms of the SFL License Agreement as provided
                in the file LICENSE.TXT.  This software is distributed in
                the hope that it will be useful, but without any warranty.
 ------------------------------------------------------------------</Prolog>-*/

#ifndef _SFLFIND_INCLUDED               /*  Allow multiple inclusions        */
#define _SFLFIND_INCLUDED

/*  Function prototypes                                                      */

#ifdef __cplusplus
extern "C" {
#endif

char *strfind (const char *string, const char *pattern, Bool repeat_find);
byte *memfind (const byte *block, size_t block_size,
               const byte *pattern, size_t pattern_size, Bool repeat_find);
char *txtfind (const char *string, const char *pattern);

#ifdef __cplusplus
}
#endif

#endif
