/*
 *  Build script for iMatix SFL Package, for OS/2.
 *
 *  Generated by Otto v2.11 from buildsfl.txt on 98/02/07, 11:46:37
 *  For more info see Otto documentation at http://www.imatix.com.
 *  Bug reports & questions to <ewen@imatix.com>
 *  ---------------------------------------------------------------
 */
'@echo off'

/* Configuration options */
CC     = 'gcc'
CCOPTS = '-DDEBUG -O2 -Wall -pedantic -Zsysv-signals'
ARCHIVE= 'ar rs'
OBJ    = '.o'
LIB    = '.a'
LIBRARIES = '-llibsfl -lsocket'

SAY "Building sfl.h header file..."

/* delete sfl.h */
'if exist sfl.h del sfl.h >nul'

/* append sflhead.h  sfl.h */
'type sflhead.h >> sfl.h'

/* append prelude.h  sfl.h */
'type prelude.h >> sfl.h'

/* append sflvers.h  sfl.h */
'type sflvers.h >> sfl.h'

/* append sflbits.h  sfl.h */
'type sflbits.h >> sfl.h'

/* append sflcomp.h  sfl.h */
'type sflcomp.h >> sfl.h'

/* append sflcons.h  sfl.h */
'type sflcons.h >> sfl.h'

/* append sflconv.h  sfl.h */
'type sflconv.h >> sfl.h'

/* append sflcryp.h  sfl.h */
'type sflcryp.h >> sfl.h'

/* append sfldate.h  sfl.h */
'type sfldate.h >> sfl.h'

/* append sflexdr.h  sfl.h */
'type sflexdr.h >> sfl.h'

/* append sflfind.h  sfl.h */
'type sflfind.h >> sfl.h'

/* append sflfile.h  sfl.h */
'type sflfile.h >> sfl.h'

/* append sfllang.h  sfl.h */
'type sfllang.h >> sfl.h'

/* append sfllbuf.h  sfl.h */
'type sfllbuf.h >> sfl.h'

/* append sfllist.h  sfl.h */
'type sfllist.h >> sfl.h'

/* append sflmath.h  sfl.h */
'type sflmath.h >> sfl.h'

/* append sflmesg.h  sfl.h */
'type sflmesg.h >> sfl.h'

/* append sflmem.h   sfl.h */
'type sflmem.h >> sfl.h'

/* append sflmime.h  sfl.h */
'type sflmime.h >> sfl.h'

/* append sflnode.h  sfl.h */
'type sflnode.h >> sfl.h'

/* append sfldir.h   sfl.h */
'type sfldir.h >> sfl.h'

/* append sflproc.h  sfl.h */
'type sflproc.h >> sfl.h'

/* append sflslot.h  sfl.h */
'type sflslot.h >> sfl.h'

/* append sflstr.h   sfl.h */
'type sflstr.h >> sfl.h'

/* append sflsock.h  sfl.h */
'type sflsock.h >> sfl.h'

/* append sflsymb.h  sfl.h */
'type sflsymb.h >> sfl.h'

/* append sflsyst.h  sfl.h */
'type sflsyst.h >> sfl.h'

/* append sflhttp.h  sfl.h */
'type sflhttp.h >> sfl.h'

/* append sflini.h   sfl.h */
'type sflini.h >> sfl.h'

/* append sflenv.h   sfl.h */
'type sflenv.h >> sfl.h'

/* append sfltok.h   sfl.h */
'type sfltok.h >> sfl.h'

/* append sfltree.h  sfl.h */
'type sfltree.h >> sfl.h'

/* append sfltron.h  sfl.h */
'type sfltron.h >> sfl.h'

/* append sfluid.h   sfl.h */
'type sfluid.h >> sfl.h'

exit 0
/* End script */

/* Utility subroutines */

/* AssertFileExists <file>
 *
 * Checks to see if the specified file (argument 1) exists.  If it does the
 * subroutine returns.  If it doesn't, the subroutine displays an error
 * message, and exits the procedure.
 */

AssertFileExists:
fullpath = stream(ARG(1), 'C', 'QUERY EXISTS')
IF fullpath = "" THEN
DO
  SAY ARG(1) "missing -- aborting"
  exit 1
END

return

/* CompileToLib <source> <library>
 *
 * Compile C source file into object file, then put that object file into
 * the library.  If either of these steps fail, then abort the script.
 *
 * CC, CCOPTS, ARCHIVE, OBJ, and LIB are REXX variables defined at the top
 * of the script.
 */

CompileToLib:

/* Check to make sure the symbols we require are defined  */
/* NOTE: commas at end of line to continue onto next line */
IF (symbol('CC') \= 'VAR') | (symbol('CCOPTS') \= 'VAR') |,
   (symbol('ARCHIVE') \= 'VAR') | (symbol('OBJ') \= 'VAR') |,
   (symbol('LIB') \= 'VAR') THEN
DO
  SAY "One of the required symbols is not defined."
  SAY "CC is a " symbol('CC')
  SAY "CCOPTS is a " symbol('CCOPTS')
  SAY "ARCHIVE is a " symbol('ARCHIVE')
  SAY "OBJ is a " symbol('OBJ')
  SAY "LIB is a " symbol('LIB')
  EXIT 99
END

PARSE ARG SOURCE LIBRARY

/* Figure out the filename for the source file */
IF (right(SOURCE, 2) = '.c') | (right(SOURCE, 2 ) = '.C') THEN
DO
  sourcefile   = SOURCE
  basefilename = left(SOURCE, (length(SOURCE) - 2))
END
ELSE
DO
  sourcefile   = SOURCE'.c'
  basefilename = SOURCE
END

/* Join the strings together to get object filename */
objectfile   = basefilename''OBJ

IF (right(LIBRARY, length(LIB)) = LIB)
THEN libraryfile = LIBRARY
ELSE libraryfile = LIBRARY''LIB

SAY "Compiling" basefilename"..."
CC CCOPTS '-c' sourcefile
IF (RC > 0) THEN exit 2
ARCHIVE libraryfile objectfile
IF (RC > 0) then exit 3
'del' objectfile '>nul'
return

/* CompileToObj <source>
 *
 * Compile C source file into object file.  If this fails, abort the script.
 *
 * CC, CCOPTS, and OBJ are REXX variables defined at the top of the script.
 */

CompileToObj:

/* Check to make sure the symbols we require are defined */
/* NOTE: commas at end of line to continue onto next line */
IF (symbol('CC') \= 'VAR') | (symbol('CCOPTS') \= 'VAR') |,
   (symbol('OBJ') \= 'VAR') THEN
DO
  SAY "One of the required symbols is not defined."
  EXIT 99
END

/* Figure out the filename for the source file */
IF (right(ARG(1), 2) = '.c') | (right(ARG(1), 2 ) = '.C') THEN
DO
  sourcefile   = ARG(1)
  basefilename = left(ARG(1), (length(ARG(1)) - 2))
END
ELSE
DO
  sourcefile   = ARG(1)'.c'
  basefilename = ARG(1)
END

/* Join the strings together */
objectfile   = basefilename''OBJ

SAY "Compiling" basefilename
CC CCOPTS '-c' sourcefile
IF (RC > 0) THEN exit 2
return


/* LinkProgram <name>
 *
 * Link the object file name.OBJ to get name.EXE.  If the link fails, exit.
 *
 * CC, CCOPTS, OBJ and LIBRARIES are REXX variables defined at the top
 * of the script.
 */

LinkProgram:

/* Check to make sure the symbols we require are defined */
/* NOTE: commas at end of line to continue onto next one */
IF (symbol('CC') \= 'VAR') | (symbol('CCOPTS') \= 'VAR') |,
   (symbol('OBJ') \= 'VAR') | (symbol('LIBRARIES') \= 'VAR') THEN
DO
  SAY "One of the required symbols is not defined."
  EXIT 99
END

basefilename = ARG(1)

/* Join the strings together */
objectfile   = basefilename''OBJ
/* Join the strings together */
/* If we are linking with -Zexe, then the output filename shouldn't have     */
/* ".exe" extension, because this will be added automatically.               */
objectfile   = basefilename''OBJ
IF (POS("-Zexe", CCOPTS) > 0) THEN
  executable = basefilename
ELSE
  executable = basefilename'.exe'

/* Figure out the libraries to link against */
locallibraries = '-L.'
'if exist library.xxx del library.xxx'
'for %%f in (*'LIB') do echo %%f >>library.xxx'
fullpath = stream('library.xxx', 'C', 'QUERY EXISTS')
IF (fullpath \= '') THEN
DO
  libfilename = 'xxx'
  DO WHILE libfilename \= ''
    libfilename = LINEIN('library.xxx')
    IF libfilename \= '' THEN
    DO
      libfilename = STRIP(libfilename)      /* CMD.EXE leaves trailing spaces*/
      IF (right(libfilename, length(LIB)) = LIB)
      THEN libraryfile = left(libfilename, (length(libfilename) - length(LIB)))
      ELSE libraryfile = libfilename

      locallibraries = locallibraries '-l'libraryfile
    END
  END
  result = stream('library.xxx','c','CLOSE')
  'if exist library.xxx del library.xxx >nul'
END

SAY "Linking" basefilename
CC CCOPTS '-o' executable objectfile locallibraries LIBRARIES
IF (RC > 0) THEN exit 2
return

/* End of File */
