/*
 *  Build script for iMatix SFL Package, for OS/2.
 *
 *  Generated by Otto v2.11 from buildsfl.txt on 98/02/07, 11:46:37
 *  For more info see Otto documentation at http://www.imatix.com.
 *  Bug reports & questions to <ewen@imatix.com>
 *  ---------------------------------------------------------------
 */
'@echo off'

/* Configuration options */
CC     = 'gcc'
CCOPTS = '-DDEBUG -O2 -Wall -pedantic -Zsysv-signals'
ARCHIVE= 'ar rs'
OBJ    = '.o'
LIB    = '.a'
LIBRARIES = '-llibsfl -lsocket'

SAY "Building Standard Function Library version 1.6"
SAY "Press any key to continue, or Ctrl-C to abort."
'pause >nul'
SAY "Checking for required files..."

/* require prelude.h */
CALL AssertFileExists 'prelude.h'

/* require sflbits.h  sflbits.c */
CALL AssertFileExists 'sflbits.h'
CALL AssertFileExists 'sflbits.c'

/* require sflhttp.h  sflhttp.c */
CALL AssertFileExists 'sflhttp.h'
CALL AssertFileExists 'sflhttp.c'

/* require sflcomp.h  sflcomp.c */
CALL AssertFileExists 'sflcomp.h'
CALL AssertFileExists 'sflcomp.c'

/* require sflcons.h  sflcons.c */
CALL AssertFileExists 'sflcons.h'
CALL AssertFileExists 'sflcons.c'

/* require sflconv.h  sflcvbs.c  sflcvdp.c  sflcvds.c  sflcvns.c */
CALL AssertFileExists 'sflconv.h'
CALL AssertFileExists 'sflcvbs.c'
CALL AssertFileExists 'sflcvdp.c'
CALL AssertFileExists 'sflcvds.c'
CALL AssertFileExists 'sflcvns.c'

/* require            sflcvsb.c  sflcvsd.c  sflcvsn.c  sflcvst.c */
CALL AssertFileExists 'sflcvsb.c'
CALL AssertFileExists 'sflcvsd.c'
CALL AssertFileExists 'sflcvsn.c'
CALL AssertFileExists 'sflcvst.c'

/* require            sflcvtp.c  sflcvts.c  sflconv.c */
CALL AssertFileExists 'sflcvtp.c'
CALL AssertFileExists 'sflcvts.c'
CALL AssertFileExists 'sflconv.c'

/* require sflcryp.h  sflcryp.c */
CALL AssertFileExists 'sflcryp.h'
CALL AssertFileExists 'sflcryp.c'

/* require sfldate.h  sfldate.c */
CALL AssertFileExists 'sfldate.h'
CALL AssertFileExists 'sfldate.c'

/* require sfldir.h   sfldir.c */
CALL AssertFileExists 'sfldir.h'
CALL AssertFileExists 'sfldir.c'

/* require sflenv.h   sflenv.c */
CALL AssertFileExists 'sflenv.h'
CALL AssertFileExists 'sflenv.c'

/* require sflexdr.h  sflexdr.c */
CALL AssertFileExists 'sflexdr.h'
CALL AssertFileExists 'sflexdr.c'

/* require sflfile.h  sflfile.c */
CALL AssertFileExists 'sflfile.h'
CALL AssertFileExists 'sflfile.c'

/* require sflfind.h  sflfind.c */
CALL AssertFileExists 'sflfind.h'
CALL AssertFileExists 'sflfind.c'

/* require sflini.h   sflini.c */
CALL AssertFileExists 'sflini.h'
CALL AssertFileExists 'sflini.c'

/* require sfllang.h  sfllang.c */
CALL AssertFileExists 'sfllang.h'
CALL AssertFileExists 'sfllang.c'

/* require sfllbuf.h  sfllbuf.c */
CALL AssertFileExists 'sfllbuf.h'
CALL AssertFileExists 'sfllbuf.c'

/* require sfllist.h  sfllist.c */
CALL AssertFileExists 'sfllist.h'
CALL AssertFileExists 'sfllist.c'

/* require sflmath.h  sflmath.c */
CALL AssertFileExists 'sflmath.h'
CALL AssertFileExists 'sflmath.c'

/* require sflmem.h   sflmem.c */
CALL AssertFileExists 'sflmem.h'
CALL AssertFileExists 'sflmem.c'

/* require sflmesg.h  sflmesg.c */
CALL AssertFileExists 'sflmesg.h'
CALL AssertFileExists 'sflmesg.c'

/* require sflmime.h  sflmime.c */
CALL AssertFileExists 'sflmime.h'
CALL AssertFileExists 'sflmime.c'

/* require sflnode.h  sflnode.c */
CALL AssertFileExists 'sflnode.h'
CALL AssertFileExists 'sflnode.c'

/* require sflproc.h  sflproc.c */
CALL AssertFileExists 'sflproc.h'
CALL AssertFileExists 'sflproc.c'

/* require sflslot.h  sflslot.c */
CALL AssertFileExists 'sflslot.h'
CALL AssertFileExists 'sflslot.c'

/* require sflsock.h  sflsock.c */
CALL AssertFileExists 'sflsock.h'
CALL AssertFileExists 'sflsock.c'

/* require sflstr.h   sflstr.c */
CALL AssertFileExists 'sflstr.h'
CALL AssertFileExists 'sflstr.c'

/* require sflsymb.h  sflsymb.c */
CALL AssertFileExists 'sflsymb.h'
CALL AssertFileExists 'sflsymb.c'

/* require sflsyst.h  sflsyst.c */
CALL AssertFileExists 'sflsyst.h'
CALL AssertFileExists 'sflsyst.c'

/* require sfltok.h   sfltok.c */
CALL AssertFileExists 'sfltok.h'
CALL AssertFileExists 'sfltok.c'

/* require sfltree.h  sfltree.c */
CALL AssertFileExists 'sfltree.h'
CALL AssertFileExists 'sfltree.c'

/* require sfltron.h  sfltron.c */
CALL AssertFileExists 'sfltron.h'
CALL AssertFileExists 'sfltron.c'

/* require sfluid.h   sfluid.c */
CALL AssertFileExists 'sfluid.h'
CALL AssertFileExists 'sfluid.c'

/* require testall.c */
CALL AssertFileExists 'testall.c'

/* require testbits.c */
CALL AssertFileExists 'testbits.c'

/* require testcomp.c */
CALL AssertFileExists 'testcomp.c'

/* require testconv.c */
CALL AssertFileExists 'testconv.c'

/* require testcryp.c */
CALL AssertFileExists 'testcryp.c'

/* require testdate.c */
CALL AssertFileExists 'testdate.c'

/* require testdes.c */
CALL AssertFileExists 'testdes.c'

/* require testdir.c */
CALL AssertFileExists 'testdir.c'

/* require testexdr.c */
CALL AssertFileExists 'testexdr.c'

/* require testfind.c */
CALL AssertFileExists 'testfind.c'

/* require testmem.c */
CALL AssertFileExists 'testmem.c'

/* require testmime.c */
CALL AssertFileExists 'testmime.c'

/* require teststr.c */
CALL AssertFileExists 'teststr.c'

/* require testsym.c */
CALL AssertFileExists 'testsym.c'

/* require testtree.c */
CALL AssertFileExists 'testtree.c'

/* require testuid.c */
CALL AssertFileExists 'testuid.c'

/* require testcgi.c */
CALL AssertFileExists 'testcgi.c'

/* delete $lib libsfl */
'if exist libsfl.a del libsfl.a >nul'

/* library libsfl */

/* compile sflbits */
CALL CompileToLib 'sflbits' 'libsfl'

/* compile sflhttp */
CALL CompileToLib 'sflhttp' 'libsfl'

/* compile sflcomp */
CALL CompileToLib 'sflcomp' 'libsfl'

/* compile sflcons */
CALL CompileToLib 'sflcons' 'libsfl'

/* compile sflcryp */
CALL CompileToLib 'sflcryp' 'libsfl'

/* compile sflcvbs sflcvdp sflcvds sflcvns */
CALL CompileToLib 'sflcvbs' 'libsfl'
CALL CompileToLib 'sflcvdp' 'libsfl'
CALL CompileToLib 'sflcvds' 'libsfl'
CALL CompileToLib 'sflcvns' 'libsfl'

/* compile sflcvsb sflcvsd sflcvsn sflcvst */
CALL CompileToLib 'sflcvsb' 'libsfl'
CALL CompileToLib 'sflcvsd' 'libsfl'
CALL CompileToLib 'sflcvsn' 'libsfl'
CALL CompileToLib 'sflcvst' 'libsfl'

/* compile sflcvtp sflcvts sflconv */
CALL CompileToLib 'sflcvtp' 'libsfl'
CALL CompileToLib 'sflcvts' 'libsfl'
CALL CompileToLib 'sflconv' 'libsfl'

/* compile sfldate */
CALL CompileToLib 'sfldate' 'libsfl'

/* compile sfldir */
CALL CompileToLib 'sfldir' 'libsfl'

/* compile sflenv */
CALL CompileToLib 'sflenv' 'libsfl'

/* compile sflexdr */
CALL CompileToLib 'sflexdr' 'libsfl'

/* compile sflfile */
CALL CompileToLib 'sflfile' 'libsfl'

/* compile sflfind */
CALL CompileToLib 'sflfind' 'libsfl'

/* compile sflini */
CALL CompileToLib 'sflini' 'libsfl'

/* compile sfllang */
CALL CompileToLib 'sfllang' 'libsfl'

/* compile sfllbuf */
CALL CompileToLib 'sfllbuf' 'libsfl'

/* compile sfllist */
CALL CompileToLib 'sfllist' 'libsfl'

/* compile sflmath */
CALL CompileToLib 'sflmath' 'libsfl'

/* compile sflmem */
CALL CompileToLib 'sflmem' 'libsfl'

/* compile sflmesg */
CALL CompileToLib 'sflmesg' 'libsfl'

/* compile sflmime */
CALL CompileToLib 'sflmime' 'libsfl'

/* compile sflnode */
CALL CompileToLib 'sflnode' 'libsfl'

/* compile sflproc */
CALL CompileToLib 'sflproc' 'libsfl'

/* compile sflslot */
CALL CompileToLib 'sflslot' 'libsfl'

/* compile sflsock */
CALL CompileToLib 'sflsock' 'libsfl'

/* compile sflstr */
CALL CompileToLib 'sflstr' 'libsfl'

/* compile sflsymb */
CALL CompileToLib 'sflsymb' 'libsfl'

/* compile sflsyst */
CALL CompileToLib 'sflsyst' 'libsfl'

/* compile sfltok */
CALL CompileToLib 'sfltok' 'libsfl'

/* compile sfltree */
CALL CompileToLib 'sfltree' 'libsfl'

/* compile sfltron */
CALL CompileToLib 'sfltron' 'libsfl'

/* compile sfluid */
CALL CompileToLib 'sfluid' 'libsfl'

/* library */

/* compile testall  testbits testcomp testconv testcryp testdate testdes */
CALL CompileToObj 'testall'
CALL CompileToObj 'testbits'
CALL CompileToObj 'testcomp'
CALL CompileToObj 'testconv'
CALL CompileToObj 'testcryp'
CALL CompileToObj 'testdate'
CALL CompileToObj 'testdes'

/* compile testexdr testfind testmem  testmime testsym  testtree testuid */
CALL CompileToObj 'testexdr'
CALL CompileToObj 'testfind'
CALL CompileToObj 'testmem'
CALL CompileToObj 'testmime'
CALL CompileToObj 'testsym'
CALL CompileToObj 'testtree'
CALL CompileToObj 'testuid'

/* link    testall  testbits testcomp testconv testcryp testdate testdes */
CALL LinkProgram 'testall'
CALL LinkProgram 'testbits'
CALL LinkProgram 'testcomp'
CALL LinkProgram 'testconv'
CALL LinkProgram 'testcryp'
CALL LinkProgram 'testdate'
CALL LinkProgram 'testdes'

/* link    testexdr testfind testmem  testmime testsym  testtree testuid */
CALL LinkProgram 'testexdr'
CALL LinkProgram 'testfind'
CALL LinkProgram 'testmem'
CALL LinkProgram 'testmime'
CALL LinkProgram 'testsym'
CALL LinkProgram 'testtree'
CALL LinkProgram 'testuid'

/* compile testcgi  testdir  teststr */
CALL CompileToObj 'testcgi'
CALL CompileToObj 'testdir'
CALL CompileToObj 'teststr'

/* link    testcgi  testdir  teststr */
CALL LinkProgram 'testcgi'
CALL LinkProgram 'testdir'
CALL LinkProgram 'teststr'

/* call buildh */
call buildh.cmd 
SAY "SFL built successfully."

exit 0
/* End script */

/* Utility subroutines */

/* AssertFileExists <file>
 *
 * Checks to see if the specified file (argument 1) exists.  If it does the
 * subroutine returns.  If it doesn't, the subroutine displays an error
 * message, and exits the procedure.
 */

AssertFileExists:
fullpath = stream(ARG(1), 'C', 'QUERY EXISTS')
IF fullpath = "" THEN
DO
  SAY ARG(1) "missing -- aborting"
  exit 1
END

return

/* CompileToLib <source> <library>
 *
 * Compile C source file into object file, then put that object file into
 * the library.  If either of these steps fail, then abort the script.
 *
 * CC, CCOPTS, ARCHIVE, OBJ, and LIB are REXX variables defined at the top
 * of the script.
 */

CompileToLib:

/* Check to make sure the symbols we require are defined  */
/* NOTE: commas at end of line to continue onto next line */
IF (symbol('CC') \= 'VAR') | (symbol('CCOPTS') \= 'VAR') |,
   (symbol('ARCHIVE') \= 'VAR') | (symbol('OBJ') \= 'VAR') |,
   (symbol('LIB') \= 'VAR') THEN
DO
  SAY "One of the required symbols is not defined."
  SAY "CC is a " symbol('CC')
  SAY "CCOPTS is a " symbol('CCOPTS')
  SAY "ARCHIVE is a " symbol('ARCHIVE')
  SAY "OBJ is a " symbol('OBJ')
  SAY "LIB is a " symbol('LIB')
  EXIT 99
END

PARSE ARG SOURCE LIBRARY

/* Figure out the filename for the source file */
IF (right(SOURCE, 2) = '.c') | (right(SOURCE, 2 ) = '.C') THEN
DO
  sourcefile   = SOURCE
  basefilename = left(SOURCE, (length(SOURCE) - 2))
END
ELSE
DO
  sourcefile   = SOURCE'.c'
  basefilename = SOURCE
END

/* Join the strings together to get object filename */
objectfile   = basefilename''OBJ

IF (right(LIBRARY, length(LIB)) = LIB)
THEN libraryfile = LIBRARY
ELSE libraryfile = LIBRARY''LIB

SAY "Compiling" basefilename"..."
CC CCOPTS '-c' sourcefile
IF (RC > 0) THEN exit 2
ARCHIVE libraryfile objectfile
IF (RC > 0) then exit 3
'del' objectfile '>nul'
return

/* CompileToObj <source>
 *
 * Compile C source file into object file.  If this fails, abort the script.
 *
 * CC, CCOPTS, and OBJ are REXX variables defined at the top of the script.
 */

CompileToObj:

/* Check to make sure the symbols we require are defined */
/* NOTE: commas at end of line to continue onto next line */
IF (symbol('CC') \= 'VAR') | (symbol('CCOPTS') \= 'VAR') |,
   (symbol('OBJ') \= 'VAR') THEN
DO
  SAY "One of the required symbols is not defined."
  EXIT 99
END

/* Figure out the filename for the source file */
IF (right(ARG(1), 2) = '.c') | (right(ARG(1), 2 ) = '.C') THEN
DO
  sourcefile   = ARG(1)
  basefilename = left(ARG(1), (length(ARG(1)) - 2))
END
ELSE
DO
  sourcefile   = ARG(1)'.c'
  basefilename = ARG(1)
END

/* Join the strings together */
objectfile   = basefilename''OBJ

SAY "Compiling" basefilename
CC CCOPTS '-c' sourcefile
IF (RC > 0) THEN exit 2
return


/* LinkProgram <name>
 *
 * Link the object file name.OBJ to get name.EXE.  If the link fails, exit.
 *
 * CC, CCOPTS, OBJ and LIBRARIES are REXX variables defined at the top
 * of the script.
 */

LinkProgram:

/* Check to make sure the symbols we require are defined */
/* NOTE: commas at end of line to continue onto next one */
IF (symbol('CC') \= 'VAR') | (symbol('CCOPTS') \= 'VAR') |,
   (symbol('OBJ') \= 'VAR') | (symbol('LIBRARIES') \= 'VAR') THEN
DO
  SAY "One of the required symbols is not defined."
  EXIT 99
END

basefilename = ARG(1)

/* Join the strings together */
objectfile   = basefilename''OBJ
/* Join the strings together */
/* If we are linking with -Zexe, then the output filename shouldn't have     */
/* ".exe" extension, because this will be added automatically.               */
objectfile   = basefilename''OBJ
IF (POS("-Zexe", CCOPTS) > 0) THEN
  executable = basefilename
ELSE
  executable = basefilename'.exe'

/* Figure out the libraries to link against */
locallibraries = '-L.'
'if exist library.xxx del library.xxx'
'for %%f in (*'LIB') do echo %%f >>library.xxx'
fullpath = stream('library.xxx', 'C', 'QUERY EXISTS')
IF (fullpath \= '') THEN
DO
  libfilename = 'xxx'
  DO WHILE libfilename \= ''
    libfilename = LINEIN('library.xxx')
    IF libfilename \= '' THEN
    DO
      libfilename = STRIP(libfilename)      /* CMD.EXE leaves trailing spaces*/
      IF (right(libfilename, length(LIB)) = LIB)
      THEN libraryfile = left(libfilename, (length(libfilename) - length(LIB)))
      ELSE libraryfile = libfilename

      locallibraries = locallibraries '-l'libraryfile
    END
  END
  result = stream('library.xxx','c','CLOSE')
  'if exist library.xxx del library.xxx >nul'
END

SAY "Linking" basefilename
CC CCOPTS '-o' executable objectfile locallibraries LIBRARIES
IF (RC > 0) THEN exit 2
return

/* End of File */
