/* rxwldmat.c (emx+gxx) Wild Matching of two Rexx Strings using
   wildmat() from ka9q */

#include <os2emx.h>
#include <stdlib.h>
#include <string.h>
#include "global.h"

static void regfun (PCSZ name)
{
  RexxRegisterFunctionDll (name, "RXMATCH", name);
}


ULONG rxwildmat_loadfuncs (PCSZ name, LONG argc, const RXSTRING *argv,
                           PCSZ queuename, PRXSTRING retstr)
{
  retstr->strlength = 0;
  if (argc != 0)
    return (1);
  regfun("RXMATCHIT");
  return (0);
}


void regerror (const char *s)
{
}

static char *rxstr_alloc (void)
{
  PVOID p;

  DosAllocMem (&p, 0xf000, PAG_READ | PAG_WRITE | PAG_COMMIT);
  return (p);
}

ULONG rxwildmat_match (PCSZ name, LONG argc, const RXSTRING *argv,
                       PCSZ queuename, PRXSTRING retstr)
{
   if (argc != 2 || RXNULLSTRING (argv[0]) || RXNULLSTRING (argv[1]))
     return (1);
   retstr->strptr = rxstr_alloc ();
   retstr->strlength = 1;
   if (wildmat( RXSTRPTR(argv[0]), RXSTRPTR(argv[1]), NULLCHARP) == 0) {
     strcpy(retstr->strptr, "1");
   } else {
     strcpy(retstr->strptr, "0");
   } /* endif */
   return(0);
}

