/****************************************************************************/
/*  DIS2.CMD - control program for warpdis package                          */
/*  Copyright (C) 1995,1996 Alex Chapman <alex@budgetweb.com>               */
/*                                                                          */
/*  This program is free software; you can redistribute it and/or modify    */
/*  it under the terms of the GNU General Public License as published by    */
/*  the Free Software Foundation; either version 2 of the License, or       */
/*  (at your option) any later version.                                     */
/*                                                                          */
/*  This program is distributed in the hope that it will be useful,         */
/*  but WITHOUT ANY WARRANTY; without even the implied warranty of          */
/*  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the           */
/*  GNU General Public License for more details.                            */
/*                                                                          */
/*  You should have received a copy of the GNU General Public License       */
/*  along with this program; if not, write to the Free Software             */
/*  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.               */
/*                                                                          */
/*  Requires killem.exe                                                     */
/*  <ftp://hobbes.nmsu.edu/os2/sysutils/kill21.zip>                         */
/*                                                                          */
/*  Last Modified: 18th September, 1995                                     */
    Version = 0.4
/****************************************************************************/

/************************************************************/
/* Change History                                           */
/************************************************************/
/* 0.1  950909  First version                               */
/* 0.2  950909  Added more options                          */
/* 0.3  950910  Added notify option                         */
/* 0.4  950918  Add user exits                              */
/************************************************************/

arg gnu .

crlf     = d2c(13)||d2c(10)                         /* CR + LF         */
ControlQ = ''                                       /* Control Queue   */
CurrentQ = ''                                       /* Current Queue   */
inifile  = 'DIS2.INI'                               /* INI file        */
killslip = 1                                        /* Do kill slip    */
delaytime = ''                                      /* Start immediate */
starttime = ''                                      /* Start immediate */

Say 'DIS2.CMD - OS/2 control program (version' version')'
Say 'Copyright (C) 1995 Alex Chapman'
Say "DIS2 comes with ABSOLUTELY NO WARRANTY; for details type 'DIS2 w'."
Say 'This is free software, and you are welcome to redistribute it under certain'
Say "conditions; type `DIS2 c' for details."
Say

call RxFuncAdd 'SysLoadFuncs', 'RexxUtil', 'SysLoadFuncs'
call SysLoadFuncs

Select
  When gnu = 'C' Then Do
    Call ShowConditions
    Exit 0
  End
  When gnu = 'W' Then Do
    Call ShowWarranty
    Exit 0
  End
  When gnu = 'H' | gnu = '?' Then Do
    Say 'DIS2 [C|W|H|?|I<inifile>|=<starttime>|+<delaytime>|!|GO]'
    Say
    Exit 0
  End
  When Left(gnu, 1) = 'I' Then Do
    inifile = Substr(gnu, 2)
  End
  When Left(gnu, 1) = '=' Then Do
    starttime = Substr(gnu, 2)
  End
  When Left(gnu, 1) = '+' Then Do
    delaytime = Substr(gnu, 2)
  End
  When gnu = 'GO' | gnu = '!' Then Do
    killslip = 0
  End
  When gnu<>'' Then Do
    Say 'Invalid parameter.  Process terminated.'
    Exit 0
  End
  Otherwise
End

signal on halt

Call ReadINIFile inifile, 'DIS2'
Call CheckParameters

If killslip = 1 Then Do
  Say 'SLIP will be killed'
End
Else Do
  Say 'SLIP will be left running'
End

Call Log '-------------------------------------------------------------'
Call Log 'DIS2 version' version 'started' date() time()

If delaytime <> '' Then Do
  Call Log 'Waiting for' delaytime 'minutes...'
  Say 'Waiting for' delaytime 'minutes...'
  Call SysSleep (60*delaytime)
End

If starttime <> '' Then Do
  Parse var starttime hh':'mm':'ss
  If ss='' Then ss=0
  If hh<0 | hh>24 Then Do
    Call Log 'Invalid time, must be entered as hh:mm:ss or hh:mm'
    Say 'Invalid time, must be entered as hh:mm:ss or hh:mm'
    Exit 1
  End
  If mm<0 | mm>59 Then Do
    Call Log 'Invalid time, must be entered as hh:mm:ss or hh:mm'
    Say 'Invalid time, must be entered as hh:mm:ss or hh:mm'
    Exit 1
  End
  If ss<0 | ss>59 Then Do
    Call Log 'Invalid time, must be entered as hh:mm:ss or hh:mm'
    Say 'Invalid time, must be entered as hh:mm:ss or hh:mm'
    Exit 1
  End
  Call Log 'Waiting until' hh':'mm':'ss
  Say 'Waiting until' hh':'mm':'ss
  goseconds = hh*3600 + mm*60 + ss
  numseconds = time('S')   /* Number of seconds since midnight */
  If numseconds > goseconds Then Do
    waitsecs = (60 * 60 * 24) - numseconds + goseconds
  End
  Else Do
    waitsecs = goseconds - numseconds
  End
  hh = Trunc(waitsecs / 3600)
  mm = Trunc((waitsecs - (3600*hh)) / 60)
  ss = waitsecs - (3600*hh) - (60*mm)
  Call SysSleep waitsecs
End

ControlQ = queue_name
Call Log 'Queue' ControlQ
CurrentQ = RXQUEUE('Set', ControlQ)
Do While Queued() <> 0
  Pull junk
End

Call Log 'Starting GETMAIL...'
Say 'Starting GETMAIL...'
'@START /C "GETMAIL - smtp daemon" GETMAIL.CMD'

Call UserExit 1

Call Log 'Starting SLIP...'
Say 'Starting SLIP...'
'@START /C SLIP.EXE'
'@SLIPWAIT' slip_wait
If RC=1 Then Do
  Call Log 'SLIP failed to start'
  '@KILLEM SLIP.EXE'
  Say
  Exit 1
End
Say 'SLIP started...'
Call Log 'SLIP started...'

Call UserExit 2

If notify = 1 Then Do
  Call Beep 900, 200
  Call Beep 1000, 200
  Call Beep 1100, 200
End

sendit  = -1      /* started */
newnews = -1      /* started */
alive = 1         /* SLIP is alive */

Call Log 'Starting SENDIT...'
Say 'Starting SENDIT...'
'@START /C "SENDIT - smtp client" SENDIT.CMD'

Call Log 'Starting NEWNEWS...'
Say 'Starting NEWNEWS...'
'@START /C "NEWNEWS - nntp client" NEWNEWS.CMD'

Do Until alive = 0
  Do While Queued() = 0 & time('E') < slip_timeout
    Call SysSleep 10
  End
  If Queued() <> 0 Then Do
    Pull message
    Say message
    Call Log message
    Parse var message '<'source'>' command reason code
    Select
      When source = 'SENDIT' Then Do
        Call time 'R' /* Reset elapsed time counter */
        Select
          When command = 'START' Then Do
            sendit = 1 /* Running */
          End
          When command = 'STOP' Then Do
            sendit = 0 /* Stopped */
          End
          When command = 'FAIL' Then Do
            sendit = 0 /* Failed */
          End
        End
      End
      When source = 'NEWNEWS' Then Do
        Call time 'R' /* Reset elapsed time counter */
        Select
          When command = 'START' Then Do
            newnews = 1
          End
          When command = 'STOP' Then Do
            newnews = 0
          End
          When command = 'FAIL' Then Do
            newnews = 0
          End
        End
      End
      Otherwise
        Call Log 'Unknown source' source
    End
    If newnews = 0 & sendit = 0 Then Do
      alive = 0
    End
  End
  Else Do
    Say '*TIMEOUT* program terminating...'
    Call Log slip_timeout 'seconds elapsed since last message'
    alive = 0
  End
End
Call UserExit 3

If killslip = 1 Then Do
  Say 'Killing SLIP in 'kill_delay' seconds...'
  Call Log 'KILLING SLIP in 'kill_delay' seconds...'
  Call SysSleep kill_delay
  '@KILLEM SLIP.EXE'
  Call UserExit 4
  Say
End
Else Do
  Say 'Not killing SLIP...'
End

Call Log 'Deleting control queue'
Call RXQUEUE 'Set', oq
Call RXQUEUE 'Delete', ControlQ

Exit 0

halt:
  Say 'Program terminated by CTRL+C'
  Exit 0

Log: Procedure expose logfile ControlQ CurrentQ

  Parse arg line
  retcode = Stream(logfile, 'c', 'open write')
  retcode = LINEOUT(logfile, line)
  retcode = Stream(logfile, 'c', 'close')
  Return

CheckParameters:
  Return

UserExit:

  arg exit
  userexit = Value('userexit_'exit)
  file = Stream(userexit, 'c', 'query exists')
  If file = '' Then Do
    Call Log 'User Exit' exit 'missing or not enabled ['userexit']'
  End
  Else Do
    Call Log 'Calling User Exit' exit '['userexit']'
    Interpret 'Call "'file'"'
  End
  Return

ReadINIFile:

  arg inifile, application
  file = Stream(inifile, 'c', 'query exists')
  If file = '' Then Do
    file = SysSearchPath('PATH',inifile)
  End
  If file = '' Then Do
    Say 'Unable to find' inifile
    Exit 1
  End
  Say 'inifile' file
  app = ''
  ini. = 0
  retcode = Stream(file, 'c', 'open read')
  If retcode <> 'READY:' Then Do
    Say 'Unable to open' file
    Exit 2
  End
  Do While Lines(file) <> 0
    line = LINEIN(file)
    If Left(line, 1) = '[' Then Do
      Parse Upper var line '[' app ']' .
    End
    Else Do
      If line <> '' & Left(line, 1) <> '#' Then Do
        If app = '' Then Do
          Say 'Invalid line in' file 'expected [application_name]'
          Exit 1
        End
        If app = application | app = 'DEFAULT' Then Do
          Parse var line varname '=' varvalue
          Parse Upper var varname varname
          varname = Strip(varname)
          varvalue = Strip(varvalue)
          If ini.varname = 0 | app = application Then Do
            retcode = Value(varname, varvalue)
            ini.varname = 1
          End
        End
      End
    End
  End
  retcode = Stream(file, 'c', 'close')
  Return

ShowWarranty:
  Say 'Because the program is licensed free of charge, there is no warranty'
  Say 'for the program, to the extent permitted by applicable law.  Except when'
  Say 'otherwise stated in writing the copyright holders and/or other parties'
  Say 'provide the program "as is" without warranty of any kind, either expressed'
  Say 'or implied, including, but not limited to, the implied warranties of'
  Say 'merchantability and fitness for a particular purpose.  The entire risk as'
  Say 'to the quality and performance of the program is with you.  Should the'
  Say 'program prove defective, you assume the cost of all necessary servicing,'
  Say 'repair or correction.'
  Say
  Say 'Read the GNU PUBLIC LICENSE for full details'
  Return

ShowConditions:
  Say 'You may copy and distribute verbatim copies of the Program''s'
  Say 'source code as you receive it, in any medium, provided that you'
  Say 'conspicuously and appropriately publish on each copy an appropriate'
  Say 'copyright notice and disclaimer of warranty; keep intact all the'
  Say 'notices that refer to this License and to the absence of any warranty;'
  Say 'and give any other recipients of the Program a copy of this License'
  Say 'along with the Program.'
  Say
  Say 'Read the GNU PUBLIC LICENSE for full details'
  Return
