/*--------------------------------------------------------------------*/
/*    i n s t a l l . c                                               */
/*                                                                    */
/*    Install/upgrade program for UUPC/extended                       */
/*                                                                    */
/*    Copyright (c) 1992 by Andrew H. Derbyshire                      */
/*--------------------------------------------------------------------*/

/*--------------------------------------------------------------------*/
/*                          RCS Information                           */
/*--------------------------------------------------------------------*/

/*
 *    $Id: install.c 1.5 1995/01/07 16:22:44 ahd v1-12v $
 *
 *    Revision history:
 *    $Log: install.c $
 *    Revision 1.5  1995/01/07 16:22:44  ahd
 *    Change boolean to KWBoolean to avoid VC++ 2.0 conflict
 *
 *    Revision 1.4  1994/02/19 05:02:21  ahd
 *    Use standard first header
 *
 * Revision 1.3  1993/04/11  00:33:54  ahd
 * Global edits for year, TEXT, etc.
 *
 * Revision 1.3  1993/04/11  00:33:54  ahd
 * Global edits for year, TEXT, etc.
 *
 * Revision 1.2  1993/04/04  04:57:01  ahd
 * *** empty log message ***
 *
 * Revision 1.1  1992/11/15  04:29:22  ahd
 * Initial revision
 *
 */

#include "uupcmoah.h"

static char rcsid[] =
      "$Id: install.c 1.5 1995/01/07 16:22:44 ahd v1-12v $";

/*--------------------------------------------------------------------*/
/*                      Standard C include files                      */
/*--------------------------------------------------------------------*/

/*--------------------------------------------------------------------*/
/*                     UUPC/extended include files                    */
/*--------------------------------------------------------------------*/

#include "timestmp.h"

/*--------------------------------------------------------------------*/
/*                          Local prototypes                          */
/*--------------------------------------------------------------------*/

/*--------------------------------------------------------------------*/
/*    m a i n                                                         */
/*                                                                    */
/*    Main program                                                    */
/*--------------------------------------------------------------------*/

void main( int argc, char **argv )
{

/*--------------------------------------------------------------------*/
/*                       Announce our parentage                       */
/*--------------------------------------------------------------------*/

   banner( argv );

/*--------------------------------------------------------------------*/
/*         Determine if UUPC/extended may have been installed         */
/*--------------------------------------------------------------------*/

   if (getenv(UUPCSYSRC) == NULL )
      installed = KWFalse;

   if (installed)
      update();
   else
      install();

} /* main */

/*--------------------------------------------------------------------*/
/*       i n s t a l l                                                */
/*                                                                    */
/*       Perform a basic install of UUPC/extended                     */
/*--------------------------------------------------------------------*/
