#       Program:        nmake.mak                      15 May 1989
#       Author:         Andrew H. Derbyshire
#                       Kendra Electronic Wonderworks
#                       P. O. Box 132
#                       Arlington, MA 02174
#       Function:       Build UUPC/extended from source files
#       Processor:      Microsoft nmake
#       External files: MASM            (8088 Assembler)
#                       CL              (Microsoft C 6.0 compiler)
#                       LINK or         (MS-DOS Linker)
#                       LINK386         (OS/2 Linker)
#                       Input source files.
#
#       Copyright (c) 1989-1998 by Kendra Electronic Wonderworks;
#       all rights reserved except those explicitly granted by
#       the UUPC/extended license.
#
#       nmk /nologo /s /f nmake.mak prodr
#       nmake /nologo /s /f nmake.mak prodp
#       nmake /nologo /s /f nmake.mak prodn
#
#       $Id: nmake.mak 1.130 1998/03/06 16:07:26 ahd Exp $
#
#       $Log: nmake.mak $
#       Revision 1.130  1998/03/06 16:07:26  ahd
#       Go to version 1.12w
#
#       Revision 1.129  1998/03/03 07:44:31  ahd
#       CORRECT BUILD OF FIRST SOURCE ARCHIVE
#       >
#
#       Revision 1.128  1998/03/03 03:04:04  ahd
#       First working POP3 server (w/o delete)
#
#       Revision 1.127  1998/03/01 19:36:36  ahd
#       First compiling POP3 server which accepts user id/password
#
#       Revision 1.126  1998/03/01 01:21:57  ahd
#       Annual Copyright Update
#
#       Revision 1.125  1998/01/03 05:26:26  ahd
#       Support current aux files in release process better
#       Move to version 1.12v
#
#       Revision 1.124  1997/12/22 14:18:34  ahd
#       Rename Borland C++ makefile to borlandc.mak
#
#       Revision 1.123  1997/12/20 22:24:25  ahd
#       Add index to document list
#
#       Revision 1.122  1997/12/13 18:25:07  ahd
#       Correct edit for creating rmailn from rmail's object file list
#
#       Revision 1.121  1997/12/13 18:02:56  ahd
#       Break out misc rmail routines into deliverm.c; rewrite
#       parsing and passing of sender information
#
#       Revision 1.120  1997/11/30 02:07:41  ahd
#       Support building libs/obj on different drive
#
#       Revision 1.119  1997/11/28 23:32:59  ahd
#       Add DNS routines to SMTP build
#
#       Revision 1.118  1997/11/28 04:51:14  ahd
#       SMTPD initial OS/2 support
#
#       Revision 1.117  1997/11/26 03:33:57  ahd
#       Correct SMTP timeouts, break out protocol from rest of daemon
#
#       Revision 1.116  1997/11/24 02:54:05  ahd
#       First working SMTP daemon
#
#       Revision 1.115  1997/11/21 18:15:05  ahd
#       Command processing stub SMTP daemon
#
#       Revision 1.114  1997/06/03 03:25:01  ahd
#       First compiling UUSMTPD
#
#       Revision 1.113  1997/05/14 05:41:23  ahd
#       Correct location of WinWord template
#
#       Revision 1.112  1997/05/11 18:14:54  ahd
#       Allow co-existence of SMTP and non-SMTP rmail/rmailn modules
#
#       Revision 1.111  1997/05/11 04:25:17  ahd
#       SMTP client support for RMAIL/UUXQT
#
#       Revision 1.110  1997/04/24 01:01:07  ahd
#       Annual Copyright Update
#
#       Revision 1.109  1997/04/24 00:55:23  ahd
#       Drop makebuf from library
#
#       Revision 1.108  1996/11/18 04:40:55  ahd
#       Support for building automatically under Windows 95
#
#       Revision 1.107  1996/03/15 04:11:49  ahd
#       Quiet deletion of assorted work files
#
#       Revision 1.106  1996/01/27 16:48:40  ahd
#       Version 1.12s
#
#       Revision 1.105  1996/01/04 03:57:20  ahd
#       Use medium model for expire, genhist under DOS
#
#       Revision 1.104  1996/01/01 23:54:01  ahd
#       Use larger stack under OS/2 16 bit
#       Annual copyright update
#       Rename user "alias" module to nickname.obj for mail.exe
#
#       Revision 1.103  1995/12/02 14:07:05  ahd
#       Make default build for DOS all .exe files
#       Go to version 1.12r
#       Allow override of STACKSIZE under DOS
#
#       Revision 1.102  1995/11/30 12:45:21  ahd
#       Support reorg of kendra's disks
#
#       Revision 1.101  1995/11/08 01:03:13  ahd
#       Allow copying between drives during install
#
#       Revision 1.100  1995/09/24 19:05:42  ahd
#       Delete additional intermediate files
#
#       Revision 1.99  1995/09/11 00:19:01  ahd
#       Go to version 1.12p
#       Add support for Word for Windows source archive, PIF files
#
#       Revision 1.98  1995/08/27 23:27:54  ahd
#       Revise for latest version of C++
#
#       Revision 1.97  1995/04/05 01:42:30  ahd
#       Make UUX an EXE file under DOS
#
#       Revision 1.96  1995/04/01 23:59:11  ahd
#       Allow more flexible building of COM files
#       Always force building of modules which are not same as current size
#       model under DOS
#
#       Revision 1.95  1995/03/24 04:23:54  ahd
#       turn off verbose messages from OS/2 32 bit DLL rename processing
#
#       Revision 1.94  1995/03/24 04:09:32  ahd
#       Generate UUSTAT as EXE file under DOS
#
#       Revision 1.93  1995/03/23 01:28:55  ahd
#       Clean up DOS build -- modules were not always regenerated
#       Clean up OS/2 build -- those messages should be tacked on the DLL,
#       not the modules.
#
#       Revision 1.92  1995/02/24 00:35:30  ahd
#       Lower stack size on COM modules
#
#       Revision 1.91  1995/02/23 04:26:17  ahd
#       Correct extra install variable names
#
#       Revision 1.90  1995/02/21 02:45:44  ahd
#       Use medium model for mail, which needs it to fit
#       im-memory file support.
#
#       Revision 1.89  1995/02/20 17:24:05  ahd
#       Drop address.obj from UUCP executable
#       move OS/2 definitions file to lib directory
#
#       Revision 1.88  1995/02/20 00:07:07  ahd
#       Move various common news subroutines into own library
#       Break common library into two parts to prevent NMAKE failures
#       Kai Uwe Rommel's news cache support
#       Support MS C++ 8.0 compiler
#       General makefile clean up
#
#       Revision 1.87  1995/02/12 23:27:23  ahd
#       split rnews into rnews/news, rename rnews dir to news, make inews COM file
#
#       Revision 1.86  1995/01/30 04:01:59  ahd
#       Add abspath()
#
#       Revision 1.85  1995/01/22 04:15:00  ahd
#       Convert internal zip names to match external names
#
#       Revision 1.84  1995/01/13 12:23:44  ahd
#       Support for UUPCDLL.DLL for Windows NT
#
#       Revision 1.83  1995/01/08 19:49:47  ahd
#       Add mail as target
#
#       Revision 1.82  1995/01/07 20:47:20  ahd
#       Add missing NT components
#
#       Revision 1.81  1995/01/07 15:05:29  ahd
#       Add imfile to library contents
#
#       Revision 1.80  1995/01/03 05:29:39  ahd
#       Add news target
#
#       Revision 1.79  1994/12/31 03:34:53  ahd
#       First pass of integrating Mike McLagan's news SYS file suuport
#
#       Revision 1.78  1994/12/27 20:47:27  ahd
#       Smoother call grading'
#
#       Revision 1.77  1994/12/22 00:42:50  ahd
#       Go to version 1.12m (1.12l does not exist, because l looks like 1)
#
#       Revision 1.76  1994/12/22 00:05:14  ahd
#       Annual Copyright Update
#

.SUFFIXES: .c .asm .zip .obj .dll .ico .bat .cmd .com .exe .pif

# *--------------------------------------------------------------------*
# *     Note:   By default, this file generates code for 80286         *
# *             systems and above.  If you are generating              *
# *             UUPC/extended for a 8088 system, remove the /G2        *
# *             option from the CCOPT= line, below                     *
# *--------------------------------------------------------------------*

# *--------------------------------------------------------------------*
# *   Our release number.  This is updated each time we ship it        *
# *   out to some unsuspecting user, or sometimes when we do a         *
# *   major fix even if we don't ship it out to the lusers.  ANY       *
# *   VERSION NOT DONE ON kendra SHOULD BE TAGGED AS N.NNAm, WHERE     *
# *   N.NNA IS THE NUMBER UUPC was shipped as, and 'm' any string      *
# *   to indentify your special version.  Just upping the              *
# *   distributed version number will confuse you AND me.              *
# *--------------------------------------------------------------------*

VERS = 1.12w

# *--------------------------------------------------------------------*
# *                    Determine the OS de jour.                       *
# *--------------------------------------------------------------------*

!ifndef OS

!if "$(CC)" == "icc"
OS=OS/2_32_Bit
!else

!ifdef OS2_SHELL
OS=OS/2_16_Bit
!else

!ifdef WINDIR
OS=WIN95
!else
OS=DOS
!endif
!endif
!endif

!endif

# *--------------------------------------------------------------------*
# *      Pull in our OS specific defines from the external file        *
# *--------------------------------------------------------------------*

!if "$(OS)" == "Windows_NT"
!include "nmakewnt.mak"
!endif

!if "$(OS)" == "WIN95"
!include "nmakew95.mak"
!endif

!if "$(OS)" == "OS/2_32_Bit"
!include "nmakos22.mak"
!endif

!if "$(OS)" == "OS/2_16_Bit"
!include "nmakos21.mak"
OS2=1
!endif

!if "$(OS)" == "DOS"
!include "nmakedos.mak"
!endif

!ifndef ZIPID
!error ZIPID not defined, check that environment file was included...
!endif

# *--------------------------------------------------------------------*
# *            User specified include file (if specified)              *
# *--------------------------------------------------------------------*

!ifdef UUPCNMK
!include $(UUPCNMK)
!endif

# *--------------------------------------------------------------------*
# *   Various directories.  The TMP directory is not defined here;     *
# *   rather we expect it to be defined as part of the user's          *
# *   environment variables                                            *
# *--------------------------------------------------------------------*

MAIL    = $(SRCSLASH)mail
UTIL    = $(SRCSLASH)util
UUCP    = $(SRCSLASH)uucp
NEWS    = $(SRCSLASH)news
UULIB   = $(SRCSLASH)lib
TEST    = $(SRCSLASH)test
UUCICO  = $(SRCSLASH)uucico
UUTRAF  = $(SRCSLASH)uutraf
SCRIPTS = $(SRCSLASH)scripts
DOCS    = $(SRCSLASH)docs

!ifndef UUPCNMK
WINWORD = d:\winword
!endif

!ifndef OBJ
OBJ=$(OBJROOT)obj$(ZIPID)$(MODEL)
!endif

!ifndef SBR
SBR     = $(SRCSLASH)sbr
!endif

!ifndef LIBDIR
LIBDIR=$(OBJ)
!endif

!ifndef ZIPDIR
ZIPDIR=$(SRCSLASH)$(VERS)
!endif

# *--------------------------------------------------------------------*
# *                        Various file names                          *
# *--------------------------------------------------------------------*

!ifndef ZIPPREFIX
ZIPPREFIX=$(ZIPDIR)\UPC$(VERS:1.=)
!endif

LIBNEWS  = $(LIBDIR)\uupc$(ZIPID)$(MODEL)N.lib
LIBCOMM  = $(LIBDIR)\uupc$(ZIPID)$(MODEL)C.lib
LIBFILE  = $(LIBDIR)\uupc$(ZIPID)$(MODEL)F.lib

WORKFILE = $(TMP)\UUPCMAKE.TMP
!ifdef OS2
DEFFILE  = $(LIBDIR)\UUPCOS$(ZIPID)$(MODEL).DEF
!endif

ZIPE1 = $(ZIPPREFIX)$(ZIPID)1.zip
ZIPE2 = $(ZIPPREFIX)$(ZIPID)2.zip
ZIPE3 = $(ZIPPREFIX)$(ZIPID)3.zip

WORDZIP  = $(ZIPPREFIX)AW.zip
HTMLZIP  = $(ZIPPREFIX)AH.zip

SRCZIPV1 = $(ZIPPREFIX)s1.zip
SRCZIPV2 = $(SRCZIPV1:s1=s2)
SRCZIPV3 = $(SRCZIPV1:s1=s3)
SRCZIPV4 = $(SRCZIPV1:s1=s4)

!ifndef INSTALLCMD
INSTALLCMD=copy
!endif

# *--------------------------------------------------------------------*
# *        The names of various object files that we create.           *
# *--------------------------------------------------------------------*

TIMESTMP = $(OBJ)\timestmp.obj

LIBFILELIST =\
    $(OBJ)\abspath.obj $(OBJ)\arbmath.obj $(OBJ)\arpadate.obj   \
    $(OBJ)\configur.obj $(OBJ)\expath.obj $(OBJ)\export.obj     \
    $(OBJ)\filebkup.obj $(OBJ)\getopt.obj $(OBJ)\getseq.obj     \
    $(OBJ)\hostable.obj $(OBJ)\hostatus.obj $(OBJ)\hostrset.obj \
    $(OBJ)\imfile.obj $(OBJ)\import.obj   \
    $(OBJ)\kanjicnv.obj $(OBJ)\lock.obj $(OBJ)\pushpop.obj      \
    $(OBJ)\security.obj $(OBJ)\ssleep.obj $(OBJ)\stater.obj     \
    $(OBJ)\trumpet.obj $(OBJ)\usertabl.obj $(OBJ)\validcmd.obj  \

LIBCOMMLIST =\
    $(OBJ)\bugout.obj $(OBJ)\catcher.obj $(OBJ)\chdir.obj       \
    $(OBJ)\checkptr.obj $(OBJ)\dater.obj $(OBJ)\dos2unix.obj    \
    $(OBJ)\execute.obj $(OBJ)\fopen.obj $(OBJ)\getargs.obj      \
    $(OBJ)\getdrive.obj $(OBJ)\logger.obj   \
    $(OBJ)\mkdir.obj      \
    $(OBJ)\mkfilenm.obj $(OBJ)\mkmbox.obj $(OBJ)\mktempnm.obj   \
    $(OBJ)\normaliz.obj $(OBJ)\printerr.obj $(OBJ)\printmsg.obj \
    $(OBJ)\readnext.obj $(OBJ)\rename.obj $(OBJ)\safeio.obj     \
    $(OBJ)\safeout.obj $(OBJ)\strpool.obj $(OBJ)\usrcatch.obj   \
    $(LIBOSLIST) $(TIMESTMP)

LIBNEWSLIST=\
    $(OBJ)\active.obj $(OBJ)\cache.obj $(OBJ)\hdbm.obj          \
    $(OBJ)\history.obj $(OBJ)\idx.obj $(OBJ)\importng.obj $(OBJ)\sys.obj

# *--------------------------------------------------------------------*
# *     Determine if we're building .COM or .EXE files under DOS       *
# *--------------------------------------------------------------------*

!ifndef COMEXE
COMEXE=exe                      # our default is safer exe files
!endif

!if "$(MODEL)" == "T"
COMEXET=com
COMEXE=com
!else
COMEXET=exe
!endif

!ifndef COMEXE
!if "$(MODEL)" == "S"
COMEXE=com
!endif
!endif

# *--------------------------------------------------------------------*
# *             Object file lists for specific programs                *
# *--------------------------------------------------------------------*

MAILOBJ = $(OBJ)\mail.obj $(OBJ)\address.obj $(OBJ)\mailblib.obj \
          $(OBJ)\maillib.obj $(OBJ)\mlib.obj $(OBJ)\mailsend.obj \
          $(OBJ)\nickname.obj $(OBJ)\mailnewm.obj

!ifdef SMTP
RMAILS_DELIVERS = $(OBJ)\delivers.obj $(OBJ)\commlibt.obj \
                  $(OBJ)\ulibip.obj $(RMAIL_DELIVERS_SUPPORT)
!endif
RMAILOBJ = $(OBJ)\rmail.obj   \
           $(OBJ)\address.obj \
           $(OBJ)\deliver.obj \
           $(OBJ)\deliverm.obj   \
           $(OBJ)\sysalias.obj

SENDBATSOBJ = $(OBJ)\sendbats.obj $(OBJ)\batch.obj

UUCICOOBJ1 =$(OBJ)\checktim.obj $(OBJ)\commlib.obj $(OBJ)\dcp.obj  \
         $(OBJ)\dcpfpkt.obj $(OBJ)\dcpgpkt.obj $(OBJ)\dcplib.obj   \
         $(OBJ)\dcpstats.obj $(OBJ)\dcpsys.obj $(OBJ)\dcpxfer.obj  \
         $(OBJ)\modem.obj $(OBJ)\nbstime.obj $(OBJ)\script.obj     \
         $(OBJ)\uucico.obj

UUSMTPDOBJ=$(OBJ)\smtpd.obj      \
           $(OBJ)\smtpclnt.obj   \
           $(OBJ)\smtpcmds.obj   \
           $(OBJ)\smtpcmmn.obj   \
           $(OBJ)\smtpdns.obj    \
           $(OBJ)\smtplwc.obj    \
           $(OBJ)\smtpnetw.obj   \
           $(OBJ)\smtpserv.obj   \
           $(OBJ)\smtprecv.obj   \
           $(OBJ)\smtputil.obj   \
           $(OBJ)\smtpverb.obj   \
           $(OBJ)\address.obj    \
           $(OBJ)\deliverm.obj   \
           $(OBJ)\delivern.obj   \
           $(OBJ)\sysalias.obj   \
           $(RMAIL_DELIVERS_SUPPORT)

UUPOPDOBJ=  $(OBJ)\smtpd.obj      \
            $(OBJ)\smtpclnt.obj   \
            $(OBJ)\smtpcmmn.obj   \
            $(OBJ)\smtpdns.obj    \
            $(OBJ)\smtpnetw.obj   \
            $(OBJ)\smtpserv.obj   \
            $(OBJ)\smtpverb.obj   \
            $(OBJ)\pop3lwc.obj    \
            $(OBJ)\pop3cmds.obj   \
            $(OBJ)\pop3user.obj   \
            $(OBJ)\pop3mbox.obj   \
            $(OBJ)\mailnewm.obj   \
            $(RMAIL_DELIVERS_SUPPORT)

RNOBJ1=$(OBJ)\addng.obj $(OBJ)\art.obj $(OBJ)\artio.obj $(OBJ)\artsrch.obj\
       $(OBJ)\backpage.obj $(OBJ)\bits.obj $(OBJ)\cheat.obj $(OBJ)\final.obj
RNOBJ2=$(OBJ)\head.obj $(OBJ)\help.obj $(OBJ)\init.obj $(OBJ)\intrp.obj\
       $(OBJ)\kfile.obj $(OBJ)\last.obj $(OBJ)\ng.obj $(OBJ)\ngdata.obj
RNOBJ3=$(OBJ)\ngsrch.obj $(OBJ)\ngstuff.obj $(OBJ)\only.obj $(OBJ)\rcln.obj\
       $(OBJ)\rcstuff.obj $(OBJ)\respond.obj $(OBJ)\rn.obj $(OBJ)\search.obj\
       $(OBJ)\sw.obj $(OBJ)\term.obj $(OBJ)\util.obj $(OBJ)\uudecode.obj \
       $(OBJ)\rnpclib.obj
RNOBJ=$(RNOBJ1) $(RNOBJ2) $(RNOBJ3)

NEWSETUPOBJ=$(OBJ)\newsetup.obj $(OBJ)\rnlib.obj

UUTRAFOBJ = $(OBJ)\uutraf.obj $(OBJ)\version.obj $(OBJ)\alist.obj\
            $(OBJ)\list.obj $(OBJ)\llist.obj

# *--------------------------------------------------------------------*
# *      Lists of programs to built for various pseudo targets         *
# *--------------------------------------------------------------------*

EXEC =\
    expire.exe fmt.$(COMEXE) fromwho.$(COMEXE) genhist.exe              \
    gensig.$(COMEXE) inews.$(COMEXE) mail.exe newsrun.exe               \
    novrstrk.$(COMEXE) rmail.exe rnews.$(COMEXE) sendbats.exe uucico.exe\
    uucp.exe uuname.$(COMEXE) uupoll.exe uuport.$(COMEXE)         \
    uustat.exe uusub.$(COMEXE) uutraf.exe uux.exe uuxqt.exe \
    $(EXTRAT)

INSTALL1= $(PROD)\mail.exe $(PROD)\rmail.exe $(PROD)\uuxqt.exe    \
          $(PROD)\uucico.exe $(PROD)\uuport.$(COMEXE) $(EXTRA1)

INSTALL2=\
    $(PROD)\uucp.exe $(PROD)\uuname.$(COMEXE) $(PROD)\uupoll.exe  \
    $(PROD)\uustat.exe $(PROD)\uusub.$(COMEXE)                    \
    $(PROD)\uux.exe $(PROD)\gensig.$(COMEXE)                      \
    $(PROD)\novrstrk.$(COMEXE) $(PROD)\fmt.$(COMEXE)                    \
    $(PROD)\fromwho.$(COMEXE) $(EXTRA2)

INSTALL3=\
    $(PROD)\expire.exe $(PROD)\genhist.exe $(PROD)\inews.$(COMEXE)      \
    $(PROD)\newsrun.exe $(PROD)\rnews.$(COMEXE) $(PROD)\sendbats.exe    \
    $(PROD)\uutraf.exe $(EXTRA3)

INSTALLRS=$(PROD)\su.bat $(PROD)\uuio.bat $(PROD)\uuclean.bat\
          $(PROD)\waiting.bat

INSTALLW=$(SRCSLASH)winword\uupcmstr.doc  \
         $(SRCSLASH)winword\uupcindx.doc  \
         $(SRCSLASH)winword\manual.dot
INSTALLH=$(SRCSLASH)winword\uupcmstr.htm  \
         $(SRCSLASH)winword\img00001.gif

!if "$(OS)" == "Windows_NT"
INSTALLS= $(INSTALLRS) $(EXTRAS)
!else
!if "$(OS)" == "Windows_95"
INSTALLS= $(INSTALLRS) $(EXTRAS)
!else
!if "$(OS)" == "DOS"
INSTALLS= $(INSTALLRS) $(EXTRAS)
!else
INSTALLS= $(INSTALLRS:.bat=.cmd) $(EXTRAS)
!endif
!endif
!endif

INSTALL= $(INSTALL1) $(INSTALL2) $(INSTALL3) $(INSTALLS)

# *--------------------------------------------------------------------*
# *   Source browser files; because of space limitations, these        *
# *   are not always generated unless you change the C compiler        *
# *   options.                                                         *
# *--------------------------------------------------------------------*

# *--------------------------------------------------------------------*
# *     This needs to be expanded to *all* the OBJ files ... but       *
# *     not today, as the Wonderworks doesn't use it.                  *
# *--------------------------------------------------------------------*
SBRS = $(LIBDOSLIST:obj=sbr)

# *--------------------------------------------------------------------*
# *                   And, of course, our makefile                     *
# *--------------------------------------------------------------------*

!ifndef MAKEFILE
MAKEFILE = $(SRCSLASH)nmake.mak
!endif

README=         docs\00readme.now winword\license.txt
ZIPHEAD=        docs\ziphead.txt

# *--------------------------------------------------------------------*
# *                      C compiler and options                        *
# *--------------------------------------------------------------------*

!ifndef CC
CC      = cl
!endif

{$(UULIB)}.c{$(OBJ)}.obj:
        $(CC) $(CCOPT) $<

{$(MAIL)}.c{$(OBJ)}.obj:
        $(CC) $(CCOPT) $<

{$(RN)}.c{$(OBJ)}.obj:
        $(CC) $(CCOPT) /W3 $<

{$(NEWS)}.c{$(OBJ)}.obj:
        $(CC) $(CCOPT) $<

{$(TEST)}.c{$(OBJ)}.obj:
        $(CC) $(CCOPT) $<

{$(UUCICO)}.c{$(OBJ)}.obj:
        $(CC) $(CCOPT) $<

{$(UUCICO)}.asm{$(OBJ)}.obj:
        $(MASM) $(MASMOPTS) $(UUCICO)\$(@B) ,$@;

{$(UUCP)}.c{$(OBJ)}.obj:
        $(CC) $(CCOPT) $<

{$(UTIL)}.c{$(OBJ)}.obj:
        $(CC) $(CCOPT) $<

{$(UUTRAF)}.c{$(OBJ)}.obj:
        $(CC) -DSYSVR3 -DUUPC -I$(UUTRAF) $(CCOPT) /W1 $<

# *--------------------------------------------------------------------*
# *                Rules for copying into production                   *
# *--------------------------------------------------------------------*

# *--------------------------------------------------------------------*
# *                         Prod .EXE files                            *
# *--------------------------------------------------------------------*

.exe{$(PROD)}.exe:
!if "$(OS)" == "OS/2_32_Bit"
        dllrname /Q /R $? $(RTLDLL:.dll=)=$(DLLNAME:.dll=)
!endif
        - $(ERASE) $@
        $(INSTALLCMD) $? $@
!ifndef KEWKEEPEXE
        - if exist $? $(ERASE) $?
!endif
        - @if exist $(?R).pdb $(ERASE) $(?R).pdb
        - @if exist $(?R).ilk $(ERASE) $(?R).ilk
        - @if exist $(?R).dbg $(ERASE) $(?R).dbg
        - @if exist $(?R).map $(ERASE) $(?R).map

# *--------------------------------------------------------------------*
# *                         PROD .COM files                            *
# *--------------------------------------------------------------------*


.com{$(PROD)}.com:
        - if exist $(?R).dbg $(ERASE) $(?R).dbg
        - if exist $(?R).map $(ERASE) $(?R).map
        - $(ERASE) $@
        $(INSTALLCMD) $? $@

.dll{$(PROD)}.dll:
        copy $? $@

{$(DOCS)}.pif{$(PROD)}.pif:
        copy $? $@

{$(SCRIPTS)}.bat{$(PROD)}.bat:
        copy $? $@

!if "$(OS)" == "Windows_NT"

{$(SCRIPTS)}.bat{$(PROD)}.cmd:
        copy $? $@
!else

{$(SCRIPTS)}.cmd{$(PROD)}.cmd:
        copy $? $@
!endif

{docs}.ico{$(PROD)}.ico:
        copy $? $@

# *--------------------------------------------------------------------*
# *            ZIP, for creating the distributed archive               *
# *--------------------------------------------------------------------*

!ifndef ZIP
ZIP     = zip
!endif

!ifndef ZIPOPT1
ZIPOPT1 = -o -9 -u -@
!endif

!ifndef ZIPOPT2
ZIPOPT2 = -j $(ZIPOPT1)
!endif

# *--------------------------------------------------------------------*
# *                Begin rules for building modules.                   *
# *--------------------------------------------------------------------*

# *--------------------------------------------------------------------*
# *        The first definition is the one built by default.           *
# *--------------------------------------------------------------------*

test:   $(OBJ) $(EXEC)

news:   $(OBJ) expire.exe genhist.exe inews.$(COMEXE) newsrun.exe \
        rnews.$(COMEXE) sendbats.exe

mail:   $(OBJ) mail.exe rmail.exe

prod:   $(OBJ) $(EXEC) $(INSTALL) regen

qprod:  $(OBJ) $(INSTALL)

install:        zip

zip:    clean $(OBJ) qzip

!ifdef NODEBUG
qzip:           ezip szip wzip regen
        @echo Build complete.
!else
qzip:
        $(MAKE) -f $(MAKEFILE) NODEBUG=1  qzip
!endif

ezip:   $(ZIPE1) $(ZIPE2) $(ZIPE3)

# *--------------------------------------------------------------------*
# *                 Build just the source .ZIP file.                   *
# *--------------------------------------------------------------------*

szip:   $(SRCZIPV1) $(SRCZIPV2) $(SRCZIPV3) $(SRCZIPV4)

wzip:   $(WORDZIP) $(HTMLZIP)

# *--------------------------------------------------------------------*
# *          Do a purge of various temporary output files.             *
# *--------------------------------------------------------------------*

clean:  xclean
        - $(ERASE) $(SRCSLASH)*.bak
        - $(ERASE) *.map
        - $(ERASE) $(WORKFILE)

# *--------------------------------------------------------------------*
# *      Do a clean of just executable files and related files.        *
# *--------------------------------------------------------------------*

xclean:
        - $(ERASE) $(OBJ)\*.obj
        - $(ERASE) $(OBJ)\*.exe
        - $(ERASE) $(LIBCOMM)
        - $(ERASE) $(SRCSLASH)*.obj
        - $(ERASE) $(SRCSLASH)*.exe
        - $(ERASE) $(SBR)\*.sbr
!if "$(MODEL)" == "S"
        $(MAKE) -f $(MAKEFILE) MODEL=M $@
        $(MAKE) -f $(MAKEFILE) MODEL=T $@
!endif

# *--------------------------------------------------------------------*
# *               The commands to actually link files                  *
# *--------------------------------------------------------------------*

comm34.$(COMEXET):   $(OBJ)\comm34.obj $(LIBFILE) $(LIBCOMM) $(DEFFILE)
        $(CC) $(LDOPT) $** $(OTHERLIBS)

inews.$(COMEXET):    $(OBJ)\inews.obj $(LIBFILE) $(LIBCOMM) $(DEFFILE)
        $(CC) $(LDOPT) $** $(OTHERLIBS)

!if "$(MODEL)" != "S"
expire.$(COMEXET):  $(OBJ)\expire.obj $(LIBNEWS) $(LIBFILE) $(LIBCOMM) $(DEFFILE)
        $(CC) $(LDOPT) $** $(OTHERLIBS)
!endif

fmt.$(COMEXET):      $(OBJ)\fmt.obj $(LIBFILE) $(LIBCOMM) $(DEFFILE)
        $(CC) $(LDOPT) $** $(OTHERLIBS)

fromwho.$(COMEXET):  $(OBJ)\fromwho.obj $(LIBFILE) $(LIBCOMM) $(DEFFILE)
        $(CC) $(LDOPT) $** $(OTHERLIBS)

!if "$(MODEL)" != "S"
genhist.$(COMEXET):  $(OBJ)\genhist.obj $(LIBNEWS) $(LIBFILE) $(LIBCOMM) $(DEFFILE)
        $(CC) $(LDOPT) $** $(OTHERLIBS)
!endif

gensig.$(COMEXET):   $(OBJ)\gensig.obj $(LIBFILE) $(LIBCOMM) $(DEFFILE)
        $(CC) $(LDOPT) $** $(OTHERLIBS)

!if "$(MODEL)" != "S"
newsrun.$(COMEXET):  $(OBJ)\newsrun.obj $(LIBNEWS) $(LIBFILE) $(LIBCOMM) $(DEFFILE)
        $(CC) $(LDOPT) $** $(OTHERLIBS)
!endif

novrstrk.$(COMEXET): $(OBJ)\novrstrk.obj $(LIBFILE) $(LIBCOMM) $(DEFFILE)
        $(CC) $(LDOPT) $** $(OTHERLIBS)

rnews.$(COMEXET):    $(OBJ)\rnews.obj $(LIBFILE) $(LIBCOMM) $(DEFFILE)
        $(CC) $(LDOPT) $** $(OTHERLIBS)

uucp.$(COMEXET):     $(OBJ)\uucp.obj $(LIBFILE) $(LIBCOMM) $(DEFFILE)
        $(CC) $(LDOPT) $** $(OTHERLIBS)

uuname.$(COMEXET):   $(OBJ)\uuname.obj $(LIBFILE) $(LIBCOMM) $(DEFFILE)
        $(CC) $(LDOPT) $** $(OTHERLIBS)

uupoll.$(COMEXET):   $(OBJ)\uupoll.obj $(LIBFILE) $(LIBCOMM) $(DEFFILE)
        $(CC) $(LDOPT) $** $(OTHERLIBS)

uuport.$(COMEXET):   $(OBJ)\uuport.obj $(LIBFILE) $(LIBCOMM) $(DEFFILE)
        $(CC) $(LDOPT) $** $(OTHERLIBS)

uustat.$(COMEXET):   $(OBJ)\uustat.obj $(LIBFILE) $(LIBCOMM) $(DEFFILE)
        $(CC) $(LDOPT) $** $(OTHERLIBS)

uusub.$(COMEXET):    $(OBJ)\uusub.obj $(LIBFILE) $(LIBCOMM) $(DEFFILE)
        $(CC) $(LDOPT) $** $(OTHERLIBS)

uux.$(COMEXET):      $(OBJ)\uux.obj $(LIBFILE) $(LIBCOMM) $(DEFFILE)
        $(CC) $(LDOPT) $** $(OTHERLIBS)

uuxqt.$(COMEXET):    $(OBJ)\uuxqt.obj $(LIBFILE) $(LIBCOMM) $(DEFFILE)
        $(CC) $(LDOPT) $** $(OTHERLIBS)

# *--------------------------------------------------------------------*
# *      DOS specific module builds, which use response files to       *
# *      get around command line length limits                         *
# *--------------------------------------------------------------------*

!if "$(OS)" == "DOS"


!if "$(MODEL)" == "S"

expire.exe:    always
        $(MAKE) -f $(MAKEFILE) MODEL=M $@

genhist.exe:    always
        $(MAKE) -f $(MAKEFILE) MODEL=M $@

mail.exe:       always
        $(MAKE) -f $(MAKEFILE) MODEL=M $@

newsrun.exe:    always
        $(MAKE) -f $(MAKEFILE) MODEL=M $@

rmail.exe:      always
        $(MAKE) -f $(MAKEFILE) MODEL=M $@

sendbats.exe:    always
        $(MAKE) -f $(MAKEFILE) MODEL=M $@

uucico.exe:     always
        $(MAKE) -f $(MAKEFILE) MODEL=M $@

comm34.com:     always
        $(MAKE) -f $(MAKEFILE) MODEL=T $@

fmt.com:        always
        $(MAKE) -f $(MAKEFILE) MODEL=T $@

fromwho.com:    always
        $(MAKE) -f $(MAKEFILE) MODEL=T $@

gensig.com:     always
        $(MAKE) -f $(MAKEFILE) MODEL=T $@

inews.com:      always
        $(MAKE) -f $(MAKEFILE) MODEL=T $@

novrstrk.com:   always
        $(MAKE) -f $(MAKEFILE) MODEL=T $@

rnews.com:      always
        $(MAKE) -f $(MAKEFILE) MODEL=T $@

uuname.com:     always
        $(MAKE) -f $(MAKEFILE) MODEL=T $@

uuport.com:     always
        $(MAKE) -f $(MAKEFILE) MODEL=T $@

uustat.com:     always
        $(MAKE) -f $(MAKEFILE) MODEL=T $@

uusub.com:      always
        $(MAKE) -f $(MAKEFILE) MODEL=T $@

uux.com:        always
        $(MAKE) -f $(MAKEFILE) MODEL=T $@

!else

mail.exe:     $(MAILOBJ) $(LIBFILE) $(LIBCOMM)
        $(LINKER) $(LINKOPT) @<<
$(MAILOBJ)
$@,,$(LIBFILE)+$(LIBCOMM);
<<

newsetup.exe:        $(NEWSETUPOBJ) $(LIBFILE) $(LIBCOMM)
        $(LINKER) $(LINKOPT) @<<
$(NEWSETUPOBJ)
$@,,$(LIBFILE)+$(LIBCOMM);
<<

rmail.exe:     $(RMAILOBJ) $(LIBFILE) $(LIBCOMM)
        $(LINKER) $(LINKOPT) @<<
$(RMAILOBJ)
$@,,$(LIBFILE)+$(LIBCOMM);
<<

rn.exe:        $(RNOBJ) $(LIBFILE) $(LIBCOMM)
        $(LINKER) $(LINKOPT) @<<
$(RNOBJ1)+
$(RNOBJ2)+
$(RNOBJ3)
$@,,$(LIBFILE)+$(LIBCOMM);
<<

sendbats.exe:     $(SENDBATSOBJ) $(LIBNEWS) $(LIBFILE) $(LIBCOMM)
        $(LINKER) $(LINKOPT) @<<
$(SENDBATSOBJ)
$@,,$(LIBNEWS)+$(LIBFILE)+$(LIBCOMM);
<<

uucico.exe:     $(UUCICOOBJ1) $(UUCICOOBJ3)\
                  $(LIBFILE) $(LIBCOMM)
        $(LINKER) $(LINKOPT) @<<
$(UUCICOOBJ1:   =+^
)+
$(UUCICOOBJ3)
$@,,$(LIBFILE)+$(LIBCOMM);
<<
!endif

uutraf.exe:      $(UUTRAFOBJ) $(LIBFILE) $(LIBCOMM)
        $(LINKER) $(LINKOPT) @<<
$(UUTRAFOBJ)
$@,,$(LIBFILE)+$(LIBCOMM);
<<

testulib.exe:   $(OBJ)\testulib.obj $(OBJ)\ulib.obj $(OBJ)\comm.obj \
                $(LIBFILE) $(LIBCOMM)
        $(LINKER) $(LINKOPT) @<<
$(OBJ)\testulib.obj $(OBJ)\ulib.obj $(OBJ)\comm.obj
$@,,$(LIBFILE)+$(LIBCOMM);
<<

!else

# *--------------------------------------------------------------------*
# *      Non-DOS module builds, which exploit OS/2 and Windows/NT      *
# *      longer command line to specify all the modules on the         *
# *      command line.                                                 *
# *--------------------------------------------------------------------*

mail.exe:     $(MAILOBJ) $(LIBFILE) $(LIBCOMM) $(DEFFILE)
        $(CC) $(LDOPT) $** $(OTHERLIBS)

newsetup.exe: $(NEWSETUPOBJ) $(LIBFILE) $(LIBCOMM) $(DEFFILE)
        $(CC) $(LDOPT) $** $(OTHERLIBS)

uupopd.exe:   $(UUPOPDOBJ) \
              $(LIBFILE) $(LIBCOMM) $(DEFFILE)
        $(CC) $(LDOPT) $** $(OTHERLIBS)

rn.exe:        $(RNOBJ) $(LIBFILE) $(LIBCOMM) $(DEFFILE)
        $(CC) $(LDOPT) $** $(OTHERLIBS)

rmail.exe:     $(RMAILOBJ) $(RMAILS_DELIVERS) $(LIBFILE) $(LIBCOMM) $(DEFFILE)
        $(CC) $(LDOPT) $** $(OTHERLIBS)

rmailn.exe:    $(RMAILOBJ:deliver.=delivern.) $(LIBFILE) $(LIBCOMM) $(DEFFILE)
        $(CC) $(LDOPT) $** $(OTHERLIBS)

sendbats.exe: $(SENDBATSOBJ) $(LIBNEWS) $(LIBFILE) $(LIBCOMM) $(DEFFILE)
        $(CC) $(LDOPT) $** $(OTHERLIBS)

uucico.exe:   $(UUCICOOBJ1) $(UUCICOOBJ2) $(UUCICOOBJ3) \
              $(LIBFILE) $(LIBCOMM) $(DEFFILE)
        $(CC) $(LDOPT) $** $(OTHERLIBS)

uusmtpd.exe:   $(UUSMTPDOBJ) \
              $(LIBFILE) $(LIBCOMM) $(DEFFILE)
        $(CC) $(LDOPT) $** $(OTHERLIBS)

# *--------------------------------------------------------------------*
# *                  UUCICO without TCP/IP support                     *
# *--------------------------------------------------------------------*

uucicon.exe:  $(UUCICOOBJ1:commlib=commlibn) $(UUCICOOBJ2) $(UUCICOOBJX) \
              $(LIBFILE) $(LIBCOMM) $(DEFFILE)
        $(CC) $(LDOPT) $** $(OTHERLIBS)

uutraf.exe:   $(UUTRAFOBJ) $(LIBFILE) $(LIBCOMM) $(DEFFILE)
        $(CC) $(LDOPT) $** $(OTHERLIBS)

regsetup.exe: $(OBJ)\regsetup.obj $(LIBFILE) $(LIBCOMM) $(DEFFILE)
        $(CC) $(LDOPT) $** $(OTHERLIBS)

uupcdll.dll:  $(OBJ)\uupcdll.obj uupcdll.exp
        $(CC) /LD $(LDOPT) $** $(OTHERLIBS:libcmt=msvcrt) -link -entry:DllMain -map:$(@B).map -force

uupcdll.exp:    uupcdll.def
        lib /out:$(@:exp=lib)  /machine:$(CPU) /def:$(@:exp=def)

uupcdll.def : nmake.mak nmakewnt.mak
        copy << $@
LIBRARY $(@B) BASE=000D0000
DESCRIPTION 'UUPC/extended $(VERS)  Copyright (c) 1989-1998 Kendra Electronic Wonderworks, All Rights Reserved'
CODE    execute,read
EXPORTS
        UUPCGetNewsSpoolSize
        UUPCGetParm
        UUPCInit
        UUPCSendMail
<<

dlltest.exe:  $(OBJ)/dlltest.obj
        $(CC) $(LDOPT) $** $(OTHERLIBS)

!endif

# *--------------------------------------------------------------------*
# *                          The zip files                             *
# *--------------------------------------------------------------------*

$(ZIPE1):  $(INSTALL1) $(README)
!if "$(OS)" != "OS/2_16_Bit"
       - if not exist $(@D) mkdir $(@D)
!endif
       -12 $(ZIP) $(ZIPOPT2) $@ < <<
       $(?: =^
       )
<<
       copy << +$(ZIPHEAD) $(WORKFILE)
Kendra Electronic Wonderworks: UUPC/extended $(VERS) $(OS:_= ) executables (1 of 3)
<<
       $(ZIP) -z $@  < $(WORKFILE)

$(ZIPE2):  $(INSTALL2) $(INSTALLS) $(README)
!if "$(OS)" != "OS/2_16_Bit"
       - if not exist $(@D) mkdir $(@D)
!endif
       -12 $(ZIP) $(ZIPOPT2) $@ < <<
       $(?: =^
       )
<<
       copy << +$(ZIPHEAD) $(WORKFILE)
Kendra Electronic Wonderworks: UUPC/extended $(VERS) $(OS:_= ) executables (2 of 3)
<<
       $(ZIP) -z $@  < $(WORKFILE)

$(ZIPE3):  $(INSTALL3) $(README)
!if "$(OS)" != "OS/2_16_Bit"
       - if not exist $(@D) mkdir $(@D)
!endif
       -12 $(ZIP) $(ZIPOPT2) $@ < <<
       $(?: =^
       )
<<
       copy << +$(ZIPHEAD) $(WORKFILE)
Kendra Electronic Wonderworks: UUPC/extended $(VERS) $(OS:_= ) executables (3 of 3)
<<
       $(ZIP) -z $@  < $(WORKFILE)

# *--------------------------------------------------------------------*
# *                           UUPCSRC.ZIP                              *
# *--------------------------------------------------------------------*

$(SRCZIPV1):  borlandc.mak NMAKE.MAK NMAKEDOS.MAK NMAKEWNT.MAK \
             NMAKOS21.MAK NMAKOS22.MAK \
             $(DOCS)\rmail.pif $(DOCS)\uuxqt.pif $(DOCS)\uuclean.pif \
             $(README)
!if "$(OS)" != "OS/2_16_Bit"
       - if not exist $(@D) mkdir $(@D)
!endif
       -18 $(ZIP) $(ZIPOPT1) $@ < <<
*.MAK
LIB\*.C
LIB\*.H
LIB\*.MAK
WINSOCK\*.H
$(README)
DOCS\*.pif
<<
       copy << +$(ZIPHEAD) $(WORKFILE)
Kendra Electronic Wonderworks: UUPC/extended $(VERS) source (1 of 4)
<<
       $(ZIP) -z $@  < $(WORKFILE)

$(SRCZIPV2): borlandc.mak nmake.mak $(README)
!if "$(OS)" != "OS/2_16_Bit"
       - if not exist $(@D) mkdir $(@D)
!endif
       -18 $(ZIP) $(ZIPOPT1) $@ < <<
UUCICO\*.ASM
UUCICO\*.C
UUCICO\*.H
UUCICO\*.MAK
$(README)
<<
       copy << +$(ZIPHEAD) $(WORKFILE)
Kendra Electronic Wonderworks: UUPC/extended $(VERS) source (2 of 4)
<<
       $(ZIP) -z $@  < $(WORKFILE)

$(SRCZIPV3): borlandc.mak nmake.mak $(README)
!if "$(OS)" != "OS/2_16_Bit"
       - if not exist $(@D) mkdir $(@D)
!endif
       -18 $(ZIP) $(ZIPOPT1) $@ < <<
MAIL\*.C
MAIL\*.H
MAIL\*.MAK
UUCP\*.C
UUCP\*.H
UUCP\*.MAK
$(README)
<<
       copy << +$(ZIPHEAD) $(WORKFILE)
Kendra Electronic Wonderworks: UUPC/extended $(VERS) source (3 of 4)
<<
       $(ZIP) -z $@  < $(WORKFILE)

$(SRCZIPV4): borlandc.mak nmake.mak $(README)
!if "$(OS)" != "OS/2_16_Bit"
       - if not exist $(@D) mkdir $(@D)
!endif
       -18 $(ZIP) $(ZIPOPT1) $@ < <<
NEWS\*.C
NEWS\*.H
NEWS\*.MAK
TEST\*.C
TEST\*.H
TEST\*.MAK
UTIL\*.C
UTIL\*.H
UTIL\*.MAK
SCRIPTS\*.CMD
SCRIPTS\*.BAT
UUTRAF\*.C
UUTRAF\*.H
UUTRAF\*.MAK
UUTRAF\CREDITS
$(README)
<<
       copy << +$(ZIPHEAD) $(WORKFILE)
Kendra Electronic Wonderworks: UUPC/extended $(VERS) source (4 of 4)
<<
       $(ZIP) -z $@  < $(WORKFILE)


# *--------------------------------------------------------------------*
# *                    Word for Windows ZIP file                       *
# *--------------------------------------------------------------------*

$(WORDZIP):  $(INSTALLW) $(README)
!if "$(OS)" != "OS/2_16_Bit"
       - if not exist $(@D) mkdir $(@D)
!endif
       -12 $(ZIP) $(ZIPOPT2) $@ < <<
       $(?: =^
       )
<<
       copy << +$(ZIPHEAD) $(WORKFILE)
Kendra Electronic Wonderworks: UUPC/extended $(VERS) Documentation (Word for Windows)
<<
       $(ZIP) -z $@  < $(WORKFILE)

$(HTMLZIP):  $(INSTALLH) $(README)
!if "$(OS)" != "OS/2_16_Bit"
       - if not exist $(@D) mkdir $(@D)
!endif
       -12 $(ZIP) $(ZIPOPT2) $@ < <<
       $(?: =^
       )
<<
       copy << +$(ZIPHEAD) $(WORKFILE)
Kendra Electronic Wonderworks: UUPC/extended $(VERS) Documentation (HTML)
<<
       $(ZIP) -z $@  < $(WORKFILE)

# *--------------------------------------------------------------------*
# *                     Handle shared libraries                        *
# *--------------------------------------------------------------------*

!ifdef DLLNAME

!if "$(DLLPROD)" == "$(DLLDIR)"
!error Prod DLL directory "$(DLLPROD)" must not equal input directory
!endif

$(DLLPROD)\$(DLLNAME):      $(DLLDIR)\$(RTLDLL)
        - erase $@
        copy $? $@
        dllrname /n /q $@ $(?B)=$(@B)
        @echo Binding messages from  $(MSGFILE) to $@
        msgbind <<
>$@
<$(MSGFILE)
*
<<
!endif

# *--------------------------------------------------------------------*
# *                    Build the object libraries                      *
# *--------------------------------------------------------------------*

!ifdef WIN32ENV

$(LIBCOMM): $(LIBCOMMLIST)
         lib /out:$@ @<<
$(LIBCOMMLIST)
<<

$(LIBFILE): $(LIBFILELIST)
         lib /out:$@ @<<
$(LIBFILELIST)
<<

$(LIBNEWS): $(LIBNEWSLIST)
         lib /out:$@ @<<
$(LIBNEWSLIST)
<<

!else
$(LIBFILE): $(LIBFILELIST)
        lib /nologo /noignorecase $@ @<<
-+$(?: =&^
-+)
nul;
<<

$(LIBCOMM): $(LIBCOMMLIST)
        lib /nologo /noignorecase $@ @<<
-+$(?: =&^
-+)
nul;
<<

$(LIBNEWS): $(LIBNEWSLIST)
        lib /nologo /noignorecase $@ @<<
-+$(?: =&^
-+)
nul;
<<

!endif

# *--------------------------------------------------------------------*
# *     The timestamp module has a reference to this MAKEFILE,         *
# *     which insures whenever we change the version number the        *
# *     time stamp gets re-generated.                                  *
# *--------------------------------------------------------------------*

$(TIMESTMP): $(MAKEFILE) $(REGEN) \
             nmakedos.mak nmakos22.mak nmakewnt.mak nmakos21.mak

# *--------------------------------------------------------------------*
# *     Header file with our version number for timestmp.c             *
# *--------------------------------------------------------------------*

$(UULIB)\win32ver.h: $(MAKEFILE) $(REGEN)
        copy << $@
/*--------------------------------------------------------------------*/
/*         DO NOT EDIT -- AUTOMATICALLY GENERATED BY MAKEFILE         */
/*--------------------------------------------------------------------*/

#define UUPCV "$(VERS)"         /* UUPC/extended version number */
<<

# *--------------------------------------------------------------------*
# *     Force a regeneration of the time stamp/version module.         *
# *--------------------------------------------------------------------*

regen:  $(UULIB)\timestmp.c
        - if exist $(LIBCOMM) $(ERASE) $(LIBCOMM)
        - if exist $(LIBFILE) $(ERASE) $(LIBFILE)
        - if exist $(LIBNEWS) $(ERASE) $(LIBNEWS)
        - $(ERASE) $(OBJ)\timestmp.obj

# *--------------------------------------------------------------------*
# *         Generate the source browser database for the PWB           *
# *--------------------------------------------------------------------*

$(MAKEFILE).bsc: $(SBRS)
        pwbrmake @<<
/o $(MAKEFILE).bsc $(SBRS)
<<

$(OBJ):
       - if not exist $@\*.* mkdir $@

always:
        @rem no operation

# *--------------------------------------------------------------------*
# *      Definition file.  Built dynamically so it automatically       *
# *      includes the correct version nuber.                           *
# *--------------------------------------------------------------------*

!ifdef DEFFILE
$(DEFFILE):     $(MAKEFILE) nmakos22.mak nmakos21.mak
       copy << $@
NAME WINDOWCOMPAT NEWFILES
DESCRIPTION 'UUPC/extended $(VERS), Changes Copyright (c) 1989-1998 Kendra Electronic Wonderworks, All Rights Reserved'
PROTMODE
STACKSIZE $(STACKSIZE)
SEGMENTS
  '_MSGSEG32' CLASS 'CODE' LOADONCALL
<<
!endif

# *--------------------------------------------------------------------*
# *      Lastly, include the rules for building the object             *
# *      files.  This line can be deleted, but then you lose the       *
# *      automatic recompiles when header files are updated.           *
# *--------------------------------------------------------------------*

!include "nmakeinc.mak"
