<<<<<<<<<<<< OS/2 WARP 3.0 USNET INTERNET HOWTO V 1.0.1  1/11/95 >>>>>>>>>>>>>>
Authored by Richard E. Esposito (esposito@us.net)
Please send any comments to support@us.net as I do not have time to support
this code.  I am providing it AS IS.
.............................................................................

In my opinion, nothing I've seen comes close to the software provided
with OS/2 WARP 3.0 for accessing the INTERNET.  I spent many hours
coming up with the following configuration which seems to work so far.
Information was delved from IBM's OS/2 Online Book Collection CD-ROM
and the Linux NET-2 HOWTO by Terry Dawson (terryd@extro.ucc.su.oz.au)
and Matt Welsh (mdw@sunsite.unc.edu)

Please feel free to experiment with it.  Send any improvements to
support@us.net whom I assume will maintain this document and code.

This setup does not require a dedicated IP address as it dynamically creates
the hosts file after achieving a modem connection.

NOTE: Sometimes the Ulti-mail/2 "In-basket" kicks off prematurely and reports
      "In-basket-refreshed failed!".  If this happens, close that information
      window and click the pull-down "In-basket/Refresh" to recover when disk
      activity settles down.

The setup requires 3 files:

1) c:\tcpip\etc\hosts.tcp
2) c:\tcp\etc\networks
3) c:\tcpip\bin\usnet.cmd

plus entries for "Dial Other Internet Providers" (Add/Modify Provider).

Be sure to substitute your user-ID and password for mine ( esposito
and <password> ) throughout.

Once this is set up and running, you can use "Retrieve Software Updates"
to get the "Web Explorer" Software.

GOOD LUCK!

c:\tcpip\etc\hosts.tcp
========================================================================
127.0.0.1          localhost
198.240.64.2       usnet.us.net nameserver
198.240.64.3       ns.us.net ftp.us.net
198.240.72.4       laurel.us.net
========================================================================

c:\tcp\etc\networks
========================================================================
default  0.0.0.0   # default route - mandatory
loopnet  127.0.0.0 # loopback network - mandatory
usnet64  198.240.64.0
usnet72  198.240.72.0
========================================================================

Entries for "Dial Other Internet Providers" (Add/Modify Provider)
========================================================================
*Provider name: US Net
 Login ID: esposito
 Password: <my password>
*Nickname: Esposito
*Phone number: 792-8817
 Login script: usenet.cmd atdt792-8817 esposito <my password>
 Connection type: SLIP
 Minutes to wait before hangup: 5
------------------------------------------------------------------------
*Your IP address: (grayed out)
*Destination IP address: (grayed out)
 Netmask: (grayed out)
*MTU size: 1006
 VJ Compression: (checked)
*Domain Nameserver: 198.240.64.2
 Your Host Name: esposito@us.net
*Your Domain name: us.net
------------------------------------------------------------------------
 News Server: news.us.net
 Gopher Server: boombox.micro.umn.edu
 WWW Server: http://www.ncsa.uiuc.edu
 POP Mail Server: mail.us.net
 Reply Domain: us.net
 Reply (mail) ID: esposito@us.net
 POP Login ID: esposito
 POP Password: <my password>
------------------------------------------------------------------------
 Modem Type: (grayed out)
 Com Port: com2
 Speed (Baud): 57600
 Data Bits: 8
 Parity: NONE
 Dial Prefix: (grayed out)
 Initialization String 1: (grayed out ATDT)
 Initialization String 2: (grayed out ~AT X4 E0 V1)
 Call Waiting Disable: (grayed out)
 Call Waiting Disable Sequence: (grayed out *70)
========================================================================

c:\tcpip\bin\usnet.cmd command file
==============================================================================
/*--------------------------------------------------------------------------*/
/*                                                                          */
/*        OS/2 2.1 / WARP REX Driver for IBM TCP/IP version 2.1 / REE       */
/*            (BOOTP Version - Does not need dedicated IP address)          */
/*                                                                          */
/*        NOTE: You must preinstall the "C:\tcpip\etc\host.tcp" and         */
/*              "C:\tcpip\etc\networks" files.                              */
/*                                                                          */
/*                                USNET.CMD                                 */
/*                                                                          */
/*            ..................................................            */
/*                                                                          */
/* Attachment script for dialing into a USNET terminal                      */
/* server in order to establish a SLIP connection.                          */
/*                                                                          */
/* The script parameters specify the command to send to the modem to dial   */
/* the remote site and the UserID/Password combination to use to log into   */
/* the terminal server.                                                     */
/*                                                                          */
/* For example, the following should be used with SlipPM's Dial Other       */
/* Internet Providers settings book:                                        */
/*                                                                          */
/*       Login Script: usnet.cmd ATDT792-8817 LoginID Password              */
/*                                                                          */
/* which would then feeds the "ATDT792-8817" command to the modem, followed */
/* by the Login ID and Password once the connection is established.         */
/*                                                                          */
/*            - - - - - - - - - - - - - - - - - - - - - - - - -             */
/*                                                                          */
/* When the script runs, it is automatically passed the interface name for  */
/* the interface it is running on as the first argument, followed by the    */
/* user arguments.                                                          */
/*                                                                          */
/* The script sends the dial string to the modem and then logs into the     */
/* terminal server using the username/password.  It then issues the SLIP    */
/* command to start SLIP, and parses the resulting output to determine the  */
/* appropriate addresses to use.  Lastly, it issues ifconfig and route      */
/* commands to configure the OS/2 system appropriately.  Note that the      */
/* configuration assumes a class C netmask for the SLIP interface.          */
/*                                                                          */
/*--------------------------------------------------------------------------*/

parse arg interface , dialcmd username password

/*--------------------------------------------------------------------------*/
/*                   Initialization and Main Script Code                    */
/*--------------------------------------------------------------------------*/

/* Set some definitions for easier COM strings */
cr='0d'x
crlf='0d0a'x

say ' '
say 'USNET - US Net Internet Gateway SLIP Connection Script ',
    '(interface' interface')'

/* Prompt for missing information */
if dialcmd = '' | dialcmd = '*' then do
   call charout , 'Dial Command: '
   parse pull dialcmd
end
else do
   say 'Dial Command: ' dialcmd
end

if username = '' | username = '*' then do
   call charout , 'User Name: '
   parse pull username
end
else do
   say 'User:' username
end

if password = '' | password = '*' then do
   call charout , 'Password: '
   password = readpass()
end

/* Flush any stuff left over from previous COM activity */
call flush_receive

/* Reset the modem here */
/* You may need to customize this for your modem make and model */
call lineout , 'Reset modem...'

/* This setup string is for the ZOOM FAX14.4 modem */
call send 'AT&FX4&C1&D2&K3&Q5&R0S11=55S95=35' || cr

/* The following is for generic Hayes compatible modems */
/* call send 'ATZ&C1&D2' || cr */
/* call send 'ATE1Q0V1X4' || cr */

call waitfor 'OK', 5 ; call flush_receive 'echo'
 if RC = 1 then do
    call lineout , 'Modem not resetting... Trying again'
    call send '+++'
    call waitfor 'OK'
    call send 'ATHZ' || cr
    call waitfor 'OK', 3
  end

/* Send Dial instructions for the remote server */
call charout , 'Now Dialing...'

/* Wait for USNET connection */
call send dialcmd || cr
call waitfor 'CONNECT' ; call waitfor crlf

/* Handle login.  Wait for standard strings, and then flush anything */
/* else to take care of trailing spaces, etc..                       */
/* call send cr */
call waitfor 'login:' ; call flush_receive 'echo'
call send username || cr
call waitfor 'Password:' ; call flush_receive 'echo'
call send password || cr
call waitfor 'usnet> '; call flush_receive 'echo'
call send 'slip' || cr

/* Parse the results of the SLIP command to determine our address.   */
/* We use the "waitfor_buffer" variable from the waitfor routine     */
/* to parse the stuff we get from US Net after waiting for an        */
/* appropriate point in the data stream.                             */

call waitfor 'abled'
parse var waitfor_buffer .  'IP address is IP=' a '.' b '.' c '.' d '.' .
os2_address = a||'.'||b||'.'||c||'.'||d
/* Flush anything else beyond 14 characters */
call flush_receive 'echo'
os2_address = DELSTR(os2_address, 14)

/* Specify US Net address */
usnet_address = '198.240.64.2'

/* Create a valid hosts file including dynamic IP address */
/* Must match YOUR HOST NAME in Dial Other Internet Providers folder */
host_name = 'esposito@us.net'

/* Initialize hosts file sans the local entry */
say 'creating hosts file'

'COPY c:\tcpip\etc\hosts.tcp c:\tcpip\etc\hosts'

/* add local entry to hosts file */
say 'adding local IP entry to hosts file'
line_out = os2_address||' '||host_name
hosts = 'c:\tcpip\etc\hosts'
lineout(hosts, line_out)

say 'testing...'

/* Attach the loopback device */
'ifconfig lo 127.0.0.1'
'route add 127.0.0.1 1'
/* end loopback definition */

'hostname -S esposito.us.net'

/* Now configure this host for the appropriate address, */
/* and for a default route through the US Net.          */

say 'SLIP Connection Established'

say 'Configuring local address =' os2_address ', US Net =' usnet_address
'ifconfig sl0 ' os2_address usnet_address ' up netmask 255.255.0.0'
'ifconfig sl0 ' os2_address ' pointopoint ' usnet_address

say 'Routing default =' usnet_address
'route add default ' usnet_address ' 1'

/* All done */
exit 0

/*--------------------------------------------------------------------------*/
/*                            send ( sendstring)                            */
/*..........................................................................*/
/*                                                                          */
/* Routine to send a character string off to the modem.                     */
/*                                                                          */
/*--------------------------------------------------------------------------*/

send:

   parse arg sendstring
   call slip_com_output interface , sendstring

   return

/*--------------------------------------------------------------------------*/
/*                    waitfor ( waitstring , [timeout] )                    */
/*..........................................................................*/
/*                                                                          */
/* Waits for the supplied string to show up in the COM input.  All input    */
/* from the time this function is called until the string shows up in the   */
/* input is accumulated in the "waitfor_buffer" variable.                   */
/*                                                                          */
/* If timeout is specified, it says how long to wait if data stops showing  */
/* up on the COM port (in seconds).                                         */
/*                                                                          */
/*--------------------------------------------------------------------------*/

waitfor:

   parse arg waitstring , timeout

   if timeout = '' then
     timeout = 5000    /* L O N G   delay if not specified */
   waitfor_buffer = '' ; done = -1; curpos = 1
   ORI_TIME=TIME('E')

   if (remain_buffer = 'REMAIN_BUFFER') then do
      remain_buffer = ''
   end

   do while (done = -1)
      if (remain_buffer \= '') then do
         line = remain_buffer
         remain_buffer = ''
       end
       else do
         line = slip_com_input(interface,,10)
      end
      waitfor_buffer = waitfor_buffer || line
      index = pos(waitstring,waitfor_buffer)
      if (index > 0) then do
         remain_buffer = substr(waitfor_buffer,index+length(waitstring))
         waitfor_buffer = delstr(waitfor_buffer,index+length(waitstring))
         done = 0
      end
      call charout , substr(waitfor_buffer,curpos)
      curpos = length(waitfor_buffer)+1
      if ((done \= 0) & (TIME('E')>timeout)) then do
        call lineout , ' WAITFOR: timed out '
        done = 1
       end
   end
   timeout=0
   RC=done
 return RC

/*--------------------------------------------------------------------------*/
/*                               readpass ()                                */
/*..........................................................................*/
/*                                                                          */
/* Routine used to read a password from the user without echoing the        */
/* password to the screen.                                                  */
/*                                                                          */
/*--------------------------------------------------------------------------*/

readpass:

  answer = ''
  do until key = cr
      key = slip_getch()
    if key \= cr then do
      answer = answer || key
    end
  end
  say ' '
  return answer

/*--------------------------------------------------------------------------*/
/*                             flush_receive ()                             */
/*..........................................................................*/
/*                                                                          */
/* Routine to flush any pending characters to be read from the COM port.    */
/* Reads everything it can until nothing new shows up for 100ms, at which   */
/* point it returns.                                                        */
/*                                                                          */
/* The optional echo argument, if 1, says to echo flushed information.      */
/*                                                                          */
/*--------------------------------------------------------------------------*/

flush_receive:
   parse arg echo

   /* If echoing the flush - take care of waitfor remaining buffer */
   if (echo \= '') & (length(remain_buffer) > 0) then do
      call charout , remain_buffer
      remain_buffer = ''
   end

   /* Eat anything left in the modem or COM buffers */
   /* Stop when nothing new appears for 100ms.      */

   do until line = ''
     line = slip_com_input(interface,,100)
     if echo \= '' then
        call charout , line
   end

   return
============================================================================
<<<<<<<< END OF HOWTO DOCUMENT >>>>>>>>>>>
