/* Rexx - URLChecker/0.0.2 */

/****************************************************************************/
/* load the rexx socket functions from rxsock.dll (must be in libpath)      */
/****************************************************************************/
if RxFuncQuery('SockLoadFuncs') then
  do
   rc = RxFuncAdd('SockLoadFuncs','RxSock','SockLoadFuncs')
   rc = SockLoadFuncs()
  end

parse arg file

inifile='URLChecker.ini'

rc=stream(file,'c','open read')
URL=linein(file)
rc=stream(file,'c','close')

say 'Checking "' || URL || '" from "' || file ||'"...'

last_modified = SysINI(inifile,URL,'Last-Modified')
if last_modified='ERROR:' then last_modified=''

info=retrieve(url,last_modified)
/* say 'retrieve()='info */

parse value info with status data1
/* say 'Status:' status
say 'Data1:' data1 */

select
 when status=200 then
  do
    say 'Document was modified...'
    rc=SysSetIcon(file,'MODIFIED.ICO')
    say ' Old Last-Modified:' last_modified
    say ' New Last-Modified:' data1
    rc=SysINI(inifile,URL,'Last-Modified',data1)
  end
 when status=304 then rc=SysSetIcon(file,'NOTMODIFIED.ICO')
 when status=0 then rc=SysSetIcon(file,'NOCONNECT.ICO')
 when status=404 then rc=SysSetIcon(file,'NOTFOUND.ICO')
 otherwise NOP
end

return 0

retrieve: procedure
 parse arg url,last_modified

crlf='0D0A'x
use_proxy=0
proxy_ip=''
proxy_port=''
parse value url with 'http://'hostname'/'path
if use_proxy=0 then parse value hostname with hostname':'port
 else
  do
   hostname=proxy_ip
   port=proxy_port
  end

if use_proxy=0 then
 do
  httpheader='GET /'path 'HTTP/1.0'crlf'User-Agent: URLChecker/0.0.2 (OS/2; M.Haller)'crlf'If-Modified-Since:'last_modified || crlf || crlf
 end
else
 do
  httpheader='GET' url 'HTTP/1.0'crlf'Host:'hostname||crlf'User-Agent: URLChecker/0.0.2 (OS/2; M.Haller)'crlf'If-Modified-Since:'last_modified || crlf || crlf
 end
  
  if port='' then port=80
  
/* say 'Hostname='hostname 'Port='port 'Path='path 'URL='url
say 'HTTPHeader: ['httpheader']' */

parse value hostname with ip1'.'ip2'.'ip3'.'ip4
if datatype(ip1,'NUM')&datatype(ip2,'NUM')&datatype(ip3,'NUM')&datatype(ip4,'NUM') then
 do
  ip_address = hostname
 end
else
 do
  rc = SockGetHostByName(hostname,'host.')
  if rc = '0' then return '0'
  ip_address = host.addr
 end

select
 when use_proxy = 1 then /* use the proxy */
  do
   http_server.family = 'AF_INET'
   http_server.port   = proxy_port
   http_server.addr   = proxy_ip
  end
 otherwise /* do not use the proxy */
  do
   http_server.family = 'AF_INET'
   http_server.port   = port
   http_server.addr   = ip_address
  end
end

/****************************************************************************/
/* open a socket                                                            */
/****************************************************************************/
socket = SockSocket('AF_INET','SOCK_STREAM',0)
if socket = '-1' then return '0'

/****************************************************************************/
/* connect to the server, if unsuccessfull exit with 0                      */
/****************************************************************************/
/*   say 'Connecte zu' http_server.addr 'auf Port' http_server.port 'auf Socket' socket */
  rc = SockConnect(socket,'http_server.')
if rc = '-1' then return '0'

rc = SockSend(socket,httpheader)

data = ''
do while rc > 0
  rc = SockRecv(socket,'newData',2048)
  if rc = '-1' then return '0'
  data = data || newData
end

rc = SockSoClose(socket)
if rc = '-1' then return '0'

parse var data with status .

  statusdata=GetHTTPParm(data,'Last-Modified')
  if statusdata='' then statusdata=GetHTTPParm(data,'Last-modified')

return status statusdata

GetHTTPParm:
  parse arg Text,Tag
  TagPosition = pos(translate(Tag),translate(Text))
  Wert = ''
  if TagPosition>0 then
    do
     TagLength=length(Tag)
     ParmPos=TagPosition+TagLength+2  /* 2=  ": " */
     LinefeedPos=pos(crlf,Text,ParmPos)
     if LinefeedPos=0 then LinefeedPos=pos(d2c(13),Text,ParmPos)
     if LinefeedPos=0 then LinefeedPos=pos(d2c(10),Text,ParmPos)
     ParmLength=LinefeedPos - Parmpos
     if (ParmPos>0) & (ParmLength>0) then Wert=substr(Text,ParmPos,ParmLength)
    end
return Wert
