/*
   U2PMMAIL--A batch file processor that will unburst ULTIMAIL bursted letters
   and add them to PMMAIL. Run this command from the PMMAIL directory. It will
   request the path of the ULTIMAIL folder that you wish to add:
     e.g. C:\tcpip\UMAIL\MAIL\Bob\Business.
   It will then request the PMMAIL folder you wish to add the letters to. U2PMMAIL
   will merge the files with the envelopes and move them to the selected PMMAIL 
   folder and update the "bag." U2PMMAIL will save the original "bag." U2PMMAIL.LOG
   Is a text file that reports on the success or failure of each letter that was 
   converted in the folder, and the name of the old "bag." This command file will not
   over-write the original mail, and old "bag is easily restored. Multimedia attachments
   will not be restored and the textfile will report this. U2PMMAIL must be run for 
   each ULTIMAIL folder you wish to convert.

   (c) 1995 Curtis C. Hovey.
*/


/*  
  Add RexxUtil functions 
*/

call RxFuncAdd 'SysLoadFuncs', 'RexxUtil', 'SysLoadFuncs'
call SysLoadFuncs


/*
  --Initialize UmailDir, Envelopes, PmmailFol, Folders, PmmailBag; open log--
*/

parse Arg Info
crlf = '0D0A'x

if lines('U2PMMAIL.LOG') \= 0 then
   do
      call stream 'U2PMMAIL.LOG','c','seek <0'
      call charout 'U2PMMAIL.LOG', crlf || crlf
   end
call lineout 'U2PMMAIL.LOG','============================================================================='
call lineout 'U2PMMAIL.LOG',date('L')', 'time('C')


/*
  Main
*/

/* Get the source information */

if word(Info, 1) =  '' then
   do 
      say 'What is the path of the Ultimail directory you wish to migrate?'
      pull UmailDir
   end
else
   do
      UmailDir = word(Info,1)
   end

call SysFileTree Umaildir'\*.ENV', 'Envelopes', FO
if Envelopes.0 = 0 then
   do
      say 'No Envelopes were found in 'UmailDir
      call stream 'U2PMMAIL.LOG','c','close'
      exit
   end


/* Get the target information */

if word(Info, 2) = '' then
   do
      say 'What is the name of PM Mail folder use wish to place the mail in?'
      say '(Folders names are case sensative)'
      parse pull PmmailFol
      if PmmailFol = '' then
         do
            PmmailFol = 'Inbox'
         end
   end
else
   do
      PmmailFol = word(Info, 2)
   end

if lines('FOLDERS.INI') = 0 then
   do
      say 'Cannot locate FOLDERS.INI. This command must be run from the PMMAIL directory.'
      call stream 'U2PMMAIL.LOG','c','close'
      exit
   end

PmmailBag = ''
do while lines('FOLDERS.INI') = 1
   Folders = linein('FOLDERS.INI')
   if Folders = PmmailFol then PmmailBag = linein('FOLDERS.INI')
   if PmmailBag \= '' then leave
end /* do while */
call stream 'FOLDERS.INI','c','close'

if PmmailBag = '' then
   do
      say 'The folder ' || PmmailFol || ' does not exist.'
      say 'You must create it in PMMail first.'
      call stream 'U2PMMAIL.LOG','c','close'
      exit
   end


/*  Report the variables */

call lineout 'U2PMMAIL.LOG',''
call lineout 'U2PMMAIL.LOG','-----------------------------------------------------------------------------'
call lineout 'U2PMMAIL.LOG','   UmailDir is 'UmailDir
do Env = 1 to Envelopes.0
   call lineout 'U2PMMAIL.LOG','      Envelope 'Env' is 'Envelopes.Env
end /* do */
call lineout 'U2PMMAIL.LOG','   PmmailFol is 'PmmailFol
call lineout 'U2PMMAIL.LOG','   PmmailBag is 'PmmailBag
call lineout 'U2PMMAIL.LOG','-----------------------------------------------------------------------------'


/*  Prepare Bag */

copy PmmailBag'.BAG' PmmailBag'.OLD'
if rc \= 0 then
   do
      call lineout 'U2PMMAIL.LOG','Cannot copy 'PmmailBag'.BAG to 'PmmailBag'.OLD.'
      call stream 'U2PMMAIL.LOG','c','close'
      exit
   end
else
   do
      call lineout 'U2PMMAIL.LOG',PmmailBag'.bag copied to 'PmmailBag'.OLD.'
   end

LetterCount = linein(PmmailBag'.bag')
LetterCount = word(LetterCount,1)
LCLength = length(LetterCount)+2
if LetterCount <> 0 then
   TempBag = charin(PmmailBag'.bag',LCLength+1,chars(PmmailBag'.bag')-LCLength)
else
   TempBag = ''
call lineout 'U2PMMAIL.LOG','There are 'LetterCount' letters already in 'PmmailFol'.'


/*  Unburst Ultimail envelopes */

do Env = 1 to Envelopes.0

   TempFile =   ''
   Header =     0
   HeadField =  ''
   BagDD =      ''
   BagMon =     ''
   BagMM =      ''
   BagYY =      ''
   BagTime =    ''
   BagSub =     ''
   BagFrom =    ''
   BagName =    ''
   BagContent = ''
   LetterBody = ''
   Skip =       0

   call linein Envelopes.Env,,0

   do while lines(Envelopes.Env) = 1
      ln = linein(Envelopes.Env)
      HeadField = Word(ln,1)
      select
         when HeadField = 'Date:' then
            do
               BagDD = word(ln,3)
               BagMon = word(ln,4)
               select
                  when BagMon = 'Jan' then BagMM = '01'
                  when BagMon = 'Feb' then BagMM = '02'
                  when BagMon = 'Mar' then BagMM = '03'
                  when BagMon = 'Apr' then BagMM = '04'
                  when BagMon = 'May' then BagMM = '05'
                  when BagMon = 'Jun' then BagMM = '06'
                  when BagMon = 'Jul' then BagMM = '07'
                  when BagMon = 'Aug' then BagMM = '08'
                  when BagMon = 'Sep' then BagMM = '09'
                  when BagMon = 'Oct' then BagMM = '10'
                  when BagMon = 'Nov' then BagMM = '11'
                  otherwise BagMM = '12'
               end  /* select */
               if wordlength(ln,5) = 2 then
                  do
                     BagYY = word(ln,5)
                  end
               else
                  do
                     BagYY = substr(word(ln,5),3,2)
                  end
               BagTime = word(ln,6)
            end
         when HeadField = 'Subject:' then BagSub = subword(ln,2)
         when HeadField = 'From:' then
            do
               if words(ln) = 2 then
                 do
                    BagFrom = word(ln,2)
                    BagName = '(null)'
                 end
               else
                 do
                    BagFrom = word(ln,words(ln))
                    BagFrom = substr(BagFrom,2,length(BagFrom)-2)
                    BagName = subword(ln,2,words(ln)-2)
                    BagName = substr(BagName,2,length(BagName)-2)
                 end
            end
         when HeadField = 'Content-Type:' then
            do
               if translate(word(ln,2)) = 'TEXT/PLAIN;' then
                  do
                     BagContent = subword(ln,1,words(ln)-1)
                     BagContent = substr(BagContent,1,length(BagContent)-1)
                     LetterBody = word(ln,words(ln))
                     LetterBody = substr(LetterBody,10)
                     FileSize = chars(UmailDir'\'LetterBody)

                     if FileSize = '' then
                        do
                           call lineout 'U2PMMAIL.LOG',"   Unable to open "Envelopes.Env"'s body -- "UnailDir'\'LetterBody'.'
                           Skip = 1
                        end

                     TempFile = TempFile || BagContent || crlf || crlf
                     TempFile = TempFile || charin(UmailDir'\'LetterBody,1,FileSize)
                     call stream UmailDir'\'LetterBody,'c','close'
                     leave
                  end
               else
                  do
                     Header = 1
                  end
            end
         otherwise nop
      end  /* select */

      if Header = 0 then
         do
            TempFile = TempFile || ln || crlf
         end
   
   end /* do while */

   call stream Envelopes.Env,'c','close'

/* Create PMMail message and update bag */

   if skip = 1 then iterate
   
   PmmailMsg = substr(LetterBody,3,6)
   PmmailMsg = PmmailMsg'00.msg'

   if lines('FOLDERS\'PmmailBag'\'PmmailMsg) = 0 then
      do
         call charout 'FOLDERS\'PmmailBag'\'PmmailMsg, TempFile
      end
   else
      do
         erase 'FOLDERS\'PmmailBag'\'PmmailMsg
         call charout 'FOLDERS\'PmmailBag'\'PmmailMsg, TempFile
      end

   if Result = 0 then
      do 
         call lineout 'U2PMMAIL.LOG', '      'PmmailMsg' created from 'Envelopes.Env'.'
      end
   else
      do
         call lineout 'U2PMMAIL.LOG', '   Failed to create 'PmmailMsg' from 'Envelopes.Env'.'
         iterate
      end

   call stream 'FOLDERS\'PmmailBag'\'PmmailMsg,'c','close'

  if length(TempBag) > 0 then
     TempBag = TempBag || crlf || BagYY'-'BagMM'-'BagDD''BagTime''BagSub''BagFrom''BagName''PmmailMsg'Y'
  else
     TempBag = BagYY'-'BagMM'-'BagDD''BagTime''BagSub''BagFrom''BagName''PmmailMsg'Y'
  LetterCount = LetterCount+1

end /* do Envelopes */

/* write new bag */

call charout PmmailBag'.bag', LetterCount || crlf || TempBag,1
if Result = '0' then
   do
      call lineout 'U2PMMAIL.LOG', '   'PmmailBag'.bag was created.'
   end
else
   do
      call lineout 'U2PMMAIL.LOG', '   Error: 'PmmailBag'.bag was not created.'
   end

call stream PmmailBag'.bag','c','close'

/* write end to log */

call lineout 'U2PMMAIL.LOG', LetterCount' messages are now in 'PmmailFol'.'
call lineout 'U2PMMAIL.LOG','-----------------------------------------------------------------------------'
call stream 'U2PMMAIL.LOG','c','close'

say 'Task completed successfully.'
exit
