//*****************************************************************************
//***  NAME              : IpSpy.h                                          ***
//***  PART OF           : IpSpy                                            ***
//***  SHORT DESCRIPTION : necessary IpSpy definitions                      ***
//--------------------------------------------------------------------------***
//***  AUTHOR            : E.Buerkle                                        ***
//***  CREATION DATE     : 15.01.97                                         ***
//***  COPYRIGHT         : (C) 1997 E.Buerkle                               ***
//*****************************************************************************

#ifndef IPSPY_H
#define IPSPY_H

#ifdef __cplusplus
      extern "C" {
#endif

// Return codes
#define RC_IPSPY_NOERROR                (0)
#define RC_IPSPY_TCPIP_NOT_FOUND        (1)
#define RC_IPSPY_SOCKET_ERROR           (2)
#define RC_IPSPY_QUEUE_ERROR            (3)
#define RC_IPSPY_NO_MEMORY              (4)
#define RC_IPSPY_CANNOT_START_THREADS   (5)
#define RC_IPSPY_NOT_INITIALIZED        (6)
#define RC_IPSPY_BUFFER_TOO_SMALL       (7)
#define RC_IPSPY_ALREADY_INITIALIZED    (8)
#define RC_IPSPY_INVALID_PARAM          (9)
#define RC_IPSPY_MUTEX_ERROR           (10)
#define RC_IPSPY_TOO_MANY_HANDLES      (11)
#define RC_IPSPY_CANNOT_OPEN_DRIVER    (12)
#define RC_IPSPY_DRIVER_ERROR          (13)
#define RC_IPSPY_MODE_NOT_SUPPORTED    (14)
#define RC_IPSPY_NOT_YET_SUPPORTED     (99)

// packet types
#define  IP_PACKET_TYPE                  1        // other
#define  REGULAR_1822_PACKET_TYPE        2
#define  HDH_1822_PACKET_TYPE            3
#define  DDN_X25_PACKET_TYPE             4
#define  RFC877_X25_PACKET_TYPE          5
#define  ETHERNET_PACKET_TYPE            6        // Ethernet-Csmacd
#define  IEEE_802_3_PACKET_TYPE          7        // Iso88023-Csmacd 
#define  IEEE_802_4_PACKET_TYPE          8        // Iso88024-Tokenbus 
#define  IEEE_802_5_PACKET_TYPE          9        // Iso88025-Tokenring 
#define  IEEE_802_6_PACKET_TYPE         10        // Iso88026-Man
#define  STARLAN_PACKET_TYPE            11
#define  PROTEON_10MBIT_PACKET_TYPE     12
#define  PROTEON_80MBIT_PACKET_TYPE     13
#define  HYPERCHANNEL_PACKET_TYPE       14
#define  FDDI_PACKET_TYPE               15
#define  LAPD_PACKET_TYPE               16
#define  SDLC_PACKET_TYPE               17
#define  DS1_PACKET_TYPE                18        // T-1
#define  E1_PACKET_TYPE                 19        // european equiv. of T-1
#define  BASIC_ISDN_PACKET_TYPE         20
#define  PRIMARY_ISDN_PACKET_TYPE       21        // proprietary serial
#define  PPP_SERIAL_PACKET_TYPE         22        // propPointToPointSerial
#define  PPP_PACKET_TYPE                23
#define  SOFTWARE_LB_PACKET_TYPE        24        // softwareLoopback
#define  EON_PACKET_TYPE                25        // CLNP over IP
#define  ETHERNET_3MBIT_PACKET_TYPE     26
#define  NSIP_PACKET_TYPE               27        // XNS over IP
#define  SLIP_PACKET_TYPE               28        // generic SLIP
#define  ULTRA_PACKET_TYPE              29        // ULTRA technologies
#define  DS3_PACKET_TYPE                30        // T-3
#define  SIP_PACKET_TYPE                31        // SMDS
#define  FRAME_RELAY_PACKET_TYPE        32

// 802.2 LLC format header definitions for transmission on token ring
#define LLC_AC                        0x10        // access control LLC
#define LLC_FC                        0x40        // frame control  LLC
#define HEAD_802_END                  0xAA        // LLC_SSAP_DSAP = 0AAAAh
#define FRAME_802_TYPE              0x0008

#define BROADCAST                     0xff        // broadcast is 0xFFFFFFFFFFFF

#define ARP_TYPE                    0x0608        // reversed for network order
#define ARP_ETH_HARDWARE            0x0100        // reversed for network order
#define ARP_TOK_HARDWARE            0x0600        // reversed for network order
#define ARP_PACKET_SIZE                 28        // fixes Ethernet assumption...


// Prototypes
APIRET APIENTRY IpSpy_Version(UCHAR **pVersion);
APIRET APIENTRY IpSpy_GetLastSocketError(ULONG *ulCode, UCHAR **pError);
APIRET APIENTRY IpSpy_QueryInterfaces(UCHAR ***pIFNames);
APIRET APIENTRY IpSpy_Init(ULONG *ulHandle, UCHAR *pchIF);
APIRET APIENTRY IpSpy_Exit(ULONG ulHandle);
APIRET APIENTRY IpSpy_ReadRaw(ULONG ulHandle, VOID *data, USHORT *usLength, USHORT *usType, ULONG *ulTimeStamp, USHORT *usUnknown);
APIRET APIENTRY IpSpy_WriteRaw(ULONG ulHandle, VOID *data, USHORT usLength, USHORT usType, ULONG ulTimeStamp, USHORT usUnknown);

  // IpSpy_(Query/Set)ReceiveMode: usMode
  #define DIRECTED_MODE         0x0001
  #define BROADCAST_MODE        0x0002
  #define PROMISCUOUS_MODE      0x0004
  #define SOURCE_ROUTING_MODE   0x0008

APIRET APIENTRY IpSpy_SetReceiveMode(USHORT usMode, UCHAR *pchIF, PVOID pvReserved);
APIRET APIENTRY IpSpy_QueryReceiveMode(USHORT *usMode, PVOID pvReserved);

#ifdef __cplusplus
        }
#endif

#endif
