#define INCL_DOS
#define INCL_DOSPROCESS
#define INCL_DOSERRORS
#include <os2.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <types.h>
#include <utils.h>
#include <netinet\in.h>
#include <sys\socket.h>
#include <sys\time.h>
#include <sys\select.h>
#include <netdb.h>
#include <nerrno.h>

int iSocket = 0;

LONG InitService( int * piSocket,ushort usPort );
BOOL Terminate( int * piSocket );
VOID _System ServerAcceptConn( );

main( int argc, char* argv[] )
{
   APIRET rc = NO_ERROR ;// Return code.

    if( !InitService( &iSocket,17701 ) )
    {
        DosSleep( 3000 );
        Terminate( &iSocket );
        DosSleep( 3000 );
    }
}

//  InitService()
LONG InitService( int* piSocket,ushort usPort )
{
    APIRET  rc;
    TID     tid;
    struct sockaddr_in  server;
    int iNameLen;
    int ns = 0;
    struct sockaddr_in client;


    printf("Socket Initialized: sock_init()\n");
    if((sock_init()) !=0)
    {
        return sock_errno();
    }

    printf("Socket creation: socket()\n");
    if(( *piSocket = socket(AF_INET, SOCK_STREAM, 0)) < 0 )
    {
        return sock_errno();
    }

    server.sin_family      = AF_INET;
    server.sin_port        = htons( usPort );
    server.sin_addr.s_addr = INADDR_ANY;
    printf("Socket binding :bind()\n");
    if( bind(*piSocket,(struct sockaddr *)&server, sizeof(server)) < 0)
    {
        rc = sock_errno();
        soclose( *piSocket );
        *piSocket = 0;
        return rc;
    }

    printf("Listening on the main Socket: listen()\n");
    if( listen( *piSocket,10 ) != 0)
    {
        rc = sock_errno();
        soclose( *piSocket );
        *piSocket = 0;
        return rc;
    }
    /* Now do an accept This ensures that we are not killing the main
       listening socket */
    for(;;)
    {
        iNameLen = sizeof(client);
        printf("Accept any Socket connections made by peer: accept()\n");
        ns = accept((int)*piSocket, (struct sockaddr *)&client, &iNameLen);
        if( -1 == ns )
        {
            ns = sock_errno();

            printf( "ServerAcceptConn: Accept returns %d.\n", ns);
            if( ns == ENOTSOCK )
                break;
        }
        else
        {
            printf("Accept succeded \n");
        }
    } // end for

    printf("Fork a process for any processing to be done \n");
    printf("on newly created Socket by accept call\n");
    if ( NO_ERROR != ( rc = DosCreateThread( &tid,
                                             (PFNTHREAD)ServerAcceptConn,
                                             NULL,
                                             0,
                                             4 * 4096) ) )
    {
        soclose( *piSocket );
        *piSocket = 0;
    }
    return rc ;
}

// ServerAcceptConn
VOID _System ServerAcceptConn()
{

    printf("ServerAcceptConn:\n");

}
//  Terminate()
BOOL Terminate( int* piSocket )
{
   APIRET rc = NO_ERROR ;// Return code.

    if( *piSocket )
    {
        printf( "Terminate: Socket %d will be closed.\n");
        soclose( *piSocket );
        *piSocket = 0;
    }
    return TRUE;
}
