/* An OS/2 REXX script to send a signal to a running EMX program based on */

/* signal name or number and pid . This script requires EMXKILL.EXE in the */

/* current directory or in the path. */

PARSE ARG inarg 

/* Get paramters. */

PARSE VALUE inarg WITH signalNumber pid

/* say 'signalNumber:' signalNumber 'pid:' pid */

if (pid ='') & (DATATYPE(signalNumber,'W') = 1) then

 DO

 pid = signalNumber

 signalNumber = '-KILL'

 END

/* Convert signalNumber to upper case. */

signalNumber = translate(signalNumber)

/* Display help if requested. */

if ( (signalNumber = "HELP") | (signalNumber = "-H") | (signalNumber = "?") ) then signal USAGE 

/* Handle usage problems. */

if (arg() = 0) then signal USAGE if (pid = '') then signal USAGE 

/* Translate signal name to number if needed. */

/* NOTE: Values taken from-EMX-sys/signal.h */

SELECT WHEN (signalNumber = "SIGHUP") | (signalNumber = "HUP") | (signalNumber = "-HUP") THEN signalNumber = 1


/* Hangup */

 WHEN (signalNumber = "SIGINT") | (signalNumber = "INT") | (signalNumber = "-INT" THEN signalNumber = 2

/* Interrupt (Ctrl-C) */

WHEN (signalNumber = "SIGQUIT") | (signalNumber = "QUIT") | (signalNumber = "-QUIT") THEN signalNumber = 3 

/* Quit */ 

WHEN (signalNumber = "SIGILL") | (signalNumber = "ILL") | (signalNumber = "-ILL") THEN signalNumber = 4 

/ * Illegal instruct */

WHEN (signalNumber = "SIGTRAP") | (signalNumber = "TRAP") | (signalNumber = "-TRAP") THEN signalNumber = 5 

/* Single step (debugging) */

WHEN (signalNumber = "SIGABRT") | (signalNumber = "ABORT") | (signalNumber = "-ABORT") THEN signalNumber = 6 

/ * abort () */ 

WHEN (signalNumber = "SIGEMT") | (signalNumber = "EMT") | (signalNumber = "-EMT") THEN signalNumber = 7


/* EMT instruction */

WHEN (signalNumber = "SIGFPE") | (signalNumber = "FPE") | (signalNumber = "-FPE") THEN signalNumber = 8 

/*Floating point */ WHEN (signalNumber = "SIGKILL") | (signalNumber = "KILL") | (signalNumber = "-KILL") THEN signalNumber = 9 

/* Kill process */ 

WHEN (signalNumber = "SIGBUS") | (signalNumber = "BUS") | (signalNumber = "-BUS") THEN signalNumber = 10

/* Bus error */

WHEN (signalNumber ="SIGSEGV") | (signalNumb) = "SEGV") | (signalNumber = "-SEGV") THEN signalNumber = 11

/* Segmentation fault */ 

WHEN (signalNumber = "SIGSYS") | (signalNumber = "SYS") | (signalNumber = "-SYS") THEN signalNumber = 12 


/* Invalid argument to system call */


WHEN (signalNumber ="SIGPIPE") | (signal) = "PIPE") | (signalNumber = "-PIPE") THEN signalNumber = 13 

/* Broken pipe */

WHEN (signalNumber = "SIGALRM") | (signalNumber = "ALARM") | (signalNumber = "-ALARM") THEN signalNumber = 14


/* Alarm */

WHEN (signalNumber = "SIGTERM"| (signalNumber ="TERM") | (signalNumber = "-TERM")-THEN signalNumber = 15

/* Termination, process killed */


WHEN (signalNumber = "SIGUSR1") | (signalNumber = "USR1") | (signalNumber = "-USR1") THEN signalNumber = 16

/* User-defined signal #1 */


WHEN (signalNumber = "SIGUSR2" | (signalNumber="USR2") | (signalNumber = "-USR2") THEN signalNumber = 17

/* User-defined-signal #2 */ 

WHEN (signalNumber = "SIGCHLD") | (signalNumber = "CHILD") | (signalNumber = "-CHILD") THEN signalNumber = 18

/* Death of a child process */

WHEN (signalNumber = "SIGBREAK" | (signalNumber="BREAK") | (signalNumber = "-BREAK") THEN signalNumber = 21 

/* Break (Ctrl-Break) */

OTHERWISE

/* Assume the signal number was passed directly. */


END


/* Send the signal. */


'@emxkill' signalNumber pid RETURN 

USAGE:SAYSAY "Usage: kill [signalName|signalNumber] pid'SAYSAY' 

If signalName-or-signalNumber is omitted, send SIGKILL .

'SAYSAY ' .... Next , list of Signals 'SAY'@pause'SAYSAY " SignalName Number Description"SAY " ------------------------ ------ -- ------------------------------ " 

SAY " SIGHUP HUP -HUP 1 Hangup"

SAY " SIGINT INT -INT 2 Interrupt (Ctrl-C)"

SAY " SIGQUIT QUIT -QUIT 3 Quit"

SAY " SIGILL ILL -ILL 4 Illegal instruction"

SAY " SIGTRAP TRAP -TRAP 5 Single step " (debugging )

SAY " SIGABRT "

SAY " SIGEMT EMT -EMT 7 EMT instruction"

SAY " SIGFPE FPE -FPE 8 Floating point"

SAY " SIGKILL KILL -KILL 9 Kill process"

SAY " SIGBUS BUS -BUS 10 Bus error"


SAY " SIGSEGV SEGV -SEGV 11 Segmentation-fault"

SAY " SIGSYS SYS -SYS 12 Invalid argument-to-system-call"

SAY " SIGPIPE PIPE -PIPE 13 Broken pipe"

SAY " SIGALRM ALARM -ALARM 14 Alarm"

SAY " SIGTERM TERM -TERM 15 Termination, process-killed"

SAY" SIGUSR1 USR1 -USR1 16 User-defined signal #1"

SAY " SIGUSR2 USR2 -USR2 17 User-defined signal #2"

SAY " SIGCHLD CHILD -CHILD 18 Death of a child process"

SAY " SIGBREAK BREAK -BREAK 21 Break (Ctrl-Break)"

EXIT ERROR:SAYSAY "An ERROR has occured."

SAYEXIT 