/* sample of an SRE-http "pre reply" procedure -- add a servername/time tag (or
  response header) to all responses.

General Info:  
Pre-reply  procedures ares called (by SRE) as:
  stuff=sref_prereply_proc(contents,fileflag,mimetype,modstring)
where
  contents = the actual contents to be sent to the client, or the fully
             qualified file name
   fileflag = 1 if this is a file, 0 if this is actual contents, 2 if "sref_multsend" contents
 mimetype = the mime type For example, image/gif or text/plain.
  clen    = content-length (might be missing)
 modstring = a string to should use to signal "new mimetype"

This procedure should return either
   ''   == when the procedure responds to the client (using 'FILE or 'VAR Goserve commands)
   0    == when the procedure does nothing (SRE will then take care of the response)
 contents == the contents to be sent to the client.  
             
A special variant of "contents" should be used if you've modified the mime=type:
    modstring||' '||mime/sub||'0d0a'x||contents
where "mime/sub" is the new mimetype.
An even more advanced form of "contents" is:
    modstring||' '||mime/sub||' 1 '||'0d0a'x||contents
which will also "suppress delta encoding".

Note that the "sref_prereply_proc" procedure name is an arbitrary name
used by sre-http when saving this procedure file to macrospace; you do NOT 
have to use this as a label anywhere in your procedure.


Info on this example:

This procedure will label the origin of this contents:
  text/plain -- a line is added at the top
  text/html  -- an html comment is added at the top
  image/gif -- a gif comment is added at the end
otherwise
  a x-sre_message response header is added

Note:the use of  pre_reply procedures require sre-http ver 1.3c and above.

*/

sref_prereply_proc:
parse arg contents,fileflag,mimetype,clen,modstring

if fileflag=1 then 
   jlen=stream(contents,'c','query size')
else
   jlen=length(contents)

call pmprintf('SRE-http pre-reply: 'fileflag' content-length = 'clen '('jlen ') and content-type= ' mimetype)

addaa='Produced on '||time('n')' 'date('n')', from '||servername()||'0d0a'x

select
  when translate(mimetype)='TEXT/PLAIN' then do
     addaa='From 'servername()||' on  '||time('n')' 'date('n')||'0d0a'x||'0d0a'x
     if fileflag=1 then do
       foo=stream(contents,'c','open read')
       aa=charin(contents,1,jlen)
       foo=stream(contents,'c','close')
       aa=addaa||aa
     end /* do */
     else do
      aa=addaa||contents
     end
     newlen=length(aa)
     return aa
   end
  when translate(mimetype)='TEXT/HTML' then do
     addaa='<!-- From 'servername()||' on  '||time('n')' 'date('n')||'-->'||'0d0a'x

     if fileflag=1 then do
       foo=stream(contents,'c','open read')
       aa=charin(contents,1,jlen)
       foo=stream(contents,'c','close')
       aa=addaa||aa
     end /* do */
     else do
      aa=addaa||contents
     end
     newlen=length(aa)
     return aa
   end

  when translate(mimetype)='IMAGE/GIF' then do
     addaa=make_comment('From 'servername()||' on  '||time('n')' 'date('n'))

     if fileflag=1 then do
       foo=stream(contents,'c','open read')
       aa=charin(contents,1,jlen)
       foo=stream(contents,'c','close')
     end /* do */
     else do
      aa=contents
     end
     aa=left(aa,jlen-1)||addaa||'3b'x   
     newlen=length(aa)
     return aa
   end


  otherwise do
       addaa='X-sre_message: From 'servername()||' on  '||time('n')' 'date('n')
       'HEADER ADD 'addaa
       return 0          /* let sre handle it (though this header will also be sent */
  end 
end


/***********/
make_comment:procedure
parse arg acomment
aa='21fe'x
aa=aa||chunkit(acomment)
return aa

/***********/
/* make a chewable chunk of data */
chunkit:procedure
parse arg astr,klen
if klen='' then klen=250
mkit=''
lenstr=length(astr)
do mm=1 to lenstr by 250 
   iget=min(250,1+lenstr-mm)
   a1=substr(astr,mm,iget)
   a0=d2c(iget)
   mkit=mkit||a0||a1
end
mkit=mkit||'00'x   
return mkit

