/* 21 April 1999. Daniel Hellerstein (danielh@crosslink.net)

    DE_SREBF .CMD: The client-side component of the SRE_BF
                   and SRE_BFC SRE-http encryption methods

This os/2 rexx program will decrypt responses from SRE-http servers
that have been encrypted using the SRE_BF and SRE_BFC encryption methods,
and either display them in a netscape window or save to a user
specified file.

To use this program, you'll need to do the following (assuming
you are running OS/2, and you have netscape for OS/2):

a)  Acquire a BlowFish executable.  In particular, 
    BLOWFISH 1.63 for OS/2, which can be found on http://hobbes.nmsu.edu.

b) Copy this file to an applications directory (it does NOT need
   to be in your path). For example, C:\OS2\APPS

c) Tell Netscape to use this DE_SREBF whenever it is recieves
   a response from a server that has a mime type of
   application/x-encrypt_SRE_BF
  
   To do this, you should set the following in NetScape:
     1) Open NetScape "applications". 
          for NS4.04 -- look in Edit-Preferences-Applications
          for NS2.02 -- look in Options-General_Preferences-Applications

     2) Create a "new type" with:

           Mime Type: application/x-encrypt_SRE_BF
           Application to Use: cmd.exe /c "x:\dir\DE_SREBF.cmd PWD:sspwd"

        where :
           sspwd   : is your "shared-secret password"
                     If you do NOT specify the PWD:sspwd, then
                     DE_SREBF will ask you to provide a "shared-secret"
                     password
           x:\dir\ : is the path you copied this file to (for example,
                     C:\OS2\APPS).

       Note: the  double quote (") characters MUST be included in 
                this definition!

After completing steps a through c, you are ready to recieve encrypted
files from an SRE-http web server. 

When you do recieve an "SRE_BF encrypted" response from an SRE-http
web server, NetScape should pop up a window that asks you to  
"load" or"save" the file -- you should choose "load".  
DE_SREBF.CMD will then be invoked.

DE_SREBF will decrypt the message, using the shared-secret
you specified (in step 2 above), and will then ask you whether to display
the message in a new NetScape window, or whether to save it to disk.

Although DE_SREBF.CMD was developed under OS/2, it might work under
different flavors of REXX -- we'll be checking on that.

*/

/* ---------- Begin user changeable parameters --------- */

/* set these to be  fully qualified default output and tempfile directories */
default_outdir=''

/* ---------- END of user changeable parameters --------- */


parse arg arglist

if arglist='' then do
    say "This is meant to be used as plug-in for NetScape"
    exit
end /* do */

say "  <<<< The SRE-http BlowFish decryptor  >>>>"
dafile=strip(word(arglist,words(arglist)))
hispwd=''
docompress=0
arglist=delword(arglist,words(arglist))
do forever
   if arglist='' then leave
   parse var arglist aword arglist
   aword=strip(translate(aword))
   if abbrev(aword,'PWD:')=1 then do
        parse var aword . ':' hispwd
   end
end /* do */

if hispwd='' then do
  call charout,' Please enter your "shared-secret" password: '
  pull hispwd ; hispwd=space(hispwd,0)
end
say ' '
if default_outdir='' then default_outdir=directory()
outdir=strip(default_outdir,'t','\')||'\'

if default_tempdir='' then default_tempdir=directory()
tempdir=strip(default_tempdir,'t','\')||'\'

crlf='0d0a'x

foo=rxfuncquery('sysloadfuncs') /* use rexxutil if it's available */
if foo=1 then do
  call RxFuncAdd 'SysLoadFuncs', 'RexxUtil', 'SysLoadFuncs'
  call SysLoadFuncs
end

dafile=strip(dafile)

/* 1) read the file */
ilen=stream(dafile,'c','query size')
if ilen=0 | ilen='' then do
    say "No such file: "dafile
    call charout, ' (hit ENTER to continue)' ; pull foo
    exit
end /* do */


foo=pos('.',dafile)
if foo=0 then foo=length(dafile)+1
tmpfile=left(dafile,foo-1)'.TMP'

address cmd 'BF 'dafile' 'tmpfile' "'||hispwd'"'

if stream(tmpfile,'c','query exists')='' then do
    say "Could not create decrypted file: "dafile
    call charout, ' (hit ENTER to continue)' ; pull foo
    exit
end /* do */

say
say
call charout, "Display in a new NetScape window (Y/N)? "
pull yn
if yn='Y' then do
   address cmd '@NETSCAPE  file:///'tmpfile
end
else do
   foo=stream(tmpfile,'c','open read')
   if abbrev(translate(foo),'READY')<>1 then do
           say "Problem accessing temporary file: "tmpfile
           say " (hit  ENTER to continue) "
           pull xx
           exit
   end /* do */
   iin=stream(tmpfile,'c','query size')
   if iin=0 | iin=''  then do
           say "Problem reading temporary file: "tmpfile
           say " (hit  ENTER to continue) "
           pull xx
           exit
   end
   aanew=charin(tmpfile,1,iin)

   oo=lastpos('\',dafile)
   datemp=substr(dafile,oo+1)
   oo=lastpos('.',datemp)
   if oo=0 then oo=length(datemp)+1
   datemp=left(datemp,oo-1)||'.'
   useout=getofile(outdir||datemp)
   if useout<>"" then do
           foo=stream(useout,'c','open write')
           foo=charout(useout,aanew,1)
           if foo<>0 then do
                say "Problem writing "useout
           end /* do */
           else
                say "   .... "useout " written successfully "
          foo=stream(useout,'c','close')
           ill=lastpos('\',useout)
           if ill>0 then  outdir=left(useout,ill)
   end /* do */
end /* do */

foo=deleteme(tmpfile)             /* cleanup */

exit

deleteme:procedure
parse arg gfile
if rxfuncquery('SYSFILEDELETE')=0 then foo=sysfiledelete(gfile)
if stream(gfile,'c','query exists')<>''then return 0
return 1


/************** Ask for an output file *************/
getofile:procedure
parse arg defout
do forever
  aa="   Output to file (ENTER="defout"):"
  if length(aa)>40 then do
     say aa
     call charout, "    ? "
  end
  else do
    call charout,aa' ?'
  end

  pull gfile2 ; gfile2=strip(gfile2)
  if right(gfile2,1)='\' & defout<>'' then do
     iu=lastpos('\',defout)
     gfile2=gfile2||substr(defout,iu+1)
  end
  if gfile2='.'  then return ''
  if gfile2="" then gfile2=defout
  if gfile2="" then iterate
  gfile0=stream(gfile2,'c','query exists')
  if gfile0<>"" then do
      call charout,'   'Gfile0 ' exists.  Overwrite (Y/N)'
      pull anans
      if abbrev(strip(anans),'Y')<>1 then iterate
      foo=deleteme(gfile0)
      if foo=1 then do
         say "    Could not delete gfile0. Try a different file name"
         iterate
      end
  end
  return gfile2
end /* do */


