/* This is a simple demo of the SRE-http "multi-send" procedure
   Please see MULTSEND.DOC for a description of the SREF_MULTI_SEND
   procedure.
*/

parse arg  ddir, tempfile, reqstrg,list,verb ,uri,user, ,
          basedir ,workdir,privset,enmadd,transaction,verbose, ,
         servername,host_nickname,homedir,aparam,semqueue,prog_file,reqnum

foo=extract('clientprotocol')
parse var foo '/' ver

/* check to see if the browser understands multi-part documents */
a=upper(strip(reqfield('Connection')))
a2=upper(strip(reqfield('PROXY-Connection')))

if ver<1.1 &  a<>'KEEP-ALIVE' & a<>'MAINTAIN' , 
    & a2<>'KEEP-ALIVE' & a2<>'MAINTAIN' then do
     wow=reqfield('user-agent')
   'String Sorry: Your Browser ('||wow||') does not support Connection:Keep-Alive'
    return ' no go '
end  /* Do */

/* This prevents NetScape from rerunning the server-push after
a "back" button has been hit */
/*a=sref_expire_response(0.1,0,'multipart/x-mixed-replace')*/

/* Start the "program" with some simple text */
foo=sref_multi_send('This is a simple additive send.. first line','text/plain','SS',
                     ,,,,'HEADER DROP EXPIRES'||'0d0a'x||'HEADER ADD X-Push: Test ' , ,
                     'X-part1: yes ')

/* note that a return code < 0 indicates the connection has been
dropped... so let's not make the server try to send stuff to
someone who's not there */

if foo<0 then return 'connection killed '

aa=syssleep(2)
foo=sref_multi_send(' .. it should have taken 2 seconds to display this 2nd ','text/plain','A')
if foo<0 then return 'connection killed '

aa=syssleep(3)
foo=sref_multi_send('and 3 seconds for this last line.  ','text/plain','A')
if foo<0 then return 'connection killed '

foo=sref_multi_send("Now let's do a server-push style animation ....  ",'text/plain','SE')
if foo<0 then return 'connection killed '

aa=syssleep(3)

/* Now do a simple, 7 frame animation */
ddir=strip(translate(ddir,'\','/'),,'\')

/* make sure SC*.GIF files are available */
aa=stream(ddir'\imgs\sc1.gif','c','query exists')
if aa='' then do
    foo=sref_multi_send('Sorry: push movie requires' ddir'\imgs\sc*.gif','text/plain','M',,,,,'X-PushMovie: none')
    if foo<0 then return 'connection killed '
    aa=syssleep(4)
    signal yoiks
end 

foo=sref_multi_send(ddir'\imgs\sc1.gif','image/gif','M',1,,,,'X-PushMovie: 1')
if foo<0 then return 'connection killed '

aa=syssleep(1)
foo=sref_multi_send(ddir'\imgs\sc2.gif','image/gif','M',1,,,,'X-PushMovie: 2')
if foo<0 then return 'connection killed '

aa=syssleep(1)
foo=sref_multi_send(ddir'\imgs\sc3.gif','image/gif','M',1)
if foo<0 then return 'connection killed '

aa=syssleep(1)
foo=sref_multi_send(ddir'\imgs\sc4.gif','image/gif','M',1)
if foo<0 then return 'connection killed '

aa=syssleep(1)
foo=sref_multi_send(ddir'\imgs\sc5.gif','image/gif','M',1)
if foo<0 then return 'connection killed '

aa=syssleep(1)
foo=sref_multi_send(ddir'\imgs\sc6.gif','image/gif','M',1)
if foo<0 then return 'connection killed '

aa=syssleep(1)
foo=sref_multi_send(ddir'\imgs\sc7.gif','image/gif','m',1)
if foo<0 then return 'connection killed '

aa=syssleep(5)

/* and end up with a little description, complete with links
to the source code */

yoiks: 
crlf='0d0a'x
aa="<html><head><title>SRE-http server push example</title></head>"crlf
aa=aa||" <body> Wasn't that <b>fun</b>.<p> "crlf
aa=aa||' <p> It was generated by a <a href="/multsend.cmd">simple REXX procedure</a> that calls the SRE-http '
aa=aa||" SREF_MULTI_SEND macrospace procedure.  You can use it as a template for your own"
aa=aa||' server-side-push tasks.  You might also want to read a <a href="/multsend.doc">brief description</a> of '
aa=aa||" SREF_MULTI_SEND. </body></html>"
foo=sref_multi_send(aa,'text/html','E',,,,,'X-End: yes')



if foo<0 then return 'connection killed '

return ' done '


