/*  */
realmcfg:

CHECKIT=0   /* Change this to 0 if you want to enable REMOTE configuration by SUPERUSERS */

/* background color */
USECOLOR='2dd52f'

/* ---------------- DO NOT MODIFY BELOW THIS LINE  ------------------ */

parse arg ddir,tempfile,sel,list,verb,uri,user,basedir,workdir,privset,enmadd,transaction,verbose, ,
         servername,host_nickname


if verb="" then do
   say " This SRE-http add-on is NOT meant to be run from the command line."
   say " It can be invoked by using CONFIGUR.HTM "
   exit
end  /* Do */


list=translate(list, ' ', '+'||'090a0d'x)  /* Whitespace, etc. */

crlf='0d0a'x
who2=extract('CLIENTADDR')
saddr2=extract('SERVERADDR')
sport=extract('SERVERPORT')

NO_REM=VALUE('SREF_NO_REMOTE_CONFIG',,'OS2ENVIRONMENT')

select
   when checkit=1 | (checkit>=0 & no_rem>0) then do

/* only if user = serveraddress !!! */
     if who2<>saddr2 | no_rem=2 then do

        call lineout tempfile, '<!doctype html public "-//IETF//DTD HTML 3.0//EN">'
        call lineout tempfile, "<html><head><title>SRE-http remote configurator disabled </title>"
        call lineout tempfile, '</head><body  bgcolor="#'||usecolor||'">'

        call lineout tempfile,' <strong> Action not allowed remotely.</strong> <pre>'
        call lineout tempfile,' </body> </html> '
        call lineout tempfile
        foo=sref_gos('FILE ERASE TYPE text/html NAME' tempfile)
        return 'REALMCFG: action not allowed remotely. '
     end
   end
   otherwise do
      if wordpos('SUPERUSER',privset)=0 then do
        'RESPONSE HTTP/1.1 401 Unauthorized '     /* Set HTTP response line */
         att=sref_gmt()
        'HEADER Noauto ADD Date: 'att

        'header add WWW-Authenticate: Basic Realm=<CONFIGURE>'  /* challenge */

        call lineout tempfile, '<!doctype html public "-//IETF//DTD HTML 3.0//EN">'
        call lineout tempfile, "<html><head><title>Not authorized </title>"
        call lineout tempfile, '</head><body  bgcolor="#'||usecolor||'">'

        call lineout tempfile,' <strong> You do not have configuration rights.</strong> <pre>'
        if who2=saddr2 then 
                call lineout tempfile,'<br> <Em> You may want to edit REALMCFG.CMD </em> '
        call lineout tempfile,' </body> </html> '
        call lineout tempfile
         iia=dosdir(tempfile,'s')

        'FILE ERASE TYPE text/html NAME' tempfile
        return '401 'iia ' REALMCFG: not permitted to configure. '
      end
   end
end

list=strip(list)
select 
   when upper(list)='TODO=SHOW' | upper(list)='TODO=SHOW_HEADER' then
        signal doshow
   when upper(list)='TODO=SET' then
        signal doset
   when abbrev(translate(list),'MATCH')+abbrev(translate(list),'TODO=MATCH')>0 then
        signal findmatch
   when abbrev(translate(list),'TODO=TEMPSHOW')=1 then
        signal showdeftemp
   otherwise
        signal dochange
end  /* select */


/* jump here to show values */
doshow:


realmfile=get_realmfile(host_nickname)
if realmfile='' then do
  call lineout tempfile, '<!doctype html public "-//IETF//DTD HTML 3.0//EN">'
  call lineout tempfile, "<html><head><title>REALMCFG: no ATTRIBS.CFG file </title></head><body>"
  call lineout tempfile, 'Sorry, there is no ATTRIBS.CFG file defined for 'servername '(w/host_nickname: 'host_nickname
  call lineout tempfile,'</body></html>'
  call lineout tempfile
  foo=sref_gos('file erase  type text/html name  ' tempfile)
  return ' done '
end /* do */

aa=sref_fileread(realmfile,'lins',,'E')
   call lineout tempfile, '<!doctype html public "-//IETF//DTD HTML 3.0//EN">'
   call lineout tempfile, "<html><head><title>SRE-http: Realm Definitions </title>"
   call lineout tempfile, '</head><body  bgcolor="#'||usecolor||'">'


call lineout tempfile, "<h1> SRE-http:  Realm Definitons  </h1> <p>"

if upper(list)='TODO=SHOW' then
   call lineout tempfile, "<h2> List of "header" comments </h2> <pre> <blockquote>"
else
   call lineout tempfile, "<h2> Description of realm entries </h2> <pre> <blockquote>"

/* show "header comments" */
iat=0
do until iat >= lins.0
   iat=iat+1
   if  abbrev(strip(lins.iat),';')  then do
        foo=strip(lins.iat) ;foo=strip(foo,'l',';')
         call lineout tempfile, foo 
   end  /* Do */
   else do
        leave
   end
end /* do -- iat is the first non header comment line  */
call lineout tempfile, '</blockquote></pre> '

/* view descriptive header only? */
if upper(list)='TODO=SHOW_HEADER' then do
   call lineout tempfile,' <hr> </body></html>'
   call lineout tempfile
   foo=sref_gos('file erase  type text/html name  ' tempfile)
   return ' done '
end  /* Do */



/* read in definitions etc */
nusers=0

call lineout tempfile, ' <hr> <h2> List of realms</h2>  '

call lineout tempfile,' Notes: <ul> '
if host_nickname='' then
   call lineout tempfile,' <li> Realm definitions, etc. (for the "default host") are stored in: ' realmfile
else
   call lineout tempfile,' <li> Realm definitions, etc. (for the 'host_nickname' host") are stored in: ' realmfile

call lineout tempfile,' <li> <em>Comments are in italics </em> '
call lineout tempfile, ' <li> Entries with no <strong>host nickname</strong> apply to all requests '
call lineout tempfile,'</ul>'

call lineout tempfile,' <hr> Thanks for checking </body></html>'
call lineout tempfile

foo=sref_gos('file erase  type text/html name  ' tempfile)
return ' done '

/* jump here if "tempshow" chosen */
showdeftemp:
d1=value(enmadd||'tempdata_dir',,'os2environment')
d2=stream(d1||'\$DFREALM.'||sport,'c','query exists')
if d2='' then do
   astring=' There are no REALMS defined ('d1||'\$DFREALM.'||sport||' does not exist)'
   foo=sref_gos('var type text/plain name  ',astring)
   return foo
end /* do */
foo=sref_gos('file type text/plain name  ' d2)
return foo


/* jump here if "match sel" chosen */
findmatch:
realmfile=get_realmfile(host_nickname)
if realmfile='' then do
  call lineout tempfile, '<!doctype html public "-//IETF//DTD HTML 3.0//EN">'
  call lineout tempfile, "<html><head><title>REALMCFG: no ATTRIBS.CFG file </title></head><body>"
  call lineout tempfile, 'Sorry, there is no ATTRIBS.CFG file defined for 'servername '(w/host_nickname: 'host_nickname
  call lineout tempfile,'</body></html>'
  call lineout tempfile
  foo=sref_gos('file erase  type text/html name  ' tempfile)
  return ' done '
end /* do */

aa=sref_fileread(realmfile,'lins',,'E')
kk=lins.0+1
lins.kk=''
lins.0=kk  /* put an elephant in cairo */
call lineout tempfile, '<!doctype html public "-//IETF//DTD HTML 3.0//EN">'
call lineout tempfile, "<html><head><title>SRE-http: match an ATTRIBS entry </title>"
call lineout tempfile, '</head><body  bgcolor="#'||usecolor||'">'

call lineout tempfile,'<!--  a button bar. --> 'crlf ,
           '<a href="/configur.htm">Configurator</a>||' crlf ,
           '<a href="/config2?todo=SET">Parameters</a>||' crlf ,
           '<a href="/usercfg?todo=SET">Usernames</a>||'  crlf ,
           '<a href="/realmcfg?todo=SET">Define-Realms</a>||'||crlf ,
           '<a href="/accescfg?todo=SET">Access-Controls||'  crlf ,
           '<a href="/aliascfg?todo=SET">Aliases</a>||'  crlf ,
           '<a href="/virtcfg?todo=SET">VirtualDir</a><p>'  


/* note: ignore header stuff */
iat=0

/* parse it */
parse var list '=' asel

asel=strip(asel,'l','/')
CALL GET_ENTRIES

if host_nickname='' then
  call lineout tempfile,'For server at:<tt>' servername '</tt> &nbsp;&nbsp; '
else
  call lineout tempfile,'Current host=<tt>' servername '<em> (w/nickname: 'host_nickname' </em></tt> &nbsp;&nbsp; '
call lineout tempfile, ' <em> # of entries='nentries'</em>'

call lineout tempfile, '<p>Find match for: <tt>'asel'</tt>'


gotit=0 ; RESU=' '

/* if superceding host, then first check host-specific entries */
if abbrev(host_nickname,'_!')<>1 then  do
  do mm=1 to nentries
     if realm.mm='' then iterate   /* not a realm def */
     if host.mm<>host_nickname then iterate          /* not this host */
     do ll=1 to words(rules.mm)
         arule=strip(word(rules.mm,ll))
         arule=strip(arule,'l','/')
         aresu=sref_wild_match(asel,arule,resu)
         if aresu=0 then iterate     /* no match */
         if aresu=-1 then do  /* exact match */
           gotit=mm
           leave mm
        end                     /* exact */
        resu=aresu
        GOTIT=MM             /* if here, better match found */
     end                        /* words in rules */
   end                  /* nentries */
end

/* no host specfic match, and not stricet superceding host? try defaults */
if gotit=0 & abbrev(host_nickname,'_!!')=0 then do
  do mm=1 to nentries
     if realm.mm='' then iterate   /* not a realm def */
     if host.mm<>host_nickname & host.mm<>'' then iterate          /* not this host */
     do ll=1 to words(rules.mm)
         arule=strip(word(rules.mm,ll))
         arule=strip(arule,'l','/')
         aresu=sref_wild_match(asel,arule,resu)
         if aresu=0 then iterate     /* no match */
         if aresu=-1 then do  /* exact match */
           gotit=mm
           leave mm
        end                     /* exact */
        resu=aresu
        GOTIT=MM             /* if here, better match found */
     end                        /* words in rules */
   end                  /* nentries */

end

call lineout tempfile,'<blockquote>'

if gotit=0 then do
 call lineout tempfile,'<b>No match! </b>'
end
else do
  call lineout tempfile,'Entry #'gotit
  rm=realm.gotit
  if subrealm.gotit<>'' then rm=rm'.'subrealm.gotit
  if crealm.gotit=1 then rm=rm '<em>(superceding)</em>'
  call lineout tempfile,'<br>Realm: <b>'rm
  call lineout tempfile,'</b><br>Rule: <tt>'rules.gotit'</tt>'
end
call lineout tempfile,'</blockquote>'

call lineout tempfile,'</body></html>'
call lineout tempfile

foo=sref_gos('file erase  type text/html name  ' tempfile)
return foo



/* jump here if "set values" chosen */
doset:
realmfile=get_realmfile(host_nickname)
if realmfile='' then do
  call lineout tempfile, '<!doctype html public "-//IETF//DTD HTML 3.0//EN">'
  call lineout tempfile, "<html><head><title>REALMCFG: no ATTRIBS.CFG file </title></head><body>"
  call lineout tempfile, 'Sorry, there is no ATTRIBS.CFG file defined for 'servername '(w/host_nickname: 'host_nickname
  call lineout tempfile,'</body></html>'
  call lineout tempfile
  foo=sref_gos('file erase  type text/html name  ' tempfile)
  return ' done '
end /* do */

aa=sref_fileread(realmfile,'lins',,'E')
kk=lins.0+1
lins.kk=''
lins.0=kk  /* put an elephant in cairo */

call lineout tempfile, '<!doctype html public "-//IETF//DTD HTML 3.0//EN">'
call lineout tempfile, "<html><head><title>SRE-http: modify realm entries </title>"
call lineout tempfile, '</head><body  bgcolor="#'||usecolor||'">'

call lineout tempfile,'<!--  a button bar. --> 'crlf ,
           '<a href="/configur.htm">Configurator</a>||' crlf ,
           '<a href="/config2?todo=SET">Parameters</a>||' crlf ,
           '<a href="/usercfg?todo=SET">Usernames</a>||'  crlf ,
           '<a href="/realmcfg?todo=SET">Define-Realms</a>||'||crlf ,
           '<a href="/accescfg?todo=SET">Access-Controls||'  crlf ,
           '<a href="/aliascfg?todo=SET">Aliases</a>||'  crlf ,
           '<a href="/virtcfg?todo=SET">VirtualDir</a><p>'  

/* note: ignore header stuff */
iat=0

/* parse it */

CALL GET_ENTRIES
call lineout tempfile, "<h1 align="center"> SRE-http: modify <A NAME="top">realm</A> definitions </h1> <p>"
if host_nickname<>'' then do
   call lineout tempfile,' <h4 align="center"> For host: 'servername' (w/nickname:'host_nickname ' </h4>'
end
else do
   call lineout tempfile,' <h4 align="center"> For the "default" host </h4>'
end /* do */

call lineout tempfile,' Use this form to modify/remove/add realm definitions, users, and replacement strings.'
call lineout tempfile,' <br><em> Questions? <A HREF="#notes">The notes might help.</A> </em>  '

call lineout tempfile,' <blockquote><table border=1><tr><td>'
call lineout tempfile,'<em>Would you like to </em> match a selector to a REALM: '
call lineout tempfile,'<FORM ACTION="/realmcfg" METHOD="GET">'
call lineout tempfile,'<input type="text" name="MATCH" size=40>'
call lineout tempfile,' <input type="submit" value="Match this selector"> </form> '
call lineout tempfile,' </table></blockquote>'

call lineout tempfile,' <h2> Modify or remove realm definitions </h2>'
call lineout tempfile,'<FORM ACTION="/realmcfg" METHOD="POST">'

call lineout tempfile,' <table border=1>'

/* Display "realm" entries */
do mm=1 to nentries
 call lineout tempfile,'<tr>'
 call add_acell mm,'Entry # 'mm 'of 'nentries
end
call lineout tempfile,' </table>'

/* --- allow user to enter a realm definition */
call lineout tempfile,'  <p> <h2> Add a realm definition </h2> <table border=1>'
mm=nentries+1
call add_acell mm,' New Entry '
call lineout tempfile,'</table> <p>'

/* --- allow user to enter a username */
mm=nentries+2
call lineout tempfile,'  <p> <h2> Add a username</h2> <table border=1>'
   call lineout tempfile,'<td valign="top"><em>New User</em><br>'
   if host_nickname='' then do
     call lineout tempfile,'<tt>Host:</tt>  <INPUT TYPE="text" NAME="host.'||mm||'"'
     call lineout tempfile,'value="'host.mm'" SIZE=10  > <br> '
     call lineout tempfile,'<br> <tt>Port:</tt> <INPUT TYPE="text" NAME="port.'||mm||'"'
     call lineout tempfile,'value="'port.mm'" SIZE=6 >  '
   end
   else do
     call lineout tempfile,'<tt>Host:</tt> 'host_nickname
     call lineout tempfile,'<br> <tt>Port:</tt> 'sport
   end
   call lineout tempfile,'<td><tt>Username:</tt>  <INPUT TYPE="text" NAME="user.'||mm||'"'
   call lineout tempfile,'value="'user.mm'" SIZE=12  >  '

   call lineout tempfile,'<br><tt>Password:</tt>  <INPUT TYPE="text" NAME="rules.'||mm||'"'
   call lineout tempfile,'value="'rules.mm'" SIZE=12  > <br> '

  call lineout tempfile,'<br><tt>Privileges:</tt>  <INPUT TYPE="text" NAME="privs.'||mm||'"'
  call lineout tempfile,'value="'privs.mm'" SIZE=32  > <br> '

call lineout tempfile,'</table> <p>'

mm=nentries+3
call lineout tempfile,'  <p> <h2> Add a replacement string</h2> <table border=1>'
   call lineout tempfile,'<td valign="top"><em>Replacement string</em><br>'
   if host_nickname='' then do
     call lineout tempfile,'<tt>Host:</tt>  <INPUT TYPE="text" NAME="host.'||mm||'"'
     call lineout tempfile,'value="'host.mm'" SIZE=10  > <br> '
     call lineout tempfile,'<br> <tt>Port:</tt> <INPUT TYPE="text" NAME="port.'||mm||'"'
     call lineout tempfile,'value="'port.mm'" SIZE=6 >  '
   end
   else do
     call lineout tempfile,'<tt>Host:</tt> 'host_nickname
     call lineout tempfile,'<br> <tt>Port:</tt> 'sport
   end


   call lineout tempfile,'<td><tt>Replace:</tt>  <INPUT TYPE="text" NAME="replace.'||mm||'"'
   call lineout tempfile,'value="'replace.mm'" SIZE=22  >  '
   call lineout tempfile,'<br><tt> with:</tt>  <INPUT TYPE="text" NAME="rules.'||mm||'"'
   call lineout tempfile,'value="'rules.mm'" SIZE=55  > <br> '

call lineout tempfile,'</table> <p>'


/* ----- add comments information */

call lineout tempfile,' <input type="hidden" name="nhiddens" value="'||hiddens.0||'">'
do jj=1 to nhidden
  boo=hiddens.jj
  boo=sref_replacestrg(boo,'"','&quot;','ALL')
  boo=sref_replacestrg(boo,'<','&lt;','ALL')
  boo=sref_replacestrg(boo,'>','&gt;','ALL')
  call lineout tempfile,'<input type="hidden" name="hiddens.'jj'" value="'boo'">'
end /* do */

call lineout tempfile,' <input type="hidden" name="nentries" value="'||mm||'">'
call lineout tempfile,' <input type="submit" value="Make these changes"> <input type="reset"> </form> '

call lineout tempfile,' <hr> <h3> <A NAME="notes">Notes </A></h3> '
if host_nickname='' then
   call lineout tempfile,' <li> Realm definitions, etc. (for the "default host") are stored in: ' realmfile
else
   call lineout tempfile,' <li> Realm definitions, etc. (for the 'host_nickname' host) are stored in: ' realmfile

call lineout tempfile, ' <li> To remove an entry, clear the realm:field (or set it to 0)'

call lineout tempfile, ' <li> When defining a realm, you <em>must </em> specify the realm: and rules:  '
call lineout tempfile, ' <li> Rules: can contain multiple entries; with each entry seperated by a space, or on a seperate line '
call lineout tempfile, ' <li> The valid LIMITLIST values are:<tt>!HTML, !CGI-BIN, !ADDONS, and !UPLOAD </tt>'
call lineout tempfile, ' <li> Entries with no <strong>host nickname</strong> will apply to all requests'
call lineout tempfile, ' <li> You can select multiple permissions'
call lineout tempfile, ' <li> A blank requires:, or if requires: contains a *, means open access'

call lineout tempfile,' <li> See <a href="/samples/in_files.doc">IN_FILES.DOC</a> for details on  realm definitions'

call lineout tempfile,' <li> Would you like to view the<a href="/realmcfg?todo=tempshow">'
call lineout tempfile,'the working copy of ATTRIBS.CFG</a>'

call lineout tempfile,'</ul>'

call lineout tempfile,' <h3> A list of the <A NAME="hosts">current hosts</A> </h3>  <blockquote> '
ii=value(enmadd||'HOSTS.0',,'os2environment')
if ii=0 then do
   call lineout tempfile,'<strong>There are no hosts defined</strong>'
end 
else do
  hlist=sref_value('$HOSTS.0',,'USE')
  call lineout tempfile,' <table> <th> IP address </th> <th> Host Nickname </th> <th> Data Directory </th> <tr> '
  do ll=1 to words(hlist)
      hh=strip(translate(word(hlist,ll)))
      wow=sref_value('$HOSTS.'||hh,,'use')
      parse var wow ip ',' hn ',' hdir
     call lineout tempfile,' <td> ' ip  '</td> <td> ' hn ' </td> <td> ' hdir '</td> <tr> '
  end /* do */
  call lineout tempfile,' </table> </blockquote>'
end

call lineout tempfile,' <p> <A HREF="#top">Return to the top of this form.</A>'

call lineout tempfile,'</body></html>'
call lineout tempfile

foo=sref_gos('file erase  type text/html name  ' tempfile)
return foo



/***********************************/
/* PARSE INTO ENTRIES  */
GET_ENTRIES:

ison=0
nhidden=0; nentries=0
hiddens.0=0
this.=''
realm.=''; subrealm.=''; host.=''; port.=''; crealm.=''
rules.=''; permissions.=''; requires.=''
advopts.=''; failfile.='' ; limitlist.=''
redirect.='';redirect2.=''
opts.=''
include.=''
user.='' ; privs.=''
replace.=''

DO MM=1 TO LINS.0
   ALINE=strip(lins.mm)
   if abbrev(aline,';')=1 then do
       nhidden=nhidden+1
       hiddens.nhidden=aline
       hiddens.0=nhidden
       iterate
   end
   if aline='' & ison=0 then iterate /* multiple emptys */
   if aline=' ' then do         /* blank line signals end of entry */
       nentries=nentries+1
       realm.nentries=this.!realm
       subrealm.nentries=this.!subrealm
       crealm.nentries=this.!crealm

       host.nentries=this.!host
       port.nentries=this.!port
       rules.nentries=this.!rules     

       user.nentries=this.!user
       privs.nentries=this.!privs
       replace.nentries=this.!replace

       permissions.nentries=this.!permissions
       requires.nentries=this.!requires
       advopts.nentries=this.!advopts
       opts.nentries=this.!opts
       failfile.nentries=this.!failfile
       limitlist.nentries=this.!limitlist

       redirect.nentries=this.!redirect
       redirect2.nentries=this.!redirect2
       include.nentries=this.!include
       this.=''
       ison=0
       iterate
   end /* do */
   
/* otherwise, an action */
    ison=1
   if pos(':',aline)>0 then
     parse var aline action ':' options
   else
      parse var aline action options 
   action=strip(translate(translate(action),' ',':='))
   options=strip(options)
   select
      when action='PORT' then do
        if options='' then options=80
        this.!port=options
      end
      when action='REALM' then do
         if options='' then iterate
         parse var options options crealm
         parse var options this.!realm '.' this.!subrealm
         this.!crealm=0
         if wordpos(translate(strip(crealm)),'1 C S SUPERCEDING SUPER COMPLETE')>0 then
           this.!crealm=1
      end 

      when abbrev(action,'REPL')=1 then do 
          this.!REPLACE=strip(translate(options))
      end 
      when abbrev(action,'WITH')=1 then do 
          this.!RULES=options
      end 

      when abbrev(action,'USER')=1 then do 
          this.!USER=strip(translate(options))
      end 
      when abbrev(action,'PWD')+abbrev(action,'PASS')>0 then do 
          this.!RULES=strip(options)
      end 
      when abbrev(action,'PRIV')>0 then do 
          this.!PRIVS=strip(options)
      end 

      when action='INCLUDE' then do
         if options='' then iterate
         this.!include=options
      end 
      when action='HOST' then do
          this.!HOST=translate(options)
      end 
      when action='INCLUDE' then do
          this.!INCLUDE=translate(options)
      end 

      when abbrev(action,'REQ')=1 then do 
          this.!REQUIRES=translate(options)
      end 
      when abbrev(action,'PERM')=1 then do 
          this.!permissions=translate(options)
      end 
      when abbrev(action,'RUL')=1 then do
        this.!RULES=this.!rules' 'options
      end
      when abbrev(action,'ADV')=1 then do
        this.!ADVOPTS=options
      end /* do */
      when abbrev(action,'OPT')=1 then do
        this.!OPTS=this.!opts||'0d0a'x||options
      end /* do */

     when abbrev(action,'FAIL')=1 then do
        this.!FAILFILE=options
      end /* do */
     when abbrev(action,'LIMIT')=1 then do
        this.!LIMITLIST=options
      end /* do */

     when wordpos(action,'REDIRECT NEGOTIATE LITERAL ALIAS VIRTUAL MOVED MOVE TEMP TEMPMOVE TEMPMOVED PERMMOVE PERMMOVED')>0 then do
         options2=translate(options,' ','=')
         parse var options2 a1  a2 
         a2=strip(a2)
         if words(options2)=1 then a2=a1  /* action=alias, etc */
         a1=strip(translate(a1))
         select   
           when abbrev(a1,"SEL")+abbrev(a1,'INTERN')=1 | action="ALIAS" then do
             this.!REDIRECT='ALIAS'
             this.!redirect2=a2
           end 
           when a1="DIR" | action="VIRTUAL" then do
             this.!REDIRECT='VIRTUAL'
             this.!REDIRECT2=a2
           end 
           when a1="LITERAL" | action="LITERAL" then do
             this.!REDIRECT='LITERAL'
             this.!REDIRECT2=a2
           end 
           when a1="NEGOTIATE" | action="NEGOTIATE" then do
             this.!REDIRECT='NEGOTIATE'
             this.!REDIRECT2=a2
           end 

           when abbrev(a1,"PERM")+abbrev(a1,'MOVE')>0 | abbrev(action,"MOVE")=1 then do
             this.!REDIRECT='MOVE'
             this.!REDIRECT2=a2
           end 
           when abbrev(a1,"TEMP")=1 | abbrev(action,"TEMP")=1 then do
              this.!REDIRECT='TEMP'
              this.!REDIRECT2=a2
           end 
           otherwise  do
             nhidden=nhidden+1
             hiddens.nhidden=aline
             hiddens.0=nhidden
           end
         end               /* which kind of redirect */
      end               /* action=redirect */
      otherwise  do
             nhidden=nhidden+1
             hiddens.nhidden=aline
             hiddens.0=nhidden
      end
  end                /* action */
   
end /* lins.0 */
return 1


/***********************************/
/* add a realm def cell */
add_acell:
parse arg mm,amess
call lineout tempfile,'<td valign="top"><em>'amess'</em><br>'

if user.mm='' & replace.mm='' then do
  call lineout tempfile,' <b><tt>Realm:</tt></b> <INPUT TYPE="text" NAME="realm.'||mm||'"'
  call lineout tempfile,'value="'realm.mm'" SIZE=14  > <br> '
  call lineout tempfile,'<b><tt>subRealm:</tt></b> <INPUT TYPE="text" NAME="subrealm.'||mm||'"'
  call lineout tempfile,'value="'subrealm.mm'" SIZE=14  > <br> '
  if crealm.mm=1 then
     call lineout tempfile,'<br><input type="checkbox" value=1 checked name="crealm.'||mm||'"><em>Superceding realm?</em>'
  else
     call lineout tempfile,'<br><input type="checkbox" value=1 name="crealm.'||mm||'"><em>Superceding realm?</em>'
end
if host_nickname='' then do
  call lineout tempfile,'<br><tt>Host:</tt>  <INPUT TYPE="text" NAME="host.'||mm||'"'
  call lineout tempfile,'value="'host.mm'" SIZE=10  > <br> '
  call lineout tempfile,'<br> <tt>Port:</tt> <INPUT TYPE="text" NAME="port.'||mm||'"'
  call lineout tempfile,'value="'port.mm'" SIZE=6 >  '
end
else do
  call lineout tempfile,'<br><tt>Host:</tt> 'host_nickname
  call lineout tempfile,'<br> <tt>Port:</tt> 'sport
end /* do */

if include.mm<>'' then do
  call lineout tempfile,'<td><tt>Include file:</tt>  <INPUT TYPE="text" NAME="include.'||mm||'"'
  call lineout tempfile,'value="'include.mm'" SIZE=20  > <br> '
  return 2
end /* do */

if user.mm<>'' then do
  call lineout tempfile,'<td><tt>Username:</tt>  <INPUT TYPE="text" NAME="user.'||mm||'"'
  call lineout tempfile,'value="'user.mm'" SIZE=12  >  '

  call lineout tempfile,'<br><tt>Password:</tt>  <INPUT TYPE="text" NAME="rules.'||mm||'"'
  call lineout tempfile,'value="'rules.mm'" SIZE=12  > <br> '

  call lineout tempfile,'<br><tt>Privileges:</tt>  <INPUT TYPE="text" NAME="privs.'||mm||'"'
  call lineout tempfile,'value="'privs.mm'" SIZE=32  > <br> '
  return 3
end

if replace.mm<>'' then do
  call lineout tempfile,'<td><tt>Replace:</tt>  <INPUT TYPE="text" NAME="replace.'||mm||'"'
  call lineout tempfile,'value="'replace.mm'" SIZE=22  >  '

  call lineout tempfile,'<br><tt> with:</tt>  <INPUT TYPE="text" NAME="rules.'||mm||'"'
  call lineout tempfile,'value="'rules.mm'" SIZE=55  > <br> '
  return 4
end



/* else, a selector=specific attribite ntry */
call lineout tempfile,'  <td> <tt>Rules:</tt><textarea name="rules.'||mm||'" cols=50 rows=1>'||strip(rules.mm)||'</textarea>'

if subrealm.mm=''then do
  call lineout tempfile,'<hr width="66%">  <tt>Requires:</tt>'
  call lineout tempfile,' <INPUT TYPE="text" NAME="requires.'||mm||'"'
  call lineout tempfile,'value="'requires.mm'" SIZE=40  > <br> '
end
else do
  call lineout tempfile,'<hr width="66%">  <tt>Requires:</tt>'
  call lineout tempfile,' <INPUT TYPE="hidden" NAME="requires.'||mm||'"'
  call lineout tempfile,'value=""><em>using value for realm <tt> 'realm.mm'</tt></em> <br> '
end /* do */

call lineout tempfile,' <br> <tt>Permissions:</tt>'
permlist='NOCACHE CACHE CACHE* PUT DELETE YES_SSI  NO_SSI  NO_SSP NO_CODE NO_HTACCESS NO_VIRTUAL NO_ALIAS NO_POSTFILTER'
aperm=permissions.mm
call lineout tempfile,' <select name="PERMISSIONS.'||mm'" size=4 multiple>'
do mz=1 to 5
    pw=strip(word(permlist,mz))
    ass='' ; if wordpos(pw,aperm)>0 then ass='SELECTED'
    call lineout tempfile,'<option value="'pw'" 'ass'>'pw
end /* do */
call lineout tempfile,'</select>'
call lineout tempfile,' <select name="PERMISSIONS.'||mm'" size=4 multiple>'
do mz=6 to 9
    pw=strip(word(permlist,mz))
    ass='' ; if wordpos(pw,aperm)>0 then ass='SELECTED'
    call lineout tempfile,'<option value="'pw'" 'ass'>'pw
end /* do */
call lineout tempfile,'</select>'
call lineout tempfile,' <select name="PERMISSIONS.'||mm'" size=4 multiple>'
do mz=10 to words(permlist)
    pw=strip(word(permlist,mz))
    ass='' ; if wordpos(pw,aperm)>0 then ass='SELECTED'
    call lineout tempfile,'<option value="'pw'" 'ass'>'pw
end /* do */
call lineout tempfile,'</select>'

call lineout tempfile,'<p><tt>Redirect:</tt> <Select name="redirect.'||mm||'" size=3>'
selecto.=''
if redirect2.mm='' then redirect.mm=''

ill=wordpos(redirect.mm,'VIRTUAL ALIAS MOVE TEMP LITERAL NEGOTIATE ')
if ill=0 then ill=7

selecto.ill.0='SELECTED'

selecto.1='VIRTUAL'
selecto.2='ALIAS'
selecto.3='MOVE'
selecto.4='TEMP'
selecto.5='LITERAL'
selecto.6='NEGOTIATE'

selecto.7='NONE'

selecto.1.1='Virtual (dir) '
selecto.2.1='Internal (selector) '
selecto.3.1='Permanent (301) '
selecto.4.1='Temporary (302) '
selecto.5.1='Literal'
selecto.6.1='Content Negotiation'

selecto.7.1='No redirection'

do mmm=1 to 7
   call lineout tempfile,'<option value="'selecto.mmm'" 'selecto.mmm.0'>'selecto.mmm.1
end
call lineout tempfile,'</select>'
call lineout tempfile, '  <tt> to</tt>:  '
call lineout tempfile,'<INPUT TYPE="text" NAME="redirect2.'||mm||'"'
call lineout tempfile,'value="'redirect2.mm'" SIZE=30> <p> '

call lineout tempfile,'<table><tr><th align="left">AdvOpts file</th><th align="left">AdvOpts list</th>'
call lineout tempfile,'<tr><td> <INPUT TYPE="text" NAME="advopts.'||mm||'"'
call lineout tempfile,'value="'advopts.mm'" SIZE=20> </td>'
call lineout tempfile,'<td> <textarea NAME="opts.'||mm||'"'
call lineout tempfile,' Cols=30 Rows=2>'opts.mm'</textarea></td> </table> <br>'
call lineout tempfile,'<br><tt>Failure file:</tt>  <INPUT TYPE="text" NAME="failfile.'||mm||'"'
call lineout tempfile,'value="'failfile.mm'" SIZE=20  > <br> '
call lineout tempfile,'<br><tt>Virtual Dir Limit-list:</tt>  <INPUT TYPE="text" NAME="limitlist.'||mm||'"'
call lineout tempfile,'value="'limitlist.mm'" SIZE=20  > <br> '


call lineout tempfile, '  '


return 1



/******************** jump here to record changes */
dochange:
ili=0
hidlist.=''
globs.=''
nentries=0; nhiddens=0
do until list=""
   parse var list aa '&' list
  parse var aa avar '=' aval
  parse var avar avar '.' aind
  avar=translate(strip(avar))
  aind=translate(strip(aind))
  aval=strip(packur(aval))
  select
     when avar='NENTRIES' then nentries=aval
     when avar='NHIDDENS' then nhiddens=aval
     otherwise do
        if avar='HIDDENS' then do
             hidlist.aind=aval
        end /* do */
        else do
         rt='!'||avar
         if avar='PERMISSIONS' then
            globs.rt.aind=globs.rt.aind' 'aval
         else
            globs.rt.aind=aval
        end
     end
  end  /* select */
end /* do */


if nentries+nhiddens=0 then do
  call lineout tempfile, '<!doctype html public "-//IETF//DTD HTML 3.0//EN">'
  call lineout tempfile, "<html><head><titLE> Nothing to change (REALMCFG) </title></head>"
  call lineout tempfile, '<body> Form contained no information (REALMCFG) </body></html>'
  call lineout tempfile
  foo=sref_gos('FILE ERASE TYPE text/html NAME ' tempfile)
  return foo
end

realmfile=get_realmfile(host_nickname)
if realmfile='' then do
  call lineout tempfile, '<!doctype html public "-//IETF//DTD HTML 3.0//EN">'
  call lineout tempfile, "<html><head><title>REALMCFG: no ATTRIBS.CFG file </title></head><body>"
  call lineout tempfile, 'Sorry, there is no ATTRIBS.CFG file defined for 'servername '(w/host_nickname: 'host_nickname
  call lineout tempfile,'</body></html>'
  call lineout tempfile
  foo=sref_gos('file erase  type text/html name  ' tempfile)
  return ' done '
end /* do */

aa=sref_fileread(realmfile,'lins',,'E')

/* save to realmfile.. but rename old realm file*/
foo=lastpos('.',realmfile)
if foo=0 then
   acf1=realmfile||'.'
else
   acf1=left(realmfile,foo)
do hi=1 to 999
   try1=acf1||hi
   if stream(acf1||hi,'c','query exists')='' then leave
end /* do */
foo=dosrename(realmfile,try1)

/* write out header lines */
newlines.=''
inew=0
do mm=1 to nhiddens
   inew=inew+1
   newlines.inew=hidlist.mm
end /* do */
inew=inew+1

/* write out entries */
do mm=1 to nentries
   inew=inew+1

   if globs.!USER.mm<>'' then do
     inew=inew+1
     newlines.inew='Port: 'globs.!port.mm   
     inew=inew+1
     newlines.inew='Host: 'globs.!host.mm   
     inew=inew+1
     newlines.inew='USER: 'globs.!user.mm   
     inew=inew+1
     newlines.inew='PWD: 'globs.!rules.mm   
     inew=inew+1
     newlines.inew='PRIVS: 'globs.!privs.mm   
     iterate
   end /* do */

   if globs.!REPLACE.mm<>'' then do
     inew=inew+1
     newlines.inew='Port: 'globs.!port.mm   
     inew=inew+1
     newlines.inew='Host: 'globs.!host.mm   
     inew=inew+1
     newlines.inew='REPLACE: 'globs.!replace.mm   
     inew=inew+1
     newlines.inew='WITH: 'globs.!rules.mm   
     iterate
   end /* do */


   if globs.!REALM.mm='' then iterate /* skip this entry */
   inew=inew+1
   rr=globs.!realm.mm
   if globs.!subrealm.mm<>'' then rr=rr||'.'||globs.!subrealm.mm
   if globs.!crealm.mm=1 then rr=rr' C'
   newlines.inew='Realm: 'rr
   inew=inew+1
   newlines.inew='Port: 'globs.!port.mm   
   inew=inew+1
   newlines.inew='Host: 'globs.!host.mm   
   inew=inew+1

   if globs.!include.mm<>'' then do
      inew=inew+1
      newlines.inew='Include: 'globs.!include.mm   
      iterate
   end    

   newlines.inew='Rules: 'globs.!rules.mm   
   if globs.!subrealm.mm='' then do
     inew=inew+1
     newlines.inew='Requires: 'globs.!requires.mm   
   end

   if translate(globs.!redirect.mm)<>'NONE' then do
       oof=globs.!redirect.mm
       inew=inew+1
       newlines.inew=oof': 'globs.!redirect2.mm   
   end

   if translate(globs.!permissions.mm)<>'' then do
     inew=inew+1
     newlines.inew='Permissions: 'globs.!permissions.mm  
   end

   if translate(globs.!limitlist.mm)<>'' then do
      inew=inew+1
      newlines.inew='LIMITLIST: 'globs.!limitlist.mm  
   end
   
   if globs.!failfile.mm<>'' then do
      inew=inew+1
      newlines.inew='FailFile: 'globs.!failfile.mm   
   end    
   if globs.!advopts.mm<>'' then do
      inew=inew+1
      newlines.inew='AdvOpts: 'globs.!advopts.mm   
   end    
   if globs.!opts.mm<>'' then do
      oop=globs.!opts.mm
      do forever
         if oop='' then leave
         parse var oop aoop '0d0a'x oop
         if aoop='' then iterate
         inew=inew+1
         newlines.inew='Option: 'aoop
      end /* do */
   end    


end /* do */
newlines.0=inew
gfoo=sref_filewrite(realmfile,newlines,'R')


call lineout tempfile, '<!doctype html public "-//IETF//DTD HTML 3.0//EN">'
call lineout tempfile, "<html><head><titLE> SRE-http: Changed the realm definitions</title>"
call lineout tempfile, '</head><body  bgcolor="#'||usecolor||'">'
if gfoo<>1 then do
   call lineout tempfile,'<b>ERROR:</b> Could not write 'realmfile
end /* do */
else do
  call lineout tempfile,' <h2>The realm definitions have been changed </h2>'
  call lineout tempfile,' The list of realm definitions has been saved to: ' realmfile
  call lineout tempfile,' <p> The old version of 'realmfile' has been moved to ' try1
  call lineout tempfile,'<p> <a href="/config2b.htm">Return to Intermediate Mode Configurator</a>'
end
call lineout tempfile,' </body> </html> '
call lineout tempfile

foo=value('SREF_REDO',1,'os2environment')


foo=sref_gos('FILE ERASE TYPE text/html NAME ' tempfile)

return foo



/***********************************/
/* Get generic, or host specific, attribs.cfg file */
get_realmfile:procedure  expose sport
parse arg hn

if hn='' then do
   realmfile=value('SREF_defrealm_FILE',,'os2environment')
end
else do /* check cfglist.cfg for first host specific attribs: file */
  realmfile=chk_cfglist(hn)
end 

if realmfile<>'' then
   realmfile=stream(realmfile,'c','query exists')

return realmfile


/* ---------------------------------------------- */
/* read ATTRIBs from cfglist_File */
chk_cfglist:procedure expose sport

parse upper arg hn

cf=value('SRE_CFGS_DIR',,'os2environment')
cfglist_file=cf||'\CFGLIST.CFG'

/* look for files */
foo=translate(stream(cfglist_file,'c','open read'))
if abbrev(foo,'READY')<>1 then do
  call pmprintf('SRE-http REALMCFG: Unable to open: 'cfglist_file)
  return ''            /* unable to open */
end
inj=stream(cfglist_file,'c','query size')
if inj=0 | inj='' then return   ''        /* empty file, nothing to add */

astuff=charin(cfglist_file,1,inj)
foo=stream(cfglist_file,'c','close')



crlf='0d0a'x
astuff=astuff||crlf||' '        /* place an elephant in cairo */
nustuff=''

/* find an ATTRIBS: entry, for this port and host, by readling CFGLIST.CFG */
mm=0

/* note: file is organized in blocks */
aport=80              /* defaults port and host */
ahost='' ; afile=''

do forever              /* for all blocks in file */
  if astuff='' then leave       /* all done  (note we always put an elephant in cairo */
  parse var astuff aline (crlf) astuff
  if abbrev(aline,';')=1 then iterate   /* ignore comments */
  if aline='' then do           /* block end */
     if afile<>''  then do      /* attribs was mentioned */
        if aport=sport & hn=ahost then do  /* this is a match! */
            ill=stream(afile,'c','query size')

            if ill=0 | ill='' then do  /* try looking in cfgsdir */
                 baa=cf'\'afile
                 ill=stream(baa,'c','query size')
                 if ill<>0 & ill<>'' then afile=baa
             end
             if ill<>0 & ill<>'' then return afile
        end
     end 
     ahost=''           /* not this entry, so reset stuff */
     afile=''
     aport=80
     iterate
   end

/* else, more lines in this "block" */
   parse upper var aline ltype ':' lstuff ;
   ltype=strip(ltype) ; lstuff=strip(lstuff)

   select
       when ltype='PORT' then aport=lstuff
       when ltype='HOST' then ahost=lstuff
       when abbrev(ltype,'ATTR')=1 then afile=lstuff
       otherwise nop
   end /* select */

end

return ''                       /* no match */


