/*4/98. this is the SRE-http configuration routine */
/* to add variables:
   1) Create a new Param.nn line (say, Param.30='NEW_CONTROL')
  2) Create a new set of output lines in the DISPLAY THEM  section
  3) Create a new set of output lines in the CHANGE THEM section
*/

config2:

CHECKIT=0   /* Change this to 0 if you want to enable REMOTE configuration by SUPERUSERS */

USECOLOR='2dd52f'


/* ---------------- DO NOT MODIFY BELOW THIS LINE  ------------------ */


parse arg ddir,tempfile,sel,list,verb,uri,user,basedir,workdir,privset, ,
           enmadd,transaction,verbose,servername,host_nickname,homedir

if verb="" then do
   say " This SRE-http procedure is not meant to be run in stand-alone mode. "
   say " You should invoke it using CONFIGUR.HTM ! "
   exit
end  /* Do */

list=translate(list, ' ', '+'||'090a0d'x)  /* Whitespace, etc. */

signal on error name badguys
signal on syntax name badguys

crlf = '0d0a'x

who2=extract('CLIENTADDR')
saddr2=extract('SERVERADDR')

NO_REM=VALUE('SREF_NO_REMOTE_CONFIG',,'OS2ENVIRONMENT')

select
   when checkit=1 | no_rem>0 then do

/* only if user = serveraddress !!! */
     if who2<>saddr2 | no_rem=2 then do

        call lineout tempfile, '<!doctype html public "-//IETF//DTD HTML 3.0//EN">'
        call lineout tempfile, "<html><head><title>SRE-http remote configurator disabled </title>"
        call lineout tempfile, '</head><body bgcolor="#'||usecolor||'">'

        call lineout tempfile,' <strong> Action not allowed remotely.</strong> <pre>'
        call lineout tempfile,' </body> </html> '
        call lineout tempfile
        foo=sref_gos('FILE ERASE TYPE text/html NAME' tempfile)
      signal off error ; signal off syntax
        return 'CONFIG2: action not allowed remotely. '
     end
   end
   otherwise do
      if wordpos('SUPERUSER',privset)=0 then do

      'header add WWW-Authenticate: Basic Realm=<Configure>'  /* challenge */
        call lineout tempfile, '<!doctype html public "-//IETF//DTD HTML 3.0//EN">'
        call lineout tempfile, "<html><head><title>Not authorized </title>"
        call lineout tempfile, '</head><body bgcolor="#'||usecolor||'">'

        call lineout tempfile,' <strong> You do not have configuration rights.</strong> <pre>'
        if who2=saddr2 then
                call lineout tempfile,'<br> <Em> You may want to edit CONFIG2.CMD </em> '
        call lineout tempfile,' </body> </html> '
        call lineout tempfile
         signal off error ; signal off syntax
        return sref_response('unauth', "You do not have configuration rights ",tempfile,servername)
      end
   end
end

/* go get initfilt */
aport=extract(serverport)
afile=value(enmadd||'INITFILT_FILE',,'os2environment')

/* the following directories and files are subject to change */
fd.1="messbox_dir"   /* location of message boxes  */
fd.2="tempfile_dir"     /* workspace for server side programs */
fd.3="counter_file" /* used by REPLACE HITS and REPLACE COUNTS keyphrase */
fd.4="record_all_file" /* used if record_option =YES or YES_ALL */
fd.5="sendfile_file"  /* used by the SENDFILE facility*/
fd.6="access_file"   /* used if ALLOW_ACCESS=YES or INHOUSE*/
fd.7="alias_file"   /* list of aliases */
fd.8="repstrgs_file"  /* custom written variables for REPLACE keyphrase */
fd.9="user_file"    /* username/password/privileges file */
fd.10="upload_dir"  /* upload directory (used by GET_URL) */
fd.11="upload_log"  /* log file for upload tracking */
fd.12="cgi_bin_dir" /* cgi-bin directory */
fd.13="virtual_file" /* file containing virtual directory information */
fd.14="mailbox_dir"   /* location of incoming e-mail box */
fd.15="tempdata_dir" /* workspace for SRE-http */
fd.16="workdata_dir" /* permanent SRE-http "data file" directory */
fd.17='logon_fail_file' /* file sent if logon failure */
fd.18='access_fail_file' /* file sent if sel-specific access failure */
fd.19='addon_dir'  /* storage of SRE-http addons */
fd.20='userinfo_dir' /* workspace for SRE-http */
fd.21='error_log'  /*error log file */
fd.22='puburl_file' /* public urls file */
fd.0=22
do mm=1 to fd.0
   fd.mm=translate(strip(fd.mm))
end



/* IF THE VERB IS POST-- THEN THIS IS A "WRITE INFO CALL
   IF IT'S GET, THEN ITS A "SHOW INFO" OR "LET ME CHANGE INFO" CALL
*/

if translate(verb)="POST" then signal write_it



/* IF HERE, VERB=GET --- so show vars or request changes  */



parse upper var list foo '=' todo
ll=list
nickname=' '
do until ll=' '
   parse var ll a1 '&' ll
   parse var a1 a1a '=' a2a ; a2a=packur(a2a) ; a1a=packur(a1a)
   if upper(a1a)='TODO' then todo=upper(a2a)
   if upper(a1a)='HOST_NICKNAME' then nickname=strip(upper(a2a))
end /* do */

/* read initfilt.80 file into internal storage */

FOO=sref_fileREAD(AFILE,'FILELINES',,'E')
IF FOO=0 THEN DO
  SAY " CONFIG2 ERROR: COULD NOT READ INITFILT FILE "
  'String  Error reading initfilt file '
   signal off error ; signal off syntax
  return "CONFIG2 ERROR: Could Not read INITFILT FILE "
end

/* convert < to &lt; and > to &gt; */
i=0
do mm=1 to filelines.0
  big=fix_me(filelines.mm)
  filelines.mm.igot=0           /* fill this is later */
  filelines.mm.name=0           /* assume it's comment/blank */
  filelines.mm.stem=' '          /* assume is non stem var */
  filelines.mm.value=' '
  if big  <>" " then do
     big=sref_replacestrg(big,'<','&lt;','all')
     big=sref_replacestrg(big,'>','&gt;','all')
     filelines.mm=big
     if abbrev(strip(big),';')=0  then do
         parse var big atype '=' avalue
         if words(atype)=1  then do
             parse upper var atype aname '.' astem
             filelines.mm.name=upper(strip(aname))
             filelines.mm.value=strip(strip(avalue),,"'")
             if astem<>' ' then filelines.mm.stem=astem
             opop=filelines.mm.name
             if nickname=' ' & verify(astem,'0123456789 .')>0 then do
                  nop                   /* no nickname, but nickname in entry */
             end
             else do
                if symbol('quiklist.opop')='VAR' then do
                   quiklist.opop=quiklist.opop' 'mm
                end
                else do
                   quiklist.opop=mm
                end   /* quiklist */
             end   /* verify/nickname */
          end      /* one work name */
      end       /* comment */
   end          /* not ' ' line */
end      /* loop over lines */

/* the following is a list of parameters that we will adjust
(if end in ., it's a stem variable)*/

/* logon control variables */
param.1="checklog"  /* whether require logon: NO ALWAYS INHOUSE*/
param.2="owners"     /* list of owners */
param.3="inhouseips."  /* stem variable of inhouse ips */
param.4="unallowedips." /* stem variable of unallowed ip */

/* request string modification variables */
param.5="default"   /* the default page : A file name relative to ddir*/
param.6="xxxyyyzzz"      /* fill in later */
param.7="home_dir"    /* the ~ substitution */
param.8="auto_name"  /* list of potential "default documents" for directories */

/* access and auditing variables */
param.9="allow_access"   /*File specific: YES=no control, INHOUSE=inhouse only, NO=Superusrs */
param.10="record_option" /*NO YES YES_ALL FILE arguments*/
param.11="verbose" /*  */

/* stem variables for  REPLACE keyphrase */
param.12="headers."     /* stem variable of headers */
param.13="footers."    /* stem variable of footers */
param.14="inhouse."    /* stem variables for replace inhouse. static variables */
param.15="superuser."  /* stem variables for replace superuser. static variables*/

/* static variables for REPLACE keyphrase */
param.16="webmaster"   /* string containing the webmasters url */
param.17="home_name"  /* colloquial name of this server */

/* misc. static variables (used for a variety of internally generated messages  */
param.18="the_realm"    /* Colloquial name of "inhouse" folks*/
param.19="option_hit_line" /* variable used with option_hit.n and option_count.n */
param.20="not_found_url" /* string returned with 404 error */

/* late additions */
param.21="INHOUSE_PRIVS"
param.22="PUBLIC_PRIVS"
param.23="PUBLIC_URLS."  /* stem var of public urls -- no longer used */
param.24="AUTO_HEADER"
param.25="UPLOAD_MAXSIZE"
param.26="UPLOAD_MINFREE"
param.27="NOEXT_TYPE"
param.28="POST_FILTER"
param.29="PRE_FILTER"
param.30="DNS_CHECK"
param.31="SMTP_GATEWAY"
param.32='SSI_SHTML_ONLY'
param.33='HOSTS.'
param.34='DO_HTACCESS'
param.35='FIX_EXPIRE'
param.36='HIT_CACHE_LEN'
param.37='HIT_CACHE_DURATION'
param.38='HIT_OWNER_SUPPRESS'
param.39='CHECK_ADD_PRIVS'
param.40='DIR_OPTIONS'
param.41='DIR_EXCLUSION'
param.42='SSI_CACHE_ON'
param.43='WRITE_LOGS'
param.44='DIR_ACCESS'
param.45='DIR_ACCESS_PRIVS'
param.46="USER_PRIVS"

param.0=46
do mm=1 to param.0
   param.mm=strip(translate(param.mm))
   param.mm.stem=0
   if pos('.',param.mm)>0 then param.mm.stem=1
   param.mm=strip(param.mm,,'.')
end


/* Note that a number of variables will  NOT be settable by this program.
Ambitious users can go into INITFILT.80 and edit these parameters.
*/


/* ************************  DISPLAY THEM --------------------------------*/
if todo="SHOW" then do
   call lineout tempfile, '<!doctype html public "-//IETF//DTD HTML 3.0//EN">'
   call lineout tempfile, "<html><head><title>SRE-http: modify initializaton parameters</title>"
   call lineout tempfile, '</head><body bgcolor="#'||usecolor||'">'

   call lineout tempfile," <hr> <h2> Current Settings of SRE-http's Parameters </h2> "
   if nickname<>'' then do
        call lineout tempfile,' <h3> For parameters specific to the ' nickname ' host.</h3>'
        call lineout tempfile,' <blockquote> You selected <strong>' nickname ' </strong> as the  target "host nickname" '
        call lineout tempfile,' The top half of this document contains only parameters specific to <strong>' nickname '. </strong>'
        call lineout tempfile,'<eM> Non host-specific parameters</em>, which are used when a host-specific parameter is '
        call lineout tempfile,' not specified, are listed  at  '
        call lineout tempfile,' the  <A HREF="#otherparams">bottom half of the document</A>. '

   end  /* Do */

   call lineout tempfile, ' <h3> Logon Control Variables </h3> <menu> '
   do mm=1 to 4
       foo=write_1(mm)
   end
   foo=write_1(30)

/*  call lineout tempfile,' </menu> <h3> PUBLIC_URLS </h3>  <menu>'
   foo=write_1(23)*/

  call lineout tempfile,'  </menu> <H3> HOST Identifiers </h3>  <menu>'
     foo=write_1(33,2)

  call lineout tempfile,' </menu>  <h3> Request  modification variables  </h3>  <menu>'
    do mm=5 to 8
        if mm=6 then iterate
       foo=write_1(mm)
    end
    foo=write_1(27)
    foo=write_1(40)
    foo=write_1(41)
    foo=write_1(44)
    foo=write_1(45)

   call lineout tempfile,' </menu> <h3> Reponse header creation, Pre and Post filters </h3>  <menu>'
   foo=write_1(24)
   foo=write_1(28)
   foo=write_1(29)

  call lineout tempfile,' </menu>  <h3> File access and auditing variables  </h3>  <menu>'
   do mm=9 to 10
       foo=write_1(mm)
    end
    foo=write_1(21)
    foo=write_1(22)
    foo=write_1(34)
    foo=write_1(43)

    foo=write_1(36)
    foo=write_1(37)
    foo=write_1(38)
    foo=write_1(39)

  call lineout tempfile,' </menu> <h3> SSI control and stem variables for REPLACE keyphrase </h3>  <menu>'
   foo=write_1(32)
   foo=write_1(42)
   do mm=12 to 15

       foo=write_1(mm)
    end

  call lineout tempfile,' </menu>  <h3> Other variables for REPLACE keyphrase  </h3>  <menu>'
   do mm=16 to 17
       foo=write_1(mm)
    end

  call lineout tempfile, '</menu> <h3>Upload control, and E-Mail support, variables </h3>  <menu>'
  do mm=25 to 26
     foo=write_1(mm)
  end
  foo=write_1(31)

  call lineout tempfile,'</menu>  <h3> Miscellanous variables (used for error messages, etc.) </h3>  <menu>'
   do mm=18 to 20
       foo=write_1(mm)
    end
    foo=write_1(35)

  call lineout tempfile,'</menu>  <hr width=50%>   <h3> Files and Directories .. </h3> <menu> '
  do mm2=1 to fd.0
      foo=write_1(mm2,1)
  end
 CALL LINEOUT TEMPFILE,'</menu>'


   call lineout tempfile,' <hr>  <h2><a name="otherparams"> Other  SRE-http Parameters </a> </h2>  '
   call lineout tempfile,' Note that the following parameters and filenames: <ol>'
   call lineout tempfile,' <li> Either apply to a  different HOST.  To change them, '
   call lineout tempfile,' re-run this configurator with a different HOST NICKNAME'
   if nickname<>' ' then do
     call lineout tempfile,' <li>Are non-host specific parameters (which may'
     call lineout tempfile,' be used if there is no host-specific entry for the parameter)'
   end
   call lineout tempfile,' <li>Are parameters that this configurator will not modify.'

   call lineout tempfile," <em> To change them, you'll have to edit INITFILT."aport
   call lineout tempfile,' </em> </ol> <br>'
   call lineout tempfile, ' <blockquote> <code> <menu>'

  spuds=0
   do mm=1 to filelines.0               /* write other host/ misc lines */
       findit=filelines.mm.name
       if findit=0 then iterate
       IF FILELINES.MM.IGOT=1 then ITERATE
       avalue=filelines.mm.value
       dostem=filelines.mm.stem
       spuds=spuds+1
       tofus.spuds.afindit=findit
       tofus.spuds.aavalue=avalue
       tofus.spuds.adostem=dostem
       tofus.spuds.jdone=0
   end
/* sort into "non-host specific" and "host-specific" terms */
   do mu=1 to spuds             /* the non-host specific terms */
       dostem=tofus.mu.adostem
       findit=tofus.mu.afindit
       avalue=tofus.mu.aavalue
       if dostem=' ' then do
          call lineout tempfile, " <li> <b>" findit "</b> =<tt> " avalue '</tt> <br>'
          tofus.mu.jdone=1
       end
       else do
          foox=lastpos('.',dostem)
          yeek=substr(dostem,foox+1)
          if datatype(yeek)='NUM' then do
              call lineout tempfile, " <li> <b>" findit ||'.'|| dostem "</b> =<tt> " avalue '</tt> <br>'
              tofus.mu.jdone=1
          end
       end
   end /* do */
   call lineout tempfile,'</menu><br><menu> '

ndid=1
do until ndid=0
   ndid=0

   do mu=1 to spuds
       if tofus.mu.jdone=1 then iterate
       ndid=ndid+1
       dostem=tofus.mu.adostem
       foox=lastpos('.',dostem)
       yhost=substr(dostem,foox+1)
       if ndid=1 then do
          nowhost=yhost
       end
       else do
           if yhost<>nowhost then iterate
       end  /* Do */
       findit=tofus.mu.afindit
       avalue=tofus.mu.aavalue
       if dostem=' ' then do
          call lineout tempfile, " <li> <b>" findit "</b> =<tt> " avalue '</tt> <br>'
          tofus.mu.jdone=1
       end
       else do
           call lineout tempfile, " <li> <b>" findit ||'.'|| dostem "</b> =<tt> " avalue '</tt> <br>'
           tofus.mu.jdone=1
       end
   end /* do */
   call lineout tempfile,'</menu><br><menu> '

end
call lineout tempfile,'</menu>'


call lineout tempfile,' </menu> '
call lineout tempfile,'<p> <em> Note: REXX Comments may point to parameter-entry errors! </em>  '
call lineout tempfile,' </blockquote> <hr> </body> </html> '
call lineout tempfile

foo=sref_gos('FILE ERASE TYPE text/html NAME' tempfile)

signal off error ; signal off syntax
return ' '

end


/* ****************      CHANGE THEM --------------------------------. */
else do


 call lineout tempfile, '<!doctype html public "-//IETF//DTD HTML 3.0//EN">'
  call lineout tempfile, "<html><head><title>SRE-http: modify initializaton parameters </title>"
        call lineout tempfile, '</head><body bgcolor="#'||usecolor||'">'
        call lineout tempfile,'<!--  a button bar. --> 'crlf ,
           '<a href="/configur.htm">Configurator</a>||' crlf ,
           '<a href="/config2?todo=SET">Parameters</a>||' crlf ,
           '<a href="/usercfg?todo=SET">Usernames</a>||'  crlf ,
           '<a href="/realmcfg?todo=SET">Define-Realms</a>||'||crlf ,
           '<a href="/accescfg?todo=SET">Access-Controls||'  crlf ,
           '<a href="/aliascfg?todo=SET">Aliases</a>||'  crlf ,
           '<a href="/virtcfg?todo=SET">VirtualDir</a><p>'  
        call lineout tempfile,' <h1> SRE-http: modify initialization parameters </h1>'
  call lineout tempfile,'<h2>  Change parameter values </h2>'
  call lineout tempfile,'This form allows you to change most (but not all) of the SRE-http parameters. '
  call lineout tempfile,'The current values are shown, and are retained if not explicitily modified.'

  if  nickname<>' 'then do
     call lineout tempfile,' <p> You selected the <strong> ' nickname '</strong> host nickname.'
     call lineout tempfile,' Parameters specific to <strong> ' nickname '</strong> '
     call lineout tempfile,'will be displayed (and modified). '
     call lineout tempfile,'<br> <em>Note:</em> When  a <strong> ' nickname '</strong>  specific parameter is not available,'
     call lineout tempfile,' the default (non host-specific) version is used.'

  end  /* Do */

  call lineout tempfile,'<p><em> If the explanations here are insufficient, '
  call lineout tempfile,' <a href="/samples/initfilt.doc">INITFILT.DOC</a>'
  call lineout tempfile,'might help!</em>'
  call lineout tempfile,'<HR WIDTH=40%>'
  call lineout tempfile,' Notes: <ul>'
  if nickname<>' ' then do
     call lineout tempfile,' <li> If you want to leave a field blank, <strong>we advise inserting a 0 </strong> -- since SRE-http will attempt '
     call lineout tempfile,' to use the default (non host-specific) parameter whenever it finds an empty variable (this'
     call lineout tempfile,' is a design "feature" ' " of REXX's use of the OS/2 environment)!<br>"
  end
  call lineout tempfile,' <li> To change the "more obscure" parameters not mentioned here you will have to'
  call lineout tempfile,' edit INITFILT.'||aport ' by hand (see INITFILT.DOC for details) '
  call lineout tempfile,'<li> A caution: '
  call lineout tempfile," do not use <code>single quote</code> (<strong>'</strong>) characters (they will cause errors)!"
  call lineout tempfile,'</ul><hr>'
  call lineout tempfile,'<FORM ACTION="config2" METHOD="POST">'

  call lineout tempfile,' <em> <A NAME="section0">Quick jumps...</A> </em> <br>'

  call lineout tempfile,'  <dl> <dt> <A HREF="#section1">Logon, privileges and HOSTS</A> '
  call lineout tempfile,' <dd> CHECKLOG, OWNERS, INHOUSEIPS. INHOUSE_PRIV, PUBLIC_PRIVS, USER_PRIVS, UNALLOWED_IPS., DNS_CHECK, HOSTS.'
  call lineout tempfile,' <dt><A HREF="#section2">Request modification </A>'
  call lineout tempfile,' <dd> DEFAULT, HOME_DIR, NOEXT_TYPE, AUTO_NAME DIR_OPTIONS DIR_EXCLUSION DIR_ACCESS DIR_ACCESS_PRIVS'
  call lineout tempfile,'<dt><A HREF="#section3"> Access and Auditing</A> '
  call lineout tempfile,' <dd> ALLOW_ACCESS, DO_HTACCESS, WRITE_LOGS, RECORD_OPTION, HIT_CACHE_LEN, HIT_CACHE_DURATION, HIT_OWNER_SUPPRESS, CHECK_ADD_PRIVS '
  call lineout tempfile,' <dt><A HREF="#section4">SSI control, Response Header, Pre-filter and Post-Filter, and Uploading</A> '
  call lineout tempfile,' <dd> AUTO_HEADER, PRE_FILTER, POST_FILTER, SSI_SHTML_ONLY, SSI_CACHE_ON, SMTP_GATEWAY, UPLOAD_MINFREE, UPLOAD_MAXSIZE '
  call lineout tempfile,' <dt><A HREF="#section5">String Replacements</A> '
  call lineout tempfile,' <dd> HEADERS., FOOTERS., INHOUSE. message, SUPERUSER. message, WEBMASTER address, HOME_NAME '
  call lineout tempfile,'<dt><A HREF="#section5a"> Miscellaneous</A> '
  call lineout tempfile,' <dd> THE_REALM, OPTION_HIT_LINE, NOT_FOUND_URL, FIX_EXPIRE '
  call lineout tempfile,'<dt><A HREF="#section6"> File & Directory Names</A> '
  call lineout tempfile,'</dl> <p> <em> and when you are done.. </em> '
  call lineout tempfile,'<INPUT TYPE="submit" VALUE="make the changes">, '
  call lineout tempfile,' <em> or you can </em> '
  call lineout tempfile,'<INPUT TYPE="reset" VALUE="reset to current values">'



  call lineout tempfile,' <hr width=80%> '

  call lineout tempfile,' <H3><a name="section1"> Logon, Privileges </a></H3>'

  call lineout tempfile,'<dl>'


/* CHECKLOG */

  call lineout tempfile,'<dt> <strong>CHECKLOG</strong>:'
  v.1="NO" ; v.2="ALWAYS" ; v.3="INHOUSE" ;
  foo=do_radio(1,3)
  call lineout tempfile,'<dd>'
  call lineout tempfile,'CHECKLOG controls the logon-level:'
  call lineout tempfile,'<ul>'
  call lineout tempfile,'<LI>NO : Logon never required'
  call lineout tempfile,'<LI>ALWAYS : Logon required for any request'
call lineout tempfile,'<LI>INHOUSE : Only requesters with predefined, or explicitily granted (in the'
call lineout tempfile,'USERS.IN file) privileges of INHOUSE or SUPERUSER are allowed in.'
call lineout tempfile,'</ul>'


/* owners */
call lineout tempfile,'<hr><dt> <strong>OWNERS</strong>:'
call lineout tempfile,' <INPUT TYPE="text" NAME="OWNERS" '
thisval=find_val(2,2)

call lineout tempfile,'value="' thisval '"'
call lineout tempfile,' SIZE=30 MAXLENGTH=180>'
call lineout tempfile,'<dd>'
call lineout tempfile,'OWNERS is a space delimited list of  <strong>numeric </strong> IP addresses of the OWNERS.  Owners'
call lineout tempfile,'are automatically granted SUPERUSER privileges.'
call lineout tempfile,'<em>Wildcards are NOT allowed in the OWNERS list </em>'

/* INHOUSEIPS.ips */
foo=find_val(3,2)
call lineout tempfile,'<hr><dt> <strong>INHOUSEIPS.</strong>:'
call lineout tempfile,' <TEXTAREA NAME="'||param.3||'." ROWS=4 COLS=25>'
call lineout tempfile,foo
call lineout tempfile,'</TEXTAREA>'
call lineout tempfile,'<dd>'
call lineout tempfile,' INHOUSEIPS. is a "stem" variable that contains the IP '
call lineout tempfile,' addresses (numeric or name) of requesters who will be automatically granted INHOUSE privileges.'
call lineout tempfile,' <br> You should enter each of these addresses on a <strong> seperate line </strong> .'
call lineout tempfile,' <em> Wildcards (the * character) are allowed</em>'
call lineout tempfile,' <p> In addition, you can put (optional)privileges after the '
call lineout tempfile, ' the IP address. '
call lineout tempfile,' <BR> Examples: <ul> <li> 152.22.12.* <li>515.21.512.51 VIEWMESS PROJ1'
call lineout tempfile,' <li> pf.ourisp.org  <li>551.21.512.* </ul> '
call lineout tempfile, ' <br> Note that 515.21.512.51 is granted VIEWMESS and PROJ1 privileges '
call lineout tempfile, " (in addition to the INHOUSE_PRIV's privleges) "


/*INHOUSE_PRIVS*/
call lineout tempfile,'<hR><dt> <strong>INHOUSE_PRIVS</strong>:'
call lineout tempfile,' <INPUT TYPE="text" NAME="INHOUSE_PRIVS" '
foo=find_val(21)
call lineout tempfile,'value="' foo '"'
call lineout tempfile,' SIZE=30 MAXLENGTH=180>'
call lineout tempfile,'<dd> INHOUSE_PRIVS is a space delimited list of  "extra"'
call lineout tempfile,' privileges to give to OWNERS and to IN-HOUSE requesters.'
call lineout tempfile,' <br>It is <em> highly</em> recommended that <strong>INHOUSE</strong>'
call lineout tempfile,' be included in this list! <p>'
call lineout tempfile,' Example: if you want to give all IN-HOUSE requesters '
call lineout tempfile,' message-box reading privileges, add VIEWMESS to this list.'

/*PUBLIC_PRIVS*/
call lineout tempfile,'<hR><dt> <strong>PUBLIC_PRIVS</strong>:'
call lineout tempfile,' <INPUT TYPE="text" NAME="PUBLIC_PRIVS" '
foo=find_val(22)
call lineout tempfile,'value="' foo '"'
call lineout tempfile,' SIZE=30 MAXLENGTH=180>'
call lineout tempfile,'<dd> PUBLIC_PRIVS is a space delimited list of "extra" '
call lineout tempfile,' privileges to give to  everyone. '

/*USER_PRIVS*/
call lineout tempfile,'<hR><dt> <strong>USER_PRIVS</strong>:'
call lineout tempfile,' <INPUT TYPE="text" NAME="USER_PRIVS" '
foo=find_val(46)
call lineout tempfile,'value="' foo '"'
call lineout tempfile,' SIZE=30 MAXLENGTH=180>'
call lineout tempfile,'<dd> USER_PRIVS is a space delimited list of "extra" '
call lineout tempfile,' privileges to give to  all <em>registered </em> users (clients with a valid with username and password). '



/* Unallowed ips */
foo=find_val(4,2)
call lineout tempfile,'<hr><dt> <strong>UNALLOWEDIPS.</strong>:'
call lineout tempfile,' <TEXTAREA NAME="'||param.4||'." ROWS=4 COLS=25>'
call lineout tempfile,foo
call lineout tempfile,'</TEXTAREA>'
call lineout tempfile,'<dd>'
call lineout tempfile,' UNALLOWEDIPS. is the "opposite" of INHOUSEIPS. It is a list of '
call lineout tempfile,' the IP addresses of requesters who will NOT be allowed access.'
call lineout tempfile,' Note  INHOUSEIPS. and OWNERS takes precedence over UNALLOWEDIPS.'
call lineout tempfile,' Thus, entering *.*.*.* as an UNALLOWEDIPS. will keep everyone, except '
call lineout tempfile,' OWNERS and INHOUSE requesters, out! '

/* DNS_CHECK */
  call lineout tempfile,'<hr><dt> <strong>DNS_CHECK</strong>:'
  v.1="NO" ; v.2="YES"
  foo=do_radio(30,2)
  call lineout tempfile,'<dd>'
  call lineout tempfile,'DNS_CHECK controls whether a domain name check should occur:'
  call lineout tempfile,'<ul>'
  call lineout tempfile,"<LI>NO : Do not check the user's <tt> IP Name </tt> "
  call lineout tempfile,"<LI>YES : Get the user's <tt> IP Name </tt> (by calling the DNS), and deny access if not found"
  call lineout tempfile,'</ul>'
  call lineout tempfile,' DNS_CHECK=YES  provides extra security, but will slow response time '
  call lineout tempfile, ' (and may keep out legitimate clients with faulty DNS servers).'

/* hosts */
foo=""
call lineout tempfile,'<hr><dt> <strong>HOSTS.</strong>:'
call lineout tempfile,' <TEXTAREA NAME="'||param.33||'." ROWS=4 COLS=45>'
foo=find_val(33,1)
call lineout tempfile,foo
call lineout tempfile,'</TEXTAREA>'
call lineout tempfile,'<dd>'
call lineout tempfile,'HOSTS. is a stem variable used to identify what HOSTS '
call lineout tempfile,'GoServe is servicing.'
call lineout tempfile,'Each HOSTS. entry should contain the following comma-delimited information:<br>'
call lineout tempfile,'<code> IP_address , host_nickname , default_dir</code> <p>'
call lineout tempfile,'Where <blockquote>'
call lineout tempfile,'<STRONG>IP_address</STRONG> is the IP address (numeric or character) of the host. <br>'
call lineout tempfile,' <STRONG>host_nickname</STRONG> is the "nickname" that you will use to refer to this host <br>'
call lineout tempfile,' <STRONG>default_directory</STRONG> is the default data directory for this host </blockquote>'
call lineout tempfile,' Examples:<MENU>'
call lineout tempfile,'<LI>www.ag.gov , main , e:\WWW1  <br>'
call lineout tempfile,'<LI>w3.ag.gov , second , e:\WWW2  <LI> 0</MENU>'
if nickname<>' ' then
  call lineout tempfile,'<p><strong> Reminder: the HOSTS. parameters are NOT host-specific! </strong>'

/*********
 public urls  no longer set in initfilt.80 -- see puburls.in 
foo=find_val(23)
call lineout tempfile,'<hr><dt> <strong>PUBLIC_URLS.</strong>:'
call lineout tempfile,' <TEXTAREA NAME="'||param.23||'." ROWS=4 COLS=25>'
call lineout tempfile,foo
call lineout tempfile,'</TEXTAREA>'
call lineout tempfile,'<dd>'
call lineout tempfile,' PUBLIC_URLS. is a "stem" variable that contains a '
call lineout tempfile,' list of "publically accessible URLs".  These URLs '
call lineout tempfile,'will be available to all requesters -- no logon or '
call lineout tempfile,'access control is attempted when PUBLIC_URLS are requested.<br>'
call lineout tempfile,'PUBLIC_URLS. entry may include * (for wildcard matching). <br>'
call lineout tempfile,'You can also specify <strong>LITERAL </strong> PUBLIC_URLS. <br>'
call lineout tempfile,' <em> Note that PUBLIC_URLS. entries  will be checked against your ALIASES</em>'
***********/

call lineout tempfile,'</dl>  '
call lineout tempfile,' <hr width=40%>  '
call lineout tempfile,' <A HREF="#section0"><EM>go to top of document</EM></A> '
call lineout tempfile,' <hr width=40%>  '
call lineout tempfile,'  <H3><A name="section2">Request Modification </a3> </H3>'
call lineout tempfile,' <dl> '

/* DEFAULT */
call lineout tempfile,'<p> <dt> <strong>DEFAULT</strong>:'
call lineout tempfile,' <INPUT TYPE="text" NAME="DEFAULT" '
foo=find_val(5)
call lineout tempfile,'value="' foo '"'
call lineout tempfile,' SIZE=30 MAXLENGTH=180>'
call lineout tempfile,'<dd>'
call lineout tempfile,' Enter the name of the HTML document to be used as your '
call lineout tempfile,' "default document" (your home page).  This will be used '
call lineout tempfile,' when an empty request selector is recieved. <br>Note that  '
call lineout tempfile,' INDEX.HTM (located in the root of your "data directory") '
call lineout tempfile, ' is often used as the default document.'



/* HOME_DIR */
call lineout tempfile,'<hR><dt> <strong>HOME_DIR</strong>:'
call lineout tempfile,' <INPUT TYPE="text" NAME="HOME_DIR" '
foo=find_val(7)
call lineout tempfile,'value="' foo '"'
call lineout tempfile,' SIZE=30 MAXLENGTH=180>'
call lineout tempfile,'<dd>'
call lineout tempfile,' HOME_DIR is used when a ~ appears in the request selector. '
call lineout tempfile,' Typically, it is a shorthand for a "home directory" --'
call lineout tempfile,' under which personal directories are placed.'
call lineout tempfile,' <br>Advanced option:  include a $ to specify a <em> web subdirectory </em>'
call lineout tempfile,' of the  <em> personal </em> directory.'


/***** NOEXT_TYPE 
call lineout tempfile,'<hR><dt> <strong>NOEXT_TYPE</strong>:'
v.1="NO" ; V.2="REDIR" ; v.3="HTM" ; v.4="HTML"
  foo=do_radio(27,4)
call lineout tempfile,'<dd> NOEXT_TYPE controls how SRE-http handles request that '
call lineout tempfile,' have no extension, that do not have a ? in them, and that do not '
call lineout tempfile,' end with a /.  <ul> <li> NO : Use as is '
call lineout tempfile,' <li>REDIR: Append a /, and then redirect '
call lineout tempfile,' <li> HTM or HTML : Treat as HTML documents (append a '
call lineout tempfile,' .HTM or a .HTML respectively) </ul>'
****/

/****** NOEXT_TYPE */
call lineout tempfile,'<hR><dt> <strong>NOEXT_TYPE</strong>:'
call lineout tempfile,' <INPUT TYPE="text" NAME="NOEXT_TYPE" '
foo=find_val(27)
call lineout tempfile,'value="' foo '"'
call lineout tempfile,' SIZE=30 MAXLENGTH=180>'
call lineout tempfile,'<dd>'
call lineout tempfile,'<dd> NOEXT_TYPE controls how SRE-http handles request that '
call lineout tempfile,' have no extension, that do not have a ? in them, and that do not '
call lineout tempfile,' end with a /. '
call lineout tempfile,' <br> You should enter a spaced delimited list containing: '
call lineout tempfile,' <menu><li> <b>NO</b> -- Use as is  (do not add an extension) '
call lineout tempfile,' <li> <b>REDIR</b> -- Add a / to the end, and redirect <em>(if used, should be the last entry)</em>'
call lineout tempfile,' <li><b>HTM</b>, <b>HTML</b>: add a .HTM or .HTML  extension (respectively)'
call lineout tempfile,' <li> <b>.xxx</b>: add a <code>.xxx</code> extension (for example, .SHT or .SHTML)'
call lineout tempfile,'</menu>'


/* AUTO_NAME */
call lineout tempfile,'<hR><dt> <strong>AUTO_NAME</strong>:'
call lineout tempfile,' <INPUT TYPE="text" NAME="AUTO_NAME" '
foo=find_val(8)
call lineout tempfile,'value="' foo '"'
call lineout tempfile,' SIZE=30 MAXLENGTH=180>'
call lineout tempfile,'<dd>'
call lineout tempfile,' AUTO_NAME is a space delimited list of "default document for directories".'
call lineout tempfile,' It is used when <code>NOEXT_TYPE=DIR</code>, and a  request for a '
call lineout tempfile, 'directory name (an <code>action</code> that ends with a /) is recieved.'
call lineout tempfile,' <br> Notes: <menu> <li> a *.HTM (or *.HTML)  means "use a file '
call lineout tempfile,     ' called directory_name.htm (or .html) " '
call lineout tempfile, ' (if it exists in the requested directory) '
call lineout tempfile,' <li> !CREATE means "create a list of links to each file in the directory </menu>'


/* DIR_OPTIONS */
call lineout tempfile,'<hR><dt> <strong>DIR_OPTIONS</strong>:'
call lineout tempfile,' <INPUT TYPE="text" NAME="DIR_OPTIONS" '
foo=find_val(40)
call lineout tempfile,'value="' foo '"'
call lineout tempfile,' SIZE=50 MAXLENGTH=180>'
call lineout tempfile,'<dd>'
call lineout tempfile," DIR_OPTIONS is used by the DIR: SRE-http's built in directory lister."
call lineout tempfile,' <br> It is used to customize the format and content of the directory listing.'
call lineout tempfile,'<br>Notes:<menu><li>DIR_OPTIONS should contain a space-delimited list of options'
call lineout tempfile, '<li> DIR is used when a !CREATE option is included in '
call lineout tempfile,' the AUTO_NAME variable </ul>'



/* DIR_Exclusion */
call lineout tempfile,'<hR><dt> <strong>DIR_EXCLUSION</strong>:'
call lineout tempfile,' <INPUT TYPE="text" NAME="DIR_EXCLUSION" '
foo=find_val(41)
call lineout tempfile,'value="' foo '"'
call lineout tempfile,' SIZE=50 MAXLENGTH=180>'
call lineout tempfile,'<dd>'
call lineout tempfile," DIR_EXCLUSION is used by !DIR: SRE-http's built in directory lister."
call lineout tempfile,' <br> It is used to indicate files and directories that should <b>not</b> be displayed.'
call lineout tempfile,'<br>Notes:<menu><li>DIR_EXCLUSION should contain a space-delimited list of filenames and directory names'
call lineout tempfile,' <li> To indicate subdirectories, start the directory name with a / '
call lineout tempfile,' <LI> You can use * as a wildcard character '
call lineout tempfile,' the AUTO_NAME variable </ul>'


/* DIR_EXCLUSION */
call lineout tempfile,'<hR><dt> <strong>DIR_ACCESS</strong>:'
call lineout tempfile,' <INPUT TYPE="text" NAME="DIR_ACCESS" '
foo=find_val(44)
call lineout tempfile,'value="' foo '"'
call lineout tempfile,' SIZE=50 MAXLENGTH=180>'
call lineout tempfile,'<br> and <strong>DIR_ACCESS_PRIVS:</strong>'
call lineout tempfile,' <br><INPUT TYPE="text" NAME="DIR_ACCESS_PRIVS" '
foo=find_val(45)
call lineout tempfile,'value="' foo '"'
call lineout tempfile,' SIZE=50 MAXLENGTH=180>'

call lineout tempfile,'<dd>'
call lineout tempfile," DIR_ACCESS is used by !DIR: SRE-http's built in directory lister."
call lineout tempfile,' <br> It is used to indicate directories that should be displayed <b>only</b> to clients with one of the DIR_ACCESS_PRIVS <em>client</em> privileges.'
call lineout tempfile,'<br>Notes:<menu><li>DIR_ACCESS should contain a space-delimited list of (relative) directory names'
call lineout tempfile,' <br> You can use * as a wildcard character '

call lineout tempfile,'<li>DIR_ACCESS_PRIVS should contain a space-delimited list of <em>client privileges</em> '
call lineout tempfile,'</ul>'

call lineout tempfile,'</dl>  '
call lineout tempfile,' <hr width=40%>  '
call lineout tempfile,' <A HREF="#section0"><EM>go to top of document</EM></A> '
call lineout tempfile,' <hr width=40%>  '
call lineout tempfile,'<H3><A name="section3"> Access and Auditing </a></H3>'
call lineout tempfile,'<dl> '

/* ALLOW_ACCESS */
call lineout tempfile,'<p><dt> <strong>ALLOW_ACCESS</strong>:'
  v.1="YES" ; v.2="INHOUSE" ; v.3="NO"
  foo=do_radio(9,3)
call lineout tempfile,'<dd>ALLOW_ACCESS turns on and off "URL" specific access control'
call lineout tempfile,' <ul> <LI>YES = Do not check (allow all requests to go through'
call lineout tempfile,' <LI> INHOUSE = Check access privileges of everyone except OWNERS or INHOUSE requesters.'
call lineout tempfile,' <LI>  NO = Check access privileges of everyone except OWNERS '
call lineout tempfile, ' (those with SUPERUSER privileges) </ul>'
call lineout tempfile,' Notes: <menu><li> ALLOW_ACCESS uses the ACCESS_FILE to store file-specific access information'
call lineout tempfile,'  </ul>'


/* DO_HTACCESS */
call lineout tempfile,'<hr><dt> <strong>DO_HTACCESS</strong>:'
htfile=get_value('DO_HTACCESS')
  v.1="YES" ;  v.2="NO"
  foo=do_radio(34,2)
call lineout tempfile,'<dd>DO_HTACCESS turns on and off the HTACCESS-file method "directory" specific access controls'
call lineout tempfile,' <ul> <LI>YES = Look for, and use, HTACCESS files to control access '
call lineout tempfile,' <LI>  NO = Do not attempt to use HTACCESS files </ul>'
call lineout tempfile,' Notes: <menu><li> ALLOW_ACCESS and DO_HTACCESS can be used simultaneously '
call lineout tempfile,'<li> The  name of (directory specific) HTACCESS file is set using the <var>HTACCESS_FILE</var> variable.'
call lineout tempfile,' <br> <var> HTACCESS_FILE </var> is currently:<strong> ' htfile '</strong>'

call lineout tempfile,'  </ul>'


/* write common-log */
call lineout tempfile,'<hr><dt> <strong>WRITE_LOGS</strong>:'
  v.1="YES" ; v.2="NO"
  foo=do_radio(43,2)
call lineout tempfile,'<dd> WRITE_LOGS instructs SRE-http to record requests in'
call lineout tempfile,' the <b>common-log</b> audit file (and in the browser and referer log files).'
call lineout tempfile,' <ul> <LI> NO = Do  <b>NOT</b> record requests in the log files.'
call lineout tempfile,' <LI>YES =Record requests </ul>'
call lineout tempfile,' Note: see the SREFLOGS.INI file for additional common-log options. <br>'


/*RECORD_OPTION */
call lineout tempfile,'<hr><dt> <strong>RECORD_OPTION</strong>:'
  v.1="YES" ; v.2="YES_ALL" ; v.3="FILE" ; v.4="NO" ;
  foo=do_radio(10,4)
call lineout tempfile,'<dd> RECORD_OPTION turns on and off "recording all requests"'
call lineout tempfile,' <ul> <LI>YES = Record all requests, but remove arguments (such as <code>?xxx</code>) first'
call lineout tempfile,' <LI>YES_ALL = Record all requests, but do not remove "arguments" '
call lineout tempfile,' (this can lead to a lot of unique entries!) '
call lineout tempfile,' <li> FILE = Record all request by absolute file name (rather then by "URL") '
call lineout tempfile,' <LI>  NO = Do not record all requests </ul>'
call lineout tempfile,' Notes: <br>'
call lineout tempfile,' i) RECORD_OPTIONS uses the RECORD_ALL_FILE to keep track of the number '
call lineout tempfile,' of requests recieved, and the date of the most recent request.<br>'
call lineout tempfile,' ii) Requests that are not "honored" (due to logon or access constraints) are NOT recorded'


/* hit_cache_len and hit_cache_duration */
call lineout tempfile,' <hr> <dt> <strong> HIT_CACHE_LEN: '
call lineout tempfile,' <INPUT TYPE="text" NAME="HIT_CACHE_LEN" '
foo=find_val(36)
call lineout tempfile,'value="' strip(foo) '" '
call lineout tempfile,' SIZE=10 MAXLENGTH=10> <br>'
call lineout tempfile,' HIT_CACHE_DURATION: </strong>'
call lineout tempfile,' <INPUT TYPE="text" NAME="HIT_CACHE_DURATION" '
foo=find_val(37)
call lineout tempfile,', value="' strip(foo)'" '
call lineout tempfile,' SIZE=10 MAXLENGTH=10>'

call lineout tempfile,'<dd>'
call lineout tempfile,' The HIT_CACHE_ variables are used to prevent recording of "false requests",'
call lineout tempfile,' that occur when a client repetitively reloads a document<br>'
call lineout tempfile,'  HIT_CACHE_LEN is the number of entries (in menory) set aside for the <em>hit </em> storage cache<br>'
call lineout tempfile,' <blockquote> On busy sites, small values of this will cause entries to be prematurely lost.'
call lineout tempfile,' Alternatively, use a value of <b>FILE</b>  -- entries will be stored in a file'
call lineout tempfile,' (this is slower, but might be safer if you are storing thousands of hits) </blockquote>'
call lineout tempfile,' HIT_CACHE_DURATION is the time (in minutes) each entry is retained.<p>'
call lineout tempfile,' Note that each entry contains a request selector and client IP address '
call lineout tempfile,' (averaging around 50 bytes). '


call lineout tempfile,'<hr><dt> <strong>HIT_OWNER_SUPPRESS</strong>:'
  v.1="YES" ; v.2="NO"
  foo=do_radio(38,2)
call lineout tempfile,'<dd> HIT_OWNER_SUPPRESS instructs SRE-http to <b>not</b> record '
call lineout tempfile,' from <b>OWNERS</b> (as listed in the OWNERS variable).'
call lineout tempfile,' <ul> <LI>YES = Do NOT record such requests.'
call lineout tempfile,' <LI>NO =allow recording </ul>'


call lineout tempfile,'<hr><dt> <strong>CHECK_ADD_PRIVS</strong>:'
  v.1="YES" ; v.2="NO"
  foo=do_radio(39,2)
call lineout tempfile,'<dd> CHECK_ADD_PRIVS instructs SRE-http to check the dynamic privileges <code>cache</code>. '
call lineout tempfile," <Ul> <li>YES = Check the dynamic privileges cache for entries that match this client's IP address"
call lineout tempfile,' <LI> NO = Do not check </ul>'
call lineout tempfile,' <em> The dynamic-privileges <code>cache</code> is used to grant additional, "transient", '
call lineout tempfile,' privileges to a client.</em>'


call lineout tempfile,'</dl>  '
call lineout tempfile,' <hr width=40%>  '
call lineout tempfile,' <A HREF="#section0"><EM>go to top of document</EM></A> '
call lineout tempfile,' <hr width=40%>  '
call lineout tempfile,' <H3><a name="section4">Response Header, Pre-filter, and Uploading </a></H3>'
call lineout tempfile,' <dl> '


/*AUTO_HEADER */
call lineout tempfile,'<p><dt> <strong>AUTO_HEADER</strong>:'
  v.1="NO" ; v.2="HEAD" ; v.3="ALWAYS"
  foo=do_radio(24,3)
call lineout tempfile,'<dd> AUTO_HEADER controls the "automatic creation of response headers"'
call lineout tempfile,'<ul> <LI>NO = Do not create additional response headers '
call lineout tempfile,'<LI>HEAD = Automatic creation of response headers for HEAD requests'
call lineout tempfile,'<LI>ALWAYS= Automatic creation of response headers fo GET and  HEAD requests'
call lineout tempfile,'</ul> Note: When active, LINK and META HTTP-EQUIV elements found in the '
call lineout tempfile,'&lt;HEAD&gt; portion of an HTML document are used to generate additional response headers'

/*PRE_FILTER */
call lineout tempfile,'<hr><dt> <strong>PRE_FILTER</strong>:'
  v.1="NO" ; v.2="YES" ; v.3="FIRST"
  foo=do_radio(29,3)
call lineout tempfile,'<dd> PRE_FILTER controls whether the PREFILTR  "pre-filter" is called '
call lineout tempfile,' before SRE-http processes the request .'
call lineout tempfile,' <ul> <li> NO = Do not call a pre-filter '
call lineout tempfile,'  <li> YES =Call a pre-filter after ascertaining logon rights'
call lineout tempfile,' <li> FIRST = Call a pre-filter before anything else </ul>'
call lineout tempfile,'<br> Notes: <menu><li>The default pre-filter procedure is PREFILTR.80'
call lineout tempfile,' <li> To change the name of the pre-filter procedure, '
call lineout tempfile,' you will have to "hand edit" the PREFILTER_NAME parameter'
call lineout tempfile," <li> SRE-http's default pre-filter (PREFILTR.80) implements"
call lineout tempfile,' the GoRemote server remote control package.'
call lineout tempfile,' <li><em>Suggestion:</em>To perform simple load balancing, change the BackupServerList and '
call lineout tempfile,' LoadThreshold variables in SRE-http.80 (see INITFILT.DOC for details)</menU>'

/*POST_FILTER */
call lineout tempfile,'<hr><dt> <strong>POST_FILTER</strong>:'
  v.1="YES" ; v.2="NO"
  foo=do_radio(28,2)
call lineout tempfile,'<dd> POST_FILTER instructs SRE-http to call a set of "post-filters"'
call lineout tempfile,' <ul> <LI>YES = Call the post-filter procedure(s).'
call lineout tempfile,' <LI>NO = do not call </ul>'
call lineout tempfile,' If POST_FILTER=YES, then the postfilter(s) will be called <strong>after</strong>'
call lineout tempfile,' the response has been sent to the client '
call lineout tempfile,' <br> Notes: <menu> <LI> The default Post-filter is POSTFILT.80 '
call lineout tempfile,' <li> To change the name(s) of the pre-filter procedure,'
call lineout tempfile,'  you will have to "hand edit" the POSTFILTER_NAME parameter.'
call lineout tempfile,' <li> SRE-http includes a few sample post-filters (POSTMAIL.80 and POSTRCRD.80) </menu>'


/* SSI_SHTML_ONLY */
call lineout tempfile,'<hr><dt> <strong>SSI_SHTML_ONLY</strong>:'
  v.1="YES" ; v.2="NO"
  foo=do_radio(32,2)
call lineout tempfile,'<dd> SSI_SHTML_ONLY is used to tell SRE-http to attempt '
call lineout tempfile,' server side includes <em> only </em> on files with a "SHTML" '
call lineout tempfile,' extension -- other html/text files (say, with .HTM or .HTML'
call lineout tempfile,' extensions) will NOT be checked for server side includes. '
call lineout tempfile,'<p> Select <b>YES</b> to turn SSI_SHTML_ONLY on, '
call lineout tempfile,'<Br> <b>NO</b> to attempt server side includes on all html/text files '
call lineout tempfile,'<p>Notes:<menu><li> SRE-http defines four extensions as "SHTML extensions": '
call lineout tempfile,' .SHTML, .SHT, .HTM-SSI and .HTML-SSI.'
call lineout tempfile,' <li> To add or modify this list, change the SSI_EXTENSIONS variable '
call lineout tempfile,' (see INITFILT.DOC for details) </menu>'

/* SSI_CACHE_ON*/
call lineout tempfile,'<hr><dt> <strong>SSI_CACHE_ON</strong>:'
  v.1="YES" ; v.2="NO"
  foo=do_radio(42,2)
call lineout tempfile,'<dd> SSI_CACHE_ON is used to enable the <em>server side include cache </em>'
call lineout tempfile,' (the SSI-CACHE). <p> '
call lineout tempfile,' The SSI-cache is used to store "compiled" versions of HTML documents that '
call lineout tempfile,' contain server side includes.  When a request for such document arrives,'
call lineout tempfile,' SRE-http will return it (perhaps with further modifications).'
call lineout tempfile,' <blockquote> Turning off caching is sometimes useful (or necessary) in highly'
call lineout tempfile,'   dynamic environments; say, where INCLUDE files are constantly changing.</blockquote>'
call lineout tempfile,"For more information on SRE-http's server side include caching "
call lineout tempfile,'algorithim, see <a href="/samples/ssicache.htm">SSICACHE.HTM </a>'


/*SMTP_GATEWAY */
call lineout tempfile,'<hr><dt> <strong>SMTP_GATEWAY</strong>:'
call lineout tempfile,' <INPUT TYPE="text" NAME="SMTP_GATEWAY" '
foo=find_val(31)
call lineout tempfile,'value="' foo '"'
call lineout tempfile,' SIZE=30 MAXLENGTH=180>'
call lineout tempfile,"<dd> SMTP_GATEWAY is used by SRE-http's <em>e-mail alert</em> facility "
call lineout tempfile," (as implemented in the POSTMAIL.80 post-filter routine). "
call lineout tempfile,' SMTP_GATEWAY should contain the name of your SMTP mail server. <br> '
call lineout tempfile,' If you do not know it, or do not need to use e-mail alerts, leave this field empty (or set it to 0)<p>'
call lineout tempfile,' For more details on SMTP_GATEWAY, see POSTMAIL.80 '

/* UPLOAD_Minfree and upload_maxsize */
call lineout tempfile,' <hr> <dt> <strong> UPLOAD_MINFREE: '
call lineout tempfile,' <INPUT TYPE="text" NAME="UPLOAD_MINFREE" '
foo=find_val(26)
call lineout tempfile,'value="' strip(foo) '" '
call lineout tempfile,' SIZE=10 MAXLENGTH=10>'
call lineout tempfile,' , and UPLOAD_MAXSIZE: </strong>'
call lineout tempfile,' <INPUT TYPE="text" NAME="UPLOAD_MAXSIZE" '
foo=find_val(25)
call lineout tempfile,', value="' strip(foo)'" '
call lineout tempfile,' SIZE=10 MAXLENGTH=10>'
call lineout tempfile,'<dd>'
call lineout tempfile,' The UPLOAD_ variables are needed when GET_URL is used to upload '
call lineout tempfile,' files from another server. <pr>'
call lineout tempfile,' UPLOAD_MINFREE is the amount of space (in K bytes) that must be free '
call lineout tempfile,' in the UPLOAD_DIRECTORY <em> after </em> the file has been uploaded.'
call lineout tempfile,' <br> UPLOAD_MAXSIZE is the maximum allowable size (in K bytes) of a uploaded file '
call lineout tempfile, '<p> If either of these limits are exceeded, the file will <strong> not </strong> be uploaded.'


call lineout tempfile,'</dl>  '
call lineout tempfile,' <hr width=40%>  '
call lineout tempfile,' <A HREF="#section0"><EM>go to top of document</EM></A> '
call lineout tempfile,' <hr width=40%>  '
call lineout tempfile,' <h3> <a name="section5">  String Replacements </a> </h3>'
call lineout tempfile,' <dl> '

/* headers */
foo=find_val(12)
call lineout tempfile,'<p><dt> <strong>HEADERS.</strong>:'
call lineout tempfile,' <TEXTAREA NAME="'||param.12||'." ROWS=4 COLS=25>'
call lineout tempfile,foo
call lineout tempfile,'</TEXTAREA>'
call lineout tempfile,'<dd> HEADERS. are added to the top of all requested HTML '
call lineout tempfile,' documents (they are added just after the first &lt;BODY&gt; tag).'

call lineout tempfile,' You should enter valid HTML code in this box '
call lineout tempfile,' (or leave it blank if you do not want a HEADER added). '
call lineout tempfile,' Note that HEADERS can contain keyphrases. '

/* footers */
foo=find_val(13)
call lineout tempfile,'<hr><dt> <strong>FOOTERS.</strong>:'
call lineout tempfile,' <TEXTAREA NAME="'||param.13||'." ROWS=4 COLS=25>'
call lineout tempfile,foo
call lineout tempfile,'</TEXTAREA>'
call lineout tempfile,'<dd> FOOTERS. are added to the top of all requested HTML '
call lineout tempfile,' documents (they are added just before  the last &lt;/BODY&gt; tag).'
call lineout tempfile,' You should enter valid HTML code in this box '
call lineout tempfile,'(or leave it blank if you do not want a FOOTER added). '
call lineout tempfile,' Note that FOOTERS can contain keyphrases. '

/* inhouse. */
foo=find_val(14)
if strip(foo)=0 then foo=" "
call lineout tempfile,'<hr><dt> <strong>INHOUSE.</strong>:'
call lineout tempfile,' <TEXTAREA NAME="'||param.14||'." ROWS=4 COLS=65>'
call lineout tempfile,foo
call lineout tempfile,'</TEXTAREA>'
call lineout tempfile,'<dd> The INHOUSE. variable(s) are used by the REPLACE INHOUSE.n keyphrase'
call lineout tempfile,' Each line of this box corresponds to a different value of n '
call lineout tempfile,' -- the first line is for INHOUSE.1, the second for INHOUSE.2, etc.'

/* SUPERUSER. */
foo=find_val(15)
call lineout tempfile,'<hr><dt> <strong>SUPERUSER.</strong>:'
if strip(foo)=0 then foo=" "
call lineout tempfile,' <TEXTAREA NAME="'||param.15||'." ROWS=4 COLS=65>'
call lineout tempfile,foo
call lineout tempfile,'</TEXTAREA>'
call lineout tempfile,'<dd> The SUPERUSER. variable(s) are used by the REPLACE SUPERUSER.n keyphrase'
call lineout tempfile,' Each line of this box corresponds to a different value of n '
call lineout tempfile,' -- the first line is for SUPERUSER.1, the second for SUPERUSER.2, etc.'


/* webmaster */
call lineout tempfile,'<hR><dt> <strong>WEBMASTER</strong>:'
foo=find_val(16)
call lineout tempfile, ' <TEXTAREA NAME="WEBMASTER" ROWS=1 COLS=68>' foo
call lineout tempfile, ' </TEXTAREA>'
call lineout tempfile,'<dd>'
call lineout tempfile,' The WEBMASTER variable is used in the REPLACE WEBMASTER keyphrase,'
call lineout tempfile,' and is used in some internally generated messages.  It should contain'
call lineout tempfile,' a contact address (preferably as a MAILTO URL) of the site''s "webmaster"'


/*HOME_NAME */
call lineout tempfile,'<hR><dt> <strong>HOME_NAME</strong>:'
call lineout tempfile,' <INPUT TYPE="text" NAME="HOME_NAME" '
foo=find_val(17)
call lineout tempfile,'value="' foo '"'
call lineout tempfile,' SIZE=30 MAXLENGTH=180>'
call lineout tempfile,'<dd>'
call lineout tempfile,' HOME_NAME is used in the REPLACE HOME_NAME keyphrase, and  is'
call lineout tempfile,' used in the default Not Found response (see below).  It should contain the '
call lineout tempfile,' commonly-used name of your organization (not necessarily the IP name!)'


call lineout tempfile,'</dl>  '
call lineout tempfile,' <hr width=40%>  '
call lineout tempfile,' <A HREF="#section0"><EM>go to top of document</EM></A> '
call lineout tempfile,' <hr width=40%>  '
call lineout tempfile,' <h3> <a name="section5a">  Miscellaneous  </a> </h3>'
call lineout tempfile,' <dl> '


/*the_realm */
call lineout tempfile,'<hR><dt> <strong>THE_REALM</strong>:'
call lineout tempfile,' <INPUT TYPE="text" NAME="the_realm" '
foo=find_val(18)
call lineout tempfile,'value="' foo '"'
call lineout tempfile,' SIZE=30 MAXLENGTH=180>'
call lineout tempfile,'<dd>'
call lineout tempfile,' THE_REALM is the realm name that will be shown to the client '
call lineout tempfile,' when  a username/password is requested.  Note that the "realm"'
call lineout tempfile,' value for a url that is contained in the ACCESS_FILE is also used '
call lineout tempfile,' (THE_REALM is used first). '



/*option_hIT_LINE */
call lineout tempfile,'<hR><dt> <strong>OPTION_HIT_LINE</strong>:'
call lineout tempfile,' <INPUT TYPE="text" NAME="OPTION_HIT_LINE" '
foo=find_val(19)
call lineout tempfile,'value="' foo'"'
call lineout tempfile,' SIZE=30 MAXLENGTH=180>'
call lineout tempfile,'<dd> OPTION_HIT_LINE is used by the REPLACE OPTION_HITS.n keyphrase'


/*NOT_FOUND_URL */
call lineout tempfile,'<hR><dt> <strong>NOT_FOUND_URL</strong>:'
foo=find_val(20)
call lineout tempfile, ' <TEXTAREA NAME="NOT_FOUND_URL" ROWS=1 COLS=60>' foo
call lineout tempfile, ' </TEXTAREA>'
call lineout tempfile,'<dd> NOT_FOUND_URL is a string that is displayed when a Not Found '
call lineout tempfile,' response is generated (say, when a requested file can not be found).'
call lineout tempfile,' Typically it will contain a link to your home page, or some other ';
call lineout tempfile,' "catchall" document.  Note that HOME_NAME is used in the default '
call lineout tempfile,' definition of NOT_FOUND_URL '

/* FIX_EXPIRE */
call lineout tempfile,' <hr> <dt> <strong> FIX_EXPIRE: </strong> '
call lineout tempfile,' <INPUT TYPE="text" NAME="FIX_EXPIRE" '
foo=find_val(35)
call lineout tempfile,'value="' foo '" '
call lineout tempfile,' SIZE=10 MAXLENGTH=10>'
call lineout tempfile,'<dd>'
call lineout tempfile,' The FIX_EXPIRE variable is used to suppress "immediate expiraton" of '
call lineout tempfile,'  documents containing server side includes, and documents generated by CGI-BIN scripts.'
call lineout tempfile,' <BR> <em> "Immediate expiration" can cause annoying reloads when clients use the back '
call lineout tempfile,' arrow key on their browsers </em> <br>'
call lineout tempfile,' <br> Set FIX_EXPIRE to a fractional value  '
call lineout tempfile,' to indicate a future expiration date (in 24hrs * FIX_EXPIRE). '
call lineout tempfile,' <br> To suppress this (and use default "immediate expiration"), set this to 0'



call lineout tempfile,' </dl> '                 /* END OF PARAMTERS LIST */
call lineout tempfile,' <A HREF="#section0"><EM>go to top of document</EM></A> '



/* === File info SECTION === */

wow=find_fnames()

call lineout tempfile,'<hr> <h3> <a name="section6"> File & Directory Names </a> </h3>'
if nickname<>' ' then
  call lineout tempfile,' <em> File and directory names are <strong>not</strong> host-specific </em><p>'
  call lineout tempfile,' <br> <b> We recommend restarting GoServe immediately after changing any of these filenames or directories!</b>'
call lineout tempfile,'<dl> <dt> <br> ' fd.1 ' = '
call lineout tempfile,'<INPUT TYPE="text" NAME="'||fd.1||'"  VALUE="'||fd.1.val||'"  '
call lineout tempfile,' SIZE=30 MAXLENGTH=60>'
Call lineout tempfile,' <dd> The MESSBOX_DIR is where the SRE-http message boxes are stored'

call lineout tempfile,'<dt> <br> ' fd.15 ' = '
call lineout tempfile,'<INPUT TYPE="text" NAME="'||fd.15||'"  VALUE="'||fd.15.val||'"  '
call lineout tempfile,' SIZE=30 MAXLENGTH=60>'
Call lineout tempfile,' <dd> The TEMPDATA_DIR is where SRE-http puts temporary  files;  '
call lineout tempfile,' such as the $xxxx.80 temporary response files, and the SSI-Cache files.'
call lineout tempfile,' It is <b>not</b> supposed to be used by <em> user supplied programs </em> (see TEMPFILE_DIR) .'

call lineout tempfile,'<dt> <br> ' fd.20 ' = '
call lineout tempfile,'<INPUT TYPE="text" NAME="'||fd.20||'"  VALUE="'||fd.20.val||'"  '
call lineout tempfile,' SIZE=30 MAXLENGTH=60>'
Call lineout tempfile,' <dd> The USERINFO_DIR is where SRE-http stores client-specific information;  '
call lineout tempfile,' such as files used for "client-specific customization".'


call lineout tempfile,'<dt> <br> ' fd.2 ' = '
call lineout tempfile,'<INPUT TYPE="text" NAME="'||fd.2||'"  VALUE="'||fd.2.val||'"  '
call lineout tempfile,' SIZE=30 MAXLENGTH=60>'
Call lineout tempfile,' <dd> The TEMPFILE_DIR is working space for your various <em> user supplied programs </em>'


call lineout tempfile,'<dt> <br> ' fd.16 ' = '
call lineout tempfile,'<INPUT TYPE="text" NAME="'||fd.16||'"  VALUE="'||fd.16.val||'"  '
call lineout tempfile,' SIZE=30 MAXLENGTH=60>'
Call lineout tempfile,' <dd> The WORKDATA_DIR is where SRE-http puts username, alias, access control'
call lineout tempfile, ' and other permanent data files.'


call lineout tempfile,'<dt> <br> ' fd.11 ' = '
call lineout tempfile,'<INPUT TYPE="text" NAME="'||fd.11||'"  VALUE="'||fd.11.val||'"  '
call lineout tempfile,' SIZE=30 MAXLENGTH=60>'
Call lineout tempfile,' <dd> The UPLOAD_DIR is where "uploaded" files will be put. '

call lineout tempfile,'<dt> <br> ' fd.12 ' = '
call lineout tempfile,'<INPUT TYPE="text" NAME="'||fd.12||'"  VALUE="'||fd.12.val||'"  '
call lineout tempfile,' SIZE=30 MAXLENGTH=60>'
Call lineout tempfile,' <dd> The CGI_BIN_DIR is where "CGI-BIN" programs should be stored. '

call lineout tempfile,'<dt> <br> ' fd.19 ' = '
call lineout tempfile,'<INPUT TYPE="text" NAME="'||fd.19||'"  VALUE="'||fd.19.val||'"  '
call lineout tempfile,' SIZE=30 MAXLENGTH=60>'
Call lineout tempfile,' <dd> The ADDON_DIR is where various SRE-http configuration tools and <B>addons</b>  programs should be stored. '

call lineout tempfile,'<dt> <br> ' fd.14 ' = '
call lineout tempfile,'<INPUT TYPE="text" NAME="'||fd.14||'"  VALUE="'||fd.14.val||'"  '
call lineout tempfile,' SIZE=30 MAXLENGTH=60>'
call lineout tempfile,"<dd> The MAILBOX_DIR is where SRE-http's will read and write e-mail messages from"
call lineout tempfile,' (it should be the "inbox" directory of an SMTP server).'

call lineout tempfile,'<dt> <br> ' fd.3 ' = '
call lineout tempfile,'<INPUT TYPE="text" NAME="'||fd.3||'"  VALUE="'||fd.3.val||'"  '
call lineout tempfile,' SIZE=30 MAXLENGTH=60>'
Call lineout tempfile,' <dd> The COUNTER_FILE is where the REPLACE HITS and REPLACE COUNTS '
call lineout tempfile,' keyphrases store the "number of hits" statistics. '


call lineout tempfile,'<dt> <br> ' fd.4 ' = '
call lineout tempfile,'<INPUT TYPE="text" NAME="'||fd.4||'"  VALUE="'||fd.4.val||'"  '
call lineout tempfile,' SIZE=30 MAXLENGTH=60>'
Call lineout tempfile,' <dd> The RECORD_ALL_FILE is where the RECORD_OPTIONS stores the '
call lineout tempfile,' "number of hits " statistics. '

call lineout tempfile,'<dt> <br> ' fd.21 ' = '
call lineout tempfile,'<INPUT TYPE="text" NAME="'||fd.21||'"  VALUE="'||fd.21.val||'"  '
call lineout tempfile,' SIZE=30 MAXLENGTH=60>'
Call lineout tempfile,' <dd> The ERROR_LOG is where SRE-http stores warnings and error messages'


call lineout tempfile,'<dt> <br> ' fd.5 ' = '
call lineout tempfile,'<INPUT TYPE="text" NAME="'||fd.5||'"  VALUE="'||fd.5.val||'"  '
call lineout tempfile,' SIZE=30 MAXLENGTH=60>'
Call lineout tempfile,' <dd> The SENDFILE_FILE is where the SENDFILE facility stores "number of hits"'
call lineout tempfile,' statistics" '


call lineout tempfile,'<dt> <br> ' fd.10 ' = '
call lineout tempfile,'<INPUT TYPE="text" NAME="'||fd.10||'"  VALUE="'||fd.10.val||'"  '
call lineout tempfile,' SIZE=30 MAXLENGTH=60>'
Call lineout tempfile,' <dd> The UPLOAD_LOG is where information on uploaded files '
call lineout tempfile,' will be stored.  If you do not want to store such info, enter <strong>0</strong> '



call lineout tempfile,'<dt> <br> ' fd.6 ' = '
call lineout tempfile,'<INPUT TYPE="text" NAME="'||fd.6||'"  VALUE="'||fd.6.val||'"  '
call lineout tempfile,' SIZE=30 MAXLENGTH=60>'
Call lineout tempfile,' <dd> The ACCESS_FILE is where  ALLOW_ACCESS looks for action-specific'
call lineout tempfile,' access information'


call lineout tempfile,'<dt> <br> ' fd.7 ' = '
call lineout tempfile,'<INPUT TYPE="text" NAME="'||fd.7||'"  VALUE="'||fd.7.val||'"  '
call lineout tempfile,' SIZE=30 MAXLENGTH=60>'
Call lineout tempfile,' <dd> The ALIAS_FILE contains the lists of ALIASES '

call lineout tempfile,'<dt> <br> ' fd.22 ' = '
call lineout tempfile,'<INPUT TYPE="text" NAME="'||fd.22||'"  VALUE="'||fd.22.val||'"  '
call lineout tempfile,' SIZE=30 MAXLENGTH=60>'
Call lineout tempfile,' <dd> The PUBURL_FILE contains the lists of PUBLIC_URLS ' 


call lineout tempfile,'<dt> <br> ' fd.13 ' = '
call lineout tempfile,'<INPUT TYPE="text" NAME="'||fd.13||'"  VALUE="'||fd.13.val||'"  '
call lineout tempfile,' SIZE=30 MAXLENGTH=60>'
Call lineout tempfile,' <dd> The VIRTUAL_FILE contains the "virtual directory" list '

call lineout tempfile,'<dt>  <br> ' fd.8 ' = '
call lineout tempfile,'<INPUT TYPE="text" NAME="'||fd.8||'"  VALUE="'||fd.8.val||'"  '
call lineout tempfile,' SIZE=30 MAXLENGTH=60>'
Call lineout tempfile,' <dd> The REPSTRGS_FILE contains the list of custom "variable names" '
call lineout tempfile,' for use by the REPLACE keyphrase '


call lineout tempfile,'<dt> <br> ' fd.9 ' = '
call lineout tempfile,'<INPUT TYPE="text" NAME="'||fd.9||'"  VALUE="'||fd.9.val||'"  '
call lineout tempfile,' SIZE=30 MAXLENGTH=60>'
Call lineout tempfile,' <dd> The USER_FILE contains logon/password/privileges information '

call lineout tempfile,'<dt> <br> ' fd.17 ' = '
call lineout tempfile,'<INPUT TYPE="text" NAME="'||fd.17||'"  VALUE="'||fd.17.val||'"  '
call lineout tempfile,' SIZE=30 MAXLENGTH=60>'
Call lineout tempfile,' <dd> The LOGON_FAIL_FILE is sent when a logon-failure occurs.'
call lineout tempfile,' <br> The LOGON_FAIL_FILE should contain an "absolute" file name (i.e.;<code> D:\GOSERVE\LOGFAIL.HTM</code>)'
call lineout tempfile,' <br> If you want to use the generic response, set this to 0. '
call lineout tempfile,' <br><em> Note that if the LOGON_FAIL_FILE is an HTML document, '
call lineout tempfile,' SRE-http will perform a few textual substitutions.</em> '

call lineout tempfile,'<dt> <br> ' fd.18 ' = '
call lineout tempfile,'<INPUT TYPE="text" NAME="'||fd.18||'"  VALUE="'||fd.18.val||'"  '
call lineout tempfile,' SIZE=30 MAXLENGTH=60>'
Call lineout tempfile,' <dd> The ACCESS_FAIL_FILE is sent when "SEL-specific" access is not allowed.'
call lineout tempfile,' <br> The ACCESS_FAIL_FILE should contain an "absolute" file name (i.e.;<code> D:\GOSERVE\ACCFAIL.HTM</code>)'
call lineout tempfile,' <br> If you want to use the generic response, set this to 0. '
call lineout tempfile,' <br><em> Note that if the ACCESS_FAIL_FILE is an HTML document, '
call lineout tempfile,' SRE-http will perform a few textual substitutions.</em> '

/* ----- no longer officially supported
call lineout tempfile,'<dt> <br> ' fd.10 ' = '
call lineout tempfile,'<INPUT TYPE="text" NAME="'||fd.10||'"  VALUE="'||fd.10.val||'"  '
call lineout tempfile,' SIZE=30 MAXLENGTH=60>'
Call lineout tempfile,' <dd> The INTERPRET_FILE contains the "REXX-code blocks" used by the '
call lineout tempfile,' INTERPRET keyphrase '
*/

call lineout tempfile,'</dl>'           /* end OF FILE INFO SECTION */

call lineout tempfile,' <A HREF="#section0"><EM>go to top of document</EM></A> '


/* Retain current file contents */
pud=0
 do bob=1 to filelines.0
    if filelines.bob.igot=1 then iterate
    pud=pud+1
    dog=filelines.bob
    DOG=sref_REPLACESTRG(DOG,'"','%22','ALL')
    DOG=sref_REPLACESTRG(DOG,"'",'%27','ALL')
    DOG=sref_REPLACESTRG(DOG,"+",'%2B','ALL')
    dog=sref_replacestrg(dog,'&','%26','ALL')
    DOG=sref_REPLACESTRG(DOG,"<",'%3c','ALL')
    DOG=sref_REPLACESTRG(DOG,">",'%3e','ALL')

    DOG=translate(DOG,"+",' ')

   call lineout tempfile,'<INPUT TYPE="hidden" NAMe="lines.'||pud|| '" value="'||DOG||'" >'

/*   dog0=strip(filelines.bob.name)
   call lineout tempfile,'    <INPUT TYPE="hidden" NAMe="lines_name.'||pud|| '" value="'||DOG0||'" >'*/


 end
 call lineout tempfile,'<INPUT TYPE="hidden" NAMe="nickname" value="'||nickname||'" >'
 call lineout tempfile,'<INPUT TYPE="hidden" NAMe="lines.0" value="'||PUD||'" >'


  call lineout tempfile,'<p> <EM>if you are done you can</EM> <INPUT TYPE="submit" VALUE="make the changes">,'
  call lineout tempfile,' <EM>or you can </EM><INPUT TYPE="reset" VALUE="reset to current values">'
  call lineout tempfile,'</FORM> <hr>'
  call lineout tempfile,' <h3>Special feature: Look up an IP address </h3>'
   call lineout tempfile,' For several of these variables (i.e.; OWNERS), numeric IP '
  call lineout tempfile,' addresses are expected.  If you need to lookup a numeric address:'
  call lineout tempfile,'  <FORM ACTION="!host" METHOD="GET">'
  call lineout tempfile,'  <em> enter the IP name here and Look It Up: </em> '
  call lineout tempfile,'  <INPUT TYPE="text" NAME=""  VALUE=""  SIZE=25 MAXLENGTH=25>'
  call lineout tempfile,'  <INPUT TYPE="submit" VALUE=" Look It Up"> </form>'


  call lineout tempfile,' <hr> </body> </html> '
  call lineout tempfile
end

foo=sref_gos('FILE ERASE TYPE text/html NAME' tempfile)
signal off error ; signal off syntax
return ' Done with Config2 -- submitted parameters '





/****************************************************/
/*  JUMP HERE ON POST CALLS, which are always "write info" calls */
/* you should never need to modify this */

write_It:   nop
crlf = '0d0a'x

ooks=fd.1
do pp=2 to fd.0
   ooks=ooks||' '||fd.pp
end

 call lineout tempfile, '<!doctype html public "-//IETF//DTD HTML 3.0//EN">'
        call lineout tempfile, "<html><head><title>CONFIG2 Results </title>"
        call lineout tempfile, '</head><body bgcolor="#'||usecolor||'">'

        call lineout tempfile,' <h1> SRE-http Configurator </h1> '

foo=stream(afile,'c','query exists')
if foo="" then do
   call lineout tempfile,' Warning: Old INITFILT.'aport ' did not exist '
end
else do
 acf1='INITFILT.B'
  do hi=1 to 99
     try1=acf1||hi
     if stream(acf1||hi,'c','query exists')='' then leave
  end /* do */

  foo=dosrename(aFILE,try1)
   CALL LINEOUT TEMPFILE,'The old version of ' Afile ' has been saved as ' try1
end

/* Parse the argument list.  Extract current file (in LINES.n) variables
to the FILELINES. array.
 Check for arguments.  Note that if no arguments, error. */
param.0=0 ; fparam.0=0
do until list=""
    parse var list a0  '&' list
    parse var  a0 a1 '=' a2
    a1=packur(a1) ; a2=strip(packur(a2))
    a1=upper(strip(a1))
    select
       when abbrev(a1,'LINES.')=1 then do
           parse var a1 foo '.' ith
          a2=translate(a2,' ','+')
          filelines.ith=packur(a2)
        end  /* Do */
        when abbrev(a1,'NICKNAME')=1 then do
             nickname=a2
        end
        otherwise do
            a2=translate(a2,' ','+')
            if wordpos(a1,ooks)>0 then do
               fparam.0=fparam.0+1 ; IARF0=fPARAM.0
               fparam.iarf0=a2 ; fparam.iarf0.name=a1
            end  /* Do */
            else do
               param.0=param.0+1 ; IARF=PARAM.0
               param.IARF=a2 ; PARAM.IARF.NAME=A1
            end
        end
     end
end


POOP=afile
call lineout poop,'; Last modified on : ' time() ' ' Date()
do mm=1 to filelines.0
   aa=sref_replacestrg(filelines.mm,'&lt;','<','ALL')
   aa=sref_replacestrg(aa,'&gt;','>','ALL')
   if aa=' ' then iterate
   if abbrev(aa,'; Last modified on')=1 then iterate
   call lineout POOP,packur(aa)
end /* do */

do mm=1 to fparam.0
  yow=fPARAM.MM.NAME "= '"fPARAM.MM "'"
  yow=translate(yow,' ','000d0a1a'x)
  call lineout POOP,yow
end

do mm=1 to param.0


   gosh1=param.mm ;   name1=param.mm.name ; inthis=0
   gosh1=bad_entry(gosh1,name1)

   if pos('.',name1)>0 then do          /* is a stem var */
       do until gosh1=""
          parse var gosh1 al1 (crlf) gosh1
          al1=packur(translate(al1,' ','0d0a00'x))
          if al1=' ' then iterate
          inthis=inthis+1
          if nickname=' ' | abbrev(upper(name1),'HOSTS')=1 then do
              yow=name1||inthis " =  '" al1 "'  "
          end
          else do
              yow=name1||inthis||'.'||nickname " =  '" al1 "'  "
          end
          yow=translate(yow,' ','000d0a1a'x)
          call lineout poop, yow
       end /* do */
   end  /* Do */
   else do
      gosh1=packur(gosh1)
      if nickname=' '  then do
          yow=name1 "= '"gosh1 "'"
      end
      else do
          yow=NAME1||'.'||nickname|| "= '"gosh1 "'"
      end
      yow=translate(yow,' ','000d0a1a'x)

      call lineout poop,yow
   end
end /* do */

CALL LINEOUT POOP
call lineout tempfile,' <p> ' afile  ' succesfully created.'

call lineout tempfile,'<p> <a href="/config2.htm">Return to Intermediate Mode Configurator</a>'
call lineout tempfile,' <hr> </body> </html> '
call lineout tempfile
foo=value('SREF_REDO',1,'os2environment')

foo=sref_gos('FILE ERASE TYPE text/html NAME' tempfile)
signal off error ; signal off syntax
return 'Done with CONFIG2 -- saved parameters'


/* jumnp here on error */
badguys:
signal off error ; signal off syntax
call pmprintf_sref(" Config2 error: at line " sigl)
'STRING  Config2 error: at line ' sigl
return ' '


/********************************************/
/* --- create a row of radio buttons */
do_radio: procedure expose param. filelines. v. tempfile nickname quiklist.
parse arg ith,inlist,nonick
unickname=nickname
if nonick=1 then unickname=' '
got1=0 ;
domark=1   /* domark=0 prevents marking for comments -- use on 2nd pass */


foobax:
do jj=1 to inlist
   v2.jj=' '
end
findit=strip(param.ith)


if symbol('quiklist.findit')<>'VAR' then   do        /* no candiate entries */
   call lineout tempfile,' <INPUT TYPE=RADIO NAME="'||param.ith||'" '
   call lineout tempfile,' VALUE="'   ||v.mm||  '" '  ||v2.mm||  '>'   v.mm  ' &nbsp; &nbsp;  , '
   return ' '
end

/* look at candidates only */
candlist=quiklist.findit
do mm0=1 to words(candlist)
    mm=strip(word(candlist,mm0))
    if mm=' ' then iterate

    bval=strip(upper(filelines.mm.name))

    if bval<>findit then iterate

/* check nickname stuff */
     if unickname<>' '   then do  /* check for .nickname at end of name */
        if pos(unickname,filelines.mm.stem)=0 then iterate
     end  /* Do */
     if unickname=' ' & filelines.mm.stem<>' ' & nonick<>1 then do /* check for nickname */
        foo1=lastpos('.',filelines.mm.stem)
        if datatype(substr(filelines.mm.stem,foo1+1))<>'NUM' then iterate
     end  /* Do */

    if domark=1 then FILELINES.MM.IGOT=1
    got1=1
    do mm2=1 to inlist
      cval=strip(filelines.mm.value)
      if v.mm2=cval then  do
          v2.mm2="CHECKED"
      end
      else do
          v2.mm2=' '
          if upper(v.mm2)='NO' & (cval=0 | abbrev(upper(cval),'N')=1 ) then
              v2.mm2="CHECKED"
          if upper(V.mm2)='YES' & (cval=1 | abbrev(upper(cval),'Y')=1) then  
             v2.mm2="CHECKED"
     end
    end
end             /* always use last match, if more then one */


if got1=0 then  do
      if unickname=' ' | nonick>0 then
          nop
      else do
         unickname=' ' ; domark=0
         signal foobax            /* try looking for non host specific value */
      end
 end


do mm=1 to inlist
   call lineout tempfile,' <INPUT TYPE=RADIO NAME="'||param.ith||'" '
   call lineout tempfile,' VALUE="'   ||v.mm||  '" '  ||v2.mm||  '>'   v.mm  ' &nbsp; &nbsp;  , '
end
return isit



/***********************************/
/* write out values for a variable (or a stem variable )
isfile=1 use file list
isfile=2 don't use hostnickname
 */
write_1:procedure expose param. filelines. tempfile fd. nickname quiklist.
parse arg iat,isfile

unickname=strip(nickname)
if isfile>0 then unickname=' '

isstem=0 ;dostem=0
if isfile<>1 then do
  findit=param.iat
  dostem=param.iat.stem
end
else do
  findit=fd.iat
end

towrite=0                 /* search filelines for findit */
if symbol('quiklist.findit')<>'VAR' then    do       /* no candiate entries */
   call lineout tempfile, "  <li> <b>" findit  "</b> =<tt> n.a. </tt> <br>"
   return ' '
end



/* look at candidates only */
candlist=quiklist.findit
do mm0=1 to words(candlist)
    mm=strip(word(candlist,mm0))

    if mm=' ' then iterate
    if unickname<>' ' & filelines.mm.stem=' ' then iterate
   if filelines.mm.name=findit then do
      if unickname<>' ' & pos(unickname,filelines.mm.stem)=0 then iterate
      if unickname=' ' & filelines.mm.stem<>' '  then do /* check for unickname */
        foo1=lastpos('.',filelines.mm.stem)
        if datatype(substr(filelines.mm.stem,foo1+1))<>'NUM' then iterate
      end  /* Do */

      wow1=filelines.mm.value
      filelines.mm.igot=1
      if dostem=0 then do
           towrite=1
           dowrite=" <li> <b>" ||findit ||"</b> =<tt> "|| wow1 ||'</tt> <br>'
           iterate              /* get latter ones? */
      end
      astem=filelines.mm.stem
      if unickname=' ' & pos('.',astem)>0 then iterate
      poop='.'||unickname
      if unickname<>' ' then astem=sref_replacestrg(astem,poop,'')
      if unickname<>' ' then astem=sref_replacestrg(astem,unickname||'.','')
      towrite=towrite+1
      dowrite.towrite="  <li> <b>"|| findit ||'.' ||astem ||"</b> =<tt> " ||wow1|| '</tt> <br>'
      isstem=1+isstem
   end
end

select
   when towrite=0 then
      call lineout tempfile, "  <li> <b>" findit  "</b> =<tt> n.a. </tt> <br>"
   when dostem=0 then
       call lineout tempfile,dowrite
   otherwise do
        do mm=1 to towrite
           call lineout tempfile,dowrite.mm
        end
   end
end
return ' '





/* ----------- */
/* get environment value, possibly host specific */
/* ------------ */
get_value: procedure expose enmadd host_nickname
parse arg vname,hname0
if hname0=0 then
        hname=' '
else
    hname=strip(host_nickname)

vname=strip(vname) ;
if hname<>' ' then do
   aval=value(enmadd||vname||'.'||hname,,'os2environment')
   if aval<>' ' Then
        return aval
end
aval=value(enmadd||vname,,'os2environment')
return aval


/* **************************************
 get current value of a parameter.  If stem variable, return
in sorted order
nonick=' ' -- check for nickname
1= never check nickname
2= only check for nickname
*/

find_val:procedure expose param. filelines. nickname quiklist.

 parse arg ith,nonick
 unickname=nickname
 if nonick=1 then unickname=' '
  findit=param.ith
  isstem=param.ith.stem
  domark=1   /* domark=0 prevents marking for comments -- use on 2nd pass */

if symbol('quiklist.findit')<>'VAR' then do          /* no candiate entries */
   return ' '
end


bowser:

  gots=0
  dowrite=0

/* look at candidates only */
candlist=quiklist.findit
do mm0=1 to words(candlist)
    mm=strip(word(candlist,mm0))
    if mm=' ' then iterate

     aval=filelines.mm.name
     if aval<>findit then iterate
     if unickname<>' ' then do  /* check for unickname at end of name */
        if pos(unickname,filelines.mm.stem)=0 then iterate
     end  /* Do */
     if unickname=' ' & filelines.mm.stem<>' '  then do /* check for unickname */
        foo1=lastpos('.',filelines.mm.stem)
        if datatype(substr(filelines.mm.stem,foo1+1))<>'NUM' then iterate
     end  /* Do */
     if domark=1 then FILELINES.MM.IGOT=1
     gogo=translate(filelines.mm.value, ' ','00090a0d'x)
     if isstem=0 then do
        dowrite=1
        towrite=gogo
      end
      else do
          dowrite=1
          if filelines.mm.stem=' ' then iterate /* bad entry */
          fii=translate(filelines.mm.stem,' ','.') ; fii=strip(word(fii,1))
          if datatype(fii)<>'NUM' then iterate
          got.value.fii=gogo
          gots=max(gots,fii)
      end
   end          /* all lines in file */

   if dowrite=0 then  do
      if unickname=' ' | nonick>0 then return ' '
      unickname=' ' ; domark=0
      signal bowser             /* try looking for non host specific value */
   end

   if isstem=0 then return towrite
   eek=' '
   do jj=1 to gots
      if symbol('got.value.jj')<>'VAR' then iterate
      eek=eek||strip(got.value.jj)||'0d0a'x
   end /* do */

return strip(eek)



/* ***************** fill in file names */
find_fnames: procedure expose fd. filelines.
do mm=1 to fd.0
   findit=strip(fd.mm)
   do mm2=1 to filelines.0
      aval=strip(filelines.mm2.name)
      if aval<>findit then iterate
      fd.mm.val=filelines.mm2.value
      FILELINES.MM2.IGOT=1
      leave
   end /* do */
end /* do */

return 0

/* --- variable names of convert foo.bar.1 to foo.1.bar */
fix_me:procedure
parse arg a1

if a1=' '  then return a1
a1=strip(a1)
if abbrev(a1,';') then return a1

parse var a1  aname '=' avalue
if pos('.',aname)=0 then return a1

foo=translate(aname,' ','.')
if words(foo)<>3 then return a1

/* if here, array.x.y (3 elements) */
if datatype(word(foo,3))='NUM' & datatype(word(foo,2))<>'NUM' then do  /* rearrange */
   foo2=word(foo,1)||'.'||word(foo,3)||'.'||word(foo,2)||' = '||avalue
   return foo2
end  /* Do */
else do
   return a1
end  /* Do */



/* */
badguys:
signal off error ; signal off syntax
call pmprintf_sref(" Config2 error: at line " sigl)
'STRING  Config2 error: at line ' sigl
return ' '


/********/
/* check for bad syntax in an initfilt.80 entry */
bad_entry:procedure expose tempfile

parse arg anent,fullent
anent1=sref_replacestrg(anent,"''","'",'ALL')
if pos("'",anent1)>0 then do
 call lineout tempfile," <p><b>WARNING!</b> converting ' in: "fullent'='anent
 anent=sref_replacestrg(anent1,"'","''",'ALL')
end
return anent

